/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.av1;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacketKt;
import org.jitsi.nlj.rtp.codec.av1.Av1DDRtpLayerDesc;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtensionKt;
import org.jitsi.rtp.rtp.header_extensions.Av1TemplateDependencyStructure;
import org.jitsi.rtp.rtp.header_extensions.DTI;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.RtpState;
import org.jitsi.videobridge.cc.av1.Av1DDFrame;
import org.jitsi.videobridge.cc.av1.Av1DDFrameMap;
import org.jitsi.videobridge.cc.av1.Av1DDFrameProjection;
import org.jitsi.videobridge.cc.av1.Av1DDQualityFilter;
import org.jitsi.videobridge.cc.av1.Av1PersistentState;
import org.jitsi.videobridge.cc.av1.PacketInsertionResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 K2\u00020\u0001:\u0001KB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010&\u001a\u00020\u0018*\u00020\u001e2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001eH\u0002J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020\u001eH\u0002JI\u00101\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001e2\u0006\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00107\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u00109J9\u0010:\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001e2\u0006\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00107\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u0010;J9\u0010<\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001e2\u0006\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00107\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u0010;J9\u0010=\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001e2\u0006\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00107\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u0010;J9\u0010>\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001e2\u0006\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00107\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u0010;JA\u0010>\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020\u001e2\u0006\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00107\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020\u0018H\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020\u0005H\u0016J\b\u0010H\u001a\u00020\u0007H\u0016J\b\u0010I\u001a\u00020JH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDAdaptiveSourceProjectionContext;", "Lorg/jitsi/videobridge/cc/AdaptiveSourceProjectionContext;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "rtpState", "Lorg/jitsi/videobridge/cc/RtpState;", "persistentState", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/videobridge/cc/RtpState;Ljava/lang/Object;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "av1FrameMaps", "Ljava/util/HashMap;", "", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrameMap;", "Lkotlin/collections/HashMap;", "av1QualityFilter", "Lorg/jitsi/videobridge/cc/av1/Av1DDQualityFilter;", "lastAv1FrameProjection", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "lastFrameNumberIndexResumption", "accept", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "targetIndex", "", "lookupAv1Frame", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "av1Packet", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "insertPacketInMap", "Lorg/jitsi/videobridge/cc/av1/PacketInsertionResult;", "haveSubsequentNonAcceptedChain", "frame", "incomingEncoding", "partOfActiveChain", "chainIdx", "seqGap", "frame1", "frame2", "frameIsNewSsrc", "frameIsProjectable", "prevFrame", "nextFrame", "findPrevAcceptedFrame", "findNextAcceptedFrame", "createProjection", "initialPacket", "mark", "isResumption", "isReset", "newDt", "receivedTime", "Ljava/time/Instant;", "(Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;ZZZLjava/lang/Integer;Ljava/time/Instant;)Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "createEncodingSwitchProjection", "(Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;ZLjava/lang/Integer;Ljava/time/Instant;)Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "createResumptionProjection", "createResetProjection", "createInEncodingProjection", "refFrame", "(Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;ZLjava/lang/Integer;Ljava/time/Instant;)Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "needsKeyframe", "rewriteRtp", "", "rewriteRtcp", "rtcpSrPacket", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "getRtpState", "getPersistentState", "getDebugState", "Lorg/json/simple/JSONObject;", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAv1DDAdaptiveSourceProjectionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DDAdaptiveSourceProjectionContext.kt\norg/jitsi/videobridge/cc/av1/Av1DDAdaptiveSourceProjectionContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,694:1\n382#2,7:695\n1617#3,9:702\n1869#3:711\n1870#3:713\n1626#3:714\n1761#3,3:716\n1#4:712\n1#4:715\n*S KotlinDebug\n*F\n+ 1 Av1DDAdaptiveSourceProjectionContext.kt\norg/jitsi/videobridge/cc/av1/Av1DDAdaptiveSourceProjectionContext\n*L\n184#1:695,7\n194#1:702,9\n194#1:711\n194#1:713\n194#1:714\n200#1:716,3\n194#1:712\n*E\n"})
public final class Av1DDAdaptiveSourceProjectionContext
implements AdaptiveSourceProjectionContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final HashMap<Long, Av1DDFrameMap> av1FrameMaps;
    @NotNull
    private final Av1DDQualityFilter av1QualityFilter;
    @NotNull
    private Av1DDFrameProjection lastAv1FrameProjection;
    private long lastFrameNumberIndexResumption;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(Av1DDAdaptiveSourceProjectionContext.class);

    public Av1DDAdaptiveSourceProjectionContext(@NotNull DiagnosticContext diagnosticContext, @NotNull RtpState rtpState, @Nullable Object persistentState, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        Intrinsics.checkNotNullParameter((Object)rtpState, (String)"rtpState");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.diagnosticContext = diagnosticContext;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.av1FrameMaps = new HashMap();
        this.av1QualityFilter = new Av1DDQualityFilter((Map<Long, Av1DDFrameMap>)this.av1FrameMaps, this.logger);
        Object object = persistentState;
        if (!(object == null ? true : object instanceof Av1PersistentState)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Av1PersistentState av1PersistentState = persistentState instanceof Av1PersistentState ? (Av1PersistentState)persistentState : null;
        Av1PersistentState av1PersistentState2 = persistentState instanceof Av1PersistentState ? (Av1PersistentState)persistentState : null;
        this.lastAv1FrameProjection = new Av1DDFrameProjection(this.diagnosticContext, rtpState.ssrc, rtpState.maxSequenceNumber, rtpState.maxTimestamp, av1PersistentState != null ? Integer.valueOf(av1PersistentState.getFrameNumber()) : null, av1PersistentState2 != null ? Integer.valueOf(av1PersistentState2.getTemplateId()) : null);
        this.lastFrameNumberIndexResumption = -1L;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public boolean accept(@NotNull PacketInfo packetInfo, int targetIndex) {
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
                packet = packetInfo.getPacket();
                if (!(packet instanceof Av1DDPacket)) {
                    this.logger.warn((Object)"Packet is not AV1 DD Packet");
                    return false;
                }
                incomingEncoding = ((Av1DDPacket)packet).getEncodingId();
                v0 = this.insertPacketInMap((Av1DDPacket)packet);
                if (v0 == null) {
                    return false;
                }
                result = v0;
                frame = result.getFrame();
                if (result.isNewFrame()) {
                    if (((Av1DDPacket)packet).isKeyframe() && this.frameIsNewSsrc(frame) && this.haveSubsequentNonAcceptedChain(frame, incomingEncoding, targetIndex)) {
                        frame.setKeyframe(false);
                    }
                    frame.setAccepted((acceptResult = this.av1QualityFilter.acceptFrame(frame, incomingEncoding, targetIndex, receivedTime = packetInfo.getReceivedTime())).getAccept() != false && this.frameIsProjectable(frame) != false);
                    if (frame.isAccepted()) {
                        projection = null;
                        try {
                            var10_11 = (Av1DDPacket)packet;
                            var11_13 = acceptResult.isResumption();
                            var12_14 = result.isReset();
                            var13_15 = acceptResult.getMark();
                            var14_16 = acceptResult.getNewDt();
                            projection = this.createProjection(frame, var10_11, var13_15, var11_13, var12_14, var14_16, receivedTime);
                        }
                        catch (Exception e) {
                            this.logger.warn((Object)"Failed to create frame projection", (Throwable)e);
                            frame.setAccepted(false);
                            return false;
                        }
                        frame.setProjection(projection);
                        if (RtpUtilsKt.isNewerThan((int)projection.getEarliestProjectedSeqNum(), (int)this.lastAv1FrameProjection.getLatestProjectedSeqNum())) {
                            this.lastAv1FrameProjection = projection;
                        }
                    }
                }
                if (!frame.isAccepted()) ** GOTO lbl-1000
                v1 = frame.getProjection();
                v2 = v1 != null ? v1.accept((Av1DDPacket)packet) : false;
                if (!v2) break block15;
                v3 = true;
                break block16;
            }
            if (frame.getProjection() == null) ** GOTO lbl-1000
            v4 = frame.getProjection();
            if (!(v4 != null ? v4.getClosedSeq() == -1 : false)) {
                v5 = frame.getProjection();
                this.logger.debug((Object)("Not accepting " + packet + ": frame projection is closed at " + (v5 != null ? Integer.valueOf(v5.getClosedSeq()) : null)));
            } else if (frame.getProjection() == null) {
                this.logger.warn((Object)("Not accepting " + packet + ": frame has no projection, even though QF accepted it"));
            } else {
                this.logger.warn((Object)("Not accepting " + packet + ", even though frame projection is not closed"));
            }
            v3 = false;
        }
        if (v3) {
            v6 = true;
        } else lbl-1000:
        // 2 sources

        {
            v6 = accept = false;
        }
        if (Av1DDAdaptiveSourceProjectionContext.timeSeriesLogger.isTraceEnabled()) {
            v7 = ((Av1DDPacket)packet).getDescriptor();
            v8 = ((Av1DDPacket)packet).getFrameInfo();
            v9 = ((Av1DDPacket)packet).getFrameInfo();
            v10 = ((Av1DDPacket)packet).getFrameInfo();
            pt = this.diagnosticContext.makeTimeSeriesPoint("rtp_av1").addField("ssrc", (Object)((Av1DDPacket)packet).getSsrc()).addField("timestamp", (Object)((Av1DDPacket)packet).getTimestamp()).addField("seq", (Object)((Av1DDPacket)packet).getSequenceNumber()).addField("frameNumber", (Object)((Av1DDPacket)packet).getFrameNumber()).addField("templateId", (Object)((Av1DDPacket)packet).getStatelessDescriptor().getFrameDependencyTemplateId()).addField("hasStructure", (Object)((v7 != null ? v7.getNewTemplateDependencyStructure() : null) != null)).addField("spatialLayer", (Object)(v8 != null ? Integer.valueOf(v8.getSpatialId()) : null)).addField("temporalLayer", (Object)(v9 != null ? Integer.valueOf(v9.getTemporalId()) : null)).addField("dti", (v11 /* !! */  = ((Av1DDPacket)packet).getFrameInfo()) != null && (v11 /* !! */  = v11 /* !! */ .getDti()) != null ? Av1DependencyDescriptorHeaderExtensionKt.toShortString((List)v11 /* !! */ ) : null).addField("hasInterPictureDependency", (Object)(v10 != null ? Boolean.valueOf(v10.hasInterPictureDependency()) : null)).addField("targetIndex", (Object)Av1DDRtpLayerDesc.Companion.indexString(targetIndex)).addField("new_frame", (Object)result.isNewFrame()).addField("accept", (Object)accept).addField("payload_length", (Object)((Av1DDPacket)packet).getPayloadLength()).addField("packet_length", (Object)packet.length);
            Intrinsics.checkNotNull((Object)pt);
            this.av1QualityFilter.addDiagnosticContext$jitsi_videobridge(pt);
            Av1DDAdaptiveSourceProjectionContext.timeSeriesLogger.trace((Map)pt);
        }
        return accept;
    }

    private final Av1DDFrame lookupAv1Frame(Av1DDPacket av1Packet) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(av1Packet.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.findFrame(av1Packet) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final PacketInsertionResult insertPacketInMap(Av1DDPacket av1Packet) {
        Object object;
        void $this$getOrPut$iv;
        Map map = this.av1FrameMaps;
        Long key$iv = av1Packet.getSsrc();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Av1DDFrameMap answer$iv = new Av1DDFrameMap(this.logger);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Av1DDFrameMap)object).insertPacket(av1Packet);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean haveSubsequentNonAcceptedChain(Av1DDFrame frame, int incomingEncoding, int targetIndex) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        if (av1DDFrameMap == null) {
            return false;
        }
        Av1DDFrameMap map = av1DDFrameMap;
        Av1TemplateDependencyStructure av1TemplateDependencyStructure = frame.getStructure();
        if (av1TemplateDependencyStructure == null) {
            return false;
        }
        Av1TemplateDependencyStructure structure = av1TemplateDependencyStructure;
        Collection dtsToCheck = incomingEncoding == RtpLayerDesc.Companion.getEidFromIndex(targetIndex) ? (Collection)SetsKt.setOf((Object)Av1DDRtpLayerDesc.Companion.getDtFromIndex(targetIndex)) : ((object = frame.getFrameInfo()) != null && (object = object.getDtisPresent()) != null ? (Collection)object : (Collection)SetsKt.emptySet());
        Iterable $this$mapNotNull$iv = dtsToCheck;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int it = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if ((Integer)CollectionsKt.getOrNull((List)structure.getDecodeTargetProtectedBy(), (int)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set chainsToCheck = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return map.nextFrameWith(frame, (Function1<? super Av1DDFrame, Boolean>)((Function1)arg_0 -> Av1DDAdaptiveSourceProjectionContext.haveSubsequentNonAcceptedChain$lambda$1(structure, this, chainsToCheck, arg_0))) != null;
    }

    private final boolean partOfActiveChain(Av1DDFrame $this$partOfActiveChain, int chainIdx) {
        Av1TemplateDependencyStructure av1TemplateDependencyStructure = $this$partOfActiveChain.getStructure();
        if (av1TemplateDependencyStructure == null) {
            return false;
        }
        Av1TemplateDependencyStructure structure = av1TemplateDependencyStructure;
        FrameInfo frameInfo = $this$partOfActiveChain.getFrameInfo();
        if (frameInfo == null) {
            return false;
        }
        FrameInfo frameInfo2 = frameInfo;
        int n = ((Collection)structure.getDecodeTargetProtectedBy()).size();
        for (int i = 0; i < n; ++i) {
            if (((Number)structure.getDecodeTargetProtectedBy().get(i)).intValue() != chainIdx || frameInfo2.getDti().get(i) != DTI.NOT_PRESENT && frameInfo2.getDti().get(i) != DTI.DISCARDABLE) continue;
            return false;
        }
        return true;
    }

    private final int seqGap(Av1DDFrame frame1, Av1DDFrame frame2) {
        int seqGap = RtpUtils.Companion.getSequenceNumberDelta(frame2.getEarliestKnownSequenceNumber(), frame1.getLatestKnownSequenceNumber());
        if (!frame1.isAccepted() && !frame2.isAccepted() && frame2.isImmediatelyAfter(frame1)) {
            seqGap = 0;
        } else {
            if (!frame1.isAccepted() && !frame1.getSeenEndOfFrame() && seqGap > 1) {
                --seqGap;
            }
            if (!frame2.isAccepted() && !frame2.getSeenStartOfFrame() && seqGap > 1) {
                --seqGap;
            }
            if (!frame1.isAccepted() && seqGap > 0) {
                --seqGap;
            }
        }
        return seqGap;
    }

    private final boolean frameIsNewSsrc(Av1DDFrame frame) {
        Av1DDFrame av1DDFrame = this.lastAv1FrameProjection.getAv1Frame();
        return !(av1DDFrame != null ? av1DDFrame.matchesSSRC(frame) : false);
    }

    private final boolean frameIsProjectable(Av1DDFrame frame) {
        return this.frameIsNewSsrc(frame) || frame.getIndex() >= this.lastFrameNumberIndexResumption;
    }

    private final synchronized Av1DDFrame prevFrame(Av1DDFrame frame) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.prevFrame(frame) : null;
    }

    private final synchronized Av1DDFrame nextFrame(Av1DDFrame frame) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.nextFrame(frame) : null;
    }

    private final Av1DDFrame findPrevAcceptedFrame(Av1DDFrame frame) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.findPrevAcceptedFrame(frame) : null;
    }

    private final Av1DDFrame findNextAcceptedFrame(Av1DDFrame frame) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.findNextAcceptedFrame(frame) : null;
    }

    private final Av1DDFrameProjection createProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, boolean isResumption, boolean isReset, Integer newDt, Instant receivedTime) {
        if (this.frameIsNewSsrc(frame)) {
            return this.createEncodingSwitchProjection(frame, initialPacket, mark, newDt, receivedTime);
        }
        if (isResumption) {
            return this.createResumptionProjection(frame, initialPacket, mark, newDt, receivedTime);
        }
        if (isReset) {
            return this.createResetProjection(frame, initialPacket, mark, newDt, receivedTime);
        }
        return this.createInEncodingProjection(frame, initialPacket, mark, newDt, receivedTime);
    }

    /*
     * Unable to fully structure code
     */
    private final Av1DDFrameProjection createEncodingSwitchProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        var6_6 = frame.isKeyframe();
        if (_Assertions.ENABLED && !var6_6) {
            var7_7 = "Assertion failed";
            throw new AssertionError((Object)var7_7);
        }
        var6_6 = initialPacket.isStartOfFrame();
        if (_Assertions.ENABLED && !var6_6) {
            var7_8 = "Assertion failed";
            throw new AssertionError((Object)var7_8);
        }
        this.lastFrameNumberIndexResumption = frame.getIndex();
        projectedSeqGap = 1;
        v0 = this.lastAv1FrameProjection.getAv1Frame();
        v1 = v0 != null ? !v0.getSeenEndOfFrame() : false;
        if (v1) {
            ++projectedSeqGap;
            this.lastAv1FrameProjection.close();
        }
        projectedSeq = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getLatestProjectedSeqNum(), projectedSeqGap);
        v2 = this.lastAv1FrameProjection.getCreated();
        if (v2 == null) ** GOTO lbl-1000
        created = v2;
        $i$a$-let-Av1DDAdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$1 = false;
        v3 = receivedTime;
        if (v3 != null) {
            it = v3;
            $i$a$-let-Av1DDAdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$1$1 = 0;
            v4 = (long)3000 * RangesKt.coerceAtLeast((long)Duration.between(created, receivedTime).dividedBy(33L).getSeconds(), (long)1L);
        } else {
            v4 = null;
        }
        v2 = v4;
        if (v4 != null) {
            v5 = v2.longValue();
        } else lbl-1000:
        // 2 sources

        {
            v5 = 3000L;
        }
        tsDelta = v5;
        projectedTs = RtpUtils.Companion.applyTimestampDelta(this.lastAv1FrameProjection.getTimestamp(), tsDelta);
        frameNumber = 0;
        templateIdDelta = 0;
        nextTemplateId = this.lastAv1FrameProjection.getNextTemplateId();
        if (nextTemplateId != null) {
            frameNumber = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getFrameNumber(), 1);
            structure = frame.getStructure();
            if (!(structure != null)) {
                throw new IllegalStateException("Check failed.");
            }
            templateIdDelta = Av1DDPacketKt.getTemplateIdDelta((int)nextTemplateId, (int)structure.getTemplateIdOffset());
        } else {
            frameNumber = frame.getFrameNumber();
            templateIdDelta = 0;
        }
        v6 = this.diagnosticContext;
        v7 = frame;
        v8 = this.lastAv1FrameProjection.getSsrc();
        v9 = projectedTs;
        v10 = RtpUtils.Companion.getSequenceNumberDelta(projectedSeq, initialPacket.getSequenceNumber());
        v11 = frameNumber;
        v12 = templateIdDelta;
        v13 = newDt;
        if (v13 != null) {
            $i$a$-let-Av1DDAdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$1$1 = ((Number)v13).intValue();
            var26_19 = v12;
            var25_20 = v11;
            var24_21 = v10;
            var22_22 = v9;
            var20_23 = v8;
            var19_24 = v7;
            var18_25 = v6;
            $i$a$-let-Av1DDAdaptiveSourceProjectionContext$createEncodingSwitchProjection$1 = false;
            v14 = frame.getStructure();
            var27_27 = v14 != null ? Integer.valueOf(v14.getDtBitmaskForDt((int)it)) : null;
            v6 = var18_25;
            v7 = var19_24;
            v8 = var20_23;
            v9 = var22_22;
            v10 = var24_21;
            v11 = var25_20;
            v12 = var26_19;
            v15 = var27_27;
        } else {
            v15 = null;
        }
        var28_28 = receivedTime;
        var29_29 = mark;
        var30_30 = v15;
        var31_31 = v12;
        var32_32 = v11;
        var33_33 = v10;
        var34_34 = v9;
        var36_35 = v8;
        var38_36 = v7;
        var39_37 = v6;
        return new Av1DDFrameProjection(var39_37, var38_36, var36_35, var34_34, var33_33, var32_32, var31_31, var30_30, var29_29, var28_28);
    }

    /*
     * WARNING - void declaration
     */
    private final Av1DDFrameProjection createResumptionProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        Integer n;
        int n2;
        this.lastFrameNumberIndexResumption = frame.getIndex();
        Av1DDFrame av1DDFrame = this.prevFrame(frame);
        Intrinsics.checkNotNull((Object)av1DDFrame);
        Av1DDFrame lastFrame = av1DDFrame;
        Av1DDFrame av1DDFrame2 = this.lastAv1FrameProjection.getAv1Frame();
        Intrinsics.checkNotNull((Object)av1DDFrame2);
        Av1DDFrame lastProjectedFrame = av1DDFrame2;
        long tsDelta = RtpUtils.Companion.getTimestampDiff(this.lastAv1FrameProjection.getTimestamp(), lastProjectedFrame.getTimestamp());
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(frame.getTimestamp(), tsDelta);
        int projectedFrameNumber = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getFrameNumber(), 1);
        if (frame.getStructure() != null) {
            Integer nextTemplateId = this.lastAv1FrameProjection.getNextTemplateId();
            if (nextTemplateId != null) {
                Av1TemplateDependencyStructure structure = frame.getStructure();
                if (!(structure != null)) {
                    throw new IllegalStateException("Check failed.");
                }
                n2 = Av1DDPacketKt.getTemplateIdDelta((int)nextTemplateId, (int)structure.getTemplateIdOffset());
            } else {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        int templateIdDelta = n2;
        int seqGap = RtpUtils.Companion.getSequenceNumberDelta(initialPacket.getSequenceNumber(), lastFrame.getLatestKnownSequenceNumber());
        int newSeq = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getLatestProjectedSeqNum(), seqGap);
        int seqDelta = RtpUtils.Companion.getSequenceNumberDelta(newSeq, initialPacket.getSequenceNumber());
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Av1DDFrame av1DDFrame3 = frame;
        long l = this.lastAv1FrameProjection.getSsrc();
        long l2 = projectedTs;
        int n3 = seqDelta;
        int n4 = projectedFrameNumber;
        int n5 = templateIdDelta;
        Integer n6 = newDt;
        if (n6 != null) {
            void it;
            int n7 = ((Number)n6).intValue();
            int n8 = n5;
            int n9 = n4;
            int n10 = n3;
            long l3 = l2;
            long l4 = l;
            Av1DDFrame av1DDFrame4 = av1DDFrame3;
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            boolean bl = false;
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = frame.getStructure();
            Integer n11 = av1TemplateDependencyStructure != null ? Integer.valueOf(av1TemplateDependencyStructure.getDtBitmaskForDt((int)it)) : null;
            diagnosticContext = diagnosticContext2;
            av1DDFrame3 = av1DDFrame4;
            l = l4;
            l2 = l3;
            n3 = n10;
            n4 = n9;
            n5 = n8;
            n = n11;
        } else {
            n = null;
        }
        Instant instant = receivedTime;
        boolean bl = mark;
        Integer n12 = n;
        int n13 = n5;
        int n14 = n4;
        int n15 = n3;
        long l5 = l2;
        long l6 = l;
        Av1DDFrame av1DDFrame5 = av1DDFrame3;
        DiagnosticContext diagnosticContext3 = diagnosticContext;
        return new Av1DDFrameProjection(diagnosticContext3, av1DDFrame5, l6, l5, n15, n14, n13, n12, bl, instant);
    }

    /*
     * WARNING - void declaration
     */
    private final Av1DDFrameProjection createResetProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        Integer n;
        int n2;
        Av1DDFrame av1DDFrame = this.lastAv1FrameProjection.getAv1Frame();
        Intrinsics.checkNotNull((Object)av1DDFrame);
        Av1DDFrame lastFrame = av1DDFrame;
        int seqDelta = RtpUtils.Companion.getSequenceNumberDelta(this.lastAv1FrameProjection.getLatestProjectedSeqNum(), lastFrame.getLatestKnownSequenceNumber());
        long tsDelta = RtpUtils.Companion.getTimestampDiff(this.lastAv1FrameProjection.getTimestamp(), lastFrame.getTimestamp());
        int frameNumberDelta = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getFrameNumber(), lastFrame.getFrameNumber());
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(frame.getTimestamp(), tsDelta);
        int projectedFrameNumber = RtpUtils.Companion.applySequenceNumberDelta(frame.getFrameNumber(), frameNumberDelta);
        if (frame.getStructure() != null) {
            Integer nextTemplateId = this.lastAv1FrameProjection.getNextTemplateId();
            if (nextTemplateId != null) {
                Av1TemplateDependencyStructure structure = frame.getStructure();
                if (!(structure != null)) {
                    throw new IllegalStateException("Check failed.");
                }
                n2 = Av1DDPacketKt.getTemplateIdDelta((int)nextTemplateId, (int)structure.getTemplateIdOffset());
            } else {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        int templateIdDelta = n2;
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Av1DDFrame av1DDFrame2 = frame;
        long l = this.lastAv1FrameProjection.getSsrc();
        long l2 = projectedTs;
        int n3 = seqDelta;
        int n4 = projectedFrameNumber;
        int n5 = templateIdDelta;
        Integer n6 = newDt;
        if (n6 != null) {
            void it;
            int structure = ((Number)n6).intValue();
            int n7 = n5;
            int n8 = n4;
            int n9 = n3;
            long l3 = l2;
            long l4 = l;
            Av1DDFrame av1DDFrame3 = av1DDFrame2;
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            boolean bl = false;
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = frame.getStructure();
            Integer n10 = av1TemplateDependencyStructure != null ? Integer.valueOf(av1TemplateDependencyStructure.getDtBitmaskForDt((int)it)) : null;
            diagnosticContext = diagnosticContext2;
            av1DDFrame2 = av1DDFrame3;
            l = l4;
            l2 = l3;
            n3 = n9;
            n4 = n8;
            n5 = n7;
            n = n10;
        } else {
            n = null;
        }
        Instant instant = receivedTime;
        boolean bl = mark;
        Integer n11 = n;
        int n12 = n5;
        int n13 = n4;
        int n14 = n3;
        long l5 = l2;
        long l6 = l;
        Av1DDFrame av1DDFrame4 = av1DDFrame2;
        DiagnosticContext diagnosticContext3 = diagnosticContext;
        return new Av1DDFrameProjection(diagnosticContext3, av1DDFrame4, l6, l5, n14, n13, n12, n11, bl, instant);
    }

    private final Av1DDFrameProjection createInEncodingProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        Av1DDFrame prevFrame = this.findPrevAcceptedFrame(frame);
        if (prevFrame != null) {
            return this.createInEncodingProjection(frame, prevFrame, initialPacket, mark, newDt, receivedTime);
        }
        Av1DDFrame nextFrame = this.findNextAcceptedFrame(frame);
        if (nextFrame != null) {
            return this.createInEncodingProjection(frame, nextFrame, initialPacket, mark, newDt, receivedTime);
        }
        Av1DDFrame av1DDFrame = this.lastAv1FrameProjection.getAv1Frame();
        Intrinsics.checkNotNull((Object)av1DDFrame);
        return this.createInEncodingProjection(frame, av1DDFrame, initialPacket, mark, newDt, receivedTime);
    }

    /*
     * WARNING - void declaration
     */
    private final Av1DDFrameProjection createInEncodingProjection(Av1DDFrame frame, Av1DDFrame refFrame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        Integer n;
        long tsGap = RtpUtils.Companion.getTimestampDiff(frame.getTimestamp(), refFrame.getTimestamp());
        int frameNumGap = RtpUtils.Companion.getSequenceNumberDelta(frame.getFrameNumber(), refFrame.getFrameNumber());
        int seqGap = 0;
        Av1DDFrame f1 = null;
        f1 = refFrame;
        Av1DDFrame f2 = null;
        int refSeq = 0;
        if (frameNumGap > 0) {
            do {
                if ((f2 = this.nextFrame(f1)) == null) {
                    boolean $i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$32 = false;
                    String $i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$32 = "No next frame found after frame with frame number " + f1.getFrameNumber() + ", even though refFrame " + refFrame.getFrameNumber() + " is before frame " + frame.getFrameNumber() + "!";
                    throw new IllegalStateException($i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$32.toString());
                }
                seqGap += this.seqGap(f1, f2);
                f1 = f2;
            } while (f2 != frame);
            Av1DDFrameProjection av1DDFrameProjection = refFrame.getProjection();
            Intrinsics.checkNotNull((Object)av1DDFrameProjection);
            refSeq = av1DDFrameProjection.getLatestProjectedSeqNum();
        } else {
            do {
                if ((f2 = this.prevFrame(f1)) == null) {
                    boolean $i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$42 = false;
                    String $i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$42 = "No previous frame found before frame with frame number " + f1.getFrameNumber() + ", even though refFrame " + refFrame.getFrameNumber() + " is after frame " + frame.getFrameNumber() + "!";
                    throw new IllegalStateException($i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$42.toString());
                }
                seqGap += -this.seqGap(f2, f1);
                f1 = f2;
            } while (f2 != frame);
            Av1DDFrameProjection av1DDFrameProjection = refFrame.getProjection();
            Intrinsics.checkNotNull((Object)av1DDFrameProjection);
            refSeq = av1DDFrameProjection.getEarliestProjectedSeqNum();
        }
        int projectedSeq = RtpUtils.Companion.applySequenceNumberDelta(refSeq, seqGap);
        Av1DDFrameProjection av1DDFrameProjection = refFrame.getProjection();
        Intrinsics.checkNotNull((Object)av1DDFrameProjection);
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(av1DDFrameProjection.getTimestamp(), tsGap);
        Av1DDFrameProjection av1DDFrameProjection2 = refFrame.getProjection();
        Intrinsics.checkNotNull((Object)av1DDFrameProjection2);
        int projectedFrameNumber = RtpUtils.Companion.applySequenceNumberDelta(av1DDFrameProjection2.getFrameNumber(), frameNumGap);
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Av1DDFrame av1DDFrame = frame;
        long l = this.lastAv1FrameProjection.getSsrc();
        long l2 = projectedTs;
        int n2 = RtpUtils.Companion.getSequenceNumberDelta(projectedSeq, initialPacket.getSequenceNumber());
        int n3 = projectedFrameNumber;
        int n4 = this.lastAv1FrameProjection.getTemplateIdDelta();
        Integer n5 = newDt;
        if (n5 != null) {
            void it;
            int n6 = ((Number)n5).intValue();
            int n7 = n4;
            int n8 = n3;
            int n9 = n2;
            long l3 = l2;
            long l4 = l;
            Av1DDFrame av1DDFrame2 = av1DDFrame;
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            boolean bl = false;
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = frame.getStructure();
            Integer n10 = av1TemplateDependencyStructure != null ? Integer.valueOf(av1TemplateDependencyStructure.getDtBitmaskForDt((int)it)) : null;
            diagnosticContext = diagnosticContext2;
            av1DDFrame = av1DDFrame2;
            l = l4;
            l2 = l3;
            n2 = n9;
            n3 = n8;
            n4 = n7;
            n = n10;
        } else {
            n = null;
        }
        Instant instant = receivedTime;
        boolean bl = mark;
        Integer n11 = n;
        int n12 = n4;
        int n13 = n3;
        int n14 = n2;
        long l5 = l2;
        long l6 = l;
        Av1DDFrame av1DDFrame3 = av1DDFrame;
        DiagnosticContext diagnosticContext3 = diagnosticContext;
        return new Av1DDFrameProjection(diagnosticContext3, av1DDFrame3, l6, l5, n14, n13, n12, n11, bl, instant);
    }

    @Override
    public boolean needsKeyframe() {
        if (this.av1QualityFilter.getNeedsKeyframe()) {
            return true;
        }
        return this.lastAv1FrameProjection.getAv1Frame() == null;
    }

    @Override
    public void rewriteRtp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        if (!(packetInfo.getPacket() instanceof Av1DDPacket)) {
            this.logger.info((Object)"Got a non-AV1 DD packet.");
            throw new RewriteException("Non-AV1 DD packet in AV1 DD source projection");
        }
        Av1DDPacket av1Packet = (Av1DDPacket)packetInfo.packetAs();
        Av1DDFrame av1DDFrame = this.lookupAv1Frame(av1Packet);
        if (av1DDFrame == null) {
            throw new RewriteException("Frame not in tracker (aged off?)");
        }
        Av1DDFrame av1Frame = av1DDFrame;
        Av1DDFrameProjection av1DDFrameProjection = av1Frame.getProjection();
        if (av1DDFrameProjection == null) {
            throw new RewriteException("Frame does not have projection?");
        }
        Av1DDFrameProjection av1Projection = av1DDFrameProjection;
        this.logger.trace(() -> Av1DDAdaptiveSourceProjectionContext.rewriteRtp$lambda$0(av1Packet));
        av1Projection.rewriteRtp(av1Packet);
    }

    @Override
    public boolean rewriteRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter((Object)rtcpSrPacket, (String)"rtcpSrPacket");
        Av1DDFrameProjection lastAv1FrameProjectionCopy = this.lastAv1FrameProjection;
        Av1DDFrame av1DDFrame = lastAv1FrameProjectionCopy.getAv1Frame();
        if (!(av1DDFrame != null ? rtcpSrPacket.getSenderSsrc() == av1DDFrame.getSsrc() : false)) {
            return false;
        }
        rtcpSrPacket.setSenderSsrc(lastAv1FrameProjectionCopy.getSsrc());
        long srcTs = rtcpSrPacket.getSenderInfo().getRtpTimestamp();
        long delta = RtpUtils.Companion.getTimestampDiff(lastAv1FrameProjectionCopy.getTimestamp(), lastAv1FrameProjectionCopy.getAv1Frame().getTimestamp());
        long dstTs = RtpUtils.Companion.applyTimestampDelta(srcTs, delta);
        if (srcTs != dstTs) {
            rtcpSrPacket.getSenderInfo().setRtpTimestamp(dstTs);
        }
        return true;
    }

    @Override
    @NotNull
    public RtpState getRtpState() {
        return new RtpState(this.lastAv1FrameProjection.getSsrc(), this.lastAv1FrameProjection.getLatestProjectedSeqNum(), this.lastAv1FrameProjection.getTimestamp());
    }

    @Override
    @NotNull
    public Object getPersistentState() {
        Integer n = this.lastAv1FrameProjection.getNextTemplateId();
        return new Av1PersistentState(this.lastAv1FrameProjection.getFrameNumber(), n != null ? n : 0);
    }

    @Override
    @NotNull
    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        ((Map)debugState).put("class", Av1DDAdaptiveSourceProjectionContext.class.getSimpleName());
        JSONArray mapSizes = new JSONArray();
        Iterator<Map.Entry<Long, Av1DDFrameMap>> iterator = this.av1FrameMaps.entrySet().iterator();
        while (iterator.hasNext()) {
            Av1DDFrameMap value;
            Long key;
            Map.Entry<Long, Av1DDFrameMap> entry;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"component1(...)");
            Intrinsics.checkNotNullExpressionValue((Object)entry.getValue(), (String)"component2(...)");
            JSONObject sizeInfo = new JSONObject();
            ((Map)sizeInfo).put("ssrc", key);
            ((Map)sizeInfo).put("size", value.size());
            mapSizes.add((Object)sizeInfo);
        }
        ((Map)debugState).put("av1FrameMaps", mapSizes);
        ((Map)debugState).put("av1QualityFilter", this.av1QualityFilter.getDebugState());
        return debugState;
    }

    private static final boolean haveSubsequentNonAcceptedChain$lambda$1(Av1TemplateDependencyStructure $structure, Av1DDAdaptiveSourceProjectionContext this$0, Set $chainsToCheck, Av1DDFrame it) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (it.isAccepted()) {
                return false;
            }
            if (it.getFrameInfo() == null) {
                it.updateParse($structure, this$0.logger);
            }
            Iterable $this$any$iv = $chainsToCheck;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int chainIdx = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!this$0.partOfActiveChain(it, chainIdx)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String rewriteRtp$lambda$0(Av1DDPacket $av1Packet) {
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension = $av1Packet.getDescriptor();
        return "Rewriting packet with structure " + System.identityHashCode(av1DependencyDescriptorHeaderExtension != null ? av1DependencyDescriptorHeaderExtension.getStructure() : null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDAdaptiveSourceProjectionContext$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

