/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J,\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d0\u001f2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u000f\u0010#\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateEstimator;", "", "<init>", "()V", "sum", "", "initialWindowMs", "noninitialWindowMs", "uncertaintyScale", "", "uncertaintyScaleInAlr", "smallSampleUncertaintyScale", "smallSampleThreshold", "Lorg/jitsi/nlj/util/DataSize;", "uncertaintySymmetryCap", "Lorg/jitsi/nlj/util/Bandwidth;", "J", "estimateFloor", "currentWindowMs", "", "prevTimeMs", "bitrateEstimateKbps", "bitrateEstimateVar", "update", "", "atTime", "Ljava/time/Instant;", "amount", "inAlr", "", "updateWindow", "Lkotlin/Pair;", "nowMs", "bytes", "rateWindowMs", "bitrate", "bitrate-4yB3KFE", "peekRate", "peekRate-4yB3KFE", "expectFastRateChange", "Companion", "jitsi-media-transform"})
public class BitrateEstimator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int sum;
    private final int initialWindowMs;
    private final int noninitialWindowMs;
    private final float uncertaintyScale;
    private final float uncertaintyScaleInAlr;
    private final float smallSampleUncertaintyScale;
    @NotNull
    private final DataSize smallSampleThreshold;
    private final long uncertaintySymmetryCap;
    private final long estimateFloor;
    private long currentWindowMs;
    private long prevTimeMs;
    private float bitrateEstimateKbps;
    private float bitrateEstimateVar;
    public static final int kInitialRateWindowMs = 500;
    public static final int kRateWindowMs = 150;
    public static final int kMinRateWindowMs = 150;
    public static final int kMaxRateWindowMs = 1000;

    public BitrateEstimator() {
        this.initialWindowMs = 500;
        this.noninitialWindowMs = 150;
        this.uncertaintyScaleInAlr = this.uncertaintyScale = 10.0f;
        this.smallSampleUncertaintyScale = this.uncertaintyScale;
        this.smallSampleThreshold = DataSize.Companion.getZERO();
        this.uncertaintySymmetryCap = Bandwidth.Companion.getZERO-rlWvAKk();
        this.estimateFloor = Bandwidth.Companion.getZERO-rlWvAKk();
        this.prevTimeMs = -1L;
        this.bitrateEstimateKbps = -1.0f;
        this.bitrateEstimateVar = 50.0f;
    }

    public void update(@NotNull Instant atTime, @NotNull DataSize amount, boolean inAlr) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        int rateWindowMs = this.bitrateEstimateKbps < 0.0f ? this.initialWindowMs : this.noninitialWindowMs;
        Pair<Float, Boolean> pair = this.updateWindow(InstantKt.toRoundedEpochMilli((Instant)atTime), MathKt.roundToInt((double)amount.getBytes()), rateWindowMs);
        float bitrateSampleKbps = ((Number)pair.component1()).floatValue();
        boolean isSmallSample = (Boolean)pair.component2();
        if (bitrateSampleKbps < 0.0f) {
            return;
        }
        if (this.bitrateEstimateKbps < 0.0f) {
            this.bitrateEstimateKbps = bitrateSampleKbps;
            return;
        }
        float scale = isSmallSample && bitrateSampleKbps < this.bitrateEstimateKbps ? this.smallSampleUncertaintyScale : (inAlr && bitrateSampleKbps < this.bitrateEstimateKbps ? this.uncertaintyScaleInAlr : this.uncertaintyScale);
        float sampleUncertainty = scale * Math.abs(this.bitrateEstimateKbps - bitrateSampleKbps) / (this.bitrateEstimateKbps + Math.min(bitrateSampleKbps, (float)Bandwidth.getKbps-impl(this.uncertaintySymmetryCap)));
        float sampleVar = sampleUncertainty * sampleUncertainty;
        float predBitrateEstimateVar = this.bitrateEstimateVar + 5.0f;
        this.bitrateEstimateKbps = (sampleVar * this.bitrateEstimateKbps + predBitrateEstimateVar * bitrateSampleKbps) / (sampleVar + predBitrateEstimateVar);
        this.bitrateEstimateKbps = Math.max(this.bitrateEstimateKbps, (float)Bandwidth.getKbps-impl(this.estimateFloor));
        this.bitrateEstimateVar = sampleVar * predBitrateEstimateVar / (sampleVar + predBitrateEstimateVar);
    }

    private final Pair<Float, Boolean> updateWindow(long nowMs, int bytes, int rateWindowMs) {
        if (nowMs < this.prevTimeMs) {
            this.prevTimeMs = -1L;
            this.sum = 0;
            this.currentWindowMs = 0L;
        }
        if (this.prevTimeMs >= 0L) {
            this.currentWindowMs += nowMs - this.prevTimeMs;
            if (nowMs - this.prevTimeMs > (long)rateWindowMs) {
                this.sum = 0;
                this.currentWindowMs %= (long)rateWindowMs;
            }
        }
        this.prevTimeMs = nowMs;
        float bitrateSample = 0.0f;
        boolean isSmallSample = false;
        if (this.currentWindowMs >= (long)rateWindowMs) {
            isSmallSample = (double)this.sum < this.smallSampleThreshold.getBytes();
            bitrateSample = 8.0f * (float)this.sum / (float)rateWindowMs;
            this.currentWindowMs -= (long)rateWindowMs;
            this.sum = 0;
        } else {
            isSmallSample = false;
            bitrateSample = -1.0f;
        }
        this.sum += bytes;
        return new Pair((Object)Float.valueOf(bitrateSample), (Object)isSmallSample);
    }

    @Nullable
    public Bandwidth bitrate-4yB3KFE() {
        return this.bitrateEstimateKbps < 0.0f ? null : Bandwidth.box-impl(BandwidthKt.getKbps(this.bitrateEstimateKbps));
    }

    @Nullable
    public final Bandwidth peekRate-4yB3KFE() {
        return this.currentWindowMs > 0L ? Bandwidth.box-impl(BandwidthKt.per(DataSizeKt.getBytes(this.sum), DurationKt.getMs((long)this.currentWindowMs))) : null;
    }

    public void expectFastRateChange() {
        this.bitrateEstimateVar += (float)200;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateEstimator$Companion;", "", "<init>", "()V", "kInitialRateWindowMs", "", "kRateWindowMs", "kMinRateWindowMs", "kMaxRateWindowMs", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

