/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketTiming;
import org.jitsi.nlj.rtp.bandwidthestimation2.TrendlineEstimatorSettings;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a%\u0010\u0006\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"linearFitSlope", "", "packets", "Lkotlin/collections/ArrayDeque;", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketTiming;", "(Lkotlin/collections/ArrayDeque;)Ljava/lang/Double;", "computeSlopeCap", "settings", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TrendlineEstimatorSettings;", "(Lkotlin/collections/ArrayDeque;Lorg/jitsi/nlj/rtp/bandwidthestimation2/TrendlineEstimatorSettings;)Ljava/lang/Double;", "jitsi-media-transform"})
public final class TrendlineEstimatorKt {
    private static final Double linearFitSlope(ArrayDeque<PacketTiming> packets) {
        if (!(packets.size() >= 2)) {
            throw new IllegalStateException("Check failed.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        for (PacketTiming packet : packets) {
            sumX += packet.getArrivalTimeMs();
            sumY += packet.getSmoothedDelayMs();
        }
        double xAvg = sumX / (double)packets.size();
        double yAvg = sumY / (double)packets.size();
        double numerator = 0.0;
        double denominator = 0.0;
        for (PacketTiming packet : packets) {
            double x = packet.getArrivalTimeMs();
            double y = packet.getSmoothedDelayMs();
            numerator += (x - xAvg) * (y - yAvg);
            denominator += (x - xAvg) * (x - xAvg);
        }
        if (denominator == 0.0) {
            return null;
        }
        return numerator / denominator;
    }

    private static final Double computeSlopeCap(ArrayDeque<PacketTiming> packets, TrendlineEstimatorSettings settings) {
        if (!(1 <= settings.getBeginningPackets() && settings.getBeginningPackets() < packets.size())) {
            throw new IllegalStateException("Check failed.");
        }
        if (!(1 <= settings.getEndPackets() && settings.getEndPackets() < packets.size())) {
            throw new IllegalStateException("Check failed.");
        }
        if (!(settings.getBeginningPackets() + settings.getEndPackets() <= packets.size())) {
            throw new IllegalStateException("Check failed.");
        }
        PacketTiming early = (PacketTiming)packets.first();
        int n = settings.getBeginningPackets();
        for (int i = 1; i < n; ++i) {
            if (!(((PacketTiming)packets.get(i)).getRawDelayMs() < early.getRawDelayMs())) continue;
            early = (PacketTiming)packets.get(i);
        }
        int lateStart = packets.size() - settings.getEndPackets();
        PacketTiming late = (PacketTiming)packets.get(lateStart);
        int n2 = packets.size();
        for (int i = lateStart + 1; i < n2; ++i) {
            if (!(((PacketTiming)packets.get(i)).getRawDelayMs() < late.getRawDelayMs())) continue;
            late = (PacketTiming)packets.get(i);
        }
        if (late.getArrivalTimeMs() - early.getArrivalTimeMs() < 1.0) {
            return null;
        }
        return (late.getRawDelayMs() - early.getRawDelayMs()) / (late.getArrivalTimeMs() - early.getArrivalTimeMs()) + settings.getCapUncertainty();
    }

    public static final /* synthetic */ Double access$linearFitSlope(ArrayDeque packets) {
        return TrendlineEstimatorKt.linearFitSlope((ArrayDeque<PacketTiming>)packets);
    }

    public static final /* synthetic */ Double access$computeSlopeCap(ArrayDeque packets, TrendlineEstimatorSettings settings) {
        return TrendlineEstimatorKt.computeSlopeCap((ArrayDeque<PacketTiming>)packets, settings);
    }
}

