/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarInnerDir extends JarDir {

    public JarInnerDir(ZipFile zipFile, ZipEntry firstEntry, String path, String nativePath) {
        this.zipFile = zipFile;
        setPath(path, nativePath);
        this.lastModifiedTime = firstEntry.getTime();
        accessFlags = ACCESS_READ;
    }

    @Override
    protected String getRelativePath() {
        return nativePath;
    }

    @Override
    protected void populateAttributes() {
    }

    @Override
    public void closeThis() {
    }

}
