/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuListener;

public class TmmUIMenuHelper {
    private TmmUIMenuHelper() {
        throw new IllegalAccessError();
    }

    public static JMenu cloneMenu(JMenu menu) {
        JMenu destination = new JMenu(menu.getText());
        destination.setIcon(menu.getIcon());
        for (Component component : menu.getMenuComponents()) {
            if (component instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)component;
                destination.add(TmmUIMenuHelper.cloneMenuItem(menuItem));
                continue;
            }
            if (!(component instanceof JSeparator)) continue;
            destination.addSeparator();
        }
        return destination;
    }

    public static JMenu morphJPopupMenuToJMenu(JPopupMenu source, String title) {
        return TmmUIMenuHelper.morphJPopupMenuToJMenu(source, title, null);
    }

    public static JMenu morphJPopupMenuToJMenu(JPopupMenu source, String title, Icon icon) {
        JMenu destination = new JMenu(title);
        if (icon != null) {
            destination.setIcon(icon);
        }
        for (Component component : source.getComponents()) {
            if (component instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)component;
                destination.add(TmmUIMenuHelper.cloneMenuItem(menuItem));
                continue;
            }
            if (!(component instanceof JSeparator)) continue;
            destination.addSeparator();
        }
        return destination;
    }

    static JMenuItem cloneMenuItem(JMenuItem item) {
        JMenuItem jmi;
        if (item == null) {
            return null;
        }
        if (item instanceof JMenu) {
            JMenu menu = (JMenu)item;
            JMenu jm = new JMenu();
            int count = menu.getItemCount();
            jm.setText(menu.getText());
            jm.setIcon(menu.getIcon());
            for (PopupMenuListener popupMenuListener : menu.getPopupMenu().getPopupMenuListeners()) {
                if (!(popupMenuListener instanceof MenuListener)) continue;
                MenuListener menuListener = (MenuListener)((Object)popupMenuListener);
                jm.addMenuListener(menuListener);
            }
            for (int i = 0; i < count; ++i) {
                JMenuItem ijmi = TmmUIMenuHelper.cloneMenuItem(menu.getItem(i));
                if (ijmi == null) {
                    jm.addSeparator();
                    continue;
                }
                jm.add(ijmi);
            }
            jmi = jm;
        } else {
            jmi = new JMenuItem();
            jmi.setText(item.getText());
            jmi.setIcon(item.getIcon());
        }
        for (ActionListener actionListener : item.getActionListeners()) {
            jmi.addActionListener(actionListener);
        }
        if (item.getAction() != null) {
            jmi.setAction(item.getAction());
        }
        return jmi;
    }
}

