/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;
import org.tinymediamanager.ui.ArtworkDragAndDropListener;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TableSpinnerEditor;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.combobox.AutocompleteSupport;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.tabbedpane.TmmTabbedPane;
import org.tinymediamanager.ui.components.table.MediaIdTable;
import org.tinymediamanager.ui.components.table.MediaRatingTable;
import org.tinymediamanager.ui.components.table.MediaTrailerTable;
import org.tinymediamanager.ui.components.table.MouseKeyboardSortingStrategy;
import org.tinymediamanager.ui.components.table.PersonTable;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.components.textfield.TmmObligatoryTextArea;
import org.tinymediamanager.ui.components.textfield.TmmRoundTextArea;
import org.tinymediamanager.ui.dialogs.AbstractEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;
import org.tinymediamanager.ui.panels.IdEditorPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.RatingEditorPanel;
import org.tinymediamanager.ui.renderer.LeftDotTableCellRenderer;
import org.tinymediamanager.ui.tvshows.EpisodeNumberTable;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeNumberEditorPanel;

public class TvShowEditorDialog
extends AbstractEditorDialog {
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private final TvShow tvShowToEdit;
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final JTabbedPane tabbedPane = new TmmTabbedPane();
    private final EventList<Person> actors;
    private final EventList<Person> crew;
    private final List<MediaGenres> genres = ObservableCollections.observableList(new ArrayList());
    private final EventList<MediaIdTable.MediaId> ids;
    private final EventList<MediaRatingTable.Rating> ratings;
    private final List<String> tags = ObservableCollections.observableList(new ArrayList());
    private final SortedList<EpisodeEditorContainer> episodes;
    private final EventList<MediaTrailer> trailers;
    private List<String> extrafanarts = null;
    private JTextArea tfTitle;
    private YearSpinner spYear;
    private JTextArea taPlot;
    private JTextArea tfTagline;
    private PersonTable tableActors;
    private PersonTable tableCrew;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private ImageLabel lblBanner;
    private JSpinner spRuntime;
    private JTextArea tfStudio;
    private JList<MediaGenres> listGenres;
    private AutocompleteComboBox<MediaGenres> cbGenres;
    private AutocompleteSupport<MediaGenres> cbGenresAutocompleteSupport;
    private JSpinner spRating;
    private JComboBox<MediaCertification> cbCertification;
    private JComboBox<MediaAiredStatus> cbStatus;
    private AutocompleteComboBox<String> cbTags;
    private AutocompleteSupport<String> cbTagsAutocompleteSupport;
    private JList<String> listTags;
    private JSpinner spDateAdded;
    private JSpinner spTop250;
    private DatePicker dpPremiered;
    private JComboBox<EpisodeGroupContainer> cbEpisodeOrder;
    private TmmTable tableEpisodes;
    private JTextArea tfSorttitle;
    private JTextArea taNote;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfClearLogo;
    private JTextField tfBanner;
    private JTextField tfClearArt;
    private JTextField tfThumb;
    private ImageLabel lblClearlogo;
    private ImageLabel lblClearart;
    private ImageLabel lblThumb;
    private ImageLabel lblCharacterart;
    private ImageLabel lblKeyart;
    private TmmTable tableIds;
    private TmmTable tableRatings;
    private JTextArea tfOriginalTitle;
    private JTextArea tfEnglishTitle;
    private JTextArea tfCountry;
    private JTextField tfCharacterart;
    private JTextField tfKeyart;
    private MediaTrailerTable tableTrailer;

    /*
     * WARNING - void declaration
     */
    public TvShowEditorDialog(TvShow tvShow, int queueIndex, int queueSize, int selectedTab) {
        super(TmmResourceBundle.getString("tvshow.edit") + (String)(queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : "") + "  < " + tvShow.getPathNIO() + " >", "tvShowEditor", tvShow);
        void var8_14;
        List<MediaCertification> availableCertifications;
        this.setMinimumSize(new Dimension(800, 600));
        this.tvShowToEdit = tvShow;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.ids = MediaIdTable.convertIdMapToEventList(this.tvShowToEdit.getIds());
        this.ratings = MediaRatingTable.convertRatingMapToEventList(this.tvShowToEdit.getRatings(), false);
        MediaRating userMediaRating = this.tvShowToEdit.getRating("user");
        this.actors = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.crew = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.episodes = new SortedList((EventList)new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(EpisodeEditorContainer.class)));
        this.trailers = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaTrailer.class));
        this.initComponents();
        this.initDataBindings();
        this.tfTitle.setText(tvShow.getTitle());
        this.tfOriginalTitle.setText(tvShow.getOriginalTitle());
        this.tfEnglishTitle.setText(tvShow.getEnglishTitle());
        this.tfSorttitle.setText(tvShow.getSortTitle());
        this.tfTagline.setText(tvShow.getTagline());
        this.taPlot.setText(tvShow.getPlot());
        this.lblPoster.setImagePath(tvShow.getArtworkFilename(MediaFileType.POSTER));
        this.lblFanart.setImagePath(tvShow.getArtworkFilename(MediaFileType.FANART));
        this.lblClearlogo.setImagePath(tvShow.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(tvShow.getArtworkFilename(MediaFileType.CLEARART));
        this.lblThumb.setImagePath(tvShow.getArtworkFilename(MediaFileType.THUMB));
        this.lblBanner.setImagePath(tvShow.getArtworkFilename(MediaFileType.BANNER));
        this.lblCharacterart.setImagePath(tvShow.getArtworkFilename(MediaFileType.CHARACTERART));
        this.lblKeyart.setImagePath(tvShow.getArtworkFilename(MediaFileType.KEYART));
        this.tfPoster.setText(tvShow.getArtworkUrl(MediaFileType.POSTER));
        this.tfFanart.setText(tvShow.getArtworkUrl(MediaFileType.FANART));
        this.tfClearLogo.setText(tvShow.getArtworkUrl(MediaFileType.CLEARLOGO));
        this.tfClearArt.setText(tvShow.getArtworkUrl(MediaFileType.CLEARART));
        this.tfThumb.setText(tvShow.getArtworkUrl(MediaFileType.THUMB));
        this.tfBanner.setText(tvShow.getArtworkUrl(MediaFileType.BANNER));
        this.tfCharacterart.setText(tvShow.getArtworkUrl(MediaFileType.CHARACTERART));
        this.tfKeyart.setText(tvShow.getArtworkUrl(MediaFileType.KEYART));
        this.tfStudio.setText(tvShow.getProductionCompany());
        this.tfCountry.setText(tvShow.getCountry());
        this.taNote.setText(tvShow.getNote());
        this.cbStatus.setSelectedItem((Object)tvShow.getStatus());
        this.spRuntime.setValue(tvShow.getRuntime());
        this.spTop250.setValue(tvShow.getTop250());
        int year = tvShow.getYear();
        this.spYear.setValue(year);
        this.spDateAdded.setValue(tvShow.getDateAdded());
        this.spRating.setModel(new SpinnerNumberModel(userMediaRating.getRating(), 0.0, 10.0, 0.1));
        for (Person person : tvShow.getActors()) {
            this.actors.add((Object)new Person(person));
        }
        this.genres.addAll(tvShow.getGenres());
        this.tags.addAll(this.tvShowToEdit.getTags());
        if (TvShowModuleManager.getInstance().getSettings().isImageExtraFanart()) {
            this.extrafanarts = new ArrayList<String>(this.tvShowToEdit.getExtraFanartUrls());
        }
        if (!(availableCertifications = MediaCertification.getCertificationsforCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry())).contains((Object)this.tvShowToEdit.getCertification())) {
            availableCertifications.add(0, this.tvShowToEdit.getCertification());
        }
        for (MediaCertification cert : availableCertifications) {
            this.cbCertification.addItem(cert);
        }
        this.cbCertification.setSelectedItem((Object)this.tvShowToEdit.getCertification());
        for (TvShowEpisode episode : this.tvShowToEdit.getEpisodes()) {
            EpisodeEditorContainer container = new EpisodeEditorContainer(episode);
            container.season = episode.getSeason(tvShow.getEpisodeGroup());
            container.episode = episode.getEpisode(tvShow.getEpisodeGroup());
            this.episodes.add((Object)container);
        }
        Object var8_11 = null;
        LinkedHashMap<MediaEpisodeGroup, EpisodeGroupContainer> episodeGroups = new LinkedHashMap<MediaEpisodeGroup, EpisodeGroupContainer>();
        for (TvShowEpisode episode : this.tvShowToEdit.getEpisodes()) {
            for (MediaEpisodeNumber mediaEpisodeNumber : episode.getEpisodeNumbers()) {
                if (!mediaEpisodeNumber.containsAnyNumber()) continue;
                EpisodeGroupContainer container = (EpisodeGroupContainer)episodeGroups.get(mediaEpisodeNumber.episodeGroup());
                if (container == null) {
                    container = new EpisodeGroupContainer(mediaEpisodeNumber.episodeGroup());
                    if (this.tvShowToEdit.getEpisodeGroup().equals(mediaEpisodeNumber.episodeGroup())) {
                        EpisodeGroupContainer episodeGroupContainer2 = container;
                    }
                    episodeGroups.put(mediaEpisodeNumber.episodeGroup(), container);
                }
                ++container.numberOfEpisodes;
            }
        }
        for (MediaEpisodeGroup episodeGroup : this.tvShowToEdit.getEpisodeGroups()) {
            EpisodeGroupContainer container = (EpisodeGroupContainer)episodeGroups.get(episodeGroup);
            if (container != null) continue;
            container = new EpisodeGroupContainer(episodeGroup);
            if (this.tvShowToEdit.getEpisodeGroup().equals(episodeGroup)) {
                EpisodeGroupContainer episodeGroupContainer3 = container;
            }
            episodeGroups.put(episodeGroup, container);
        }
        episodeGroups.values().forEach(episodeGroupContainer -> this.cbEpisodeOrder.addItem((EpisodeGroupContainer)episodeGroupContainer));
        if (var8_14 != null) {
            this.cbEpisodeOrder.setSelectedItem(var8_14);
        }
        this.cbEpisodeOrder.addItemListener(e -> this.buildEpisodeContainer());
        this.trailers.addAll(tvShow.getTrailer());
        this.tableEpisodes.getColumnModel().getColumn(1).setCellRenderer(new LeftDotTableCellRenderer());
        this.tableEpisodes.getColumnModel().getColumn(2).setCellEditor(new TableSpinnerEditor());
        this.tableEpisodes.getColumnModel().getColumn(3).setCellEditor(new TableSpinnerEditor());
        TableColumnResizer.adjustColumnPreferredWidths(this.tableActors, 6);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableEpisodes, 6);
        this.tableTrailer.getModel().addTableModelListener(arg0 -> {
            int row;
            MediaTrailer changedTrailer;
            if (arg0.getColumn() == 0 && (changedTrailer = (MediaTrailer)this.trailers.get(row = arg0.getFirstRow())).getInNfo().booleanValue()) {
                for (MediaTrailer trailer : this.trailers) {
                    if (trailer == changedTrailer) continue;
                    trailer.setInNfo(Boolean.FALSE);
                }
            }
        });
        this.registerDropTarget(this.lblPoster, this.tfPoster);
        this.registerDropTarget(this.lblFanart, this.tfFanart);
        this.registerDropTarget(this.lblBanner, this.tfBanner);
        this.registerDropTarget(this.lblClearart, this.tfClearArt);
        this.registerDropTarget(this.lblClearlogo, this.tfClearLogo);
        this.registerDropTarget(this.lblThumb, this.tfThumb);
        this.registerDropTarget(this.lblKeyart, this.tfKeyart);
        this.registerDropTarget(this.lblCharacterart, this.tfCharacterart);
        this.tabbedPane.setSelectedIndex(selectedTab);
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    private void buildEpisodeContainer() {
        Object obj = this.cbEpisodeOrder.getSelectedItem();
        if (obj instanceof EpisodeGroupContainer) {
            EpisodeGroupContainer episodeGroupContainer = (EpisodeGroupContainer)obj;
            for (EpisodeEditorContainer episodeContainer : this.episodes) {
                MediaEpisodeNumber episodeNumber = episodeContainer.getEpisodeNumber(episodeGroupContainer.episodeGroup);
                if (episodeNumber != null) {
                    episodeContainer.setSeason(episodeNumber.season());
                    episodeContainer.setEpisode(episodeNumber.episode());
                    continue;
                }
                episodeContainer.setSeason(-1);
                episodeContainer.setEpisode(-1);
            }
        }
    }

    private void initComponents() {
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(this.tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel details1Panel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), details1Panel);
        details1Panel.setLayout((LayoutManager)new MigLayout("", "[][grow][50lp:75lp][][60lp:75lp][100lp:n][][25lp:n][200lp:250lp,grow]", "[][][][][][75lp:25%:25%,grow][][][pref!][][][][75lp:20%:20%,grow][50lp:50lp:100lp,grow 50]"));
        TmmLabel lblTitle = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        details1Panel.add((Component)lblTitle, "cell 0 0,alignx right");
        this.tfTitle = new TmmObligatoryTextArea();
        details1Panel.add((Component)this.tfTitle, "cell 1 0 6 1,growx,wmin 0");
        this.lblPoster = new ImageLabel();
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.POSTER, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblPoster, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblPoster, TvShowEditorDialog.this.tfPoster);
            }
        });
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        details1Panel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster")), "cell 8 0");
        LinkLabel lblPosterSize = new LinkLabel();
        details1Panel.add((Component)lblPosterSize, "cell 8 0");
        FlatButton btnDeletePoster = new FlatButton(IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        details1Panel.add((Component)btnDeletePoster, "cell 8 0");
        details1Panel.add((Component)this.lblPoster, "cell 8 1 1 8,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, btnDeletePoster, MediaFileType.POSTER));
        TmmLabel lblOriginalTitleT = new TmmLabel(TmmResourceBundle.getString("metatag.originaltitle"));
        details1Panel.add((Component)lblOriginalTitleT, "cell 0 1,alignx right");
        this.tfOriginalTitle = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfOriginalTitle, "cell 1 1 6 1,growx,wmin 0");
        TmmLabel lblTitleEnglish = new TmmLabel(TmmResourceBundle.getString("metatag.title.english"));
        details1Panel.add((Component)lblTitleEnglish, "cell 0 2,alignx right");
        this.tfEnglishTitle = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfEnglishTitle, "cell 1 2 6 1,growx,wmin 0");
        TmmLabel lblSortTitle = new TmmLabel(TmmResourceBundle.getString("metatag.sorttitle"));
        details1Panel.add((Component)lblSortTitle, "cell 0 3,alignx right");
        this.tfSorttitle = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfSorttitle, "cell 1 3 6 1,growx,wmin 0");
        TmmLabel lblTagline = new TmmLabel(TmmResourceBundle.getString("metatag.tagline"));
        details1Panel.add((Component)lblTagline, "cell 0 4,alignx right");
        this.tfTagline = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfTagline, "cell 1 4 6 1,growx,wmin 0");
        TmmLabel lblPlot = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        details1Panel.add((Component)lblPlot, "cell 0 5,alignx right,aligny top");
        JScrollPane scrollPanePlot = new JScrollPane();
        details1Panel.add((Component)scrollPanePlot, "cell 1 5 6 1,wmin 0,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        this.taPlot.setForeground(UIManager.getColor("TextField.foreground"));
        this.taPlot.setFocusTraversalKeys(0, null);
        this.taPlot.setFocusTraversalKeys(1, null);
        scrollPanePlot.setViewportView(this.taPlot);
        TmmLabel lblYear = new TmmLabel(TmmResourceBundle.getString("metatag.year"));
        details1Panel.add((Component)lblYear, "cell 0 6,alignx right");
        this.spYear = new YearSpinner();
        details1Panel.add((Component)this.spYear, "cell 1 6,growx");
        TmmLabel lblpremiered = new TmmLabel(TmmResourceBundle.getString("metatag.premiered"));
        details1Panel.add((Component)lblpremiered, "cell 3 6,alignx right");
        this.dpPremiered = new DatePicker(this.tvShowToEdit.getFirstAired());
        details1Panel.add((Component)this.dpPremiered, "cell 4 6 2 1,growx");
        TmmLabel lblStudio = new TmmLabel(TmmResourceBundle.getString("metatag.studio"));
        details1Panel.add((Component)lblStudio, "cell 0 7,alignx right");
        this.tfStudio = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfStudio, "cell 1 7 6 1,growx,wmin 0");
        TmmLabel lblCountryT = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        details1Panel.add((Component)lblCountryT, "cell 0 8,alignx trailing");
        this.tfCountry = new TmmRoundTextArea();
        details1Panel.add((Component)this.tfCountry, "cell 1 8 6 1,growx,wmin 0");
        TmmLabel lblRuntime = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        details1Panel.add((Component)lblRuntime, "cell 0 9,alignx right");
        this.spRuntime = new JSpinner();
        details1Panel.add((Component)this.spRuntime, "flowx,cell 1 9,growx");
        TmmLabel lblMin = new TmmLabel(TmmResourceBundle.getString("metatag.minutes"));
        details1Panel.add((Component)lblMin, "cell 1 9");
        TmmLabel lblStatus = new TmmLabel(TmmResourceBundle.getString("metatag.status"));
        details1Panel.add((Component)lblStatus, "cell 3 9,alignx right");
        this.cbStatus = new JComboBox<MediaAiredStatus>(MediaAiredStatus.values());
        details1Panel.add(this.cbStatus, "cell 4 9,growx");
        TmmLabel lblCertification = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        details1Panel.add((Component)lblCertification, "cell 0 10,alignx right");
        this.cbCertification = new JComboBox();
        details1Panel.add(this.cbCertification, "cell 1 10,growx");
        TmmLabel lblRating = new TmmLabel(TmmResourceBundle.getString("metatag.userrating"));
        details1Panel.add((Component)lblRating, "cell 0 11,alignx right");
        this.spRating = new JSpinner();
        details1Panel.add((Component)this.spRating, "cell 1 11,growx");
        JLabel lblUserRatingHint = new JLabel(IconManager.HINT);
        lblUserRatingHint.setToolTipText(TmmResourceBundle.getString("edit.userrating.hint"));
        details1Panel.add((Component)lblUserRatingHint, "cell 2 11");
        TmmLabel lblTop = new TmmLabel(TmmResourceBundle.getString("metatag.top250"));
        details1Panel.add((Component)lblTop, "cell 3 11,alignx right");
        this.spTop250 = new JSpinner();
        details1Panel.add((Component)this.spTop250, "cell 4 11,growx");
        TmmLabel lblRatingsT = new TmmLabel(TmmResourceBundle.getString("metatag.ratings"));
        details1Panel.add((Component)lblRatingsT, "flowy,cell 0 12,alignx right,aligny top");
        JScrollPane scrollPaneRatings = new JScrollPane();
        details1Panel.add((Component)scrollPaneRatings, "cell 1 12,wmin 0,grow");
        this.tableRatings = new MediaRatingTable(this.ratings);
        this.tableRatings.configureScrollPane(scrollPaneRatings);
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.BACKGROUND, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblFanart, MediaType.TV_SHOW);
                dialog.bindExtraFanarts(TvShowEditorDialog.this.extrafanarts);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblFanart, TvShowEditorDialog.this.tfFanart);
            }
        });
        details1Panel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart")), "cell 8 10");
        LinkLabel lblFanartSize = new LinkLabel();
        details1Panel.add((Component)lblFanartSize, "cell 8 10");
        FlatButton btnDeleteFanart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteFanart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteFanart.addActionListener(e -> {
            this.lblFanart.clearImage();
            this.tfFanart.setText("");
        });
        details1Panel.add((Component)btnDeleteFanart, "cell 8 10");
        details1Panel.add((Component)this.lblFanart, "cell 8 11 1 4,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblFanartSize, this.lblFanart, btnDeleteFanart, MediaFileType.FANART));
        SquareIconButton btnAddRating = new SquareIconButton(new AddRatingAction());
        details1Panel.add((Component)btnAddRating, "cell 0 12,alignx right,aligny top");
        SquareIconButton btnRemoveRating = new SquareIconButton(new RemoveRatingAction());
        details1Panel.add((Component)btnRemoveRating, "cell 0 12,alignx right,aligny top");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        details1Panel.add((Component)lblNoteT, "cell 0 13,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        details1Panel.add((Component)scrollPane, "cell 1 13 6 1,wmin 0,grow");
        this.taNote = new JTextArea();
        this.taNote.setLineWrap(true);
        this.taNote.setWrapStyleWord(true);
        this.taNote.setForeground(UIManager.getColor("TextField.foreground"));
        this.taNote.setFocusTraversalKeys(0, null);
        this.taNote.setFocusTraversalKeys(1, null);
        scrollPane.setViewportView(this.taNote);
        JPanel details2Panel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details2"), details2Panel);
        details2Panel.setLayout((LayoutManager)new MigLayout("", "[][200lp:n][20lp:50lp][][50lp:100lp][20lp:n][grow][300lp:300lp,grow]", "[][][][][][100lp][pref!][20lp:n][100lp:150lp,grow][][grow]"));
        TmmLabel lblDateAdded = new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
        details2Panel.add((Component)lblDateAdded, "cell 0 0,alignx right");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        details2Panel.add((Component)this.spDateAdded, "cell 1 0");
        TmmLabel lblIds = new TmmLabel(TmmResourceBundle.getString("metatag.ids"));
        details2Panel.add((Component)lblIds, "flowy,cell 6 0 1 3,alignx right,aligny top");
        JScrollPane scrollPaneIds = new JScrollPane();
        details2Panel.add((Component)scrollPaneIds, "cell 7 0 1 7,growx");
        this.tableIds = new MediaIdTable(this.ids, ScraperType.TV_SHOW);
        this.tableIds.configureScrollPane(scrollPaneIds);
        SquareIconButton btnAddId = new SquareIconButton(new AddIdAction());
        details2Panel.add((Component)btnAddId, "cell 6 0 1 3,alignx right,aligny top");
        SquareIconButton btnRemoveId = new SquareIconButton(new RemoveIdAction());
        details2Panel.add((Component)btnRemoveId, "cell 6 0 1 3,alignx right,aligny top");
        TmmLabel lblGenres = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        details2Panel.add((Component)lblGenres, "flowy,cell 0 8,alignx right,aligny top");
        JScrollPane scrollPaneGenres = new JScrollPane();
        details2Panel.add((Component)scrollPaneGenres, "cell 1 8 4 1,grow");
        this.listGenres = new JList();
        scrollPaneGenres.setViewportView(this.listGenres);
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        this.cbGenresAutocompleteSupport = this.cbGenres.getAutoCompleteSupport();
        InputMap im = this.cbGenres.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbGenres.getActionMap().put(enterAction, new AddGenreAction());
        details2Panel.add(this.cbGenres, "cell 1 9 4 1,growx,wmin 0");
        SquareIconButton btnAddGenre = new SquareIconButton(new AddGenreAction());
        details2Panel.add((Component)btnAddGenre, "cell 0 8,alignx right,aligny top");
        SquareIconButton btnRemoveGenre = new SquareIconButton(new RemoveGenreAction());
        details2Panel.add((Component)btnRemoveGenre, "cell 0 8,alignx right,aligny top");
        SquareIconButton btnMoveGenreUp = new SquareIconButton(new MoveGenreUpAction());
        details2Panel.add((Component)btnMoveGenreUp, "cell 0 8,alignx right,aligny top");
        SquareIconButton btnMoveGenreDown = new SquareIconButton(new MoveGenreDownAction());
        details2Panel.add((Component)btnMoveGenreDown, "cell 0 8,alignx right,aligny top");
        TmmLabel lblTags = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        details2Panel.add((Component)lblTags, "flowy,cell 6 8,alignx right,aligny top");
        JScrollPane scrollPaneTags = new JScrollPane();
        details2Panel.add((Component)scrollPaneTags, "cell 7 8,grow");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInTvShows());
        this.cbTagsAutocompleteSupport = this.cbTags.getAutoCompleteSupport();
        im = this.cbTags.getInputMap(1);
        enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        details2Panel.add(this.cbTags, "cell 7 9,growx,wmin 0");
        SquareIconButton btnAddTag = new SquareIconButton(new AddTagAction());
        details2Panel.add((Component)btnAddTag, "cell 6 8,alignx right,aligny top");
        SquareIconButton btnRemoveTag = new SquareIconButton(new RemoveTagAction());
        details2Panel.add((Component)btnRemoveTag, "cell 6 8,alignx right,aligny top");
        SquareIconButton btnMoveTagUp = new SquareIconButton(new MoveTagUpAction());
        details2Panel.add((Component)btnMoveTagUp, "cell 6 8,alignx right,aligny top");
        SquareIconButton btnMoveTagDown = new SquareIconButton(new MoveTagDownAction());
        details2Panel.add((Component)btnMoveTagDown, "cell 6 8,alignx right,aligny top");
        JPanel crewPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("movie.edit.castandcrew"), null, crewPanel, null);
        crewPanel.setLayout((LayoutManager)new MigLayout("", "[][150lp:300lp,grow][20lp:n][][150lp:300lp,grow]", "[200lp:400lp,grow]"));
        TmmLabel lblActorsT = new TmmLabel(TmmResourceBundle.getString("metatag.actors"));
        crewPanel.add((Component)lblActorsT, "flowy,cell 0 0,alignx right,aligny top");
        this.tableActors = new PersonTable(this.actors);
        this.tableActors.setAddTitle(TmmResourceBundle.getString("cast.actor.add"));
        this.tableActors.setEditTitle(TmmResourceBundle.getString("cast.actor.edit"));
        this.tableActors.setAllowedEditorTypes(new Person.Type[]{Person.Type.ACTOR});
        JScrollPane scrollPane2 = new JScrollPane();
        this.tableActors.configureScrollPane(scrollPane2);
        crewPanel.add((Component)scrollPane2, "cell 1 0,grow");
        SquareIconButton btnAddActor = new SquareIconButton(new AddActorAction());
        crewPanel.add((Component)btnAddActor, "cell 0 0,alignx right");
        SquareIconButton btnRemoveActor = new SquareIconButton(new RemoveActorAction());
        crewPanel.add((Component)btnRemoveActor, "cell 0 0,alignx right");
        SquareIconButton btnMoveActorUp = new SquareIconButton(new MoveActorUpAction());
        crewPanel.add((Component)btnMoveActorUp, "cell 0 0,alignx right");
        SquareIconButton btnMoveActorDown = new SquareIconButton(new MoveActorDownAction());
        crewPanel.add((Component)btnMoveActorDown, "cell 0 0,alignx right,aligny top");
        TmmLabel lblCrewT = new TmmLabel(TmmResourceBundle.getString("metatag.crew"));
        crewPanel.add((Component)lblCrewT, "flowy,cell 3 0,alignx right,aligny top");
        this.tableCrew = new PersonTable(this.crew);
        this.tableCrew.setAddTitle(TmmResourceBundle.getString("cast.crew.add"));
        this.tableCrew.setEditTitle(TmmResourceBundle.getString("cast.crew.edit"));
        this.tableCrew.setAllowedEditorTypes(new Person.Type[]{Person.Type.DIRECTOR, Person.Type.WRITER, Person.Type.PRODUCER, Person.Type.COMPOSER, Person.Type.EDITOR, Person.Type.CAMERA, Person.Type.OTHER});
        scrollPane2 = new JScrollPane();
        this.tableCrew.configureScrollPane(scrollPane2);
        crewPanel.add((Component)scrollPane2, "cell 4 0,grow");
        SquareIconButton btnAddCrew = new SquareIconButton(new AddCrewAction());
        crewPanel.add((Component)btnAddCrew, "cell 3 0,alignx right");
        SquareIconButton btnRemoveCrew = new SquareIconButton(new RemoveCrewAction());
        crewPanel.add((Component)btnRemoveCrew, "cell 3 0,alignx right");
        SquareIconButton btnMoveCrewUp = new SquareIconButton(new MoveCrewUpAction());
        crewPanel.add((Component)btnMoveCrewUp, "cell 3 0,alignx right");
        SquareIconButton btnMoveCrewDown = new SquareIconButton(new MoveCrewDownAction());
        crewPanel.add((Component)btnMoveCrewDown, "cell 3 0,alignx right,aligny top");
        JPanel artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[25%:35%:35%,grow][20lp:n][25%:35%:35%,grow][20lp:n][15%:30%:30%,grow]", "[][100lp:30%:30%,grow][20lp:n][][100lp:30%:30%,grow][20lp:n][][100lp:30%:30%,grow]"));
        TmmLabel lblClearlogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "cell 0 0");
        LinkLabel lblClearlogoSize = new LinkLabel();
        artworkPanel.add((Component)lblClearlogoSize, "cell 0 0");
        FlatButton btnDeleteClearLogo = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteClearLogo.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteClearLogo.addActionListener(e -> {
            this.lblClearlogo.clearImage();
            this.tfClearLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearLogo, "cell 0 0");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.CLEARLOGO, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblClearlogo, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblClearlogo, TvShowEditorDialog.this.tfClearLogo);
            }
        });
        artworkPanel.add((Component)this.lblClearlogo, "cell 0 1,grow");
        this.lblClearlogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearlogoSize, this.lblClearlogo, btnDeleteClearLogo, MediaFileType.CLEARLOGO));
        TmmLabel lblClearartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "flowx,cell 2 0");
        LinkLabel lblClearartSize = new LinkLabel();
        artworkPanel.add((Component)lblClearartSize, "flowx,cell 2 0");
        FlatButton btnDeleteClearart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteClearart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteClearart.addActionListener(e -> {
            this.lblClearart.clearImage();
            this.tfClearArt.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearart, "cell 2 0");
        this.lblClearart = new ImageLabel();
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.CLEARART, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblClearart, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblClearart, TvShowEditorDialog.this.tfClearArt);
            }
        });
        artworkPanel.add((Component)this.lblClearart, "cell 2 1,grow");
        this.lblClearart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearartSize, this.lblClearart, btnDeleteClearart, MediaFileType.CLEARART));
        TmmLabel lblKeyartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.keyart"));
        artworkPanel.add((Component)lblKeyartT, "cell 4 0");
        LinkLabel lblKeyartSize = new LinkLabel();
        artworkPanel.add((Component)lblKeyartSize, "flowx,cell 4 0");
        FlatButton btnDeleteKeyart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteKeyart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteKeyart.addActionListener(e -> {
            this.lblKeyart.clearImage();
            this.tfKeyart.setText("");
        });
        artworkPanel.add((Component)btnDeleteKeyart, "cell 4 0");
        this.lblKeyart = new ImageLabel();
        this.lblKeyart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblKeyart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.KEYART, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblKeyart, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblKeyart, TvShowEditorDialog.this.tfKeyart);
            }
        });
        artworkPanel.add((Component)this.lblKeyart, "cell 4 1 1 4,grow");
        this.lblKeyart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblKeyartSize, this.lblKeyart, btnDeleteKeyart, MediaFileType.KEYART));
        TmmLabel lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 3 3 1");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "flowx,cell 0 3 3 1");
        FlatButton btnDeleteBanner = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 0 3 3 1");
        this.lblBanner = new ImageLabel();
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.BANNER, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblBanner, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblBanner, TvShowEditorDialog.this.tfBanner);
            }
        });
        artworkPanel.add((Component)this.lblBanner, "cell 0 4 3 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, btnDeleteBanner, MediaFileType.BANNER));
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 6");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 0 6");
        FlatButton btnDeleteThumb = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 0 6");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.THUMB, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblThumb, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblThumb, TvShowEditorDialog.this.tfThumb);
            }
        });
        artworkPanel.add((Component)this.lblThumb, "cell 0 7,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, btnDeleteThumb, MediaFileType.THUMB));
        TmmLabel lblCharacterartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.characterart"));
        artworkPanel.add((Component)lblCharacterartT, "cell 2 6");
        LinkLabel lblCharacterartSize = new LinkLabel();
        artworkPanel.add((Component)lblCharacterartSize, "cell 2 6");
        FlatButton btnDeleteCharacterart = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteCharacterart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteCharacterart.addActionListener(e -> {
            this.lblCharacterart.clearImage();
            this.tfCharacterart.setText("");
        });
        artworkPanel.add((Component)btnDeleteCharacterart, "cell 2 6");
        this.lblCharacterart = new ImageLabel();
        this.lblCharacterart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblCharacterart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEditorDialog.this, new HashMap<String, Object>(TvShowEditorDialog.this.tvShowToEdit.getIds()), MediaArtwork.MediaArtworkType.CHARACTERART, TvShowEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEditorDialog.this.lblCharacterart, MediaType.TV_SHOW);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEditorDialog.this.tvShowToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEditorDialog.this.updateArtworkUrl(TvShowEditorDialog.this.lblCharacterart, TvShowEditorDialog.this.tfCharacterart);
            }
        });
        artworkPanel.add((Component)this.lblCharacterart, "cell 2 7, grow");
        this.lblCharacterart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblCharacterartSize, this.lblCharacterart, btnDeleteCharacterart, MediaFileType.CHARACTERART));
        artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("edit.artwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][]"));
        TmmLabel lblPosterT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        TmmLabel lblFanartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        artworkPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        TmmLabel lblClearLogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearLogoT, "cell 0 2,alignx right");
        this.tfClearLogo = new JTextField();
        artworkPanel.add((Component)this.tfClearLogo, "cell 1 2,growx");
        lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 3,alignx right");
        this.tfBanner = new JTextField();
        artworkPanel.add((Component)this.tfBanner, "cell 1 3,growx");
        TmmLabel lblClearArtT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearArtT, "cell 0 4,alignx right");
        this.tfClearArt = new JTextField();
        artworkPanel.add((Component)this.tfClearArt, "cell 1 4,growx");
        lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 5,alignx right");
        this.tfThumb = new JTextField();
        artworkPanel.add((Component)this.tfThumb, "cell 1 5,growx");
        lblCharacterartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.characterart"));
        artworkPanel.add((Component)lblCharacterartT, "cell 0 6,alignx trailing");
        this.tfCharacterart = new JTextField();
        artworkPanel.add((Component)this.tfCharacterart, "cell 1 6,growx");
        lblKeyartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.keyart"));
        artworkPanel.add((Component)lblKeyartT, "cell 0 7,alignx trailing");
        this.tfKeyart = new JTextField();
        artworkPanel.add((Component)this.tfKeyart, "cell 1 7,growx");
        JPanel episodesPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.episodes"), episodesPanel);
        episodesPanel.setLayout((LayoutManager)new MigLayout("", "[][200lp:450lp,grow]", "[][][100lp:200lp,grow]"));
        JLabel lblEpisodeOrderT = new JLabel(TmmResourceBundle.getString("metatag.episode.group"));
        episodesPanel.add((Component)lblEpisodeOrderT, "flowx,cell 0 0 2 1");
        this.cbEpisodeOrder = new JComboBox();
        episodesPanel.add(this.cbEpisodeOrder, "cell 0 0 2 1");
        JLabel lblEpisodeOrderHint = new JLabel(IconManager.HINT);
        lblEpisodeOrderHint.setToolTipText(TmmResourceBundle.getString("tvshow.showepisodegroup.desc"));
        episodesPanel.add((Component)lblEpisodeOrderHint, "cell 0 0 2 1");
        SquareIconButton btnCloneEpisode = new SquareIconButton(new CloneEpisodeAction());
        episodesPanel.add((Component)btnCloneEpisode, "cell 0 1");
        this.tableEpisodes = new TmmEditorTable((TableModel)((Object)new TmmTableModel<EpisodeEditorContainer>((EventList<EpisodeEditorContainer>)this.episodes, new EpisodeTableFormat()))){

            @Override
            protected void editButtonClicked(int row) {
                if (row > -1) {
                    row = TvShowEditorDialog.this.tableEpisodes.convertRowIndexToModel(row);
                    EpisodeEditorContainer episodeContainer = (EpisodeEditorContainer)TvShowEditorDialog.this.episodes.get(row);
                    ModalPopupPanel popupPanel = TvShowEditorDialog.this.createModalPopupPanel();
                    popupPanel.setTitle(TmmResourceBundle.getString("tvshowepisode.edit"));
                    EpisodeEditorPanel episodeEditorPanel = new EpisodeEditorPanel(episodeContainer);
                    popupPanel.setContent(episodeEditorPanel);
                    TvShowEditorDialog.this.showModalPopupPanel(popupPanel);
                }
            }
        };
        this.tableEpisodes.installComparatorChooser(this.episodes, new MouseKeyboardSortingStrategy());
        JScrollPane scrollPaneEpisodes = new JScrollPane();
        this.tableEpisodes.configureScrollPane(scrollPaneEpisodes);
        episodesPanel.add((Component)scrollPaneEpisodes, "cell 1 1 1 2,grow");
        SquareIconButton btnRemoveEpisode = new SquareIconButton(new RemoveEpisodeAction());
        episodesPanel.add((Component)btnRemoveEpisode, "cell 0 2,aligny top");
        JPanel trailerPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("Settings.trailer"), null, trailerPanel, null);
        trailerPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[100lp:250lp,grow][grow 200]"));
        TmmLabel lblTrailer = new TmmLabel(TmmResourceBundle.getString("metatag.trailer"));
        trailerPanel.add((Component)lblTrailer, "flowy,cell 0 0,alignx right,aligny top");
        SquareIconButton btnAddTrailer = new SquareIconButton(new AddTrailerAction());
        trailerPanel.add((Component)btnAddTrailer, "cell 0 0,alignx right,aligny top");
        SquareIconButton btnRemoveTrailer = new SquareIconButton(new RemoveTrailerAction());
        trailerPanel.add((Component)btnRemoveTrailer, "cell 0 0,alignx right,aligny top");
        SquareIconButton btnPlayTrailer = new SquareIconButton(new PlayTrailerAction());
        trailerPanel.add((Component)btnPlayTrailer, "cell 0 0,alignx right,aligny top");
        JScrollPane scrollPaneTrailer = new JScrollPane();
        trailerPanel.add((Component)scrollPaneTrailer, "cell 1 0,grow");
        this.tableTrailer = new MediaTrailerTable(this.trailers, true);
        this.tableTrailer.configureScrollPane(scrollPaneTrailer);
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbstractEditorDialog.AbortQueueAction(this, TmmResourceBundle.getString("tvshow.edit.abortqueue.desc")));
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new AbstractEditorDialog.NavigateBackAction(this));
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new CancelAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new OKAction());
        this.getRootPane().registerKeyboardAction(new OKAction(), KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), 2);
        this.getRootPane().registerKeyboardAction(new OKAction(), KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), 2);
        this.addButton(okButton);
    }

    private void registerDropTarget(final ImageLabel imageLabel, final JTextField textField) {
        new DropTarget(imageLabel, new ArtworkDragAndDropListener(imageLabel){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                super.drop(dtde);
                TvShowEditorDialog.this.updateArtworkUrl(imageLabel, textField);
            }
        });
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.tvShowToEdit.getArtworkFilename(type))) {
            this.tvShowToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.tvShowToEdit.getArtworkUrl(type))) {
            this.tvShowToEdit.setArtworkUrl(textField.getText(), type);
            this.tvShowToEdit.downloadArtwork(type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.tvShowToEdit.removeArtworkUrl(type);
        } else if (StringUtils.isBlank((CharSequence)this.tvShowToEdit.getArtworkFilename(type))) {
            this.tvShowToEdit.downloadArtwork(type);
        }
    }

    @Override
    public void dispose() {
        if (this.dpPremiered != null) {
            this.dpPremiered.cleanup();
        }
        super.dispose();
    }

    protected void initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.genres, this.listGenres);
        jListBinding.bind();
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        jListBinding_1.bind();
        this.bindingGroup = new BindingGroup();
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.bindingGroup.addBinding((Binding)jListBinding_1);
    }

    private static class EpisodeEditorContainer
    extends AbstractModelObject
    implements Comparable<EpisodeEditorContainer> {
        private final TvShowEpisode tvShowEpisode;
        private final List<MediaEpisodeNumber> episodeNumbers;
        private int season = -1;
        private int episode = -1;

        EpisodeEditorContainer(TvShowEpisode episode) {
            this.tvShowEpisode = episode;
            this.episodeNumbers = new ArrayList<MediaEpisodeNumber>(episode.getEpisodeNumbers());
        }

        String getEpisodeTitle() {
            return this.tvShowEpisode.getTitle();
        }

        String getMediaFilename() {
            List<MediaFile> mfs = this.tvShowEpisode.getMediaFiles(MediaFileType.VIDEO);
            if (mfs != null && !mfs.isEmpty()) {
                return mfs.get(0).getFile().toString();
            }
            return "";
        }

        List<MediaEpisodeNumber> getEpisodeNumbers() {
            return this.episodeNumbers;
        }

        MediaEpisodeNumber getEpisodeNumber(@NotNull MediaEpisodeGroup episodeGroup) {
            return this.episodeNumbers.stream().filter(mediaEpisodeNumber -> mediaEpisodeNumber.episodeGroup().equals(episodeGroup)).findFirst().orElse(null);
        }

        int getEpisode() {
            return this.episode;
        }

        void setEpisode(int newValue) {
            int oldValue = this.episode;
            this.episode = newValue;
            this.firePropertyChange("episode", oldValue, newValue);
        }

        int getSeason() {
            return this.season;
        }

        void setSeason(int newValue) {
            int oldValue = this.season;
            this.season = newValue;
            this.firePropertyChange("season", oldValue, newValue);
        }

        @Override
        public int compareTo(@NotNull EpisodeEditorContainer other) {
            int result = Integer.compare(this.season, other.season);
            if (result == 0) {
                result = Integer.compare(this.episode, other.episode);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EpisodeEditorContainer that = (EpisodeEditorContainer)o;
            return this.tvShowEpisode.equals(that.tvShowEpisode);
        }

        public int hashCode() {
            return Objects.hash(this.tvShowEpisode);
        }
    }

    private static class EpisodeGroupContainer {
        private final MediaEpisodeGroup episodeGroup;
        private int numberOfEpisodes;

        EpisodeGroupContainer(MediaEpisodeGroup episodeGroup) {
            this.episodeGroup = episodeGroup;
        }

        public String toString() {
            String localizedEnumName = TmmResourceBundle.getString("episodeGroup." + this.episodeGroup.getEpisodeGroupType().name().toLowerCase(Locale.ROOT));
            Object episodeGroupName = StringUtils.isNotBlank((CharSequence)this.episodeGroup.getName()) ? this.episodeGroup.getName() + " (" + localizedEnumName + ")" : localizedEnumName;
            return (String)episodeGroupName + " - " + this.numberOfEpisodes + " " + TmmResourceBundle.getString("metatag.episodes");
        }
    }

    private class AddRatingAction
    extends AbstractAction {
        private AddRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            ModalPopupPanel popupPanel = TvShowEditorDialog.this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("rating.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNotBlank((CharSequence)rating.key) && rating.value > 0.0f && rating.maxValue > 0 && rating.votes > 0) {
                    TvShowEditorDialog.this.ratings.add((Object)rating);
                }
            });
            RatingEditorPanel ratingEditorPanel = new RatingEditorPanel(rating);
            popupPanel.setContent(ratingEditorPanel);
            TvShowEditorDialog.this.showModalPopupPanel(popupPanel);
        }
    }

    private class RemoveRatingAction
    extends AbstractAction {
        private RemoveRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmUIHelper.removeSelectedRowsFromJTable(TvShowEditorDialog.this.tableRatings, TvShowEditorDialog.this.ratings);
        }
    }

    private class AddIdAction
    extends AbstractAction {
        AddIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            ModalPopupPanel popupPanel = TvShowEditorDialog.this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("id.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                    TvShowEditorDialog.this.ids.add((Object)mediaId);
                }
            });
            IdEditorPanel idEditorPanel = new IdEditorPanel(mediaId, ScraperType.TVSHOW_ARTWORK);
            popupPanel.setContent(idEditorPanel);
            TvShowEditorDialog.this.showModalPopupPanel(popupPanel);
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        RemoveIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmUIHelper.removeSelectedRowsFromJTable(TvShowEditorDialog.this.tableIds, TvShowEditorDialog.this.ids);
        }
    }

    private class AddGenreAction
    extends AbstractAction {
        AddGenreAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("genre.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            MediaGenres newGenre = null;
            Object item = TvShowEditorDialog.this.cbGenres.getSelectedItem();
            Component editorComponent = TvShowEditorDialog.this.cbGenres.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (item instanceof MediaGenres) {
                MediaGenres mediaGenres;
                newGenre = mediaGenres = (MediaGenres)item;
            }
            if (item instanceof String) {
                String genre = (String)item;
                newGenre = MediaGenres.getGenre(genre);
            }
            if (newGenre != null && !TvShowEditorDialog.this.genres.contains(newGenre)) {
                TvShowEditorDialog.this.genres.add(newGenre);
                if (editorComponent instanceof JTextField) {
                    TvShowEditorDialog.this.cbGenresAutocompleteSupport.setFirstItem(null);
                    TvShowEditorDialog.this.cbGenres.setSelectedIndex(0);
                    TvShowEditorDialog.this.cbGenresAutocompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveGenreAction
    extends AbstractAction {
        RemoveGenreAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("genre.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MediaGenres genre : TvShowEditorDialog.this.listGenres.getSelectedValuesList()) {
                TvShowEditorDialog.this.genres.remove(genre);
            }
        }
    }

    private class MoveGenreUpAction
    extends AbstractAction {
        MoveGenreUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movegenreup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listGenres.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.genres.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveGenreDownAction
    extends AbstractAction {
        MoveGenreDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movegenredown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listGenres.getSelectedIndex();
            if (row < TvShowEditorDialog.this.genres.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.genres.subList(row, row + 2), -1);
                TvShowEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        AddTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            Object selectedItem = TvShowEditorDialog.this.cbTags.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            String newTag = (String)selectedItem;
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = TvShowEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : TvShowEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                TvShowEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    TvShowEditorDialog.this.cbTagsAutocompleteSupport.setFirstItem("");
                    TvShowEditorDialog.this.cbTags.setSelectedIndex(0);
                    TvShowEditorDialog.this.cbTagsAutocompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        RemoveTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (String tag : TvShowEditorDialog.this.listTags.getSelectedValuesList()) {
                TvShowEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        MoveTagUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveTagDownAction
    extends AbstractAction {
        MoveTagDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.listTags.getSelectedIndex();
            if (row < TvShowEditorDialog.this.tags.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.tags.subList(row, row + 2), -1);
                TvShowEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddActorAction
    extends AbstractAction {
        AddActorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.actor.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.tableActors.addPerson();
        }
    }

    private class RemoveActorAction
    extends AbstractAction {
        RemoveActorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.actor.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.actors.removeAll(TvShowEditorDialog.this.tableActors.getSelectedPersons());
        }
    }

    private class MoveActorUpAction
    extends AbstractAction {
        MoveActorUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.moveactorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.actors.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveActorDownAction
    extends AbstractAction {
        MoveActorDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.moveactordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableActors.getSelectedRow();
            if (row < TvShowEditorDialog.this.actors.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.actors.subList(row, row + 2), -1);
                TvShowEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddCrewAction
    extends AbstractAction {
        public AddCrewAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.crew.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.tableCrew.addPerson();
        }
    }

    private class RemoveCrewAction
    extends AbstractAction {
        public RemoveCrewAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.crew.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.crew.removeAll(TvShowEditorDialog.this.tableCrew.getSelectedPersons());
        }
    }

    private class MoveCrewUpAction
    extends AbstractAction {
        public MoveCrewUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movecrewup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableCrew.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEditorDialog.this.crew.subList(row - 1, row + 1), 1);
                TvShowEditorDialog.this.tableCrew.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveCrewDownAction
    extends AbstractAction {
        public MoveCrewDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movecrewdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableCrew.getSelectedRow();
            if (row < TvShowEditorDialog.this.crew.size() - 1) {
                Collections.rotate(TvShowEditorDialog.this.crew.subList(row, row + 2), -1);
                TvShowEditorDialog.this.tableCrew.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class CloneEpisodeAction
    extends AbstractAction {
        CloneEpisodeAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshowepisode.clone"));
            this.putValue("SmallIcon", IconManager.COPY_INV);
            this.putValue("SwingLargeIconKey", IconManager.COPY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int row = TvShowEditorDialog.this.tableEpisodes.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableEpisodes.convertRowIndexToModel(row);
                EpisodeEditorContainer origContainer = (EpisodeEditorContainer)TvShowEditorDialog.this.episodes.get(row);
                EpisodeEditorContainer newContainer = new EpisodeEditorContainer(new TvShowEpisode(origContainer.tvShowEpisode));
                ModalPopupPanel popupPanel = TvShowEditorDialog.this.createModalPopupPanel();
                popupPanel.setTitle(TmmResourceBundle.getString("tvshowepisode.clone"));
                EpisodeEditorPanel episodeEditorPanel = new EpisodeEditorPanel(newContainer);
                popupPanel.setContent(episodeEditorPanel);
                TvShowEditorDialog.this.showModalPopupPanel(popupPanel);
            }
        }
    }

    private static class EpisodeTableFormat
    extends TmmTableFormat<EpisodeEditorContainer> {
        EpisodeTableFormat() {
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            TmmTableFormat.IntegerComparator integerComparator = new TmmTableFormat.IntegerComparator();
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "name", EpisodeEditorContainer::getEpisodeTitle, String.class);
            col.setColumnResizeable(true);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", EpisodeEditorContainer::getMediaFilename, String.class);
            col.setColumnResizeable(true);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.season"), "season", EpisodeEditorContainer::getSeason, Integer.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(integerComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.episode"), "episode", EpisodeEditorContainer::getEpisode, Integer.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(integerComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Button.edit"), "edit", episode -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }

    private class RemoveEpisodeAction
    extends AbstractAction {
        RemoveEpisodeAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshowepisode.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmUIHelper.removeSelectedRowsFromJTable(TvShowEditorDialog.this.tableEpisodes, TvShowEditorDialog.this.episodes);
        }
    }

    private class AddTrailerAction
    extends AbstractAction {
        public AddTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.tableTrailer.addTrailer();
        }
    }

    private class RemoveTrailerAction
    extends AbstractAction {
        public RemoveTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmUIHelper.removeSelectedRowsFromJTable(TvShowEditorDialog.this.tableTrailer, TvShowEditorDialog.this.trailers);
        }
    }

    private class PlayTrailerAction
    extends AbstractAction {
        public PlayTrailerAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("trailer.play"));
            this.putValue("SmallIcon", IconManager.PLAY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEditorDialog.this.tableTrailer.getSelectedRow();
            if (row > -1) {
                row = TvShowEditorDialog.this.tableTrailer.convertRowIndexToModel(row);
                MediaTrailer selectedTrailer = (MediaTrailer)TvShowEditorDialog.this.trailers.get(row);
                String url = selectedTrailer.getUrl();
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception ex) {
                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
                }
            } else {
                JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isBlank((CharSequence)TvShowEditorDialog.this.tfTitle.getText())) {
                TvShowEditorDialog.this.tfTitle.requestFocusInWindow();
                return;
            }
            TvShowEditorDialog.this.commitChanges();
            TvShowEditorDialog.this.tvShowToEdit.setTitle(TvShowEditorDialog.this.tfTitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setOriginalTitle(TvShowEditorDialog.this.tfOriginalTitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setEnglishTitle(TvShowEditorDialog.this.tfEnglishTitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setSortTitle(TvShowEditorDialog.this.tfSorttitle.getText());
            TvShowEditorDialog.this.tvShowToEdit.setYear((Integer)TvShowEditorDialog.this.spYear.getValue());
            TvShowEditorDialog.this.tvShowToEdit.setPlot(TvShowEditorDialog.this.taPlot.getText());
            TvShowEditorDialog.this.tvShowToEdit.setTagline(TvShowEditorDialog.this.tfTagline.getText());
            TvShowEditorDialog.this.tvShowToEdit.setRuntime((Integer)TvShowEditorDialog.this.spRuntime.getValue());
            TvShowEditorDialog.this.tvShowToEdit.setTop250((Integer)TvShowEditorDialog.this.spTop250.getValue());
            for (Iterator id : TvShowEditorDialog.this.ids) {
                try {
                    Integer value = Integer.parseInt(((MediaIdTable.MediaId)((Object)id)).value);
                    TvShowEditorDialog.this.tvShowToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, value);
                }
                catch (NumberFormatException ex) {
                    TvShowEditorDialog.this.tvShowToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, ((MediaIdTable.MediaId)((Object)id)).value);
                }
            }
            ArrayList<String> removeIds = new ArrayList<String>();
            for (Map.Entry entry : TvShowEditorDialog.this.tvShowToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId((String)entry.getKey());
                if (TvShowEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add((String)entry.getKey());
            }
            for (String id : removeIds) {
                TvShowEditorDialog.this.tvShowToEdit.setId(id, null);
            }
            Object certification = TvShowEditorDialog.this.cbCertification.getSelectedItem();
            if (certification instanceof MediaCertification) {
                MediaCertification mediaCertification = (MediaCertification)((Object)certification);
                TvShowEditorDialog.this.tvShowToEdit.setCertification(mediaCertification);
            }
            TvShowEditorDialog.this.processArtwork(MediaFileType.POSTER, TvShowEditorDialog.this.lblPoster, TvShowEditorDialog.this.tfPoster);
            TvShowEditorDialog.this.processArtwork(MediaFileType.FANART, TvShowEditorDialog.this.lblFanart, TvShowEditorDialog.this.tfFanart);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CLEARLOGO, TvShowEditorDialog.this.lblClearlogo, TvShowEditorDialog.this.tfClearLogo);
            TvShowEditorDialog.this.processArtwork(MediaFileType.BANNER, TvShowEditorDialog.this.lblBanner, TvShowEditorDialog.this.tfBanner);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CLEARART, TvShowEditorDialog.this.lblClearart, TvShowEditorDialog.this.tfClearArt);
            TvShowEditorDialog.this.processArtwork(MediaFileType.THUMB, TvShowEditorDialog.this.lblThumb, TvShowEditorDialog.this.tfThumb);
            TvShowEditorDialog.this.processArtwork(MediaFileType.CHARACTERART, TvShowEditorDialog.this.lblCharacterart, TvShowEditorDialog.this.tfCharacterart);
            TvShowEditorDialog.this.processArtwork(MediaFileType.KEYART, TvShowEditorDialog.this.lblKeyart, TvShowEditorDialog.this.tfKeyart);
            if (!(TvShowEditorDialog.this.extrafanarts == null || TvShowEditorDialog.this.extrafanarts.size() == TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls().size() && new HashSet<String>(TvShowEditorDialog.this.extrafanarts).containsAll(TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls()) && new HashSet<String>(TvShowEditorDialog.this.tvShowToEdit.getExtraFanartUrls()).containsAll(TvShowEditorDialog.this.extrafanarts))) {
                TvShowEditorDialog.this.tvShowToEdit.setExtraFanartUrls(TvShowEditorDialog.this.extrafanarts);
                TvShowEditorDialog.this.tvShowToEdit.downloadArtwork(MediaFileType.EXTRAFANART);
            }
            TvShowEditorDialog.this.tvShowToEdit.setProductionCompany(TvShowEditorDialog.this.tfStudio.getText());
            TvShowEditorDialog.this.tvShowToEdit.setCountry(TvShowEditorDialog.this.tfCountry.getText());
            TvShowEditorDialog.this.tvShowToEdit.setNote(TvShowEditorDialog.this.taNote.getText());
            TvShowEditorDialog.this.tvShowToEdit.removeAllGenres();
            TvShowEditorDialog.this.tvShowToEdit.setGenres(TvShowEditorDialog.this.genres);
            TvShowEditorDialog.this.tvShowToEdit.removeActors();
            TvShowEditorDialog.this.tvShowToEdit.setActors((List<Person>)TvShowEditorDialog.this.actors);
            TvShowEditorDialog.this.tvShowToEdit.removeCrew();
            TvShowEditorDialog.this.tvShowToEdit.setCrew((List<Person>)TvShowEditorDialog.this.crew);
            TvShowEditorDialog.this.tvShowToEdit.removeAllTags();
            TvShowEditorDialog.this.tvShowToEdit.setTags(TvShowEditorDialog.this.tags);
            TvShowEditorDialog.this.tvShowToEdit.removeAllTrailers();
            TvShowEditorDialog.this.tvShowToEdit.addToTrailer((Collection<MediaTrailer>)TvShowEditorDialog.this.trailers);
            TvShowEditorDialog.this.tvShowToEdit.setDateAdded((Date)TvShowEditorDialog.this.spDateAdded.getValue());
            TvShowEditorDialog.this.tvShowToEdit.setFirstAired(TvShowEditorDialog.this.dpPremiered.getDate());
            TvShowEditorDialog.this.tvShowToEdit.setStatus((MediaAiredStatus)((Object)TvShowEditorDialog.this.cbStatus.getSelectedItem()));
            Object obj = TvShowEditorDialog.this.cbEpisodeOrder.getSelectedItem();
            if (obj instanceof EpisodeGroupContainer) {
                EpisodeGroupContainer episodeGroupContainer = (EpisodeGroupContainer)obj;
                TvShowEditorDialog.this.tvShowToEdit.setEpisodeGroup(episodeGroupContainer.episodeGroup);
            }
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            double userRating = (Double)TvShowEditorDialog.this.spRating.getValue();
            if (userRating > 0.0) {
                newRatings.put("user", new MediaRating("user", userRating, 1, 10));
            }
            for (MediaRatingTable.Rating rating : TvShowEditorDialog.this.ratings) {
                if (!StringUtils.isNotBlank((CharSequence)rating.key) || !(rating.value > 0.0f)) continue;
                newRatings.put(rating.key, new MediaRating(rating.key, rating.value, rating.votes, rating.maxValue));
            }
            TvShowEditorDialog.this.tvShowToEdit.setRatings(newRatings);
            if (userRating == 0.0) {
                TvShowEditorDialog.this.tvShowToEdit.removeRating("user");
            }
            for (int i = TvShowEditorDialog.this.tvShowToEdit.getEpisodeCount() - 1; i >= 0; --i) {
                boolean found = false;
                TvShowEpisode episode = TvShowEditorDialog.this.tvShowToEdit.getEpisodes().get(i);
                for (EpisodeEditorContainer container : TvShowEditorDialog.this.episodes) {
                    if (container.tvShowEpisode != episode) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                TvShowEditorDialog.this.tvShowToEdit.removeEpisode(episode);
            }
            for (EpisodeEditorContainer container : TvShowEditorDialog.this.episodes) {
                boolean found = false;
                boolean shouldStore = false;
                if (!new HashSet<MediaEpisodeNumber>(container.episodeNumbers).containsAll(container.tvShowEpisode.getEpisodeNumbers()) || !new HashSet<MediaEpisodeNumber>(container.tvShowEpisode.getEpisodeNumbers()).containsAll(container.episodeNumbers)) {
                    HashMap<MediaEpisodeGroup, MediaEpisodeNumber> episodeNumberMap = new HashMap<MediaEpisodeGroup, MediaEpisodeNumber>();
                    for (MediaEpisodeNumber episodeNumber : container.episodeNumbers) {
                        episodeNumberMap.putIfAbsent(episodeNumber.episodeGroup(), episodeNumber);
                    }
                    container.tvShowEpisode.setEpisodeNumbers(episodeNumberMap);
                    container.tvShowEpisode.removeAllIds();
                    shouldStore = true;
                }
                for (TvShowEpisode episode : TvShowEditorDialog.this.tvShowToEdit.getEpisodes()) {
                    if (container.tvShowEpisode != episode) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    container.tvShowEpisode.writeNFO();
                    container.tvShowEpisode.saveToDb();
                    TvShowEditorDialog.this.tvShowToEdit.addEpisode(container.tvShowEpisode);
                    continue;
                }
                if (!shouldStore) continue;
                container.tvShowEpisode.writeNFO();
                container.tvShowEpisode.saveToDb();
            }
            TvShowEditorDialog.this.tvShowToEdit.writeNFO();
            TvShowEditorDialog.this.tvShowToEdit.saveToDb();
            if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
                TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(Collections.singletonList(TvShowEditorDialog.this.tvShowToEdit));
                task.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
                task.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            TvShowEditorDialog.this.setVisible(false);
        }
    }

    private class EpisodeEditorPanel
    extends AbstractModalInputPanel {
        private final EpisodeEditorContainer episodeContainer;
        private final EventList<MediaEpisodeNumber> episodeNumbers;
        private final TmmTable tableEpisodeNumbers;

        EpisodeEditorPanel(final EpisodeEditorContainer episode) {
            this.episodeContainer = episode;
            this.episodeNumbers = new BasicEventList(new ArrayList<MediaEpisodeNumber>(episode.tvShowEpisode.getEpisodeNumbers()));
            this.setLayout((LayoutManager)new MigLayout("", "[][100lp:n,grow]", "[][][50lp:150lp][20lp]"));
            JLabel lblEpisodeTitleT = new JLabel(TmmResourceBundle.getString("metatag.title"));
            this.add((Component)lblEpisodeTitleT, "cell 0 0,alignx trailing");
            JLabel episodeTitle = new JLabel(episode.getEpisodeTitle());
            this.add((Component)episodeTitle, "cell 1 0, wmin 0");
            JLabel lblMediaFileT = new JLabel(TmmResourceBundle.getString("metatag.filename"));
            this.add((Component)lblMediaFileT, "cell 0 1,alignx trailing");
            episodeTitle = new JLabel(episode.getMediaFilename());
            this.add((Component)episodeTitle, "cell 1 1, wmin 0");
            TmmLabel lblEpisodeNumbersT = new TmmLabel(TmmResourceBundle.getString("metatag.episode"));
            this.add((Component)lblEpisodeNumbersT, "cell 0 2,flowy, alignx right,aligny top");
            JScrollPane scrollPane = new JScrollPane();
            this.add((Component)scrollPane, "cell 1 2,grow");
            this.tableEpisodeNumbers = new EpisodeNumberTable(this.episodeNumbers){

                @Override
                protected void editButtonClicked(int row) {
                    MediaEpisodeNumber episodeNumber = (MediaEpisodeNumber)EpisodeEditorPanel.this.episodeNumbers.get(row);
                    if (episodeNumber == null) {
                        return;
                    }
                    ModalPopupPanel popupPanel = TvShowEditorDialog.this.createModalPopupPanel();
                    popupPanel.setTitle(TmmResourceBundle.getString("episodenumber.edit"));
                    TvShowEpisodeNumberEditorPanel episodeNumberEditorPanel = new TvShowEpisodeNumberEditorPanel(episodeNumber, episode.tvShowEpisode.getTvShow().getEpisodeGroups());
                    popupPanel.setContent(episodeNumberEditorPanel);
                    popupPanel.setOnCloseHandler(() -> {
                        MediaEpisodeNumber episodeNumber1 = episodeNumberEditorPanel.getEpisodeNumber();
                        if (episodeNumber1 != null && episodeNumber1.containsAnyNumber()) {
                            EpisodeEditorPanel.this.addOrEditEpisodeNumber(episodeNumber1);
                        }
                    });
                    TvShowEditorDialog.this.showModalPopupPanel(popupPanel);
                }
            };
            this.tableEpisodeNumbers.configureScrollPane(scrollPane);
            SquareIconButton btnAddEpisodeNumber = new SquareIconButton(IconManager.ADD_INV);
            btnAddEpisodeNumber.addActionListener(e -> {
                ModalPopupPanel popupPanel = TvShowEditorDialog.this.createModalPopupPanel();
                popupPanel.setTitle(TmmResourceBundle.getString("episodenumber.add"));
                TvShowEpisodeNumberEditorPanel episodeNumberEditorPanel = new TvShowEpisodeNumberEditorPanel(new MediaEpisodeNumber(TvShowEditorDialog.this.tvShowToEdit.getEpisodeGroup(), -1, -1), TvShowEditorDialog.this.tvShowToEdit.getEpisodeGroups());
                popupPanel.setContent(episodeNumberEditorPanel);
                popupPanel.setOnCloseHandler(() -> {
                    MediaEpisodeNumber episodeNumber = episodeNumberEditorPanel.getEpisodeNumber();
                    if (episodeNumber != null && episodeNumber.containsAnyNumber()) {
                        this.addOrEditEpisodeNumber(episodeNumber);
                    }
                });
                TvShowEditorDialog.this.showModalPopupPanel(popupPanel);
            });
            this.add((Component)btnAddEpisodeNumber, "cell 0 2,alignx right,aligny top");
            SquareIconButton btnRemoveEpisodeNumber = new SquareIconButton(IconManager.REMOVE_INV);
            btnRemoveEpisodeNumber.addActionListener(e -> TmmUIHelper.removeSelectedRowsFromJTable(this.tableEpisodeNumbers, this.episodeNumbers));
            this.add((Component)btnRemoveEpisodeNumber, "cell 0 2,alignx right,aligny top");
        }

        @Override
        protected void onClose() {
            this.episodeContainer.episodeNumbers.clear();
            this.episodeContainer.episodeNumbers.addAll((Collection<MediaEpisodeNumber>)this.episodeNumbers);
            if (!TvShowEditorDialog.this.episodes.contains((Object)this.episodeContainer)) {
                TvShowEditorDialog.this.episodes.add((Object)this.episodeContainer);
            }
            TvShowEditorDialog.this.buildEpisodeContainer();
            TvShowEditorDialog.this.episodes.sort(EpisodeEditorContainer::compareTo);
            this.setVisible(false);
        }

        private void addOrEditEpisodeNumber(MediaEpisodeNumber episodeNumber) {
            MediaEpisodeNumber existing = this.episodeNumbers.stream().filter(ep -> ep.episodeGroup().getEpisodeGroupType() == episodeNumber.episodeGroup().getEpisodeGroupType()).findFirst().orElse(null);
            if (existing != null) {
                int index = this.episodeNumbers.indexOf((Object)existing);
                this.episodeNumbers.remove((Object)existing);
                this.episodeNumbers.add(index, (Object)episodeNumber);
                TvShowEditorDialog.this.ids.clear();
            } else {
                this.episodeNumbers.add((Object)episodeNumber);
            }
        }
    }
}

