/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.tokenizer.text.buffered;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.vinniks.parsla.tokenizer.text.buffered.CharacterBufferProvider;

public final class CharacterBufferCache
implements CharacterBufferProvider {
    private final int bufferSize;
    private final int bufferCount;
    private final Set<char[]> ownedBuffers;
    private final Set<char[]> cachedBuffers;

    public CharacterBufferCache(int bufferSize, int bufferCount) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("buffer size can not be less than 1");
        }
        if (bufferCount < 0) {
            throw new IllegalArgumentException("buffer count can not be less than 0");
        }
        this.bufferSize = bufferSize;
        this.bufferCount = bufferCount;
        this.ownedBuffers = new HashSet<char[]>();
        this.cachedBuffers = new LinkedHashSet<char[]>();
    }

    @Override
    public synchronized char[] acquireBuffer() {
        if (!this.cachedBuffers.isEmpty()) {
            char[] buffer = this.cachedBuffers.iterator().next();
            this.cachedBuffers.remove(buffer);
            return buffer;
        }
        char[] buffer = new char[this.bufferSize];
        if (this.ownedBuffers.size() < this.bufferCount) {
            this.ownedBuffers.add(buffer);
        }
        return buffer;
    }

    @Override
    public synchronized void releaseBuffer(@NonNull char[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        if (this.ownedBuffers.contains(buffer)) {
            this.cachedBuffers.add(buffer);
        }
    }

    @Generated
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Generated
    public int getBufferCount() {
        return this.bufferCount;
    }
}

