/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.ProbabilitySelector;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.Seq;
import java.util.Objects;

public final class ExponentialRankSelector<G extends Gene<?, G>, C extends Comparable<? super C>>
extends ProbabilitySelector<G, C> {
    private final double _c;

    public ExponentialRankSelector(double c) {
        super(true);
        if (c < 0.0 || c >= 1.0) {
            throw new IllegalArgumentException(String.format("Value %s is out of range [0..1): ", c));
        }
        this._c = c;
    }

    public ExponentialRankSelector() {
        this(0.975);
    }

    @Override
    protected double[] probabilities(Seq<Phenotype<G, C>> population, int count) {
        assert (population != null) : "Population must not be null. ";
        assert (!population.isEmpty()) : "Population is empty.";
        assert (count > 0) : "Population to select must be greater than zero. ";
        double N = population.size();
        double[] probabilities = new double[population.size()];
        double b = (this._c - 1.0) / (Math.pow(this._c, N) - 1.0);
        for (int i = 0; i < probabilities.length; ++i) {
            probabilities[i] = Math.pow(this._c, i) * b;
        }
        return probabilities;
    }

    public int hashCode() {
        return Hash.of(this.getClass()).and(this._c).value();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ExponentialRankSelector && Objects.equals(((ExponentialRankSelector)obj)._c, this._c);
    }

    public String toString() {
        return String.format("%s[c=%f]", this.getClass().getSimpleName(), this._c);
    }
}

