/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.function.PDFunction;

public class PDType0Function
extends PDFunction {
    private BitSet sampleTable;
    private final COSArray size = this.getSize();
    private final COSArray domain = this.getDomain();
    private final COSArray encode = this.getEncode();
    private final COSArray decode = this.getDecode();
    private final int outputDimension;
    private List<Integer> sizesProducts = this.getSizesProducts();
    private long numberOfSampleBytes = 0L;
    private static final Logger LOGGER = Logger.getLogger(PDType0Function.class.getCanonicalName());
    private static final long ALLOWABLE_MEMORY_CAPACITY = 100000000L;

    protected PDType0Function(COSObject obj) {
        super(obj);
        COSArray range = this.getRange();
        this.outputDimension = range != null ? range.size() / 2 : 0;
    }

    private COSArray getEncode() {
        COSArray encode = this.getCOSArray(ASAtom.ENCODE);
        if (encode == null) {
            encode = this.getDefaultEncode();
        }
        return encode;
    }

    private COSArray getDefaultEncode() {
        ArrayList<COSObject> encodeFromSize = new ArrayList<COSObject>();
        for (COSObject item : this.size) {
            encodeFromSize.add(COSReal.construct(0.0));
            encodeFromSize.add(COSReal.construct(item.getType() == COSObjType.COS_INTEGER ? (double)(item.getInteger() - 1L) : 0.0));
        }
        return new COSArray(encodeFromSize);
    }

    private COSArray getDecode() {
        COSArray decode = this.getCOSArray(ASAtom.DECODE);
        if (decode == null) {
            decode = this.getRange();
        }
        return decode;
    }

    private Long getBitsPerSample() {
        Long bitsPerSample = this.getIntegerKey(ASAtom.BITS_PER_SAMPLE);
        List<Long> validBitsPerSample = Arrays.asList(1L, 2L, 4L, 8L, 12L, 16L, 24L, 32L);
        if (validBitsPerSample.contains(bitsPerSample)) {
            return bitsPerSample;
        }
        LOGGER.log(Level.WARNING, "Invalid BitsPerSample key value in Type 0 Functions");
        return null;
    }

    private Long getOrder() {
        Long order = this.getIntegerKey(ASAtom.ORDER);
        if (order == null || order != 1L && order != 3L) {
            return 1L;
        }
        for (COSObject value : this.size) {
            if (value.getInteger() >= 4L) continue;
            return 1L;
        }
        return order;
    }

    private COSArray getSize() {
        COSArray size = this.getCOSArray(ASAtom.SIZE);
        if (size == null) {
            LOGGER.log(Level.WARNING, "Type 0 Function does not contain the Size entry or the Size entry has incorrect value");
            return (COSArray)COSArray.construct().get();
        }
        return size;
    }

    private List<Integer> getSizesProducts() {
        if (this.sizesProducts == null) {
            this.sizesProducts = new ArrayList<Integer>();
            int valueToBeAdded = 1;
            this.sizesProducts.add(valueToBeAdded);
            for (COSObject item : this.size) {
                this.sizesProducts.add(valueToBeAdded *= item.getType() == COSObjType.COS_INTEGER ? item.getInteger().intValue() : 1);
            }
        }
        return this.sizesProducts;
    }

    private BitSet getSampleTable() {
        if (this.sampleTable == null) {
            this.sampleTable = this.getSamples();
        }
        return this.sampleTable;
    }

    private long getNumberOfSampleBytes() {
        if (this.numberOfSampleBytes == 0L) {
            double num = 1.0;
            for (COSObject item : this.size) {
                num *= (double)item.getInteger().longValue();
            }
            this.numberOfSampleBytes = (long)Math.ceil(num * (double)this.getBitsPerSample().longValue() / 8.0 * (double)this.outputDimension);
        }
        return this.numberOfSampleBytes;
    }

    private BitSet getSamples() {
        BitSet bitSet;
        block9: {
            COSObject obj = this.getObject();
            if (obj.getType() != COSObjType.COS_STREAM) {
                LOGGER.log(Level.WARNING, "Invalid stream for type 0 function");
                return new BitSet();
            }
            ASInputStream functionStream = this.getObject().getData(COSStream.FilterFlags.DECODE);
            try {
                byte[] bytes = new byte[(int)this.getNumberOfSampleBytes()];
                functionStream.read(bytes);
                bitSet = BitSet.valueOf(bytes);
                if (functionStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (functionStream != null) {
                        try {
                            functionStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Can not parse function", e);
                    return new BitSet();
                }
            }
            functionStream.close();
        }
        return bitSet;
    }

    private int bitSetToUnsignedInt(BitSet b, int startBit, int length) {
        int value = 0;
        int bitValue = 1;
        for (int i = 0; i < length; ++i) {
            if (b.get(startBit + i)) {
                value += bitValue;
            }
            bitValue += bitValue;
        }
        return value;
    }

    private List<Integer> getSampleValue(List<Integer> coordinates) {
        int startIndex = 0;
        for (int i = coordinates.size() - 1; i >= 0; --i) {
            startIndex += coordinates.get(i) * this.sizesProducts.get(i) * this.getBitsPerSample().intValue() * this.outputDimension;
        }
        int endIndex = startIndex + this.getBitsPerSample().intValue() * this.outputDimension;
        ArrayList<Integer> resultValues = new ArrayList<Integer>();
        while (startIndex < endIndex) {
            resultValues.add(this.bitSetToUnsignedInt(this.getSampleTable(), startIndex, this.getBitsPerSample().intValue()));
            startIndex += this.getBitsPerSample().intValue();
        }
        return resultValues;
    }

    @Override
    public List<COSObject> getResult(List<COSObject> ops) {
        try {
            if (this.getNumberOfSampleBytes() > 100000000L) {
                LOGGER.log(Level.WARNING, "Type 0 function sample stream requires more than 100Mb of data. The result of the function will not be evaluated. ");
                return null;
            }
            List<COSObject> operands = this.getValuesInIntervals(ops, this.getDomain());
            for (int i = 0; i < operands.size(); ++i) {
                operands.set(i, this.interpolate(operands.get(i), this.domain.at(2 * i), this.domain.at(2 * i + 1), this.encode.at(2 * i), this.encode.at(2 * i + 1)));
            }
            operands = this.getValuesInIntervals(operands, this.getDefaultEncode());
            List<Double> doubleOperands = operands.stream().map(COSObject::getReal).collect(Collectors.toList());
            List<COSObject> interpolationResult = this.getOrder().intValue() == 1 ? this.multiLinearInterpolation(doubleOperands) : this.multiCubicInterpolation(doubleOperands);
            ArrayList<COSObject> result = new ArrayList<COSObject>();
            for (int i = 0; i < this.outputDimension; ++i) {
                result.add(this.interpolate(interpolationResult.get(i), COSReal.construct(0.0), COSReal.construct(Math.pow(2.0, this.getBitsPerSample().longValue()) - 1.0), this.decode.at(2 * i), this.decode.at(2 * i + 1)));
            }
            return Collections.unmodifiableList(this.getValuesInIntervals(result, this.getRange()));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while evaluating type 0 function", e);
            return null;
        }
    }

    private List<BitSet> getLinearNCombinations(int n) {
        ArrayList<BitSet> result = new ArrayList<BitSet>();
        long N = 1L << n;
        long bits = 0L;
        while (bits < N) {
            BitSet bitSet = new BitSet(n);
            bitSet.or(BitSet.valueOf(new long[]{bits++}));
            result.add(bitSet);
        }
        return result;
    }

    private List<List<Integer>> getCubicNCombinations(int n) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        int N = 1 << 2 * n;
        for (int bits = N - 1; bits >= 0; --bits) {
            ArrayList<Integer> combination = new ArrayList<Integer>();
            int currentValue = bits;
            for (int i = n - 1; i >= 0; --i) {
                int val = (int)Math.pow(4.0, i);
                if (val > currentValue) {
                    combination.add(-1);
                    continue;
                }
                if (val * 3 <= currentValue) {
                    combination.add(2);
                    currentValue -= val * 3;
                    continue;
                }
                if (val * 2 <= currentValue) {
                    combination.add(1);
                    currentValue -= val * 2;
                    continue;
                }
                combination.add(0);
                currentValue -= val;
            }
            result.add(combination);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private List<COSObject> multiLinearInterpolation(List<Double> x) {
        try {
            ArrayList<Integer> leftX = new ArrayList<Integer>();
            ArrayList<Integer> rightX = new ArrayList<Integer>();
            ArrayList<Double> alpha = new ArrayList<Double>();
            for (int i = 0; i < x.size(); ++i) {
                if (this.size.at(i).getInteger() == 1L) {
                    leftX.add(0);
                    rightX.add(0);
                    alpha.add(1.0);
                    continue;
                }
                leftX.add((int)Math.floor(x.get(i)));
                rightX.add((Integer)leftX.get(i) + 1);
                alpha.add(x.get(i) - (double)((Integer)leftX.get(i)).intValue());
            }
            ArrayList multipliedByCoefficientsSampleValues = new ArrayList();
            for (BitSet combination : this.getLinearNCombinations(x.size())) {
                void var10_15;
                ArrayList<Integer> sampleX = new ArrayList<Integer>();
                Double coefficientForSampleValue = 1.0;
                boolean bl = false;
                while (var10_15 < x.size()) {
                    if (combination.get((int)var10_15)) {
                        sampleX.add((Integer)leftX.get((int)var10_15));
                        coefficientForSampleValue = coefficientForSampleValue * (1.0 - (Double)alpha.get((int)var10_15));
                    } else {
                        sampleX.add((Integer)rightX.get((int)var10_15));
                        coefficientForSampleValue = coefficientForSampleValue * (Double)alpha.get((int)var10_15);
                    }
                    ++var10_15;
                }
                Double d = coefficientForSampleValue;
                multipliedByCoefficientsSampleValues.add(this.getSampleValue(sampleX).stream().map(o -> (double)o.intValue() * finalFactor).collect(Collectors.toList()));
            }
            ArrayList<COSObject> result = new ArrayList<COSObject>();
            for (int i = 0; i < this.outputDimension; ++i) {
                Double res = 0.0;
                for (List list : multipliedByCoefficientsSampleValues) {
                    res = res + (Double)list.get(i);
                }
                result.add(COSReal.construct(res));
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get interpolant coefficients", e);
            return null;
        }
    }

    private List<COSObject> multiCubicInterpolation(List<Double> x) {
        try {
            ArrayList<List<Double>> samples = new ArrayList<List<Double>>();
            for (List<Integer> combination : this.getCubicNCombinations(x.size())) {
                ArrayList<Integer> sampleX = new ArrayList<Integer>();
                for (int i = 0; i < x.size(); ++i) {
                    sampleX.add((int)Math.max(0.0, Math.min((double)(this.size.at(i).getInteger() - 1L), Math.floor(x.get(i)) + (double)combination.get(i).intValue())));
                }
                samples.add(this.getSampleValue(sampleX).stream().map(v -> (double)v).collect(Collectors.toList()));
            }
            List<Double> interpolateResult = this.nCubicInterpolate(x.size(), samples, x);
            ArrayList<COSObject> result = new ArrayList<COSObject>();
            for (Double value : interpolateResult) {
                result.add(COSReal.construct(value));
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get interpolant coefficients", e);
            return null;
        }
    }

    private List<Double> nCubicInterpolate(int n, List<List<Double>> p, List<Double> coordinates) {
        if (n == 1) {
            return this.cubicInterpolate(p, coordinates.get(0) - Math.floor(coordinates.get(0)));
        }
        ArrayList<List<Double>> arr = new ArrayList<List<Double>>();
        int skip = 1 << (n - 1) * 2;
        arr.add(this.nCubicInterpolate(n - 1, p, coordinates.subList(1, coordinates.size())));
        arr.add(this.nCubicInterpolate(n - 1, p.subList(skip, p.size()), coordinates.subList(1, coordinates.size())));
        arr.add(this.nCubicInterpolate(n - 1, p.subList(2 * skip, p.size()), coordinates.subList(1, coordinates.size())));
        arr.add(this.nCubicInterpolate(n - 1, p.subList(3 * skip, p.size()), coordinates.subList(1, coordinates.size())));
        return this.cubicInterpolate(arr, coordinates.get(0) - Math.floor(coordinates.get(0)));
    }

    private List<Double> cubicInterpolate(List<List<Double>> adjacentSampleValues, double x) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < this.outputDimension; ++i) {
            result.add(adjacentSampleValues.get(2).get(i) + 0.5 * x * (adjacentSampleValues.get(1).get(i) - adjacentSampleValues.get(3).get(i) + x * (2.0 * adjacentSampleValues.get(3).get(i) - 5.0 * adjacentSampleValues.get(2).get(i) + 4.0 * adjacentSampleValues.get(1).get(i) - adjacentSampleValues.get(0).get(i) + x * (3.0 * (adjacentSampleValues.get(2).get(i) - adjacentSampleValues.get(1).get(i)) + adjacentSampleValues.get(0).get(i) - adjacentSampleValues.get(3).get(i)))));
        }
        return result;
    }
}

