/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LanguageLoadingProvider;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.CoreModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.Scanner;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModProvider;
import net.minecraftforge.forgespi.locating.ModFileFactory;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.slf4j.Logger;

public class ModFile
implements IModFile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String jarVersion;
    private Map<String, Object> fileProperties;
    private List<IModLanguageProvider> loaders;
    private Throwable scanError;
    private final SecureJar jar;
    private final IModFile.Type modFileType;
    private final IModProvider provider;
    private final IModFileInfo modFileInfo;
    private ModFileScanData fileModFileScanData;
    private CompletableFuture<ModFileScanData> futureScanResult;
    private List<CoreModFile> coreMods;
    private Path accessTransformer;
    static final Attributes.Name TYPE = new Attributes.Name("FMLModType");
    private SecureJar.Status securityStatus;

    public ModFile(SecureJar jar, IModProvider provider, ModFileFactory.ModFileInfoParser parser) {
        this(jar, provider, parser, ModFile.parseType(jar));
    }

    public ModFile(SecureJar jar, IModProvider provider, ModFileFactory.ModFileInfoParser parser, String type) {
        this.provider = provider;
        this.jar = jar;
        Manifest manifest = this.jar.moduleDataProvider().getManifest();
        this.modFileType = IModFile.Type.valueOf((String)type);
        this.jarVersion = Optional.ofNullable(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION)).orElse("0.0NONE");
        this.modFileInfo = ModFileParser.readModList(this, parser);
    }

    public Supplier<Map<String, Object>> getSubstitutionMap() {
        return () -> ImmutableMap.builder().put((Object)"jarVersion", (Object)this.jarVersion).putAll(this.fileProperties).build();
    }

    public IModFile.Type getType() {
        return this.modFileType;
    }

    public Path getFilePath() {
        return this.jar.getPrimaryPath();
    }

    public SecureJar getSecureJar() {
        return this.jar;
    }

    public List<IModInfo> getModInfos() {
        return this.modFileInfo.getMods();
    }

    public Optional<Path> getAccessTransformer() {
        return Optional.ofNullable(Files.exists(this.accessTransformer, new LinkOption[0]) ? this.accessTransformer : null);
    }

    public boolean identifyMods() {
        if (this.modFileInfo == null) {
            return this.getType() != IModFile.Type.MOD;
        }
        LOGGER.debug(LogMarkers.LOADING, "Loading mod file {} with languages {}", (Object)this.getFileName(), (Object)this.modFileInfo.requiredLanguageLoaders());
        this.coreMods = ModFileParser.getCoreMods(this);
        if (!this.coreMods.isEmpty()) {
            LOGGER.warn("Mod file {} contains javascript coremods! JS CoreMods are deprecated and will be removed in a future release. Consider using Mixin or ModLauncher transformers.", (Object)this.getFileName());
        }
        for (CoreModFile mi : this.coreMods) {
            LOGGER.debug(LogMarkers.LOADING, "Found coremod {}", (Object)mi.getPath());
        }
        this.accessTransformer = this.findResource("META-INF", "accesstransformer.cfg");
        return true;
    }

    public List<CoreModFile> getCoreMods() {
        return this.coreMods;
    }

    public ModFileScanData compileContent() {
        return new Scanner(this).scan();
    }

    public void scanFile(Consumer<Path> pathConsumer) {
        this.provider.scanFile((IModFile)this, pathConsumer);
    }

    public void setFutureScanResult(CompletableFuture<ModFileScanData> future) {
        this.futureScanResult = future;
    }

    public ModFileScanData getScanResult() {
        if (this.futureScanResult != null) {
            try {
                this.futureScanResult.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Caught unexpected exception processing scan results", (Throwable)e);
            }
        }
        if (this.scanError != null) {
            throw new RuntimeException(this.scanError);
        }
        return this.fileModFileScanData;
    }

    public void setScanResult(ModFileScanData modFileScanData, Throwable throwable) {
        this.futureScanResult = null;
        this.fileModFileScanData = modFileScanData;
        if (throwable != null) {
            this.scanError = throwable;
        }
    }

    public void setFileProperties(Map<String, Object> fileProperties) {
        this.fileProperties = fileProperties;
    }

    public List<IModLanguageProvider> getLoaders() {
        return this.loaders;
    }

    public Path findResource(String ... path) {
        if (path.length < 1) {
            throw new IllegalArgumentException("Missing path");
        }
        return this.getSecureJar().getPath(String.join((CharSequence)"/", path), new String[0]);
    }

    public void identifyLanguage() {
        ArrayList<IModLanguageProvider> lst = new ArrayList<IModLanguageProvider>(this.modFileInfo.requiredLanguageLoaders().size());
        LanguageLoadingProvider services = FMLLoader.getLanguageLoadingProvider();
        for (IModFileInfo.LanguageSpec spec : this.modFileInfo.requiredLanguageLoaders()) {
            IModLanguageProvider service = services.findLanguage(this, spec.languageName(), spec.acceptedVersions());
            lst.add(service);
        }
        this.loaders = Collections.unmodifiableList(lst);
    }

    public String toString() {
        Path path = this.getFilePath();
        return "Mod File: " + String.valueOf(path) == null ? "null" : path.toUri().toString();
    }

    public String getFileName() {
        String ret;
        Path path = this.getFilePath();
        Path filename = path.getFileName();
        String string = ret = filename == null ? path.getFileSystem().toString() : filename.toString();
        if (Files.isDirectory(path, new LinkOption[0]) && path.getFileSystem() == FileSystems.getDefault()) {
            ret = path.toAbsolutePath().toString();
        }
        if (ret.isEmpty() || ret.equals("/")) {
            ret = path.toUri().toString();
        }
        return ret;
    }

    public IModProvider getProvider() {
        return this.provider;
    }

    public IModFileInfo getModFileInfo() {
        return this.modFileInfo;
    }

    public void setSecurityStatus(SecureJar.Status status) {
        this.securityStatus = status;
    }

    public SecureJar.Status getSecurityStatus() {
        return this.securityStatus;
    }

    public ArtifactVersion getJarVersion() {
        return new DefaultArtifactVersion(this.jarVersion);
    }

    private static String parseType(SecureJar jar) {
        Manifest m = jar.moduleDataProvider().getManifest();
        Optional<String> value = Optional.ofNullable(m.getMainAttributes().getValue(TYPE));
        return value.orElse("MOD");
    }
}

