/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.earlydisplay.DisplayWindow;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL30C;

public enum ForgeRenderTypes {
    ITEM_LAYERED_SOLID(() -> ForgeRenderTypes.getItemLayeredSolid(ForgeRenderTypes.blockAtlas())),
    ITEM_LAYERED_CUTOUT(() -> ForgeRenderTypes.getItemLayeredCutout(ForgeRenderTypes.blockAtlas())),
    ITEM_LAYERED_CUTOUT_MIPPED(() -> ForgeRenderTypes.getItemLayeredCutoutMipped(ForgeRenderTypes.blockAtlas())),
    ITEM_LAYERED_TRANSLUCENT(() -> ForgeRenderTypes.getItemLayeredTranslucent(ForgeRenderTypes.blockAtlas())),
    ITEM_UNSORTED_TRANSLUCENT(() -> ForgeRenderTypes.getUnsortedTranslucent(ForgeRenderTypes.blockAtlas())),
    ITEM_UNLIT_TRANSLUCENT(() -> ForgeRenderTypes.getUnlitTranslucent(ForgeRenderTypes.blockAtlas())),
    ITEM_UNSORTED_UNLIT_TRANSLUCENT(() -> ForgeRenderTypes.getUnlitTranslucent(ForgeRenderTypes.blockAtlas(), false));

    public static boolean enableTextTextureLinearFiltering;
    private final NonNullSupplier<RenderType> renderTypeSupplier;

    private static ResourceLocation blockAtlas() {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public static RenderType getItemLayeredSolid(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_SOLID.apply(textureLocation);
    }

    public static RenderType getItemLayeredCutout(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT.apply(textureLocation);
    }

    public static RenderType getItemLayeredCutoutMipped(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT_MIPPED.apply(textureLocation);
    }

    public static RenderType getItemLayeredTranslucent(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_TRANSLUCENT.apply(textureLocation);
    }

    public static RenderType getUnsortedTranslucent(ResourceLocation textureLocation) {
        return Internal.UNSORTED_TRANSLUCENT.apply(textureLocation);
    }

    public static RenderType getUnlitTranslucent(ResourceLocation textureLocation) {
        return Internal.UNLIT_TRANSLUCENT_SORTED.apply(textureLocation);
    }

    public static RenderType getUnlitTranslucent(ResourceLocation textureLocation, boolean sortingEnabled) {
        return (sortingEnabled ? Internal.UNLIT_TRANSLUCENT_SORTED : Internal.UNLIT_TRANSLUCENT_UNSORTED).apply(textureLocation);
    }

    public static RenderType getEntityCutoutMipped(ResourceLocation textureLocation) {
        return Internal.LAYERED_ITEM_CUTOUT_MIPPED.apply(textureLocation);
    }

    public static RenderType getText(ResourceLocation locationIn) {
        return Internal.TEXT.apply(locationIn);
    }

    public static RenderType getTextIntensity(ResourceLocation locationIn) {
        return Internal.TEXT_INTENSITY.apply(locationIn);
    }

    public static RenderType getTextPolygonOffset(ResourceLocation locationIn) {
        return Internal.TEXT_POLYGON_OFFSET.apply(locationIn);
    }

    public static RenderType getTextIntensityPolygonOffset(ResourceLocation locationIn) {
        return Internal.TEXT_INTENSITY_POLYGON_OFFSET.apply(locationIn);
    }

    public static RenderType getTextSeeThrough(ResourceLocation locationIn) {
        return Internal.TEXT_SEETHROUGH.apply(locationIn);
    }

    public static RenderType getTextIntensitySeeThrough(ResourceLocation locationIn) {
        return Internal.TEXT_INTENSITY_SEE_THROUGH.apply(locationIn);
    }

    @ApiStatus.Internal
    public static RenderType getLoadingOverlay(DisplayWindow window) {
        return Internal.getLoadingOverlay(window);
    }

    private ForgeRenderTypes(NonNullSupplier<RenderType> renderTypeSupplier) {
        this.renderTypeSupplier = NonNullLazy.of(renderTypeSupplier);
    }

    public RenderType get() {
        return this.renderTypeSupplier.get();
    }

    static {
        enableTextTextureLinearFiltering = false;
    }

    private static abstract class Internal
    extends RenderType {
        public static Function<ResourceLocation, RenderType> UNSORTED_TRANSLUCENT = Util.memoize(Internal::unsortedTranslucent);
        public static Function<ResourceLocation, RenderType> UNLIT_TRANSLUCENT_SORTED = Util.memoize(Internal::unlitTranslucentSorted);
        public static Function<ResourceLocation, RenderType> UNLIT_TRANSLUCENT_UNSORTED = Util.memoize(Internal::unlitTranslucentUnsorted);
        public static Function<ResourceLocation, RenderType> LAYERED_ITEM_SOLID = Util.memoize(Internal::layeredItemSolid);
        public static Function<ResourceLocation, RenderType> LAYERED_ITEM_CUTOUT = Util.memoize(Internal::layeredItemCutout);
        public static Function<ResourceLocation, RenderType> LAYERED_ITEM_CUTOUT_MIPPED = Util.memoize(Internal::layeredItemCutoutMipped);
        public static Function<ResourceLocation, RenderType> LAYERED_ITEM_TRANSLUCENT = Util.memoize(Internal::layeredItemTranslucent);
        public static Function<ResourceLocation, RenderType> TEXT = Util.memoize(Internal::getText);
        public static Function<ResourceLocation, RenderType> TEXT_INTENSITY = Util.memoize(Internal::getTextIntensity);
        public static Function<ResourceLocation, RenderType> TEXT_POLYGON_OFFSET = Util.memoize(Internal::getTextPolygonOffset);
        public static Function<ResourceLocation, RenderType> TEXT_INTENSITY_POLYGON_OFFSET = Util.memoize(Internal::getTextIntensityPolygonOffset);
        public static Function<ResourceLocation, RenderType> TEXT_SEE_THROUGH = Util.memoize(Internal::getTextSeeThrough);
        @Deprecated
        public static Function<ResourceLocation, RenderType> TEXT_SEETHROUGH = TEXT_SEE_THROUGH;
        public static Function<ResourceLocation, RenderType> TEXT_INTENSITY_SEE_THROUGH = Util.memoize(Internal::getTextIntensitySeeThrough);
        @Deprecated(forRemoval=true, since="1.21.5")
        public static Function<ResourceLocation, RenderType> TEXT_INTENSITY_SEETHROUGH = TEXT_INTENSITY_SEE_THROUGH;
        private static final RenderPipeline LOADING_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.GUI_TEXTURED_SNIPPET}).withLocation("pipeline/forge/loading_overlay").withBlend(new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE)).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).build();

        private Internal(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
            throw new IllegalStateException("This class must not be instantiated");
        }

        private static RenderType unsortedTranslucent(ResourceLocation textureLocation) {
            return Internal.create((String)"forge_unsorted_translucent", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ENTITY_TRANSLUCENT, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false)).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
        }

        private static RenderType unlitTranslucentSorted(ResourceLocation textureLocation) {
            return Internal.create((String)"forge_unlit_translucent_sorted", (int)1536, (boolean)true, (boolean)true, (RenderPipeline)RenderPipelines.ENTITY_TRANSLUCENT, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false)).setLightmapState(NO_LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
        }

        private static RenderType unlitTranslucentUnsorted(ResourceLocation textureLocation) {
            return Internal.create((String)"forge_unlit_translucent_sorted", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ENTITY_TRANSLUCENT, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false)).setLightmapState(NO_LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
        }

        private static RenderType layeredItemSolid(ResourceLocation locationIn) {
            return Internal.create((String)"forge_layered_item_soild", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ENTITY_SOLID, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
        }

        private static RenderType layeredItemCutout(ResourceLocation locationIn) {
            return Internal.create((String)"forge_layered_item_cutout", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ENTITY_CUTOUT, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
        }

        private static RenderType layeredItemCutoutMipped(ResourceLocation locationIn) {
            return Internal.create((String)"forge_layered_item_cutout_mipped", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ENTITY_SMOOTH_CUTOUT, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, true)).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
        }

        private static RenderType layeredItemTranslucent(ResourceLocation locationIn) {
            return Internal.create((String)"forge_layered_item_translucent", (int)1536, (boolean)true, (boolean)true, (RenderPipeline)RenderPipelines.ITEM_ENTITY_TRANSLUCENT_CULL, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(locationIn, false)).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
        }

        private static RenderType getText(ResourceLocation locationIn) {
            return Internal.create((String)"forge_text", (int)786432, (boolean)false, (boolean)true, (RenderPipeline)RenderPipelines.TEXT, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomizableTextureState(locationIn, false)).setLightmapState(LIGHTMAP).createCompositeState(false));
        }

        private static RenderType getTextIntensity(ResourceLocation locationIn) {
            return Internal.create((String)"forge_text_intensity", (int)786432, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.TEXT_INTENSITY, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomizableTextureState(locationIn, false)).setLightmapState(LIGHTMAP).createCompositeState(false));
        }

        private static RenderType getTextPolygonOffset(ResourceLocation locationIn) {
            return Internal.create((String)"forge_text_polygon_offset", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)RenderPipelines.TEXT_POLYGON_OFFSET, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomizableTextureState(locationIn, false)).setLightmapState(LIGHTMAP).createCompositeState(false));
        }

        private static RenderType getTextIntensityPolygonOffset(ResourceLocation locationIn) {
            return Internal.create((String)"forge_text_intensity_polygon_offset", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)RenderPipelines.TEXT_INTENSITY, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomizableTextureState(locationIn, false)).setLightmapState(LIGHTMAP).createCompositeState(false));
        }

        private static RenderType getTextSeeThrough(ResourceLocation locationIn) {
            return Internal.create((String)"forge_text_see_through", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.TEXT_SEE_THROUGH, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomizableTextureState(locationIn, false)).setLightmapState(LIGHTMAP).createCompositeState(false));
        }

        private static RenderType getTextIntensitySeeThrough(ResourceLocation locationIn) {
            return Internal.create((String)"forge_text_intensity_see_through", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)RenderPipelines.TEXT_INTENSITY_SEE_THROUGH, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomizableTextureState(locationIn, false)).setLightmapState(LIGHTMAP).createCompositeState(false));
        }

        public static RenderType getLoadingOverlay(DisplayWindow window) {
            return Internal.create((String)"forge_loading_overlay", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)LOADING_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new LoadingOverlayTextureState(window)).createCompositeState(false));
        }
    }

    private static class LoadingOverlayTextureState
    extends RenderStateShard.TextureStateShard {
        private static final ResourceLocation LOADING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"loading_overlay");
        private final GpuTexture texture;
        private final GpuTextureView textureView;

        private LoadingOverlayTextureState(DisplayWindow window) {
            super(LOADING_TEXTURE, false);
            GpuDevice gpu = RenderSystem.getDevice();
            this.texture = gpu.createTexture(LOADING_TEXTURE.toString(), 5, TextureFormat.RGBA8, window.context().width(), window.context().height(), 1, window.getFramebufferTextureId());
            this.textureView = gpu.createTextureView(this.texture);
            this.setupState = () -> {
                GL30C.glTexParameterIi((int)3553, (int)10241, (int)9728);
                GL30C.glTexParameterIi((int)3553, (int)10240, (int)9728);
                RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.textureView);
            };
        }
    }

    private static class CustomizableTextureState
    extends RenderStateShard.TextureStateShard {
        private CustomizableTextureState(ResourceLocation resLoc, boolean mipmap) {
            super(resLoc, mipmap);
            this.setupState = () -> {
                TextureManager manager = Minecraft.getInstance().getTextureManager();
                AbstractTexture texture = manager.getTexture(resLoc);
                texture.setFilter(enableTextTextureLinearFiltering, this.mipmap);
                RenderSystem.setShaderTexture((int)0, (GpuTextureView)texture.getTextureView());
            };
        }
    }
}

