/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.madgag.gif.fmsware.GifDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmToStringStyle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaFile
extends AbstractModelObject
implements Comparable<MediaFile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFile.class);
    public static final MediaFile EMPTY_MEDIAFILE = new MediaFile();
    @JsonProperty
    private MediaFileType type = MediaFileType.UNKNOWN;
    @JsonProperty
    private String path = "";
    @JsonProperty
    private String filename = "";
    @JsonProperty
    private long filesize = 0L;
    @JsonProperty
    private long filedate = 0L;
    @JsonProperty
    private String videoCodec = "";
    @JsonProperty
    private String containerFormat = "";
    @JsonProperty
    private String exactVideoFormat = "";
    @JsonProperty
    private String video3DFormat = "";
    @JsonProperty
    private int videoWidth = 0;
    @JsonProperty
    private int videoHeight = 0;
    @JsonProperty
    private Float aspectRatio = Float.valueOf(0.0f);
    @JsonProperty
    private Float aspectRatio2 = null;
    @JsonProperty
    private Float pixelAspectRatio = Float.valueOf(0.0f);
    @JsonProperty
    private int videoBitRate = 0;
    @JsonProperty
    private int overallBitRate = 0;
    @JsonProperty
    private int bitDepth = 0;
    @JsonProperty
    private double frameRate = 0.0;
    @JsonProperty
    private int durationInSecs = 0;
    @JsonProperty
    private int stacking = 0;
    @JsonProperty
    private String stackingMarker = "";
    @JsonProperty
    private String title = "";
    @JsonProperty
    protected Date dateCreated = null;
    @JsonProperty
    protected Date dateLastModified = null;
    @JsonProperty
    private boolean isISO = false;
    @JsonProperty
    private boolean isAnimatedGraphic = false;
    @JsonProperty
    private String hdrFormat = "";
    @JsonProperty
    protected Map<String, String> checksums = new ConcurrentHashMap<String, String>(0);
    @JsonProperty
    private List<MediaFileAudioStream> audioStreams = null;
    @JsonProperty
    private List<MediaFileSubtitle> subtitles = null;
    private Path file = null;
    private Map<String, String> extraData = null;

    public MediaFile(MediaFile clone) {
        this.type = clone.type;
        this.path = clone.path;
        this.filename = clone.filename;
        this.filesize = clone.filesize;
        this.filedate = clone.filedate;
        this.videoCodec = clone.videoCodec;
        this.containerFormat = clone.containerFormat;
        this.exactVideoFormat = clone.exactVideoFormat;
        this.video3DFormat = clone.video3DFormat;
        this.videoHeight = clone.videoHeight;
        this.videoWidth = clone.videoWidth;
        this.aspectRatio = clone.aspectRatio;
        this.aspectRatio2 = clone.aspectRatio2;
        this.pixelAspectRatio = clone.pixelAspectRatio;
        this.overallBitRate = clone.overallBitRate;
        this.bitDepth = clone.bitDepth;
        this.frameRate = clone.frameRate;
        this.durationInSecs = clone.durationInSecs;
        this.stacking = clone.stacking;
        this.stackingMarker = clone.stackingMarker;
        this.title = clone.title;
        this.dateCreated = clone.dateCreated;
        this.dateLastModified = clone.dateLastModified;
        this.isISO = clone.isISO;
        this.isAnimatedGraphic = clone.isAnimatedGraphic;
        this.hdrFormat = clone.hdrFormat;
        if (ListUtils.isNotEmpty(clone.audioStreams)) {
            this.audioStreams = new CopyOnWriteArrayList<MediaFileAudioStream>(clone.audioStreams);
        }
        if (ListUtils.isNotEmpty(clone.subtitles)) {
            this.subtitles = new CopyOnWriteArrayList<MediaFileSubtitle>(clone.subtitles);
        }
        this.checksums.clear();
        this.checksums = clone.getChecksums();
    }

    public MediaFile() {
        this.path = "";
        this.filename = "";
    }

    public MediaFile(Path f) {
        this(f, null);
    }

    public MediaFile(Path f, MediaFileType type) {
        this.path = f.getParent() == null ? "" : f.getParent().toString();
        this.filename = f.getFileName().toString();
        this.file = f.toAbsolutePath();
        this.type = type == null ? MediaFileHelper.parseMediaFileType(f) : type;
        if ("iso".equalsIgnoreCase(FilenameUtils.getExtension((String)this.filename))) {
            this.isISO = true;
        }
        if (!this.isValidMediainfoFormat() && StringUtils.isBlank((CharSequence)this.getContainerFormat())) {
            this.setContainerFormat(this.getExtension());
        }
    }

    public boolean isValidMediainfoFormat() {
        String extension = this.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            extension = extension.toLowerCase(Locale.ROOT);
        }
        if (MediaFileHelper.BINARY_FILETYPES.contains(extension)) {
            return true;
        }
        if ("iso".equalsIgnoreCase(extension) || this.isDiscFile()) {
            return true;
        }
        if (this.type == null) {
            return false;
        }
        switch (this.type) {
            case VIDEO: 
            case EXTRA: 
            case TRAILER: 
            case SAMPLE: 
            case SUBTITLE: 
            case AUDIO: 
            case NFO: {
                return true;
            }
        }
        return this.isGraphic();
    }

    public boolean isPacked() {
        String ext = this.getExtension().toLowerCase(Locale.ROOT);
        return ext.equals("zip") || ext.equals("rar") || ext.equals("7z") || ext.matches("r\\d+");
    }

    public boolean isMusicTheme() {
        switch (this.type) {
            case THEME: {
                return true;
            }
        }
        return false;
    }

    public boolean isTextual() {
        switch (this.type) {
            case NFO: 
            case TEXT: {
                return true;
            }
        }
        return false;
    }

    public boolean isGraphic() {
        switch (this.type) {
            case GRAPHIC: 
            case BANNER: 
            case FANART: 
            case POSTER: 
            case THUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case CLEARART: 
            case CHARACTERART: 
            case KEYART: 
            case SEASON_POSTER: 
            case SEASON_FANART: 
            case SEASON_BANNER: 
            case SEASON_THUMB: 
            case EXTRAFANART: 
            case EXTRATHUMB: 
            case DISC: {
                return true;
            }
        }
        return false;
    }

    public boolean isVideo() {
        switch (this.type) {
            case VIDEO: 
            case TRAILER: 
            case SAMPLE: 
            case VIDEO_EXTRA: {
                return true;
            }
            case EXTRA: {
                if (!Settings.getInstance().getVideoFileType().contains("." + this.getExtension().toLowerCase(Locale.ROOT))) break;
                return true;
            }
        }
        return false;
    }

    public boolean isDiscFile() {
        return this.isBlurayFile() || this.isDVDFile() || this.isHDDVDFile();
    }

    public boolean isDVDFile() {
        return MediaFileHelper.isDVDFile(this.filename);
    }

    public boolean isHDDVDFile() {
        return MediaFileHelper.isHDDVDFile(this.filename);
    }

    public boolean isBlurayFile() {
        return MediaFileHelper.isBlurayFile(this.filename);
    }

    public boolean isMainDiscIdentifierFile() {
        return MediaFileHelper.isMainDiscIdentifierFile(this.getFilename());
    }

    public void clearVideoInformation() {
        this.setVideoWidth(0);
        this.setVideoHeight(0);
        this.setVideoBitRate(0);
        this.setOverallBitRate(0);
        this.setDuration(0);
        this.setVideoCodec("");
        this.setBitDepth(0);
        this.setFrameRate(0.0);
        this.setExactVideoFormat("");
        this.setContainerFormat("");
        this.setAspectRatio(Float.valueOf(0.0f));
        this.setAspectRatio2(null);
        this.setPixelAspectRatio(Float.valueOf(0.0f));
        this.setVideo3DFormat("");
        this.setHdrFormat("");
        this.setAnimatedGraphic(false);
    }

    public void clearAudioInformation() {
        this.setAudioStreams(Collections.emptyList());
    }

    public void clearSubtitleInformation() {
        this.setSubtitles(Collections.emptyList());
    }

    public Path getFile() {
        return this.getFileAsPath();
    }

    public Path getFileAsPath() {
        if (this.file == null) {
            Path f = Paths.get(this.path, this.filename);
            this.file = f.toAbsolutePath();
        }
        return this.file;
    }

    public void setFile(Path file) {
        this.setFilename(file.getFileName().toString());
        this.setPath(file.toAbsolutePath().getParent().toString());
        this.file = file.toAbsolutePath();
    }

    private void invalidateFileHandle() {
        if (this.file != null) {
            this.file = null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String newValue) {
        String oldValue = this.path;
        this.path = newValue;
        this.invalidateFileHandle();
        this.firePropertyChange("path", oldValue, newValue);
    }

    public void replacePathForRenamedFolder(Path oldPath, Path newPath) {
        if (oldPath == null || newPath == null || oldPath.equals(newPath)) {
            return;
        }
        int oldCnt = oldPath.getNameCount();
        Path remaining = this.getFileAsPath().subpath(oldCnt, this.getFileAsPath().getNameCount());
        Path newPathToSet = null;
        newPathToSet = remaining != null ? newPath.resolve(remaining).getParent() : newPath;
        this.setPath(newPathToSet.toAbsolutePath().toString());
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilenameWithoutStacking() {
        if (this.stackingMarker.isEmpty()) {
            return this.filename;
        }
        return this.filename.replaceAll("[ _.-]*" + this.stackingMarker, "");
    }

    public void setFilename(String newValue) {
        String oldValue = this.filename;
        this.filename = newValue;
        this.invalidateFileHandle();
        this.firePropertyChange("filename", oldValue, newValue);
    }

    public String getExtension() {
        return FilenameUtils.getExtension((String)this.filename);
    }

    public String getBasename() {
        return FilenameUtils.getBaseName((String)this.filename);
    }

    public String getMediaInfoXmlFilename() {
        return this.getBasename() + "-mediainfo.xml";
    }

    public void setFiledate(long newValue) {
        long oldValue = this.filedate;
        this.filedate = newValue;
        this.firePropertyChange("filedate", oldValue, newValue);
    }

    public long getFiledate() {
        return this.filedate;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long newValue) {
        long oldValue = this.filesize;
        this.filesize = newValue;
        this.firePropertyChange("filesize", oldValue, newValue);
        this.firePropertyChange("filesizeInMegabytes", oldValue, newValue);
    }

    public MediaFileType getType() {
        return this.type;
    }

    public void setType(MediaFileType type) {
        this.type = type;
    }

    public int getStacking() {
        return this.stacking;
    }

    public void setStacking(int stacking) {
        this.stacking = stacking;
    }

    public String getStackingMarker() {
        return this.stackingMarker;
    }

    public void setStackingMarker(String stackingMarker) {
        this.stackingMarker = stackingMarker;
    }

    public boolean isISO() {
        return this.isISO;
    }

    public void setIsISO(boolean newValue) {
        this.isISO = newValue;
    }

    public void removeStackingInformation() {
        this.setStacking(0);
        this.setStackingMarker("");
    }

    public void detectStackingInformation() {
        this.stacking = Utils.getStackingNumber(this.filename);
        if (this.stacking == 0) {
            this.stacking = Utils.getStackingNumber(FilenameUtils.getBaseName((String)this.getPath()));
        }
        this.stackingMarker = Utils.getStackingMarker(this.filename);
        if (this.stackingMarker.isEmpty()) {
            this.stackingMarker = Utils.getFolderStackingMarker(FilenameUtils.getBaseName((String)this.getPath()));
        }
    }

    public List<MediaFileSubtitle> getSubtitles() {
        if (this.subtitles == null) {
            return Collections.emptyList();
        }
        return this.subtitles;
    }

    public Collection<String> getSubtitleLanguages() {
        TreeSet<String> subtitleLanguages = new TreeSet<String>();
        for (MediaFileSubtitle stream : ListUtils.nullSafe(this.subtitles)) {
            if (StringUtils.isBlank((CharSequence)stream.getLanguage())) continue;
            subtitleLanguages.add(stream.getLanguage());
        }
        return subtitleLanguages;
    }

    public Collection<String> getSubtitleCodecs() {
        TreeSet<String> subtitleLanguages = new TreeSet<String>();
        for (MediaFileSubtitle stream : ListUtils.nullSafe(this.subtitles)) {
            if (StringUtils.isBlank((CharSequence)stream.getCodec())) continue;
            subtitleLanguages.add(stream.getCodec());
        }
        return subtitleLanguages;
    }

    public Collection<MediaStreamInfo.Flags> getSubtitleTypes() {
        EnumSet<MediaStreamInfo.Flags> subtitleTypes = EnumSet.noneOf(MediaStreamInfo.Flags.class);
        for (MediaFileSubtitle stream : ListUtils.nullSafe(this.subtitles)) {
            subtitleTypes.addAll(stream.getFlags());
        }
        return subtitleTypes;
    }

    public String getSubtitlesAsString() {
        if (this.subtitles == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<MediaFileSubtitle> cleansub = new LinkedHashSet<MediaFileSubtitle>(this.subtitles);
        for (MediaFileSubtitle sub : cleansub) {
            if (StringUtils.isBlank((CharSequence)sub.getLanguage())) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sub.getLanguage());
        }
        return sb.toString();
    }

    public void setSubtitles(List<MediaFileSubtitle> subtitles) {
        if (this.subtitles == null && subtitles.isEmpty()) {
            return;
        }
        if (this.subtitles == null) {
            this.subtitles = new CopyOnWriteArrayList<MediaFileSubtitle>();
        } else {
            this.subtitles.clear();
        }
        this.subtitles.addAll(subtitles);
        this.firePropertyChange("subtitles", null, subtitles);
    }

    public void addSubtitle(MediaFileSubtitle subtitle) {
        if (this.subtitles == null) {
            this.subtitles = new CopyOnWriteArrayList<MediaFileSubtitle>();
        }
        if (!this.subtitles.contains(subtitle)) {
            this.subtitles.add(subtitle);
            this.firePropertyChange("subtitles", null, this.subtitles);
        }
    }

    public boolean hasSubtitles() {
        return this.subtitles != null && !this.subtitles.isEmpty();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue;
        this.firePropertyChange("title", oldValue, newValue);
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(String newValue) {
        if ("avc".equalsIgnoreCase(newValue) || "x264".equalsIgnoreCase(newValue)) {
            newValue = "h264";
        }
        if ("hevc".equalsIgnoreCase(newValue) || "x265".equalsIgnoreCase(newValue)) {
            newValue = "h265";
        }
        String oldValue = this.videoCodec;
        this.videoCodec = newValue;
        this.firePropertyChange("videoCodec", oldValue, newValue);
    }

    public String getAudioCodec() {
        String codec = "";
        MediaFileAudioStream highestStream = this.getDefaultOrBestAudioStream();
        if (highestStream != null) {
            codec = highestStream.getCodec();
        }
        return codec;
    }

    public List<String> getAudioTitleList() {
        ArrayList<String> audioTitleList = new ArrayList<String>();
        for (MediaFileAudioStream stream : ListUtils.nullSafe(this.audioStreams)) {
            audioTitleList.add(stream.getTitle());
        }
        return audioTitleList;
    }

    public List<String> getAudioCodecList() {
        ArrayList<String> audioCodecs = new ArrayList<String>();
        for (MediaFileAudioStream stream : ListUtils.nullSafe(this.audioStreams)) {
            audioCodecs.add(stream.getCodec());
        }
        return audioCodecs;
    }

    public String getAudioCodecListAsAstring() {
        StringBuilder sb = new StringBuilder();
        for (MediaFileAudioStream audioStream : ListUtils.nullSafe(this.audioStreams)) {
            if (sb.length() > 0) {
                sb.append(" / ");
            }
            sb.append(audioStream.getCodec());
        }
        return sb.toString();
    }

    private MediaFileAudioStream getBestAudioStream() {
        MediaFileAudioStream highestStream = null;
        for (MediaFileAudioStream stream : ListUtils.nullSafe(this.audioStreams)) {
            if (highestStream == null) {
                highestStream = stream;
                continue;
            }
            if (highestStream.getAudioChannels() >= stream.getAudioChannels()) continue;
            highestStream = stream;
        }
        return highestStream;
    }

    public String getAudioLanguage() {
        String language = "";
        MediaFileAudioStream highestStream = this.getDefaultOrBestAudioStream();
        if (highestStream != null) {
            language = highestStream.getLanguage();
        }
        return language;
    }

    public List<String> getAudioLanguagesList() {
        ArrayList<String> audioLanguages = new ArrayList<String>();
        for (MediaFileAudioStream stream : ListUtils.nullSafe(this.audioStreams)) {
            if (StringUtils.isBlank((CharSequence)stream.getLanguage())) continue;
            audioLanguages.add(stream.getLanguage());
        }
        return audioLanguages;
    }

    public String getContainerFormat() {
        return this.containerFormat;
    }

    public void setContainerFormatDirect() {
        String extensions = MediaFileHelper.getMediaInfoDirect(this, MediaInfo.StreamKind.General, 0, "FileExtension", "Codec/Extensions", "Format/Extensions", "Format");
        extensions = extensions.replace("braw", "");
        extensions = extensions.replace("h3d", "");
        this.setContainerFormat(MediaFileHelper.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
    }

    public void setContainerFormat(String newValue) {
        String oldValue = this.containerFormat;
        this.containerFormat = newValue;
        this.firePropertyChange("containerFormat", oldValue, newValue);
    }

    public String getVideoFormat() {
        return MediaFileHelper.getVideoFormat(this);
    }

    public String getExactVideoFormat() {
        return this.exactVideoFormat;
    }

    public void setExactVideoFormat(String newValue) {
        String oldValue = this.exactVideoFormat;
        this.exactVideoFormat = newValue;
        this.firePropertyChange("exactVideoFormat", oldValue, newValue);
    }

    public String getAudioChannels() {
        Object channels = "";
        MediaFileAudioStream highestStream = this.getDefaultOrBestAudioStream();
        if (highestStream != null) {
            channels = highestStream.getAudioChannels() + "ch";
        }
        return channels;
    }

    public String getAudioChannelsDot() {
        String channels = "";
        MediaFileAudioStream highestStream = this.getDefaultOrBestAudioStream();
        if (highestStream != null) {
            channels = MediaFileHelper.audioChannelInDotNotation(highestStream.getAudioChannels());
        }
        return channels;
    }

    public int getAudioChannelCount() {
        MediaFileAudioStream highestStream = this.getDefaultOrBestAudioStream();
        if (highestStream != null) {
            return highestStream.getAudioChannels();
        }
        return 0;
    }

    public List<String> getAudioChannelsList() {
        ArrayList<String> audioChannels = new ArrayList<String>();
        for (MediaFileAudioStream stream : ListUtils.nullSafe(this.audioStreams)) {
            audioChannels.add(stream.getAudioChannels() + "ch");
        }
        return audioChannels;
    }

    public List<String> getAudioChannelsDotList() {
        ArrayList<String> audioChannels = new ArrayList<String>();
        for (MediaFileAudioStream stream : ListUtils.nullSafe(this.audioStreams)) {
            audioChannels.add(MediaFileHelper.audioChannelInDotNotation(stream.getAudioChannels()));
        }
        return audioChannels;
    }

    public String getVideoResolution() {
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return "";
        }
        return this.videoWidth + "x" + this.videoHeight;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date newValue) {
        Date oldValue = this.dateCreated;
        this.dateCreated = newValue;
        this.firePropertyChange("dateCreated", oldValue, newValue);
    }

    public Date getDateLastModified() {
        return this.dateLastModified;
    }

    public void setDateLastModified(Date newValue) {
        Date oldValue = this.dateLastModified;
        this.dateLastModified = newValue;
        this.firePropertyChange("exactVideoFormat", oldValue, newValue);
    }

    public void setVideoWidth(int newValue) {
        int oldValue = this.videoWidth;
        this.videoWidth = newValue;
        this.firePropertyChange("videoWidth", oldValue, newValue);
        this.firePropertyChange("videoFormat", oldValue, newValue);
    }

    public void setVideoHeight(int newValue) {
        int oldValue = this.videoHeight;
        this.videoHeight = newValue;
        this.firePropertyChange("videoHeight", oldValue, newValue);
        this.firePropertyChange("videoFormat", oldValue, newValue);
    }

    public Boolean isWidescreen() {
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return false;
        }
        return (float)this.videoWidth / (float)this.videoHeight > 1.37f;
    }

    public void setAspectRatio(Float newValue) {
        Float oldValue = this.aspectRatio;
        this.aspectRatio = newValue;
        this.firePropertyChange("aspectRatio", oldValue, newValue);
    }

    public Float getAspectRatio() {
        if (this.aspectRatio.floatValue() > 0.0f) {
            return Float.valueOf(this.getCommonAspectRatio(this.aspectRatio));
        }
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return Float.valueOf(0.0f);
        }
        float ar = (float)this.videoWidth / (float)this.videoHeight;
        return Float.valueOf(this.getCommonAspectRatio(Float.valueOf(ar)));
    }

    public void setAspectRatio2(Float newValue) {
        Float oldValue = this.aspectRatio2;
        this.aspectRatio2 = newValue;
        this.firePropertyChange("aspectRatio2", oldValue, newValue);
    }

    public Float getAspectRatio2() {
        return this.aspectRatio2;
    }

    public Float getPixelAspectRatio() {
        return this.pixelAspectRatio;
    }

    public void setPixelAspectRatio(Float pixelAspectRatio) {
        this.pixelAspectRatio = pixelAspectRatio;
    }

    private float getCommonAspectRatio(Float ar) {
        float ret = ar.floatValue() < 1.3499f ? 1.33f : (ar.floatValue() < 1.3997f ? 1.37f : (ar.floatValue() < 1.4935f ? 1.43f : (ar.floatValue() < 1.6092f ? 1.56f : (ar.floatValue() < 1.719f ? 1.66f : (ar.floatValue() < 1.8147f ? 1.78f : (ar.floatValue() < 1.8748f ? 1.85f : (ar.floatValue() < 1.9494f ? 1.9f : (ar.floatValue() < 2.0976f ? 2.0f : (ar.floatValue() < 2.2738f ? 2.2f : (ar.floatValue() < 2.3749f ? 2.35f : (ar.floatValue() < 2.4739f ? 2.4f : (ar.floatValue() < 2.6529f ? 2.55f : 2.76f))))))))))));
        return ret;
    }

    public String getVideoDefinitionCategory() {
        return MediaFileHelper.getVideoDefinitionCategory(this);
    }

    public boolean isVideoDefinitionLD() {
        return MediaFileHelper.isVideoDefinitionLD(this);
    }

    public boolean isVideoDefinitionSD() {
        return MediaFileHelper.isVideoDefinitionSD(this);
    }

    public boolean isVideoDefinitionHD() {
        return MediaFileHelper.isVideoDefinitionHD(this);
    }

    public boolean isVideoDefinitionUHD() {
        return MediaFileHelper.isVideoDefinitionUHD(this);
    }

    public int getVideoBitRate() {
        if (this.videoBitRate == 0 && this.overallBitRate != 0) {
            int calculatedVideoBitRate = this.overallBitRate;
            for (MediaFileAudioStream audioStream : ListUtils.nullSafe(this.audioStreams)) {
                calculatedVideoBitRate -= audioStream.getBitrate();
            }
            if (calculatedVideoBitRate > 0) {
                return calculatedVideoBitRate;
            }
        }
        return this.videoBitRate;
    }

    public void setVideoBitRate(int newValue) {
        int oldValue = this.videoBitRate;
        this.videoBitRate = newValue;
        this.firePropertyChange("videoBitRate", oldValue, newValue);
        this.firePropertyChange("bitRateInKbps", oldValue, newValue);
    }

    public String getVideoBitRateInKbps() {
        return this.getVideoBitRate() + " kbps";
    }

    public int getOverallBitRate() {
        return this.overallBitRate;
    }

    public void setOverallBitRate(int newValue) {
        int oldValue = this.overallBitRate;
        this.overallBitRate = newValue;
        this.firePropertyChange("overallBitRate", oldValue, newValue);
    }

    public String getOverallBitRateInKbps() {
        return this.getOverallBitRate() + " kbps";
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        double oldValue = this.frameRate;
        this.frameRate = frameRate;
        this.firePropertyChange("frameRate", oldValue, frameRate);
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(int newValue) {
        int oldValue = this.bitDepth;
        this.bitDepth = newValue;
        this.firePropertyChange("bitDepth", oldValue, newValue);
    }

    public String getBitDepthString() {
        return this.bitDepth + " bit";
    }

    public int getDuration() {
        return this.durationInSecs;
    }

    public int getDurationInMinutes() {
        return this.durationInSecs / 60;
    }

    public void setDurationInMinutes(int durationInMinutes) {
        this.setDuration(durationInMinutes * 60);
    }

    public String getDurationHM() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        if (s > 30L) {
            ++m;
        }
        return String.format("%dh %02dm", h, m);
    }

    public String getDurationHMS() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        return String.format("%dh %02dm %02ds", h, m, s);
    }

    public String getDurationHHMMSS() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        return String.format("%02d:%02d:%02d", h, m, s);
    }

    public String getDurationShort() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        if (h > 0L) {
            return String.format("%d:%02d:%02d", h, m, s);
        }
        if (m > 0L) {
            return String.format("%d:%02d", m, s);
        }
        return String.format("%d", s);
    }

    public void setDuration(int newValue) {
        int oldValue = this.durationInSecs;
        this.durationInSecs = newValue;
        this.firePropertyChange("duration", oldValue, newValue);
        this.firePropertyChange("durationShort", oldValue, newValue);
        this.firePropertyChange("durationHM", oldValue, newValue);
        this.firePropertyChange("durationHHMMSS", oldValue, newValue);
    }

    public List<MediaFileAudioStream> getAudioStreams() {
        if (this.audioStreams == null) {
            return Collections.emptyList();
        }
        return this.audioStreams;
    }

    public MediaFileAudioStream getDefaultOrBestAudioStream() {
        MediaFileAudioStream ret = null;
        for (MediaFileAudioStream as : ListUtils.nullSafe(this.audioStreams)) {
            if (!as.isDefaultStream()) continue;
            ret = as;
            break;
        }
        if (ret == null) {
            ret = this.getBestAudioStream();
        }
        return ret;
    }

    public void setAudioStreams(List<MediaFileAudioStream> audioStreams) {
        if (this.audioStreams == null && audioStreams.isEmpty()) {
            return;
        }
        if (this.audioStreams == null) {
            this.audioStreams = new CopyOnWriteArrayList<MediaFileAudioStream>();
        } else {
            this.audioStreams.clear();
        }
        this.audioStreams.addAll(audioStreams);
        this.firePropertyChange("audioStreams", null, audioStreams);
    }

    public String getCombinedCodecs() {
        StringBuilder sb = new StringBuilder(this.videoCodec);
        for (MediaFileAudioStream audioStream : ListUtils.nullSafe(this.audioStreams)) {
            if (!sb.isEmpty()) {
                sb.append(" / ");
            }
            sb.append(audioStream.getCodec());
        }
        return sb.toString();
    }

    public String getVideo3DFormat() {
        return this.video3DFormat;
    }

    public String getVideo3DFormatOld() {
        String f = this.video3DFormat;
        if (f.contains("top") && f.contains("bottom") || f.contains("TAB")) {
            f = "3D HTAB";
            if (this.videoHeight > this.videoWidth) {
                f = "3D TAB";
            }
            return f;
        }
        if (f.contains("left") && f.contains("right") || f.contains("SBS")) {
            f = "3D HSBS";
            if (this.getAspectRatio().floatValue() > 3.0f) {
                f = "3D SBS";
            }
            return f;
        }
        if (f.contains("block") || f.contains("MVC")) {
            f = "3D MVC";
            return f;
        }
        return "";
    }

    public void setVideo3DFormat(String video3DFormat) {
        this.video3DFormat = video3DFormat;
    }

    public boolean isAnimatedGraphic() {
        return this.isAnimatedGraphic;
    }

    public void setAnimatedGraphic(boolean isAnimatedGraphic) {
        this.isAnimatedGraphic = isAnimatedGraphic;
    }

    public boolean isHDR() {
        return StringUtils.isNotBlank((CharSequence)this.hdrFormat);
    }

    public void setHdrFormat(String format) {
        this.hdrFormat = format;
    }

    public String getHdrFormat() {
        return this.hdrFormat;
    }

    public Map<String, String> getChecksums() {
        return this.checksums;
    }

    public void setChecksums(Map<String, String> checksums) {
        this.checksums = checksums;
    }

    public String getCRC32() {
        return this.checksums.get("crc32") == null ? "" : this.checksums.get("crc32");
    }

    public void setCRC32(String crc) {
        this.checksums.put("crc32", crc);
    }

    public void addExtraData(String key, String value) {
        if (this.extraData == null) {
            this.extraData = new HashMap<String, String>();
        }
        this.extraData.put(key, value);
    }

    public Map<String, String> getExtraData() {
        if (this.extraData == null) {
            return Collections.emptyMap();
        }
        return this.extraData;
    }

    public void checkForAnimation() {
        if (this.isGraphic() && this.getExtension().equalsIgnoreCase("gif")) {
            try {
                GifDecoder decoder = new GifDecoder();
                decoder.read(this.getFileAsPath().toString());
                if (decoder.getFrameCount() > 1) {
                    this.setAnimatedGraphic(true);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not check GIF for animation for '{}' - '{}'", (Object)this.getFileAsPath(), (Object)e.getMessage());
            }
        }
    }

    public void gatherMediaInformation() {
        this.gatherMediaInformation(false);
    }

    public void gatherMediaInformation(boolean force) {
        MediaFileHelper.gatherMediaInformation(this, force);
    }

    public boolean exists() {
        return Files.exists(this.getFileAsPath(), new LinkOption[0]);
    }

    public boolean deleteSafely(String datasource) {
        return Utils.deleteFileWithBackup(this.getFileAsPath(), datasource);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TmmToStringStyle.TMM_STYLE, (boolean)false, MediaFile.class);
    }

    public boolean equals(Object other) {
        if (other instanceof MediaFile) {
            MediaFile mf2 = (MediaFile)other;
            return this.compareTo(mf2) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(MediaFile other) {
        return this.getFileAsPath().compareTo(other.getFileAsPath());
    }

    public int hashCode() {
        return this.getFileAsPath().hashCode();
    }
}

