/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.treetable;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableSortingStrategy;

public abstract class AbstractTmmTreeTableNodeComparator
implements Comparator<TmmTreeNode>,
ITmmTreeTableSortingStrategy {
    private static final Pattern FROM_STRING_PATTERN = Pattern.compile("^\\s*column\\s+(\\d+)(\\s+comparator\\s+(\\d+))?(\\s+(reversed))?\\s*$", 2);
    protected ITmmTreeTableSortingStrategy.SortDirection sortDirection;
    protected int sortColumn;

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("column ");
        result.append(this.sortColumn);
        if (this.sortDirection == ITmmTreeTableSortingStrategy.SortDirection.DESCENDING) {
            result.append(" reversed");
        }
        return result.toString();
    }

    @Override
    public void fromString(String stringEncoded) {
        boolean reversedComparator;
        if (StringUtils.isBlank((CharSequence)stringEncoded)) {
            return;
        }
        Matcher matcher = FROM_STRING_PATTERN.matcher(stringEncoded);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Failed to parse column spec, \"" + stringEncoded + "\"");
        }
        int columnIndex = Integer.parseInt(matcher.group(1));
        boolean bl = reversedComparator = matcher.group(5) != null;
        if (columnIndex >= 0) {
            this.sortColumn = columnIndex;
        }
        this.sortDirection = reversedComparator ? ITmmTreeTableSortingStrategy.SortDirection.DESCENDING : ITmmTreeTableSortingStrategy.SortDirection.ASCENDING;
    }
}

