/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.searchtree.FullTextSearchTree;
import net.minecraft.client.searchtree.IdSearchTree;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.CreativeModeTabSearchRegistry;

@OnlyIn(value=Dist.CLIENT)
public class SessionSearchTrees {
    private static final Key RECIPE_COLLECTIONS = new Key();
    public static final Key CREATIVE_NAMES = new Key();
    public static final Key CREATIVE_TAGS = new Key();
    private CompletableFuture<SearchTree<ItemStack>> EMPTY = CompletableFuture.completedFuture(SearchTree.empty());
    private Map<Key, CompletableFuture<SearchTree<ItemStack>>> creativeSearch = new IdentityHashMap<Key, CompletableFuture<SearchTree<ItemStack>>>();
    private CompletableFuture<SearchTree<RecipeCollection>> recipeSearch = CompletableFuture.completedFuture(SearchTree.empty());
    private final Map<Key, Runnable> reloaders = new IdentityHashMap<Key, Runnable>();

    private void register(Key p_342736_, Runnable p_343077_) {
        p_343077_.run();
        this.reloaders.put(p_342736_, p_343077_);
    }

    public void rebuildAfterLanguageChange() {
        for (Runnable runnable : this.reloaders.values()) {
            runnable.run();
        }
    }

    private static Stream<String> getTooltipLines(Stream<ItemStack> p_344293_, Item.TooltipContext p_343228_, TooltipFlag p_342315_) {
        return p_344293_.flatMap(p_343071_ -> p_343071_.getTooltipLines(p_343228_, null, p_342315_).stream()).map(p_344266_ -> ChatFormatting.stripFormatting(p_344266_.getString()).trim()).filter(p_345189_ -> !p_345189_.isEmpty());
    }

    public void updateRecipes(ClientRecipeBook p_343609_, Level p_362281_) {
        this.register(RECIPE_COLLECTIONS, () -> {
            List list = p_343609_.getCollections();
            RegistryAccess registryaccess = p_362281_.registryAccess();
            HolderLookup.RegistryLookup registry = registryaccess.lookupOrThrow(Registries.ITEM);
            Item.TooltipContext item$tooltipcontext = Item.TooltipContext.of(registryaccess);
            ContextMap contextmap = SlotDisplayContext.fromLevel(p_362281_);
            TooltipFlag.Default tooltipflag = TooltipFlag.Default.NORMAL;
            CompletableFuture<SearchTree<RecipeCollection>> completablefuture = this.recipeSearch;
            this.recipeSearch = CompletableFuture.supplyAsync(() -> SessionSearchTrees.lambda$updateRecipes$8(contextmap, item$tooltipcontext, tooltipflag, (Registry)registry, list), Util.backgroundExecutor());
            completablefuture.cancel(true);
        });
    }

    public SearchTree<RecipeCollection> recipes() {
        return this.recipeSearch.join();
    }

    public void updateCreativeTags(List<ItemStack> p_344581_) {
        for (Map.Entry entry : CreativeModeTabSearchRegistry.getTagSearchKeys().entrySet()) {
            this.register((Key)entry.getValue(), () -> {
                List<ItemStack> items = entry.getKey() == CreativeModeTabs.searchTab() ? p_344581_ : List.copyOf(((CreativeModeTab)entry.getKey()).getDisplayItems());
                CompletableFuture<SearchTree<ItemStack>> completablefuture = this.creativeSearch.getOrDefault(entry.getValue(), this.EMPTY);
                this.creativeSearch.put((Key)entry.getValue(), CompletableFuture.supplyAsync(() -> new IdSearchTree(p_342206_ -> p_342206_.getTags().map(TagKey::location), items), Util.backgroundExecutor()));
                completablefuture.cancel(true);
            });
        }
    }

    public SearchTree<ItemStack> creativeTagSearch() {
        return this.getSearchTree(CREATIVE_TAGS);
    }

    public void updateCreativeTooltips(HolderLookup.Provider p_343364_, List<ItemStack> p_342500_) {
        for (Map.Entry entry : CreativeModeTabSearchRegistry.getNameSearchKeys().entrySet()) {
            this.register((Key)entry.getValue(), () -> {
                List<ItemStack> items = entry.getKey() == CreativeModeTabs.searchTab() ? p_342500_ : List.copyOf(((CreativeModeTab)entry.getKey()).getDisplayItems());
                Item.TooltipContext item$tooltipcontext = Item.TooltipContext.of(p_343364_);
                TooltipFlag.Default tooltipflag = TooltipFlag.Default.NORMAL.asCreative();
                CompletableFuture<SearchTree<ItemStack>> completablefuture = this.creativeSearch.getOrDefault(entry.getValue(), this.EMPTY);
                this.creativeSearch.put((Key)entry.getValue(), CompletableFuture.supplyAsync(() -> new FullTextSearchTree(p_345254_ -> SessionSearchTrees.getTooltipLines(Stream.of(p_345254_), item$tooltipcontext, tooltipflag), p_344415_ -> p_344415_.getItemHolder().unwrapKey().map(ResourceKey::location).stream(), items), Util.backgroundExecutor()));
                completablefuture.cancel(true);
            });
        }
    }

    public SearchTree<ItemStack> creativeNameSearch() {
        return this.getSearchTree(CREATIVE_NAMES);
    }

    public SearchTree<ItemStack> getSearchTree(Key key) {
        return this.creativeSearch.getOrDefault(key, this.EMPTY).join();
    }

    private static /* synthetic */ SearchTree lambda$updateRecipes$8(ContextMap contextmap, Item.TooltipContext item$tooltipcontext, TooltipFlag tooltipflag, Registry registry, List list) {
        return new FullTextSearchTree(p_357799_ -> SessionSearchTrees.getTooltipLines(p_357799_.getRecipes().stream().flatMap(p_357810_ -> p_357810_.resultItems(contextmap).stream()), item$tooltipcontext, tooltipflag), p_357813_ -> p_357813_.getRecipes().stream().flatMap(p_357803_ -> p_357803_.resultItems(contextmap).stream()).map(p_357808_ -> registry.getKey(p_357808_.getItem())), list);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Key {
    }
}

