/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.videobridge.JvbLastNKt;
import org.jitsi.videobridge.SsrcLimitConfig;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.load_management.ConferenceSizeLastNLimits;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u001a,\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bj\u0002`\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"prioritize", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "conferenceSources", "", "selectedSourceNames", "", "getEffectiveConstraints", "", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "sources", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "effectiveLastN", "", "lastN", "conferenceSize", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nPrioritize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Prioritize.kt\norg/jitsi/videobridge/cc/allocation/PrioritizeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1869#2,2:101\n1011#2,2:103\n1285#2,2:105\n1299#2,4:107\n*S KotlinDebug\n*F\n+ 1 Prioritize.kt\norg/jitsi/videobridge/cc/allocation/PrioritizeKt\n*L\n39#1:101,2\n52#1:103,2\n76#1:105,2\n76#1:107,4\n*E\n"})
public final class PrioritizeKt {
    @NotNull
    public static final List<MediaSourceDesc> prioritize(@NotNull List<MediaSourceDesc> conferenceSources, @NotNull List<String> selectedSourceNames) {
        Intrinsics.checkNotNullParameter(conferenceSources, (String)"conferenceSources");
        Intrinsics.checkNotNullParameter(selectedSourceNames, (String)"selectedSourceNames");
        List enabledSelectedSources = new ArrayList();
        List enabledNonSelectedSources = new ArrayList();
        List disabledSources = new ArrayList();
        Iterable $this$forEach$iv = conferenceSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            MediaSourceDesc source = (MediaSourceDesc)element$iv;
            boolean bl2 = false;
            if (source.getVideoType().isEnabled()) {
                if (selectedSourceNames.contains(source.getSourceName())) {
                    bl = enabledSelectedSources.add(source);
                    continue;
                }
                bl = enabledNonSelectedSources.add(source);
                continue;
            }
            bl = disabledSources.add(source);
        }
        List $this$sortBy$iv = enabledSelectedSources;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(selectedSourceNames){
                final /* synthetic */ List $selectedSourceNames$inlined;
                {
                    this.$selectedSourceNames$inlined = list;
                }

                public final int compare(T a, T b) {
                    MediaSourceDesc it = (MediaSourceDesc)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$selectedSourceNames$inlined.indexOf(it.getSourceName()));
                    it = (MediaSourceDesc)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$selectedSourceNames$inlined.indexOf(it.getSourceName())));
                }
            });
        }
        enabledSelectedSources.addAll(enabledNonSelectedSources);
        enabledSelectedSources.addAll(disabledSources);
        return enabledSelectedSources;
    }

    public static /* synthetic */ List prioritize$default(List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return PrioritizeKt.prioritize(list, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<MediaSourceDesc, VideoConstraints> getEffectiveConstraints(@NotNull List<MediaSourceDesc> sources, @NotNull AllocationSettings allocationSettings) {
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)allocationSettings, (String)"allocationSettings");
        int effectiveLastN = PrioritizeKt.effectiveLastN(allocationSettings.getLastN(), sources.size() + 1);
        int sourcesWithNonZeroConstraints = 0;
        Iterable $this$associateWith$iv = sources;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            VideoConstraints videoConstraints;
            void source;
            MediaSourceDesc mediaSourceDesc = (MediaSourceDesc)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            if (!source.getVideoType().isEnabled() || sourcesWithNonZeroConstraints >= effectiveLastN) {
                videoConstraints = VideoConstraints.Companion.getNOTHING();
            } else {
                VideoConstraints videoConstraints2;
                VideoConstraints it = videoConstraints2 = allocationSettings.getConstraints(source.getSourceName());
                boolean bl2 = false;
                if (!it.isDisabled()) {
                    ++sourcesWithNonZeroConstraints;
                }
                videoConstraints = videoConstraints2;
            }
            VideoConstraints videoConstraints3 = videoConstraints;
            map.put(t, videoConstraints3);
        }
        return destination$iv$iv;
    }

    private static final int effectiveLastN(int lastN, int conferenceSize) {
        int[] nArray = new int[]{lastN, JvbLastNKt.jvbLastNSingleton.getJvbLastN(), ConferenceSizeLastNLimits.Companion.getSingleton().getLastNLimit(conferenceSize), SsrcLimitConfig.config.getMaxVideoSsrcs()};
        int adjustedLastN = JvbLastNKt.calculateLastN(nArray);
        return adjustedLastN < 0 ? Integer.MAX_VALUE : adjustedLastN;
    }
}

