/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.utils.DurationKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\tJ\u0006\u0010,\u001a\u00020\u0005J\b\u0010-\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0013\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\n \u001d*\u0004\u0018\u00010\t0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\u001aR\"\u0010%\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!\u00a8\u0006."}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/RttBasedBackoff;", "", "<init>", "()V", "disabled", "", "getDisabled", "()Z", "configuredLimit", "Ljava/time/Duration;", "getConfiguredLimit", "()Ljava/time/Duration;", "dropFraction", "", "getDropFraction", "()D", "dropInterval", "getDropInterval", "bandwidthFloor", "Lorg/jitsi/nlj/util/Bandwidth;", "getBandwidthFloor-rlWvAKk", "()J", "J", "rttLimit", "getRttLimit", "setRttLimit", "(Ljava/time/Duration;)V", "lastPropagationRttUpdate", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getLastPropagationRttUpdate", "()Ljava/time/Instant;", "setLastPropagationRttUpdate", "(Ljava/time/Instant;)V", "lastPropagationRtt", "getLastPropagationRtt", "setLastPropagationRtt", "lastPacketSent", "getLastPacketSent", "setLastPacketSent", "updatePropagationRtt", "", "atTime", "propagationRtt", "isRttAboveLimit", "correctedRtt", "jitsi-media-transform"})
public final class RttBasedBackoff {
    private final boolean disabled;
    @NotNull
    private final Duration configuredLimit = DurationKt.getSecs((int)3);
    private final double dropFraction;
    @NotNull
    private final Duration dropInterval = DurationKt.getSecs((int)1);
    private final long bandwidthFloor = BandwidthKt.getKbps(5);
    @NotNull
    private Duration rttLimit = this.configuredLimit;
    private Instant lastPropagationRttUpdate = Instant.MAX;
    private Duration lastPropagationRtt = Duration.ZERO;
    private Instant lastPacketSent = Instant.MIN;

    public RttBasedBackoff() {
        this.dropFraction = 0.8;
    }

    public final boolean getDisabled() {
        return this.disabled;
    }

    @NotNull
    public final Duration getConfiguredLimit() {
        return this.configuredLimit;
    }

    public final double getDropFraction() {
        return this.dropFraction;
    }

    @NotNull
    public final Duration getDropInterval() {
        return this.dropInterval;
    }

    public final long getBandwidthFloor-rlWvAKk() {
        return this.bandwidthFloor;
    }

    @NotNull
    public final Duration getRttLimit() {
        return this.rttLimit;
    }

    public final void setRttLimit(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.rttLimit = duration;
    }

    public final Instant getLastPropagationRttUpdate() {
        return this.lastPropagationRttUpdate;
    }

    public final void setLastPropagationRttUpdate(Instant instant) {
        this.lastPropagationRttUpdate = instant;
    }

    public final Duration getLastPropagationRtt() {
        return this.lastPropagationRtt;
    }

    public final void setLastPropagationRtt(Duration duration) {
        this.lastPropagationRtt = duration;
    }

    public final Instant getLastPacketSent() {
        return this.lastPacketSent;
    }

    public final void setLastPacketSent(Instant instant) {
        this.lastPacketSent = instant;
    }

    public final void updatePropagationRtt(@NotNull Instant atTime, @NotNull Duration propagationRtt) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        Intrinsics.checkNotNullParameter((Object)propagationRtt, (String)"propagationRtt");
        this.lastPropagationRttUpdate = atTime;
        this.lastPropagationRtt = propagationRtt;
    }

    public final boolean isRttAboveLimit() {
        return this.correctedRtt().compareTo(this.rttLimit) > 0;
    }

    private final Duration correctedRtt() {
        Duration duration = Duration.between(this.lastPropagationRttUpdate, this.lastPacketSent);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
        Duration timeoutCorrection = DurationKt.max((Duration)duration, (Duration)duration2);
        Duration duration3 = timeoutCorrection.plus(this.lastPropagationRtt);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"plus(...)");
        return duration3;
    }
}

