/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.ExtendedFileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileSetDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.ImplementationUseDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.LogicalVolumeDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.LogicalVolumeIntegrityDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.PartitionDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.PrimaryVolumeDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.TerminatingDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UnallocatedSpaceDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DescriptorTag;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDFVolumeDescriptorSet
implements VolumeDescriptorSet {
    private static final Log log = LogFactory.getLog(UDFVolumeDescriptorSet.class);
    private UDFFileSystem fs;
    public PrimaryVolumeDescriptor pvd;
    public LogicalVolumeDescriptor lvd;
    public LogicalVolumeIntegrityDescriptor lvid;
    public PartitionDescriptor pd;
    public ImplementationUseDescriptor impl;
    public UnallocatedSpaceDescriptor un;
    public FileSetDescriptor rootFSD;
    public FileEntryDescriptor rootEntry;
    private long fsdLocation = 0L;
    private int invalidCnt = 0;

    public UDFVolumeDescriptorSet(UDFFileSystem fs) {
        this.fs = fs;
    }

    public boolean deserialize(byte[] bytes) throws IOException {
        Integer type = UDFUtil.getUInt16(bytes, 0);
        boolean terminated = false;
        try {
            switch (type) {
                case 1: {
                    log.debug((Object)"Found primary volume descriptor.");
                    this.pvd = new PrimaryVolumeDescriptor(bytes);
                    break;
                }
                case 2: {
                    log.debug((Object)"Found anchor pointer.");
                    break;
                }
                case 3: {
                    log.debug((Object)"Found volume descriptorpointer.");
                    break;
                }
                case 4: {
                    log.debug((Object)"Found implementation use descriptor.");
                    this.impl = new ImplementationUseDescriptor(bytes);
                    break;
                }
                case 5: {
                    log.debug((Object)"Found partition descriptor.");
                    this.pd = new PartitionDescriptor(bytes);
                    break;
                }
                case 6: {
                    log.debug((Object)"Found logical volume descriptor");
                    this.lvd = new LogicalVolumeDescriptor(bytes);
                    log.debug((Object)("Disc identifier: " + this.lvd.logicalVolumeIdentifier.toString().replace("\u0000.*$", "").trim()));
                    break;
                }
                case 7: {
                    log.debug((Object)"Found unallocated space descriptor.");
                    this.un = new UnallocatedSpaceDescriptor(bytes);
                    break;
                }
                case 8: {
                    log.debug((Object)"Found terminating descriptor.");
                    TerminatingDescriptor t = new TerminatingDescriptor(bytes);
                    terminated = true;
                    this.tracePartition();
                    break;
                }
                case 9: {
                    log.debug((Object)"Found logical volume integrity descriptor.");
                    this.lvid = new LogicalVolumeIntegrityDescriptor(bytes);
                    break;
                }
                default: {
                    log.debug((Object)("Found unknown volume descriptor with type: " + type));
                    ++this.invalidCnt;
                    if (this.invalidCnt > 1000) {
                        terminated = true;
                        log.warn((Object)"Too many unknown descriptors - giving up!");
                    }
                    break;
                }
            }
        }
        catch (InvalidDescriptor ex) {
            throw new IOException(ex.getMessage());
        }
        return terminated;
    }

    private void tracePartition() throws IOException, InvalidDescriptor {
        DescriptorTag tag;
        byte[] buffer = new byte[2048];
        if (this.lvd.integritySequenceExtent.length > 0L) {
            this.fs.readBlock(this.lvd.integritySequenceExtent.location, buffer);
            this.lvid = new LogicalVolumeIntegrityDescriptor(buffer);
        }
        this.fsdLocation = this.pd.startingLocation;
        this.fs.readBlock(this.fsdLocation, buffer);
        int type = UDFUtil.getUInt16(buffer, 0);
        if (type == 261) {
            FileEntryDescriptor fed = new FileEntryDescriptor(buffer);
            if (fed.allocDescriptorLength > 0L) {
                int fidFsdLoc = fed.allocDescriptors.get((int)0).location.intValue();
                this.fsdLocation += (long)fidFsdLoc;
                this.fs.readBlock(this.fsdLocation, buffer);
                type = UDFUtil.getUInt16(buffer, 0);
            }
        }
        if (type != 256) {
            this.fsdLocation = this.pd.startingLocation + this.lvd.logicalVolumeContentsUse.location.blockNumber;
            this.fs.readBlock(this.fsdLocation, buffer);
            type = UDFUtil.getUInt16(buffer, 0);
        }
        if (type != 256) {
            this.fsdLocation = 257L;
            this.fs.readBlock(this.fsdLocation, buffer);
            type = UDFUtil.getUInt16(buffer, 0);
        }
        if (type != 256) {
            this.fsdLocation = this.pd.startingLocation + this.fs.getAnchor().mainVolumeExtent.location;
            this.fs.readBlock(this.fsdLocation, buffer);
            type = UDFUtil.getUInt16(buffer, 0);
        }
        if (type != 256) {
            ArrayList<Integer> blockIds = new ArrayList<Integer>(300);
            this.fsdLocation = 32L;
            while (type != 256 && this.fsdLocation < 300L) {
                this.fs.readBlock(++this.fsdLocation, buffer);
                type = UDFUtil.getUInt16(buffer, 0);
                blockIds.add(type);
            }
            log.debug((Object)("IDs of block 32-300: " + blockIds));
        }
        this.rootFSD = new FileSetDescriptor(buffer);
        log.debug((Object)("Found FSD at block " + this.fsdLocation));
        if (this.rootFSD.rootICB.length > 0L) {
            this.fs.readBlock(this.fsdLocation + this.rootFSD.rootICB.location.blockNumber, buffer);
            tag = new DescriptorTag(buffer);
            if (tag.identifier == 261) {
                this.rootEntry = new FileEntryDescriptor(buffer);
            } else if (tag.identifier == 266) {
                this.rootEntry = new ExtendedFileEntryDescriptor(buffer);
            }
        }
        if (this.rootFSD.sysStreamDirICB.length > 0L) {
            this.fs.readBlock(this.fsdLocation + this.rootFSD.rootICB.location.blockNumber, buffer);
            tag = new DescriptorTag(buffer);
            if (tag.identifier == 261) {
                this.rootEntry = new FileEntryDescriptor(buffer);
            } else if (tag.identifier == 266) {
                this.rootEntry = new ExtendedFileEntryDescriptor(buffer);
            }
        }
    }

    public FileEntry getRootEntry() {
        return new UDFFileEntry(this.fs, this.rootEntry, null, null, true);
    }

    public long getPDStartPos() {
        return this.pd.startingLocation;
    }

    public long getFSDloc() {
        return this.fsdLocation;
    }
}

