/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class FileIdentifierDescriptor
extends UDFDescriptor {
    public Integer version;
    public Integer characteristics;
    public Integer fileIdLength;
    public LongAD icb;
    public Integer implUseLength;
    public RegId implUse;
    public DString fileId;
    protected Integer consumption;
    public final int MINIMUM_LENGTH = 40;

    public FileIdentifierDescriptor() {
    }

    public FileIdentifierDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 257;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 40) {
            throw new InvalidDescriptor("File identifier descriptor too short");
        }
        this.deserializeTag(bytes);
        this.version = this.getUInt16(bytes);
        this.characteristics = this.getUInt8(bytes);
        this.fileIdLength = this.getUInt8(bytes);
        this.icb = new LongAD(this.getBytes(bytes, 16));
        this.implUseLength = this.getUInt16(bytes);
        if (this.implUseLength > 0) {
            this.implUse = new RegId(this.getBytes(bytes, this.implUseLength));
        }
        this.fileId = new DString(this.getBytes(bytes, this.fileIdLength));
        if (this.currentPos % 4 > 0) {
            int paddingLength = 4 - this.currentPos % 4;
            this.currentPos += paddingLength;
        }
        this.consumption = this.currentPos;
    }

    public Integer getConsumption() {
        return this.consumption;
    }
}

