/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.entities;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.connector.MovieToEmbyConnector;
import org.tinymediamanager.core.movie.connector.MovieToJellyfinConnector;
import org.tinymediamanager.core.movie.connector.MovieToKodiConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpLegacyConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpMovingPicturesConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpMyVideoConnector;
import org.tinymediamanager.core.movie.connector.MovieToXbmcConnector;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.movie.tasks.MovieActorImageFetcherTask;
import org.tinymediamanager.core.movie.tasks.MovieSetScrapeTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class Movie
extends MediaEntity
implements IMediaInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Movie.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new MovieMediaFileComparator();
    private static final Comparator<MediaTrailer> TRAILER_QUALITY_COMPARATOR = new MediaTrailer.QualityComparator();
    @JsonProperty
    private String englishTitle = "";
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private String tagline = "";
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    private boolean watched = false;
    @JsonProperty
    private int playcount = 0;
    @JsonProperty
    private Date lastWatched = null;
    @JsonProperty
    private boolean isDisc = false;
    @JsonProperty
    private String spokenLanguages = "";
    @JsonProperty
    private String country = "";
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date releaseDate = null;
    @JsonProperty
    private boolean multiMovieDir = false;
    @JsonProperty
    private int top250 = 0;
    @JsonProperty
    private MediaSource mediaSource = MediaSource.UNKNOWN;
    @JsonProperty
    private boolean videoIn3D = false;
    @JsonProperty
    private MediaCertification certification = MediaCertification.UNKNOWN;
    @JsonProperty
    private UUID movieSetId;
    @JsonProperty
    private MovieEdition edition = MovieEdition.NONE;
    @JsonProperty
    private boolean stacked = false;
    @JsonProperty
    private boolean offline = false;
    @JsonProperty
    private final List<MediaGenres> genres = new CopyOnWriteArrayList<MediaGenres>();
    @JsonProperty
    private final List<String> extraThumbs = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private final List<String> extraFanarts = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private final List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<Person> crew = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<MediaTrailer> trailer = new CopyOnWriteArrayList<MediaTrailer>();
    @JsonProperty
    private final List<String> showlinks = new CopyOnWriteArrayList<String>();
    private MovieSet movieSet;
    private String titleSortable = "";
    private String originalTitleSortable = "";
    private String localizedSpokenLanguages = "";

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        this.genres.removeIf(Objects::isNull);
        this.extraThumbs.removeIf(Objects::isNull);
        this.extraFanarts.removeIf(Objects::isNull);
        this.actors.removeIf(Objects::isNull);
        this.crew.removeIf(Objects::isNull);
        this.trailer.removeIf(Objects::isNull);
        this.showlinks.removeIf(Objects::isNull);
        if (this.movieSetId != null) {
            this.movieSet = MovieModuleManager.getInstance().getMovieList().lookupMovieSet(this.movieSetId);
        }
    }

    public void merge(Movie other) {
        this.merge(other, false);
    }

    public void forceMerge(Movie other) {
        this.merge(other, true);
    }

    void merge(Movie other, boolean force) {
        if (this.locked || other == null) {
            return;
        }
        super.merge(other, force);
        this.setEnglishTitle(StringUtils.isEmpty((CharSequence)this.englishTitle) || force ? other.englishTitle : this.englishTitle);
        this.setSortTitle(StringUtils.isEmpty((CharSequence)this.sortTitle) || force ? other.sortTitle : this.sortTitle);
        this.setTagline(StringUtils.isEmpty((CharSequence)this.tagline) || force ? other.tagline : this.tagline);
        this.setSpokenLanguages(StringUtils.isEmpty((CharSequence)this.spokenLanguages) || force ? other.spokenLanguages : this.spokenLanguages);
        this.setCountry(StringUtils.isEmpty((CharSequence)this.country) || force ? other.country : this.country);
        this.setWatched(!this.watched || force ? other.watched : this.watched);
        this.setPlaycount(this.playcount == 0 || force ? other.playcount : this.playcount);
        this.setLastWatched(this.lastWatched == null || force ? other.lastWatched : this.lastWatched);
        this.setRuntime(this.runtime == 0 || force ? other.runtime : this.runtime);
        this.setTop250(this.top250 == 0 || force ? other.top250 : this.top250);
        this.setReleaseDate(this.releaseDate == null || force ? other.releaseDate : this.releaseDate);
        this.setMovieSet(this.movieSet == null || force ? other.movieSet : this.movieSet);
        this.setMediaSource(this.mediaSource == MediaSource.UNKNOWN || force ? other.mediaSource : this.mediaSource);
        this.setCertification(this.certification == MediaCertification.UNKNOWN || force ? other.certification : this.certification);
        this.setEdition(this.edition == MovieEdition.NONE || force ? other.edition : this.edition);
        if (force) {
            this.genres.clear();
            this.actors.clear();
            this.crew.clear();
            this.trailer.clear();
            this.extraFanarts.clear();
            this.extraThumbs.clear();
        }
        this.setGenres(other.genres);
        this.setActors(other.actors);
        this.setCrew(other.crew);
        this.setShowlinks(other.showlinks);
        this.setExtraFanarts(other.extraFanarts);
        this.setExtraThumbs(other.extraThumbs);
        ArrayList<MediaTrailer> mergedTrailers = new ArrayList<MediaTrailer>(this.trailer);
        ListUtils.mergeLists(mergedTrailers, other.trailer);
        this.setTrailers(mergedTrailers);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void addToMediaFiles(MediaFile mediaFile) {
        super.addToMediaFiles(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    @Override
    protected float calculateScrapeScore() {
        float score = super.calculateScrapeScore();
        score += (float)Utils.returnOneWhenFilled(this.tagline);
        score += (float)Utils.returnOneWhenFilled(this.spokenLanguages);
        score += (float)Utils.returnOneWhenFilled(this.country);
        score += (float)Utils.returnOneWhenFilled(this.top250);
        score += (float)Utils.returnOneWhenFilled(this.runtime);
        score += (float)Utils.returnOneWhenFilled(this.releaseDate);
        if (this.certification != MediaCertification.UNKNOWN) {
            score += 1.0f;
        }
        score += (float)Utils.returnOneWhenFilled(this.actors);
        score += (float)Utils.returnOneWhenFilled(this.crew);
        return score += (float)Utils.returnOneWhenFilled(this.trailer);
    }

    public String getEnglishTitle() {
        return this.englishTitle;
    }

    public void setEnglishTitle(String newValue) {
        String oldValue = this.englishTitle;
        this.englishTitle = newValue;
        this.firePropertyChange("englishTitle", oldValue, newValue);
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = StrgUtils.strip(newValue);
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    public String getTitleSortable() {
        if (StringUtils.isBlank((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public String getOriginalTitleSortable() {
        if (StringUtils.isBlank((CharSequence)this.originalTitleSortable)) {
            this.originalTitleSortable = Utils.getSortableName(this.getOriginalTitle());
        }
        return this.originalTitleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
        this.originalTitleSortable = "";
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> mf = this.getMediaFiles(MediaFileType.NFO);
        return mf != null && !mf.isEmpty();
    }

    @Deprecated
    public Boolean getHasMetadata() {
        return !this.plot.isEmpty() && this.year != 0;
    }

    @Deprecated
    public Boolean getHasImages() {
        for (MediaArtwork.MediaArtworkType type : Arrays.asList(MediaArtwork.MediaArtworkType.POSTER, MediaArtwork.MediaArtworkType.BACKGROUND)) {
            if (!StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.getMediaFileType(type)))) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasTrailer() {
        return !this.getMediaFiles(MediaFileType.TRAILER).isEmpty();
    }

    public Boolean getHasNote() {
        return StringUtils.isNotBlank((CharSequence)this.note);
    }

    public String getTitleForUi() {
        Object titleForUi = this.title;
        if (this.year > 0) {
            titleForUi = (String)titleForUi + " (" + this.year + ")";
        }
        return titleForUi;
    }

    public List<MediaTrailer> getTrailer() {
        return this.trailer;
    }

    public void addToTrailer(Collection<MediaTrailer> newTrailers) {
        LinkedHashSet<MediaTrailer> newItems = new LinkedHashSet<MediaTrailer>();
        for (MediaTrailer trailer : ListUtils.nullSafe(newTrailers)) {
            if (trailer == null || this.trailer.contains(trailer)) continue;
            newItems.add(trailer);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.trailer.addAll(newItems);
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void removeAllTrailers() {
        this.trailer.clear();
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public List<String> getShowlinks() {
        return this.showlinks;
    }

    public void setShowlinks(List<String> newShowlinks) {
        ListUtils.mergeLists(this.showlinks, newShowlinks);
        Utils.removeEmptyStringsFromList(this.showlinks);
        this.firePropertyChange("showlinks", null, this.showlinks);
        this.firePropertyChange("showlinksAsString", null, this.showlinks);
    }

    public void addShowlinks(Collection<String> newShowlinks) {
        LinkedHashSet<String> newItems = new LinkedHashSet<String>(1);
        for (String showlink : ListUtils.nullSafe(newShowlinks)) {
            if (StringUtils.isBlank((CharSequence)showlink) || this.showlinks.contains(showlink)) continue;
            newItems.add(showlink);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.showlinks.addAll(newItems);
        this.firePropertyChange("newShowlinks", null, newShowlinks);
        this.firePropertyChange("showlinksAsString", null, newShowlinks);
    }

    public void removeShowlink(String showlink) {
        if (this.showlinks.remove(showlink)) {
            this.firePropertyChange("showlinks", null, this.showlinks);
            this.firePropertyChange("showlinksAsString", null, this.showlinks);
        }
    }

    public void removeAllShowlinks() {
        this.showlinks.clear();
        this.firePropertyChange("showlinks", null, this.showlinks);
        this.firePropertyChange("showlinksAsString", null, this.showlinks);
    }

    public String getShowlinksAsString() {
        return String.join((CharSequence)", ", this.showlinks);
    }

    public boolean getHasSubtitles() {
        if (!this.getMediaFiles(MediaFileType.SUBTITLE).isEmpty()) {
            return true;
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO)) {
            if (!mf.hasSubtitles()) continue;
            return true;
        }
        return false;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public int getTmdbId() {
        return this.getIdAsInt("tmdb");
    }

    public void setTmdbId(int newValue) {
        this.setId("tmdb", newValue);
    }

    public int getTraktId() {
        return this.getIdAsInt("trakt");
    }

    public void setTraktId(int newValue) {
        this.setId("trakt", newValue);
    }

    public int getRuntime() {
        int runtimeFromMi = 0;
        if (MovieModuleManager.getInstance().getSettings().isRuntimeFromMediaInfo() && (runtimeFromMi = this.getRuntimeFromMediaFilesInMinutes()) > 0) {
            return runtimeFromMi;
        }
        return this.runtime == 0 ? runtimeFromMi : this.runtime;
    }

    public String getTagline() {
        return this.tagline;
    }

    public boolean hasFile(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return false;
        }
        for (MediaFile file : new ArrayList<MediaFile>(this.getMediaFiles())) {
            if (filename.compareTo(file.getFilename()) != 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getExtraThumbs() {
        return this.extraThumbs;
    }

    @JsonSetter
    public void setExtraThumbs(List<String> extraThumbs) {
        this.extraThumbs.clear();
        this.extraThumbs.addAll(extraThumbs);
        this.firePropertyChange("extraThumbs", null, this.extraThumbs);
    }

    public List<String> getExtraFanarts() {
        return this.extraFanarts;
    }

    @JsonSetter
    public void setExtraFanarts(List<String> extraFanarts) {
        this.extraFanarts.clear();
        this.extraFanarts.addAll(extraFanarts);
        this.firePropertyChange("extraFanarts", null, this.extraFanarts);
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public void setMetadata(MediaMetadata metadata, List<MovieScraperMetadataConfig> config, boolean overwriteExistingItems) {
        if (this.locked) {
            LOGGER.debug("movie locked, but setMetadata has been called!");
            return;
        }
        if (metadata == null || metadata.getIds().isEmpty()) {
            LOGGER.warn("Wanted to save empty metadata for movie '{}'", (Object)this.getTitle());
            return;
        }
        MovieSettings settings = MovieModuleManager.getInstance().getSettings();
        boolean matchFound = false;
        for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(this.getId(entry.getKey()))) continue;
            matchFound = true;
            break;
        }
        boolean newEntity = false;
        if (this.ids.isEmpty()) {
            matchFound = true;
            newEntity = true;
        }
        if (!matchFound && overwriteExistingItems) {
            this.ids.clear();
        }
        if (overwriteExistingItems) {
            this.setIds(metadata.getIds());
        } else {
            for (Map.Entry entry : metadata.getIds().entrySet()) {
                if (this.ids.containsKey(entry.getKey())) continue;
                this.setId((String)entry.getKey(), entry.getValue());
            }
        }
        if (config.contains(MovieScraperMetadataConfig.TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getTitle()) && (overwriteExistingItems || newEntity || StringUtils.isBlank((CharSequence)this.getTitle()))) {
            if (settings.getCapitalWordsInTitles()) {
                this.setTitle(StrgUtils.capitalize(metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(MovieScraperMetadataConfig.ORIGINAL_TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getOriginalTitle()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getOriginalTitle()))) {
            if (settings.getCapitalWordsInTitles()) {
                this.setOriginalTitle(StrgUtils.capitalize(metadata.getOriginalTitle()));
            } else {
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.contains(MovieScraperMetadataConfig.ENGLISH_TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getEnglishTitle()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getEnglishTitle()))) {
            if (settings.getCapitalWordsInTitles()) {
                this.setEnglishTitle(StrgUtils.capitalize(metadata.getEnglishTitle()));
            } else {
                this.setEnglishTitle(metadata.getEnglishTitle());
            }
        }
        if (config.contains(MovieScraperMetadataConfig.TAGLINE) && StringUtils.isNotBlank((CharSequence)metadata.getTagline()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getTagline()))) {
            this.setTagline(metadata.getTagline());
        }
        if (config.contains(MovieScraperMetadataConfig.PLOT) && StringUtils.isNotBlank((CharSequence)metadata.getPlot()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getPlot()))) {
            this.setPlot(metadata.getPlot());
        }
        if (config.contains(MovieScraperMetadataConfig.YEAR) && metadata.getYear() > 0 && (overwriteExistingItems || this.getYear() <= 0)) {
            this.setYear(metadata.getYear());
        }
        if (config.contains(MovieScraperMetadataConfig.RELEASE_DATE) && metadata.getReleaseDate() != null && (overwriteExistingItems || this.getReleaseDate() == null)) {
            this.setReleaseDate(metadata.getReleaseDate());
        }
        if (config.contains(MovieScraperMetadataConfig.RATING)) {
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            if (matchFound || !overwriteExistingItems) {
                newRatings.putAll(this.getRatings());
            }
            for (MediaRating mediaRating : metadata.getRatings()) {
                if (overwriteExistingItems) {
                    newRatings.put(mediaRating.getId(), mediaRating);
                    continue;
                }
                newRatings.putIfAbsent(mediaRating.getId(), mediaRating);
            }
            this.setRatings(newRatings);
        }
        if (config.contains(MovieScraperMetadataConfig.TOP250) && metadata.getTop250() > 0 && (overwriteExistingItems || this.getTop250() <= 0)) {
            this.setTop250(metadata.getTop250());
        }
        if (config.contains(MovieScraperMetadataConfig.RUNTIME) && metadata.getRuntime() > 0 && (overwriteExistingItems || this.getRuntime() <= 0)) {
            this.setRuntime(metadata.getRuntime());
        }
        if (config.contains(MovieScraperMetadataConfig.SPOKEN_LANGUAGES) && !metadata.getSpokenLanguages().isEmpty() && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getSpokenLanguages()))) {
            this.setSpokenLanguages(StringUtils.join(metadata.getSpokenLanguages(), (String)", "));
        }
        if (config.contains(MovieScraperMetadataConfig.COUNTRY) && !metadata.getCountries().isEmpty() && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getCountry()))) {
            this.setCountry(StringUtils.join(metadata.getCountries(), (String)", "));
        }
        if (config.contains(MovieScraperMetadataConfig.CERTIFICATION) && (overwriteExistingItems || this.getCertification() == null || this.getCertification() == MediaCertification.UNKNOWN) && !metadata.getCertifications().isEmpty()) {
            if (metadata.getCertifications().size() > 1) {
                MediaCertification mpaa = null;
                for (MediaCertification cert : metadata.getCertifications()) {
                    if (cert.name().startsWith("US_TV")) continue;
                    mpaa = cert;
                    break;
                }
                if (mpaa != null) {
                    this.setCertification(mpaa);
                } else {
                    this.setCertification(metadata.getCertifications().get(0));
                }
            } else {
                this.setCertification(metadata.getCertifications().get(0));
            }
        }
        if (config.contains(MovieScraperMetadataConfig.PRODUCTION_COMPANY) && !metadata.getProductionCompanies().isEmpty() && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getProductionCompany()))) {
            this.setProductionCompany(StringUtils.join(metadata.getProductionCompanies(), (String)", "));
        }
        if (config.contains(MovieScraperMetadataConfig.ACTORS)) {
            if (!matchFound || overwriteExistingItems) {
                this.actors.clear();
            }
            this.setActors(metadata.getCastMembers(Person.Type.ACTOR));
        }
        if (config.contains(MovieScraperMetadataConfig.CREW)) {
            if (!matchFound || overwriteExistingItems) {
                this.crew.clear();
            }
            this.setCrew(metadata.getCastMembers(Person.Type.DIRECTOR));
            this.setCrew(metadata.getCastMembers(Person.Type.WRITER));
            this.setCrew(metadata.getCastMembers(Person.Type.PRODUCER));
            this.setCrew(metadata.getCastMembers(Person.Type.OTHER));
        }
        if (config.contains(MovieScraperMetadataConfig.GENRES)) {
            if (!matchFound || overwriteExistingItems) {
                this.genres.clear();
            }
            this.setGenres(metadata.getGenres());
        }
        if (config.contains(MovieScraperMetadataConfig.TAGS)) {
            if (!matchFound || overwriteExistingItems) {
                this.removeAllTags();
            }
            this.addToTags(metadata.getTags());
        }
        if (config.contains(MovieScraperMetadataConfig.COLLECTION) && (overwriteExistingItems || this.getMovieSet() == null)) {
            int col = 0;
            try {
                col = (Integer)metadata.getId("tmdbSet");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (col != 0) {
                boolean bl;
                boolean bl2 = false;
                MovieSet movieSet = MovieModuleManager.getInstance().getMovieList().findMovieSet(metadata.getCollectionName(), col);
                if (movieSet == null && StringUtils.isNotBlank((CharSequence)metadata.getCollectionName())) {
                    movieSet = new MovieSet(metadata.getCollectionName());
                    movieSet.setTmdbId(col);
                    movieSet.saveToDb();
                    MovieModuleManager.getInstance().getMovieList().addMovieSet(movieSet);
                    bl = true;
                }
                if (movieSet != null) {
                    List<MediaScraper> movieSetMediaScrapers;
                    this.setMovieSet(null);
                    this.setMovieSet(movieSet);
                    movieSet.insertMovie(this);
                    movieSet.saveToDb();
                    if (bl && !(movieSetMediaScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET)).isEmpty()) {
                        MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions();
                        options.setTmdbId(col);
                        if (metadata.getScrapeOptions() != null) {
                            options.setLanguage(metadata.getScrapeOptions().getLanguage());
                        } else {
                            options.setLanguage(MovieModuleManager.getInstance().getSettings().getScraperLanguage());
                        }
                        options.setMetadataScraper(movieSetMediaScrapers.get(0));
                        options.setArtworkScraper(MovieModuleManager.getInstance().getMovieList().getDefaultArtworkScrapers());
                        MovieSetScrapeTask task = new MovieSetScrapeTask(Collections.singletonList(movieSet), options, Arrays.asList(MovieSetScraperMetadataConfig.values()));
                        TmmTaskManager.getInstance().addUnnamedTask(task);
                    }
                }
            }
        }
        this.writeNFO();
        this.saveToDb();
    }

    @JsonSetter
    public void setTrailers(List<MediaTrailer> trailers) {
        MediaTrailer preferredTrailer = null;
        this.removeAllTrailers();
        ArrayList<MediaTrailer> newItems = new ArrayList<MediaTrailer>();
        if (MovieModuleManager.getInstance().getSettings().isUseTrailerPreference()) {
            TrailerQuality desiredQuality = MovieModuleManager.getInstance().getSettings().getTrailerQuality();
            TrailerSources desiredSource = TrailerSources.YOUTUBE;
            for (MediaTrailer trailer : trailers) {
                if (!desiredQuality.containsQuality(trailer.getQuality()) || !desiredSource.containsSource(trailer.getProvider())) continue;
                trailer.setInNfo(Boolean.TRUE);
                preferredTrailer = trailer;
                break;
            }
            if (preferredTrailer == null) {
                for (MediaTrailer trailer : trailers) {
                    if (!desiredQuality.containsQuality(trailer.getQuality())) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
            if (preferredTrailer == null) {
                ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
                sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
                for (MediaTrailer trailer : sortedTrailers) {
                    if (desiredQuality.ordinal() < TrailerQuality.getTrailerQuality(trailer.getQuality()).ordinal()) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
        }
        if (preferredTrailer == null && !trailers.isEmpty()) {
            ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
            sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
            preferredTrailer = (MediaTrailer)sortedTrailers.get(0);
            preferredTrailer.setInNfo(Boolean.TRUE);
        }
        if (preferredTrailer != null) {
            newItems.add(preferredTrailer);
        }
        for (MediaTrailer trailer : trailers) {
            if (preferredTrailer != null && preferredTrailer == trailer) continue;
            if (preferredTrailer == null && this.trailer.isEmpty() && trailer.getUrl().startsWith("http")) {
                trailer.setInNfo(Boolean.TRUE);
            }
            newItems.add(trailer);
        }
        this.addToTrailer(newItems);
        this.mixinLocalTrailers();
    }

    public void setArtwork(MediaMetadata md, List<MovieScraperMetadataConfig> config, boolean overwrite) {
        this.setArtwork(md.getMediaArt(MediaArtwork.MediaArtworkType.ALL), config, overwrite);
    }

    public void setArtwork(List<MediaArtwork> artwork, List<MovieScraperMetadataConfig> config, boolean overwrite) {
        MovieArtworkHelper.setArtwork(this, artwork, config, overwrite);
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    @Override
    public void setOriginalTitle(String newValue) {
        String oldValue = this.originalTitle;
        super.setOriginalTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.originalTitleSortable;
        this.originalTitleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.originalTitleSortable);
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void setTagline(String newValue) {
        String oldValue = this.tagline;
        this.tagline = StrgUtils.strip(newValue);
        this.firePropertyChange("tagline", oldValue, newValue);
    }

    @Override
    public void setYear(int newValue) {
        int oldValue = this.year;
        super.setYear(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
    }

    public String getNfoFilename(MovieNfoNaming nfo) {
        String filename = "";
        MediaFile mainFile = this.getMainFile();
        if (mainFile != null) {
            filename = mainFile.getFilename();
        }
        if (this.isStacked()) {
            filename = Utils.cleanStackingMarkers(filename);
        }
        filename = this.getNfoFilename(nfo, filename);
        return filename;
    }

    public String getNfoFilename(MovieNfoNaming nfo, String newMovieFilename) {
        Object filename;
        switch (nfo) {
            case FILENAME_NFO: {
                filename = this.isDisc() ? (MovieModuleManager.getInstance().getSettings().isNfoDiscFolderInside() ? FilenameUtils.removeExtension((String)this.findDiscMainFile()) : "movie") : FilenameUtils.removeExtension((String)newMovieFilename);
                if (((String)filename).isEmpty()) break;
                filename = (String)filename + ".nfo";
                break;
            }
            case MOVIE_NFO: {
                filename = "movie.nfo";
                break;
            }
            default: {
                filename = "";
            }
        }
        LOGGER.trace("getNfoFilename: '{}' / '{}' -> '{}'", new Object[]{newMovieFilename, nfo, filename});
        return filename;
    }

    public String getTrailerFilename(MovieTrailerNaming trailer) {
        String filename = "";
        if (this.isDisc) {
            filename = this.findDiscMainFile();
        } else {
            MediaFile mainFile = this.getMainFile();
            if (mainFile != null) {
                filename = mainFile.getFilename();
            }
        }
        if (this.isStacked()) {
            filename = Utils.cleanStackingMarkers(filename);
        }
        filename = this.getTrailerFilename(trailer, filename);
        LOGGER.trace("getTrailerFilename: {} -> '{}'", (Object)trailer, (Object)filename);
        return filename;
    }

    public String getTrailerFilename(MovieTrailerNaming trailer, String newMovieFilename) {
        String filename = trailer.getFilename(FilenameUtils.getBaseName((String)newMovieFilename), FilenameUtils.getExtension((String)newMovieFilename));
        filename = FilenameUtils.removeExtension((String)filename);
        LOGGER.trace("getTrailerFilename: '{}' / {} -> '{}'", new Object[]{newMovieFilename, trailer, filename});
        return filename;
    }

    public void downloadArtwork(MediaFileType type) {
        MovieArtworkHelper.downloadArtwork(this, type);
    }

    public void writeActorImages(boolean overwriteExistingItems) {
        MovieActorImageFetcherTask task = new MovieActorImageFetcherTask(this);
        task.setOverwriteExistingItems(overwriteExistingItems);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public void writeNFO() {
        if (MovieModuleManager.getInstance().getSettings().getNfoFilenames().isEmpty()) {
            LOGGER.debug("Not writing any NFO file, because NFO filename preferences were empty...");
            return;
        }
        MovieGenericXmlConnector connector = switch (MovieModuleManager.getInstance().getSettings().getMovieConnector()) {
            case MovieConnectors.MP -> new MovieToMpLegacyConnector(this);
            case MovieConnectors.MP_MP -> new MovieToMpMovingPicturesConnector(this);
            case MovieConnectors.MP_MV -> new MovieToMpMyVideoConnector(this);
            case MovieConnectors.XBMC -> new MovieToXbmcConnector(this);
            case MovieConnectors.EMBY -> new MovieToEmbyConnector(this);
            case MovieConnectors.JELLYFIN -> new MovieToJellyfinConnector(this);
            default -> new MovieToKodiConnector(this);
        };
        ArrayList<MovieNfoNaming> nfonames = new ArrayList<MovieNfoNaming>();
        if (this.isMultiMovieDir() || this.isDisc) {
            nfonames.add(MovieNfoNaming.FILENAME_NFO);
        } else {
            nfonames = MovieModuleManager.getInstance().getSettings().getNfoFilenames();
        }
        connector.write(nfonames);
        this.firePropertyChange("hasNfoFile", false, true);
    }

    public List<MediaGenres> getGenres() {
        return this.genres;
    }

    public void addToGenres(Collection<MediaGenres> newGenres) {
        LinkedHashSet<MediaGenres> newItems = new LinkedHashSet<MediaGenres>();
        for (MediaGenres genre : ListUtils.nullSafe(newGenres)) {
            if (genre == null || this.genres.contains(genre)) continue;
            newItems.add(genre);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.genres.addAll(newItems);
        this.firePropertyChange("genre", null, newGenres);
        this.firePropertyChange("genresAsString", null, newGenres);
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> newGenres) {
        ListUtils.mergeLists(this.genres, newGenres);
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genres.contains(genre)) {
            this.genres.remove(genre);
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public void removeAllGenres() {
        this.genres.clear();
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    @Override
    public MediaCertification getCertification() {
        return this.certification;
    }

    public void setCertification(MediaCertification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, (Object)newValue);
    }

    @Override
    public MediaRating getRating() {
        MediaRating mediaRating = null;
        for (String ratingSource : MovieModuleManager.getInstance().getSettings().getRatingSources()) {
            if (!StringUtils.isBlank((CharSequence)ratingSource) && (mediaRating = (MediaRating)this.ratings.get(ratingSource)) != null) break;
        }
        if (mediaRating == null) {
            mediaRating = MediaMetadata.EMPTY_RATING;
        }
        return mediaRating;
    }

    public boolean getHasRating() {
        return !this.ratings.isEmpty();
    }

    @Override
    public MediaRating getUserRating() {
        MediaRating mediaRating = (MediaRating)this.ratings.get("user");
        if (mediaRating == null) {
            mediaRating = MediaMetadata.EMPTY_RATING;
        }
        return mediaRating;
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genres) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void setWatched(boolean newValue) {
        boolean oldValue = this.watched;
        this.watched = newValue;
        this.firePropertyChange("watched", oldValue, newValue);
    }

    public int getPlaycount() {
        return this.playcount;
    }

    public void setPlaycount(int newValue) {
        int oldValue = this.playcount;
        this.playcount = newValue;
        this.firePropertyChange("playcount", oldValue, newValue);
    }

    public boolean isMultiMovieDir() {
        return this.multiMovieDir;
    }

    public void setMultiMovieDir(boolean multiDir) {
        this.multiMovieDir = multiDir;
    }

    public boolean hasMultiMovieNaming() {
        if (this.isDisc()) {
            return false;
        }
        MediaFile vid = this.getMainFile();
        String name = FilenameUtils.getBaseName((String)vid.getFilenameWithoutStacking());
        if (name.isEmpty()) {
            return false;
        }
        for (MediaFile mf : this.getMediaFiles()) {
            if (mf.getFilename().startsWith(name) && !mf.isDiscFile()) continue;
            return false;
        }
        return true;
    }

    public MovieSet getMovieSet() {
        return this.movieSet;
    }

    public void setMovieSet(MovieSet newValue) {
        MovieSet oldValue = this.movieSet;
        this.movieSet = newValue;
        this.movieSetId = newValue == null ? null : newValue.getDbId();
        this.firePropertyChange("movieset", oldValue, newValue);
        this.firePropertyChange("movieSetTitle", oldValue, newValue);
    }

    public void movieSetTitleChanged() {
        this.firePropertyChange("movieSetTitle", null, "");
    }

    public String getMovieSetTitle() {
        if (this.movieSet != null) {
            return this.movieSet.getTitle();
        }
        return "";
    }

    public void removeFromMovieSet() {
        if (this.movieSet != null) {
            this.movieSet.removeMovie(this, true);
        }
        this.setMovieSet(null);
    }

    public boolean isDisc() {
        return this.isDisc;
    }

    public void setDisc(boolean isDisc) {
        this.isDisc = isDisc;
    }

    public String findDiscMainFile() {
        MediaFile mainVideoFile = this.getMainVideoFile();
        Object filename = "";
        if (mainVideoFile.isBlurayFile()) {
            filename = "index.bdmv";
        }
        if (mainVideoFile.isDVDFile()) {
            filename = "VIDEO_TS.ifo";
        }
        if (mainVideoFile.isHDDVDFile()) {
            filename = "HVDVD_TS.ifo";
        }
        if (StringUtils.isNotBlank((CharSequence)filename) && mainVideoFile.getFile().toFile().isDirectory()) {
            filename = mainVideoFile.getFilename() + File.separator + (String)filename;
        }
        return filename;
    }

    public int getMediaInfoVideoBitrate() {
        return this.getMainVideoFile().getVideoBitRate();
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return this.getMainVideoFile().getBitDepth();
    }

    public String getMediaInfoAudioCodecAndChannels() {
        MediaFile mf = this.getMainVideoFile();
        if (!mf.getAudioCodec().isEmpty()) {
            return mf.getAudioCodec() + "_" + mf.getAudioChannels();
        }
        return "";
    }

    public void setSpokenLanguages(String newValue) {
        String oldValue = this.spokenLanguages;
        this.spokenLanguages = StrgUtils.strip(newValue);
        this.firePropertyChange("spokenLanguages", oldValue, newValue);
        this.localizedSpokenLanguages = "";
        this.firePropertyChange("localizedSpokenLanguages", oldValue, newValue);
    }

    public String getSpokenLanguages() {
        return this.spokenLanguages;
    }

    public String getLocalizedSpokenLanguages() {
        if (StringUtils.isBlank((CharSequence)this.localizedSpokenLanguages)) {
            ArrayList<String> translatedLanguages = new ArrayList<String>();
            for (String langu : ParserUtils.split(this.getSpokenLanguages())) {
                String translated = LanguageUtils.getLocalizedLanguageNameFromLocalizedString(Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage()), langu.strip());
                translatedLanguages.add(translated);
            }
            this.localizedSpokenLanguages = String.join((CharSequence)", ", translatedLanguages);
        }
        return this.localizedSpokenLanguages;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String newValue) {
        String oldValue = this.country;
        this.country = StrgUtils.strip(newValue);
        this.firePropertyChange("country", oldValue, newValue);
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(MediaSource newValue) {
        MediaSource oldValue = this.mediaSource;
        this.mediaSource = newValue;
        this.firePropertyChange("mediaSource", oldValue, newValue);
    }

    @Override
    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf);
        }
        if (MovieModuleManager.getInstance().getSettings().isWriteActorImages() && !this.isMultiMovieDir()) {
            for (MediaFile mf : this.listActorFiles()) {
                if (!mf.isGraphic()) continue;
                filesToCache.add(mf);
            }
        }
        return filesToCache;
    }

    protected List<MediaFile> listActorFiles() {
        if (this.getPathNIO() == null || !Files.exists(this.getPathNIO().resolve(".actors"), new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<MediaFile> fileNames = new ArrayList<MediaFile>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getPathNIO().resolve(".actors"));){
            for (Path path : directoryStream) {
                MediaFile mf;
                if (!Utils.isRegularFile(path) || !(mf = new MediaFile(path)).isGraphic()) continue;
                fileNames.add(mf);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Cannot get actors: {}", (Object)this.getPathNIO().resolve(".actors"));
        }
        return fileNames;
    }

    public List<MediaFile> getMediaFilesContainingAudioStreams() {
        ArrayList<MediaFile> mediaFilesWithAudioStreams = new ArrayList<MediaFile>(1);
        List<MediaFile> videoFiles = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videoFiles.isEmpty()) {
            MediaFile videoFile = videoFiles.get(0);
            mediaFilesWithAudioStreams.add(videoFile);
        }
        mediaFilesWithAudioStreams.addAll(this.getMediaFiles(MediaFileType.AUDIO));
        return mediaFilesWithAudioStreams;
    }

    public List<MediaFile> getMediaFilesContainingSubtitles() {
        ArrayList<MediaFile> mediaFilesWithSubtitles = new ArrayList<MediaFile>(1);
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
            if (!mediaFile.hasSubtitles()) continue;
            mediaFilesWithSubtitles.add(mediaFile);
        }
        return mediaFilesWithSubtitles;
    }

    @Deprecated
    private int getRuntimeFromDvdFiles() {
        int rtifo = 0;
        MediaFile ifo = null;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.getFilename().toLowerCase(Locale.ROOT).endsWith("ifo") || mf.getDuration() <= rtifo) continue;
            rtifo = mf.getDuration();
            ifo = mf;
        }
        if (ifo != null) {
            LOGGER.trace("Found longest IFO:{} duration:{}", (Object)ifo.getFilename(), (Object)this.runtime);
            String prefix = StrgUtils.substr(ifo.getFilename(), "(?i)^(VTS_\\d+).*");
            if (prefix.isEmpty()) {
                prefix = StrgUtils.substr(ifo.getFilename(), "(?i)^(HV\\d+)I.*");
            }
            if (!prefix.isEmpty()) {
                int rtvob = 0;
                for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
                    if (!mf.getFilename().startsWith(prefix) || ifo.getFilename().equals(mf.getFilename())) continue;
                    LOGGER.trace("VOB:{} duration:{} accumulated:{}", new Object[]{mf.getFilename(), mf.getDuration(), rtvob += mf.getDuration()});
                }
                if (rtvob > rtifo) {
                    rtifo = rtvob;
                }
            } else {
                LOGGER.trace("TODO: bluray");
            }
        }
        return rtifo;
    }

    @Deprecated
    public int getRuntimeFromMediaFiles() {
        return this.getRuntimeFromMediaFilesInSeconds();
    }

    public int getRuntimeFromMediaFilesInSeconds() {
        int runtime = 0;
        if (this.isDisc) {
            runtime = this.runtime * 60;
        }
        if (runtime < 10) {
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
                if (mf.isMainDiscIdentifierFile() || mf.getFilename().toLowerCase(Locale.ROOT).endsWith("ifo")) continue;
                runtime += mf.getDuration();
            }
        }
        return runtime;
    }

    public int getRuntimeFromMediaFilesInMinutes() {
        return this.getRuntimeFromMediaFilesInSeconds() / 60;
    }

    @Override
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    @JsonIgnore
    public void setReleaseDate(Date newValue) {
        Date oldValue = this.releaseDate;
        this.releaseDate = newValue;
        this.firePropertyChange("releaseDate", oldValue, newValue);
        this.firePropertyChange("releaseDateAsString", oldValue, newValue);
    }

    public String getReleaseDateFormatted() {
        if (this.releaseDate == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.releaseDate);
    }

    public String getReleaseDateAsString() {
        if (this.releaseDate == null) {
            return "";
        }
        return TmmDateFormat.MEDIUM_DATE_FORMAT.format(this.releaseDate);
    }

    public void setReleaseDate(String dateAsString) {
        try {
            this.setReleaseDate(DateUtils.parseDate(dateAsString));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    @Override
    public void saveToDb() {
        MovieModuleManager.getInstance().getMovieList().persistMovie(this);
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
        if (MovieModuleManager.getInstance().getSettings().getMovieConnector() == MovieConnectors.MP) {
            this.writeNFO();
        }
    }

    public List<MediaFile> getVideoFiles() {
        return this.getMediaFiles(MediaFileType.VIDEO);
    }

    public String getVideoBasenameWithoutStacking() {
        MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
        return FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
    }

    public int getTop250() {
        return this.top250;
    }

    public void setVideoIn3D(boolean newValue) {
        boolean oldValue = this.videoIn3D;
        this.videoIn3D = newValue;
        this.firePropertyChange("videoIn3D", oldValue, newValue);
    }

    @Override
    public boolean isVideoIn3D() {
        return this.videoIn3D || StringUtils.isNotBlank((CharSequence)this.getMainVideoFile().getVideo3DFormat());
    }

    public void setTop250(int newValue) {
        int oldValue = this.top250;
        this.top250 = newValue;
        this.firePropertyChange("top250", oldValue, newValue);
    }

    public void addToActors(Collection<Person> newActors) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newActors)) {
            if (person == null || this.actors.contains(person)) continue;
            if (person.getType() != Person.Type.ACTOR && person.getType() != Person.Type.GUEST) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.actors.addAll(newItems);
        this.firePropertyChange("actors", null, this.getActors());
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    public void removeActors() {
        this.actors.clear();
        this.firePropertyChange("actors", null, this.getActors());
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        this.mergePersons(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    public List<Person> getActors() {
        return this.actors;
    }

    public String getActorsAsString() {
        ArrayList<String> actorNames = new ArrayList<String>();
        for (Person actor : this.actors) {
            actorNames.add(actor.getName());
        }
        return StringUtils.join(actorNames, (String)", ");
    }

    public void addToCrew(Collection<Person> newCrew) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newCrew)) {
            if (person == null || this.crew.contains(person)) continue;
            if (person.getType() == Person.Type.ACTOR) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.crew.addAll(newItems);
        this.firePropertyChange("crew", null, this.getCrew());
        this.firePropertyChange("producersAsString", null, this.getProducersAsString());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public void removeCrew() {
        this.crew.clear();
        this.firePropertyChange("crew", null, this.getCrew());
        this.firePropertyChange("producersAsString", null, this.getProducersAsString());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    @JsonSetter
    public void setCrew(List<Person> newCrew) {
        this.mergePersons(this.crew, newCrew);
        this.firePropertyChange("crew", null, this.getCrew());
        this.firePropertyChange("producersAsString", null, this.getProducersAsString());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public List<Person> getCrew() {
        return this.crew;
    }

    public List<Person> getProducers() {
        return this.crew.stream().filter(person -> person.getType() == Person.Type.PRODUCER).toList();
    }

    public String getProducersAsString() {
        ArrayList<String> producerNames = new ArrayList<String>();
        for (Person producer : this.getProducers()) {
            producerNames.add(producer.getName());
        }
        return StringUtils.join(producerNames, (String)", ");
    }

    public List<Person> getDirectors() {
        return this.crew.stream().filter(person -> person.getType() == Person.Type.DIRECTOR).toList();
    }

    public String getDirectorsAsString() {
        ArrayList<String> directorNames = new ArrayList<String>();
        for (Person director : this.getDirectors()) {
            directorNames.add(director.getName());
        }
        return StringUtils.join(directorNames, (String)", ");
    }

    public List<Person> getWriters() {
        return this.crew.stream().filter(person -> person.getType() == Person.Type.WRITER).toList();
    }

    public String getWritersAsString() {
        ArrayList<String> writerNames = new ArrayList<String>();
        for (Person writer : this.getWriters()) {
            writerNames.add(writer.getName());
        }
        return StringUtils.join(writerNames, (String)", ");
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public void reEvaluateDiscfolder() {
        boolean disc = false;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.isDiscFile()) continue;
            disc = true;
        }
        this.setDisc(disc);
    }

    public void reEvaluateStacking() {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs.size() > 1 && !this.isDisc()) {
            boolean stacked = false;
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE, MediaFileType.MEDIAINFO, MediaFileType.VSMETA, MediaFileType.DOUBLE_EXT)) {
                mf.detectStackingInformation();
                if (mf.getStacking() <= 0) continue;
                stacked = true;
            }
            this.setStacked(stacked);
        } else {
            this.setStacked(false);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE, MediaFileType.MEDIAINFO, MediaFileType.VSMETA, MediaFileType.DOUBLE_EXT)) {
                mf.removeStackingInformation();
            }
        }
    }

    public boolean deleteFilesSafely() {
        if (this.isMultiMovieDir()) {
            boolean ok = true;
            for (MediaFile mf : this.getMediaFiles()) {
                if (mf.deleteSafely(this.getDataSource())) continue;
                ok = false;
            }
            try {
                Utils.deleteEmptyDirectoryRecursive(this.getPathNIO());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ok;
        }
        return Utils.deleteDirectorySafely(this.getPathNIO(), this.getDataSource());
    }

    @Override
    public MediaFile getMainVideoFile() {
        MediaFile vid = null;
        if (this.stacked) {
            vid = this.getMediaFiles(MediaFileType.VIDEO).stream().min(Comparator.comparingInt(MediaFile::getStacking)).orElse(MediaFile.EMPTY_MEDIAFILE);
        } else if (this.isDisc()) {
            vid = this.getMainDVDVideoFile();
        }
        if (vid == null || vid.getFilename().isEmpty()) {
            vid = this.getBiggestMediaFile(MediaFileType.VIDEO);
        }
        if (vid != null) {
            return vid;
        }
        LOGGER.debug("Movie without video file? {} | {}", (Object)this.getPathNIO(), (Object)this.getTitle());
        return MediaFile.EMPTY_MEDIAFILE;
    }

    public MediaFile getMainDVDVideoFile() {
        MediaFile vid = null;
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mediaFile.getExtension().equalsIgnoreCase("ifo") || vid != null && mediaFile.getDuration() <= vid.getDuration()) continue;
            vid = mediaFile;
        }
        if (vid != null) {
            String prefix = StrgUtils.substr(vid.getFilename(), "(?i)^(VTS_\\d+).*");
            if (prefix.isEmpty()) {
                prefix = StrgUtils.substr(vid.getFilename(), "(?i)^(HV\\d+)I.*");
            }
            for (MediaFile mif : this.getMediaFiles(MediaFileType.VIDEO)) {
                if (!mif.getFilename().startsWith(prefix) || mif.getFilename().endsWith("IFO")) continue;
                vid = mif;
            }
        }
        if (vid == null) {
            for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO)) {
                if (!mediaFile.getExtension().equalsIgnoreCase("m2ts") || vid != null && mediaFile.getDuration() <= vid.getDuration()) continue;
                vid = mediaFile;
            }
        }
        return vid;
    }

    @Override
    public MediaFile getMainFile() {
        return this.getMainVideoFile();
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return this.getMainVideoFile().getVideoResolution();
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return this.getMainVideoFile().getVideoFormat();
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return this.getMainVideoFile().getVideoCodec();
    }

    @Override
    public double getMediaInfoFrameRate() {
        return this.getMainVideoFile().getFrameRate();
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return this.getMainVideoFile().getAspectRatio().floatValue();
    }

    public String getMediaInfoAspectRatioAsString() {
        DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        return df.format(this.getMainVideoFile().getAspectRatio()).replaceAll("\\.", "");
    }

    @Override
    public Float getMediaInfoAspectRatio2() {
        return this.getMainVideoFile().getAspectRatio2();
    }

    public String getMediaInfoAspectRatio2AsString() {
        Float aspectRatio2 = this.getMediaInfoAspectRatio2();
        String ar2AsString = "";
        if (aspectRatio2 != null) {
            DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
            ar2AsString = df.format(this.getMainVideoFile().getAspectRatio2()).replaceAll("\\.", "");
        }
        return ar2AsString;
    }

    public boolean isMultiFormat() {
        return this.getMainVideoFile().getAspectRatio2() != null;
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return this.getMainVideoFile().getAudioCodec();
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        ArrayList<String> lang = new ArrayList<String>();
        lang.addAll(this.getMainVideoFile().getAudioCodecList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioCodecList());
        }
        return lang;
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return this.getMainVideoFile().getAudioChannels();
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        ArrayList<String> lang = new ArrayList<String>();
        lang.addAll(this.getMainVideoFile().getAudioChannelsList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioChannelsList());
        }
        return lang;
    }

    @Override
    public String getMediaInfoAudioChannelsDot() {
        return this.getMainVideoFile().getAudioChannelsDot();
    }

    @Override
    public List<String> getMediaInfoAudioChannelDotList() {
        ArrayList<String> lang = new ArrayList<String>();
        lang.addAll(this.getMainVideoFile().getAudioChannelsDotList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioChannelsDotList());
        }
        return lang;
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return this.getMainVideoFile().getAudioLanguage();
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getAudioLanguagesList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioLanguagesList());
        }
        return lang;
    }

    @Override
    public List<String> getMediaInfoSubtitleLanguageList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getSubtitleLanguagesList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
            lang.addAll(mf.getSubtitleLanguagesList());
        }
        return lang;
    }

    @Override
    public List<String> getMediaInfoSubtitleCodecList() {
        ArrayList<String> codecs = new ArrayList<String>(this.getMainVideoFile().getSubtitleCodecList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
            codecs.addAll(mf.getSubtitleCodecList());
        }
        return codecs;
    }

    @Override
    public String getMediaInfoContainerFormat() {
        return this.getMainVideoFile().getContainerFormat();
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return this.getMediaSource();
    }

    @Override
    public long getVideoFilesize() {
        long filesize = 0L;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            filesize += mf.getFilesize();
        }
        return filesize;
    }

    public String getVideo3DFormat() {
        MediaFile mediaFile = this.getMainVideoFile();
        if (StringUtils.isNotBlank((CharSequence)mediaFile.getVideo3DFormat())) {
            return mediaFile.getVideo3DFormatOld();
        }
        if (this.isVideoIn3D()) {
            return "3D";
        }
        return "";
    }

    public String getVideo3DFormat2() {
        MediaFile mediaFile = this.getMainVideoFile();
        if (StringUtils.isNotBlank((CharSequence)mediaFile.getVideo3DFormat())) {
            return mediaFile.getVideo3DFormat();
        }
        if (this.isVideoIn3D()) {
            return "3D";
        }
        return "";
    }

    @Override
    public String getVideoHDRFormat() {
        return this.getMainVideoFile().getHdrFormat();
    }

    public Boolean isVideoInHDR() {
        return StringUtils.isNotEmpty((CharSequence)this.getMainVideoFile().getHdrFormat());
    }

    public String getVideoHDR() {
        return this.isVideoInHDR() != false ? "HDR" : "";
    }

    public MovieEdition getEdition() {
        return this.edition;
    }

    public String getEditionAsString() {
        return this.edition.toString();
    }

    public void setOffline(boolean newValue) {
        boolean oldValue = this.offline;
        this.offline = newValue;
        this.firePropertyChange("offline", oldValue, newValue);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String getCRC32() {
        return this.getMainVideoFile().getCRC32();
    }

    public void setEdition(MovieEdition newValue) {
        MovieEdition oldValue = this.edition;
        this.edition = newValue;
        this.firePropertyChange("edition", oldValue, newValue);
        this.firePropertyChange("editionAsString", oldValue, newValue);
    }

    @Override
    public void removeFromMediaFiles(MediaFile mediaFile) {
        super.removeFromMediaFiles(mediaFile);
        boolean dirty = false;
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            for (int i = this.trailer.size() - 1; i >= 0; --i) {
                MediaTrailer mediaTrailer = this.trailer.get(i);
                if (!mediaTrailer.getUrl().equals(mediaFile.getFileAsPath().toUri().toString())) continue;
                this.trailer.remove(mediaTrailer);
                dirty = true;
            }
        }
        if (dirty) {
            this.firePropertyChange("trailer", null, this.trailer);
        }
    }

    @Override
    protected void fireAddedEventForMediaFile(MediaFile mediaFile) {
        super.fireAddedEventForMediaFile(mediaFile);
        switch (mediaFile.getType()) {
            case TRAILER: {
                this.firePropertyChange("trailer", false, true);
                break;
            }
            case SUBTITLE: {
                this.firePropertyChange("hasSubtitle", false, true);
                break;
            }
        }
    }

    @Override
    protected void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        super.fireRemoveEventForMediaFile(mediaFile);
        switch (mediaFile.getType()) {
            case TRAILER: {
                this.firePropertyChange("trailer", true, false);
                break;
            }
            case SUBTITLE: {
                this.firePropertyChange("hasSubtitle", true, false);
                break;
            }
        }
    }

    private void mixinLocalTrailers() {
        for (int i = this.trailer.size() - 1; i >= 0; --i) {
            MediaTrailer mediaTrailer = this.trailer.get(i);
            if (!"downloaded".equalsIgnoreCase(mediaTrailer.getProvider())) continue;
            this.trailer.remove(i);
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.TRAILER)) {
            LOGGER.debug("adding local trailer {}", (Object)mf.getFilename());
            MediaTrailer mt = new MediaTrailer();
            mt.setName(mf.getFilename());
            mt.setProvider("downloaded");
            mt.setQuality(mf.getVideoFormat());
            mt.setInNfo(false);
            mt.setUrl(mf.getFile().toUri().toString());
            this.trailer.add(0, mt);
            this.firePropertyChange("trailer", null, this.trailer);
        }
    }

    @Override
    public void callbackForGatheredMediainformation(MediaFile mediaFile) {
        boolean dirty = false;
        if (this.getMediaSource() == MediaSource.BLURAY && this.getMainVideoFile().getVideoDefinitionCategory().equals("UHD")) {
            this.setMediaSource(MediaSource.UHD_BLURAY);
            dirty = true;
        }
        if (mediaFile.getType() == MediaFileType.VIDEO && MovieModuleManager.getInstance().getSettings().isUseMediainfoMetadata() && this.getMediaFiles(MediaFileType.NFO).isEmpty() && !mediaFile.getExtraData().isEmpty()) {
            String date;
            String genre;
            String plot;
            String year;
            String originalTitle;
            String title = mediaFile.getExtraData().get("title");
            if (StringUtils.isNotBlank((CharSequence)title)) {
                this.setTitle(title);
                dirty = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(originalTitle = mediaFile.getExtraData().get("originalTitle")))) {
                this.setOriginalTitle(originalTitle);
                dirty = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(year = mediaFile.getExtraData().get("year")))) {
                try {
                    int y = Integer.parseInt(year);
                    if (y > 1900 && y < 2100) {
                        this.setYear(y);
                    }
                }
                catch (Exception y) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(plot = mediaFile.getExtraData().get("plot")))) {
                this.setPlot(plot);
                dirty = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(genre = mediaFile.getExtraData().get("genre")))) {
                ArrayList<MediaGenres> genres = new ArrayList<MediaGenres>();
                for (String part : ParserUtils.split(genre)) {
                    genres.add(MediaGenres.getGenre(part));
                }
                this.addToGenres(genres);
            }
            if (StringUtils.isNotBlank((CharSequence)(date = mediaFile.getExtraData().get("releaseDate")))) {
                this.setReleaseDate(date);
            }
        }
        if (dirty) {
            this.saveToDb();
        }
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    public Object getValueForMetadata(MovieScraperMetadataConfig metadataConfig) {
        return switch (metadataConfig) {
            default -> throw new IncompatibleClassChangeError();
            case MovieScraperMetadataConfig.ID -> this.getIds();
            case MovieScraperMetadataConfig.TITLE -> this.getTitle();
            case MovieScraperMetadataConfig.ORIGINAL_TITLE -> this.getOriginalTitle();
            case MovieScraperMetadataConfig.ENGLISH_TITLE -> this.getEnglishTitle();
            case MovieScraperMetadataConfig.TAGLINE -> this.getTagline();
            case MovieScraperMetadataConfig.PLOT -> this.getPlot();
            case MovieScraperMetadataConfig.YEAR -> this.getYear();
            case MovieScraperMetadataConfig.RELEASE_DATE -> this.getReleaseDate();
            case MovieScraperMetadataConfig.RATING -> this.getRatings();
            case MovieScraperMetadataConfig.TOP250 -> this.getTop250();
            case MovieScraperMetadataConfig.RUNTIME -> this.getRuntime();
            case MovieScraperMetadataConfig.CERTIFICATION -> this.getCertification();
            case MovieScraperMetadataConfig.GENRES -> this.getGenres();
            case MovieScraperMetadataConfig.SPOKEN_LANGUAGES -> this.getSpokenLanguages();
            case MovieScraperMetadataConfig.COUNTRY -> this.getCountry();
            case MovieScraperMetadataConfig.PRODUCTION_COMPANY -> this.getProductionCompany();
            case MovieScraperMetadataConfig.TAGS -> this.getTags();
            case MovieScraperMetadataConfig.COLLECTION -> this.getMovieSet();
            case MovieScraperMetadataConfig.TRAILER -> this.getTrailer();
            case MovieScraperMetadataConfig.ACTORS -> this.getActors();
            case MovieScraperMetadataConfig.CREW -> this.getCrew();
            case MovieScraperMetadataConfig.POSTER -> this.getMediaFiles(MediaFileType.POSTER);
            case MovieScraperMetadataConfig.FANART -> this.getMediaFiles(MediaFileType.FANART);
            case MovieScraperMetadataConfig.BANNER -> this.getMediaFiles(MediaFileType.BANNER);
            case MovieScraperMetadataConfig.CLEARART -> this.getMediaFiles(MediaFileType.CLEARART);
            case MovieScraperMetadataConfig.THUMB -> this.getMediaFiles(MediaFileType.THUMB);
            case MovieScraperMetadataConfig.CLEARLOGO -> this.getMediaFiles(MediaFileType.CLEARLOGO);
            case MovieScraperMetadataConfig.DISCART -> this.getMediaFiles(MediaFileType.DISC);
            case MovieScraperMetadataConfig.KEYART -> this.getMediaFiles(MediaFileType.KEYART);
            case MovieScraperMetadataConfig.EXTRAFANART -> this.getMediaFiles(MediaFileType.EXTRAFANART);
            case MovieScraperMetadataConfig.EXTRATHUMB -> this.getMediaFiles(MediaFileType.EXTRATHUMB);
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Movie movie = (Movie)o;
        return this.path.equals(movie.path) && this.getMainFile().getFile().equals(movie.getMainFile().getFile());
    }

    public int hashCode() {
        return Objects.hash(this.path, this.getMainFile().getFile());
    }

    @JsonAnySetter
    public void setUnknownFields(String property, Object value) {
        if (value == null) {
            return;
        }
        switch (property) {
            case "producers": 
            case "writers": 
            case "directors": {
                if (!(value instanceof List)) break;
                List crewList = (List)value;
                for (Person person : UpgradeTasks.upgradeCrew(crewList)) {
                    if (this.crew.contains(person)) continue;
                    this.crew.add(person);
                }
                this.crew.sort(Comparator.comparingInt(o -> o.getType().ordinal()));
            }
        }
    }
}

