/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.clipinf.StringIOHelper;

@XmlType(propOrder={"clipStreamType", "applicationType", "isAtcDelta", "tsRecordingRate", "numSourcePackets", "const0x00001e80", "tsTypeInfoFormatId"})
public class ClipInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipInfo.class);
    private byte clipStreamType;
    private byte applicationType;
    private int isAtcDelta;
    private int tsRecordingRate;
    private int numSourcePackets;
    private Integer const0x00001e80;
    private String tsTypeInfoFormatId;

    public byte getClipStreamType() {
        return this.clipStreamType;
    }

    public void setClipStreamType(byte by) {
        this.clipStreamType = by;
    }

    public byte getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(byte by) {
        this.applicationType = by;
    }

    public int getIsAtcDelta() {
        return this.isAtcDelta;
    }

    public void setIsAtcDelta(int n) {
        this.isAtcDelta = n;
    }

    public int getTsRecordingRate() {
        return this.tsRecordingRate;
    }

    public void setTsRecordingRate(int n) {
        this.tsRecordingRate = n;
    }

    public int getNumSourcePackets() {
        return this.numSourcePackets;
    }

    public void setNumSourcePackets(int n) {
        this.numSourcePackets = n;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getConst0x00001e80() {
        return this.const0x00001e80;
    }

    public void setConst0x00001e80(Integer n) {
        this.const0x00001e80 = n;
    }

    public String getTsTypeInfoFormatId() {
        return this.tsTypeInfoFormatId;
    }

    public void setTsTypeInfoFormatId(String string) {
        this.tsTypeInfoFormatId = string;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        LOGGER.trace("ClipInfo length={}", (Object)n);
        dataInputStream.skipBytes(2);
        this.clipStreamType = dataInputStream.readByte();
        LOGGER.trace("ClipInfo clipStreamType={}", (Object)this.clipStreamType);
        this.applicationType = dataInputStream.readByte();
        this.applicationType = (byte)(this.applicationType & 0xF);
        LOGGER.trace("ClipInfo applicationType={}", (Object)this.applicationType);
        this.isAtcDelta = dataInputStream.readInt();
        this.isAtcDelta &= 1;
        LOGGER.trace("ClipInfo isAtcDelta={}", (Object)this.isAtcDelta);
        this.tsRecordingRate = dataInputStream.readInt();
        LOGGER.trace("ClipInfo tsRecordingRate={} seconds", (Object)(this.tsRecordingRate / 10000));
        this.numSourcePackets = dataInputStream.readInt();
        LOGGER.trace("ClipInfo numSourcePackets={}", (Object)this.numSourcePackets);
        dataInputStream.skipBytes(127);
        this.const0x00001e80 = dataInputStream.readInt();
        LOGGER.trace("ClipInfo const0x00001e80={}", (Object)this.const0x00001e80);
        this.tsTypeInfoFormatId = StringIOHelper.readISO646String(dataInputStream, 4);
        LOGGER.trace("ClipInfo tsTypeInfoFormatId={}", (Object)this.tsTypeInfoFormatId);
        dataInputStream.skipBytes(25);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(176);
        for (n = 0; n < 2; ++n) {
            dataOutputStream.write(0);
        }
        dataOutputStream.write(this.getClipStreamType());
        dataOutputStream.write(this.getApplicationType());
        dataOutputStream.write(this.getIsAtcDelta() & 1);
        dataOutputStream.writeInt(this.getTsRecordingRate());
        dataOutputStream.writeInt(this.getNumSourcePackets());
        for (n = 0; n < 127; ++n) {
            dataOutputStream.write(0);
        }
        dataOutputStream.writeInt(this.getConst0x00001e80());
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getTsTypeInfoFormatId()));
        for (n = 0; n < 25; ++n) {
            dataOutputStream.write(0);
        }
        LOGGER.trace("ClipInfo: {} ?={}", (Object)176, (Object)(dataOutputStream.size() - 4));
    }
}

