/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.bdjo;

import com.hdcookbook.grin.util.BitStreamIO;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.bdjo.AppCacheEntry;
import org.tinymediamanager.library.bluray.bdjo.AppCacheInfo;
import org.tinymediamanager.library.bluray.bdjo.AppInfo;
import org.tinymediamanager.library.bluray.bdjo.AppName;
import org.tinymediamanager.library.bluray.bdjo.AppProfile;
import org.tinymediamanager.library.bluray.bdjo.ApplicationDescriptor;
import org.tinymediamanager.library.bluray.bdjo.ApplicationManagementTable;
import org.tinymediamanager.library.bluray.bdjo.BDJO;
import org.tinymediamanager.library.bluray.bdjo.BDJOWriter;
import org.tinymediamanager.library.bluray.bdjo.Binding;
import org.tinymediamanager.library.bluray.bdjo.HaviDeviceConfig;
import org.tinymediamanager.library.bluray.bdjo.TableOfAccessiblePlayLists;
import org.tinymediamanager.library.bluray.bdjo.TerminalInfo;
import org.tinymediamanager.library.bluray.bdjo.Version;
import org.tinymediamanager.library.bluray.bdjo.Visibility;

public final class BDJOReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDJOReader.class);
    private static boolean TRACE = true;
    private static volatile ScriptEngine javaFxEngine;

    private BDJOReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initJavaFxEngine() {
        if (javaFxEngine != null) return;
        Class<BDJOReader> clazz = BDJOReader.class;
        synchronized (BDJOReader.class) {
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            javaFxEngine = scriptEngineManager.getEngineByName("FX");
            if (javaFxEngine != null) return;
            throw new RuntimeException("cannot load JavaFX engine, check your CLASSPATH");
        }
    }

    public static synchronized BDJO readFX(Reader reader) throws ScriptException {
        BDJOReader.initJavaFxEngine();
        return (BDJO)javaFxEngine.eval(reader);
    }

    public static synchronized BDJO readFX(String string) throws ScriptException {
        BDJOReader.initJavaFxEngine();
        return (BDJO)javaFxEngine.eval(string);
    }

    public static BDJO readXML(Reader reader) throws JAXBException {
        String string = BDJO.class.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        JAXBContext jAXBContext = JAXBContext.newInstance((String)string2);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        return (BDJO)unmarshaller.unmarshal(reader);
    }

    public static BDJO readXML(String string) throws JAXBException {
        return BDJOReader.readXML(new StringReader(string));
    }

    private static String iso646String(byte[] byArray) {
        try {
            return new String(byArray, "ISO646-US");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static String readISO646String(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO, int n) throws IOException {
        byte[] byArray = new byte[n];
        bitStreamIO.assertByteAligned(1);
        dataInputStream.read(byArray);
        String string2 = BDJOReader.iso646String(byArray);
        if (TRACE) {
            LOGGER.trace(string + ":  \"" + string2 + "\"");
        }
        return string2;
    }

    private static String toUTF8String(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static String readUTF8String(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO, int n) throws IOException {
        byte[] byArray = new byte[n];
        bitStreamIO.assertByteAligned(1);
        dataInputStream.read(byArray);
        String string2 = BDJOReader.toUTF8String(byArray);
        if (TRACE) {
            LOGGER.trace(string + ":  \"" + string2 + "\"");
        }
        return string2;
    }

    private static byte readByte(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        bitStreamIO.assertByteAligned(1);
        byte by = dataInputStream.readByte();
        if (TRACE) {
            LOGGER.trace(string + ":  " + by + " ");
        }
        return by;
    }

    private static int readUnsignedByte(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        bitStreamIO.assertByteAligned(1);
        int n = dataInputStream.readUnsignedByte();
        if (TRACE) {
            LOGGER.trace(string + ":  " + n + " ");
        }
        return n;
    }

    private static short readShort(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        bitStreamIO.assertByteAligned(1);
        short s = dataInputStream.readShort();
        if (TRACE) {
            LOGGER.trace(string + ":  " + s + " ");
        }
        return s;
    }

    private static int readUnsignedShort(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        bitStreamIO.assertByteAligned(1);
        int n = dataInputStream.readUnsignedShort();
        if (TRACE) {
            LOGGER.trace(string + ":  " + n + " ");
        }
        return n;
    }

    private static int readInt(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        bitStreamIO.assertByteAligned(1);
        int n = dataInputStream.readInt();
        if (TRACE) {
            LOGGER.trace(string + ":  " + n + " ");
        }
        return n;
    }

    private static int readBits(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO, int n) throws IOException {
        int n2 = bitStreamIO.readBits(dataInputStream, n);
        if (TRACE) {
            LOGGER.trace(string + ":  \"" + n2 + "\"");
        }
        return n2;
    }

    private static long readBitsLong(String string, DataInputStream dataInputStream, BitStreamIO bitStreamIO, int n) throws IOException {
        long l = bitStreamIO.readBitsLong(dataInputStream, n);
        if (TRACE) {
            LOGGER.trace(string + ":  \"" + l + "\"");
        }
        return l;
    }

    private static TerminalInfo readTerminalInfo(DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        boolean bl;
        TerminalInfo terminalInfo = new TerminalInfo();
        if (TRACE) {
            LOGGER.trace("Terminal info:");
        }
        BDJOReader.readInt("    length (ignored)", dataInputStream, bitStreamIO);
        terminalInfo.setDefaultFontFile(BDJOReader.readISO646String("    default font", dataInputStream, bitStreamIO, 5));
        int n = BDJOReader.readBits("    HAVi config", dataInputStream, bitStreamIO, 4);
        HaviDeviceConfig[] haviDeviceConfigArray = HaviDeviceConfig.values();
        for (bl = false; bl < haviDeviceConfigArray.length; bl += 1) {
            HaviDeviceConfig haviDeviceConfig = haviDeviceConfigArray[bl];
            if (haviDeviceConfig.getId() != n) continue;
            terminalInfo.setInitialHaviConfig(haviDeviceConfig);
            break;
        }
        bl = BDJOReader.readBits("    menu call mask", dataInputStream, bitStreamIO, 1) != 0;
        terminalInfo.setMenuCallMask(bl);
        bl = BDJOReader.readBits("    title search mask", dataInputStream, bitStreamIO, 1) != 0;
        terminalInfo.setTitleSearchMask(bl);
        bl = BDJOReader.readBits("    mouse supported", dataInputStream, bitStreamIO, 1) != 0;
        terminalInfo.setMouseSupported(bl);
        bl = BDJOReader.readBits("    mouse interest", dataInputStream, bitStreamIO, 1) != 0;
        terminalInfo.setMouseInterest(bl);
        terminalInfo.setInitialOutputMode(BDJOReader.readBits("    initial output mode", dataInputStream, bitStreamIO, 2));
        terminalInfo.setInitialFrameRate(BDJOReader.readBits("    initial frame rate", dataInputStream, bitStreamIO, 4));
        terminalInfo.setInitialDynamicRangeType(BDJOReader.readBits("    initial dynamic range", dataInputStream, bitStreamIO, 4));
        terminalInfo.setHdrModeGraphicsGain(BDJOReader.readBits("    HDR graphic gain", dataInputStream, bitStreamIO, 2));
        terminalInfo.setReserved(BDJOReader.readBits("    reserved", dataInputStream, bitStreamIO, 4));
        BDJOReader.readBitsLong("    padding", dataInputStream, bitStreamIO, 16);
        return terminalInfo;
    }

    private static AppCacheInfo readAppCacheInfo(DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        if (TRACE) {
            LOGGER.trace("App cache info:");
        }
        AppCacheInfo appCacheInfo = new AppCacheInfo();
        BDJOReader.readInt("    length (ignored)", dataInputStream, bitStreamIO);
        int n = BDJOReader.readUnsignedByte("    number of entries", dataInputStream, bitStreamIO);
        BDJOReader.readByte("    padding", dataInputStream, bitStreamIO);
        AppCacheEntry[] appCacheEntryArray = new AppCacheEntry[n];
        int n2 = 12;
        for (int i = 0; i < appCacheEntryArray.length; ++i) {
            AppCacheEntry appCacheEntry = new AppCacheEntry();
            appCacheEntry.setType(BDJOReader.readByte("        entry_type", dataInputStream, bitStreamIO));
            appCacheEntry.setName(BDJOReader.readISO646String("        ref_to_name", dataInputStream, bitStreamIO, 5));
            appCacheEntry.setLanguage(BDJOReader.readISO646String("        language_code", dataInputStream, bitStreamIO, 3));
            appCacheEntryArray[i] = appCacheEntry;
            BDJOReader.readBits("        padding", dataInputStream, bitStreamIO, 24);
        }
        appCacheInfo.setEntries(appCacheEntryArray);
        return appCacheInfo;
    }

    private static TableOfAccessiblePlayLists readTableOfAccessiblePlayLists(DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        if (TRACE) {
            LOGGER.trace("Table of accessible playlists:");
        }
        BDJOReader.readInt("    length (ignored)", dataInputStream, bitStreamIO);
        int n = BDJOReader.readBits("    num playlists", dataInputStream, bitStreamIO, 11);
        TableOfAccessiblePlayLists tableOfAccessiblePlayLists = new TableOfAccessiblePlayLists();
        boolean bl = BDJOReader.readBits("    access to all flag", dataInputStream, bitStreamIO, 1) != 0;
        tableOfAccessiblePlayLists.setAccessToAllFlag(bl);
        bl = BDJOReader.readBits("    autostart first playlist", dataInputStream, bitStreamIO, 1) != 0;
        tableOfAccessiblePlayLists.setAutostartFirstPlayListFlag(bl);
        BDJOReader.readBits("    padding", dataInputStream, bitStreamIO, 19);
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = BDJOReader.readISO646String("        playlist file name", dataInputStream, bitStreamIO, 5);
            BDJOReader.readByte("        padding", dataInputStream, bitStreamIO);
        }
        tableOfAccessiblePlayLists.setPlayListFileNames(stringArray);
        return tableOfAccessiblePlayLists;
    }

    private static ApplicationManagementTable readApplicationManagementTable(DataInputStream dataInputStream, BitStreamIO bitStreamIO) throws IOException {
        if (TRACE) {
            LOGGER.trace("Application management table:");
        }
        BDJOReader.readInt("    length (ignored)", dataInputStream, bitStreamIO);
        int n = BDJOReader.readUnsignedByte("    number of applications", dataInputStream, bitStreamIO);
        BDJOReader.readByte("    padding", dataInputStream, bitStreamIO);
        AppInfo[] appInfoArray = new AppInfo[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if (TRACE) {
                LOGGER.trace("    " + i + ":");
            }
            AppInfo appInfo = new AppInfo();
            appInfo.setControlCode(BDJOReader.readByte("        application control code", dataInputStream, bitStreamIO));
            appInfo.setType((byte)BDJOReader.readBits("        application type", dataInputStream, bitStreamIO, 4));
            BDJOReader.readBits("        padding", dataInputStream, bitStreamIO, 4);
            appInfo.setOrganizationId(BDJOReader.readInt("        org id", dataInputStream, bitStreamIO));
            appInfo.setApplicationId(BDJOReader.readShort("        app id", dataInputStream, bitStreamIO));
            BDJOReader.readByte("        descriptor_tag (ignored)", dataInputStream, bitStreamIO);
            BDJOReader.readByte("        padding", dataInputStream, bitStreamIO);
            BDJOReader.readInt("        descriptor_length (ignored)", dataInputStream, bitStreamIO);
            BDJOReader.readInt("        padding", dataInputStream, bitStreamIO);
            int n7 = BDJOReader.readBits("        application profiles count", dataInputStream, bitStreamIO, 4);
            BDJOReader.readBits("        padding", dataInputStream, bitStreamIO, 12);
            AppProfile[] appProfileArray = new AppProfile[n7];
            for (int j = 0; j < n7; ++j) {
                if (TRACE) {
                    LOGGER.trace("        " + j + ":");
                }
                AppProfile appProfile = new AppProfile();
                appProfile.setProfile(BDJOReader.readShort("            profile", dataInputStream, bitStreamIO));
                appProfile.setMajorVersion((short)BDJOReader.readUnsignedByte("            major version", dataInputStream, bitStreamIO));
                appProfile.setMinorVersion((short)BDJOReader.readUnsignedByte("            minor version", dataInputStream, bitStreamIO));
                appProfile.setMicroVersion((short)BDJOReader.readUnsignedByte("            micro version", dataInputStream, bitStreamIO));
                BDJOReader.readUnsignedByte("            padding", dataInputStream, bitStreamIO);
                appProfileArray[j] = appProfile;
            }
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor();
            applicationDescriptor.setProfiles(appProfileArray);
            applicationDescriptor.setPriority((short)BDJOReader.readUnsignedByte("        application priority", dataInputStream, bitStreamIO));
            int n8 = BDJOReader.readBits("        binding", dataInputStream, bitStreamIO, 2);
            Binding[] bindingArray = Binding.values();
            for (n6 = 0; n6 < bindingArray.length; ++n6) {
                if (bindingArray[n6].ordinal() != n8) continue;
                applicationDescriptor.setBinding(bindingArray[n6]);
                break;
            }
            n6 = BDJOReader.readBits("        visibility", dataInputStream, bitStreamIO, 2);
            Visibility[] visibilityArray = Visibility.values();
            for (n5 = 0; n5 < visibilityArray.length; ++n5) {
                if (visibilityArray[n5].ordinal() != n6) continue;
                applicationDescriptor.setVisibility(visibilityArray[n5]);
                break;
            }
            BDJOReader.readBits("        padding", dataInputStream, bitStreamIO, 4);
            n5 = BDJOReader.readUnsignedShort("        application name bytes", dataInputStream, bitStreamIO);
            if (n5 > 0) {
                AppName[] appNameArray;
                ArrayList<AppName[]> arrayList = new ArrayList<AppName[]>();
                for (n3 = 0; n3 < n5; n3 += n4) {
                    appNameArray = new AppName();
                    appNameArray.setLanguage(BDJOReader.readISO646String("            language", dataInputStream, bitStreamIO, 3));
                    n3 += 3;
                    n4 = BDJOReader.readUnsignedByte("            name length", dataInputStream, bitStreamIO);
                    ++n3;
                    appNameArray.setName(BDJOReader.readUTF8String("            name", dataInputStream, bitStreamIO, n4));
                    arrayList.add(appNameArray);
                }
                appNameArray = arrayList.toArray(new AppName[arrayList.size()]);
                applicationDescriptor.setNames(appNameArray);
            }
            if ((n5 & 1) != 0) {
                BDJOReader.readByte("        padding", dataInputStream, bitStreamIO);
            }
            n3 = BDJOReader.readUnsignedByte("        icon length", dataInputStream, bitStreamIO);
            applicationDescriptor.setIconLocator(BDJOReader.readISO646String("        icon locator", dataInputStream, bitStreamIO, n3));
            if ((n3 & 1) == 0) {
                BDJOReader.readByte("        padding", dataInputStream, bitStreamIO);
            }
            applicationDescriptor.setIconFlags(BDJOReader.readShort("        application icon flags", dataInputStream, bitStreamIO));
            int n9 = BDJOReader.readUnsignedByte("        base dir length", dataInputStream, bitStreamIO);
            applicationDescriptor.setBaseDirectory(BDJOReader.readISO646String("        base directory", dataInputStream, bitStreamIO, n9));
            if ((n9 & 1) == 0) {
                dataInputStream.skipBytes(1);
            }
            int n10 = dataInputStream.readUnsignedByte();
            applicationDescriptor.setClasspathExtension(BDJOReader.readISO646String("        classpath extenstion", dataInputStream, bitStreamIO, n10));
            if ((n10 & 1) == 0) {
                BDJOReader.readByte("        padding", dataInputStream, bitStreamIO);
            }
            n4 = BDJOReader.readUnsignedByte("        initial class length", dataInputStream, bitStreamIO);
            applicationDescriptor.setInitialClassName(BDJOReader.readUTF8String("        initial class", dataInputStream, bitStreamIO, n4));
            if ((n4 & 1) == 0) {
                BDJOReader.readByte("        padding", dataInputStream, bitStreamIO);
            }
            if ((n2 = BDJOReader.readUnsignedByte("        param bytes", dataInputStream, bitStreamIO)) > 0) {
                int n11;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = 0; j < n2; j += n11) {
                    n11 = BDJOReader.readUnsignedByte("            len", dataInputStream, bitStreamIO);
                    ++j;
                    arrayList.add(BDJOReader.readUTF8String("            param", dataInputStream, bitStreamIO, n11));
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                applicationDescriptor.setParameters(stringArray);
            }
            if ((n2 & 1) == 0) {
                BDJOReader.readByte("        padding", dataInputStream, bitStreamIO);
            }
            appInfo.setApplicationDescriptor(applicationDescriptor);
            appInfoArray[i] = appInfo;
        }
        ApplicationManagementTable applicationManagementTable = new ApplicationManagementTable();
        applicationManagementTable.setApplications(appInfoArray);
        return applicationManagementTable;
    }

    public static BDJO readBDJO(InputStream inputStream) throws IOException {
        BitStreamIO bitStreamIO;
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        String string = BDJOReader.readISO646String("magic number", dataInputStream, bitStreamIO = new BitStreamIO(), 4);
        if (!string.equals("BDJO")) {
            throw new IOException("BDJO magic is missing, not a bdjo file?");
        }
        String string2 = BDJOReader.readISO646String("version", dataInputStream, bitStreamIO, 4);
        BDJO bDJO = new BDJO();
        bDJO.setVersion(Version.valueOf("V_" + string2));
        BDJOReader.readInt("terminal info start address (ignored)", dataInputStream, bitStreamIO);
        BDJOReader.readInt("app cache info start address (ignored)", dataInputStream, bitStreamIO);
        BDJOReader.readInt("table of accessible playlists start address (ignored)", dataInputStream, bitStreamIO);
        BDJOReader.readInt("application management table start address (ignored)", dataInputStream, bitStreamIO);
        BDJOReader.readInt("key interest table start address (ignored)", dataInputStream, bitStreamIO);
        BDJOReader.readInt("file access info start address (ignored)", dataInputStream, bitStreamIO);
        BDJOReader.readBitsLong("padding", dataInputStream, bitStreamIO, 64);
        BDJOReader.readBitsLong("padding", dataInputStream, bitStreamIO, 64);
        bDJO.setTerminalInfo(BDJOReader.readTerminalInfo(dataInputStream, bitStreamIO));
        bDJO.setAppCacheInfo(BDJOReader.readAppCacheInfo(dataInputStream, bitStreamIO));
        bDJO.setTableOfAccessiblePlayLists(BDJOReader.readTableOfAccessiblePlayLists(dataInputStream, bitStreamIO));
        bDJO.setApplicationManagementTable(BDJOReader.readApplicationManagementTable(dataInputStream, bitStreamIO));
        bDJO.setKeyInterestTable(BDJOReader.readInt("key interest table", dataInputStream, bitStreamIO));
        int n = BDJOReader.readUnsignedShort("file access info length", dataInputStream, bitStreamIO);
        bDJO.setFileAccessInfo(BDJOReader.readISO646String("file access info", dataInputStream, bitStreamIO, n));
        return bDJO;
    }

    public static void main(String[] stringArray) throws Exception {
        BDJO bDJO;
        if (stringArray[0].endsWith(".fx")) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            bDJO = BDJOReader.readFX(bufferedReader);
        } else if (stringArray[0].endsWith(".bdjo")) {
            bDJO = BDJOReader.readBDJO(new BufferedInputStream(new FileInputStream(stringArray[0])));
        } else {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            bDJO = BDJOReader.readXML(bufferedReader);
        }
        BDJOWriter.writeFX(bDJO, new PrintWriter(System.out));
    }
}

