/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class TvShowAddDatasourceAction
extends TmmAction {
    public TvShowAddDatasourceAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.datasource.add"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.datasource.add"));
        this.putValue("SmallIcon", IconManager.ADD);
        this.putValue("SwingLargeIconKey", IconManager.ADD);
    }

    @Override
    protected void processAction(ActionEvent e) {
        SwingUtilities.invokeLater(() -> {
            String path = TmmProperties.getInstance().getProperty("tvshow.datasource.path");
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("Settings.tvshowdatasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                TvShowModuleManager.getInstance().getSettings().addTvShowDataSources(file.toAbsolutePath().toString());
                TvShowModuleManager.getInstance().getSettings().saveSettings();
                TmmProperties.getInstance().putProperty("tvshow.datasource.path", file.toAbsolutePath().toString());
            }
        });
    }
}

