/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRewriteSeasonNfoAction
extends TmmAction {
    public TvShowRewriteSeasonNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.rewriteseasonnfo"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final Set<TvShowSeason> selectedSeasons = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects().getSeasonsRecursive();
        if (selectedSeasons.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshow.rewriteseasonnfo"), selectedSeasons.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (TvShowSeason season : selectedSeasons) {
                    season.writeNfo();
                    season.saveToDb();
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

