/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.messagebox.teleport;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.model.messagebox.teleport.ImmutableTeleportRequestDataDto;
import com.ubnt.model.messagebox.teleport.TeleportRequestType;
import com.ubnt.model.messagebox.teleport.TeleportRequestUserPayloadDto;
import com.ubnt.return.D;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableTeleportRequestDataDto.class)
@Value.Immutable
@D
public interface TeleportRequestDataDto {
    @JsonProperty(value="token")
    public String token();

    @JsonProperty(value="teleportRequestId")
    public String teleportRequestId();

    @JsonProperty(value="userPayload")
    public TeleportRequestUserPayloadDto userPayload();

    @Value.Lazy
    default public boolean isAccessRequest() {
        return this.userPayload().requestType() == TeleportRequestType.REQUEST_ACCESS;
    }

    @Value.Lazy
    default public boolean isIceConfigurationRequest() {
        return this.userPayload().requestType() == TeleportRequestType.GET_ICE_CONFIGURATION;
    }

    @Value.Lazy
    default public boolean isConnectionRequest() {
        return this.userPayload().requestType() == TeleportRequestType.CONNECT;
    }

    @Value.Lazy
    default public boolean isRemovalRequest() {
        return this.userPayload().requestType() == TeleportRequestType.REMOVE;
    }

    public static ImmutableTeleportRequestDataDto.Builder builder() {
        return ImmutableTeleportRequestDataDto.builder();
    }
}

