/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSNumber;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSReal;
import org.verapdf.gf.model.impl.cos.GFCosInteger;
import org.verapdf.gf.model.impl.cos.GFCosObject;
import org.verapdf.gf.model.impl.cos.GFCosReal;
import org.verapdf.model.coslayer.CosNumber;

public class GFCosNumber
extends GFCosObject
implements CosNumber {
    private final long longVal;
    private final double doubleVal;

    protected GFCosNumber(COSNumber number, String type) {
        super(number, type);
        this.longVal = number.getInteger();
        this.doubleVal = number.getReal();
    }

    public static GFCosNumber fromPDFParserNumber(COSBase number) {
        if (number.getType() == COSObjType.COS_INTEGER) {
            return new GFCosInteger((COSInteger)number);
        }
        if (number.getType() == COSObjType.COS_REAL) {
            return new GFCosReal((COSReal)number);
        }
        return null;
    }

    @Override
    public String getstringValue() {
        return String.valueOf(this.doubleVal);
    }

    @Override
    public Long getintValue() {
        return this.longVal;
    }

    @Override
    public Double getrealValue() {
        return this.doubleVal;
    }
}

