#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-Cj7chVkBIbZBAtjHkBDKJf
key:                  tree-diff-0.3.0.1-Cj7chVkBIbZBAtjHkBDKJf
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  81c3a7c41e1dee3fd4f84cc2a6f308cd
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-Cj7chVkBIbZBAtjHkBDKJf
depends:
    QuickCheck-2.15.0.1-LaRIQHiwv8U7w9VIoXbmQQ
    aeson-2.2.0.0-A8FqDK4tVym6hhqwC7qXFC
    ansi-terminal-1.0.2-5XGQCBITBQK54h4mZtEY0l
    ansi-wl-pprint-1.0.2-DTFkkr6LOud89Oh0XZBo7 base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4 bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-2TMrYujL0SWBJEdw6jCOMM parsec-3.1.16.1
    parsers-0.12.12-3ctdS7BplAaRKS9RF5B8 pretty-1.1.3.6
    primitive-0.9.1.0-6uX3awsflEb6ebVZsasp0o
    scientific-0.3.8.0-JLcC8H5zZSyDPbVdOVmQEk
    semialign-1.3.1-J9n0W5NqrHmHz34Pf4FZZT
    strict-0.5.1-DmrRf36qs51E6Fr043iRQu
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig text-2.0.2
    these-1.2.1-4hTMfx1DS6oLW0Vj2YyJsc time-1.12.2
    unordered-containers-0.2.20.1-650icVWmHjf3WKXK0GKpae
    uuid-types-1.0.6-7gx1lcEyzTzHtsXguSIhiO
    vector-0.13.2.0-8Ien1418VpU5tGTMA2qRu7

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

