/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirNameConflictsTracker;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0006H\u0016J:\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNameConflictsTrackerImpl;", "Lorg/jetbrains/kotlin/fir/FirNameConflictsTracker;", "<init>", "()V", "redeclaredClassifiers", "", "Lorg/jetbrains/kotlin/name/ClassId;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNameConflictsTrackerImpl$ClassifierRedeclarationImpl;", "getClassifierRedeclarations", "", "Lorg/jetbrains/kotlin/fir/FirNameConflictsTracker$ClassifierRedeclaration;", "classId", "registerClassifierRedeclaration", "", "newSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "newSymbolFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "prevSymbol", "prevSymbolFile", "ClassifierRedeclarationImpl", "checkers"})
public final class FirNameConflictsTrackerImpl
extends FirNameConflictsTracker {
    @NotNull
    private final Map<ClassId, Set<ClassifierRedeclarationImpl>> redeclaredClassifiers = new HashMap();

    @Override
    @NotNull
    public Collection<FirNameConflictsTracker.ClassifierRedeclaration> getClassifierRedeclarations(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Set<ClassifierRedeclarationImpl> set = this.redeclaredClassifiers.get(classId);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    public void registerClassifierRedeclaration(@NotNull ClassId classId, @NotNull FirClassLikeSymbol<?> newSymbol, @NotNull FirFile newSymbolFile, @NotNull FirClassLikeSymbol<?> prevSymbol, @Nullable FirFile prevSymbolFile) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(newSymbol, "newSymbol");
        Intrinsics.checkNotNullParameter(newSymbolFile, "newSymbolFile");
        Intrinsics.checkNotNullParameter(prevSymbol, "prevSymbol");
        ClassifierRedeclarationImpl[] classifierRedeclarationImplArray = new ClassifierRedeclarationImpl[]{new ClassifierRedeclarationImpl(newSymbol, newSymbolFile), new ClassifierRedeclarationImpl(prevSymbol, prevSymbolFile)};
        this.redeclaredClassifiers.merge(classId, SetsKt.linkedSetOf(classifierRedeclarationImplArray), (arg_0, arg_1) -> FirNameConflictsTrackerImpl.registerClassifierRedeclaration$lambda$1(FirNameConflictsTrackerImpl::registerClassifierRedeclaration$lambda$0, arg_0, arg_1));
    }

    private static final Set registerClassifierRedeclaration$lambda$0(Set a2, Set b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        return SetsKt.plus(a2, b2);
    }

    private static final Set registerClassifierRedeclaration$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Set)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNameConflictsTrackerImpl$ClassifierRedeclarationImpl;", "Lorg/jetbrains/kotlin/fir/FirNameConflictsTracker$ClassifierRedeclaration;", "classifierSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "containingFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "getClassifierSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getContainingFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
    public static final class ClassifierRedeclarationImpl
    extends FirNameConflictsTracker.ClassifierRedeclaration {
        @NotNull
        private final FirClassLikeSymbol<?> classifierSymbol;
        @Nullable
        private final FirFile containingFile;

        public ClassifierRedeclarationImpl(@NotNull FirClassLikeSymbol<?> classifierSymbol, @Nullable FirFile containingFile) {
            Intrinsics.checkNotNullParameter(classifierSymbol, "classifierSymbol");
            this.classifierSymbol = classifierSymbol;
            this.containingFile = containingFile;
        }

        @Override
        @NotNull
        public FirClassLikeSymbol<?> getClassifierSymbol() {
            return this.classifierSymbol;
        }

        @Override
        @Nullable
        public FirFile getContainingFile() {
            return this.containingFile;
        }

        @NotNull
        public final FirClassLikeSymbol<?> component1() {
            return this.classifierSymbol;
        }

        @Nullable
        public final FirFile component2() {
            return this.containingFile;
        }

        @NotNull
        public final ClassifierRedeclarationImpl copy(@NotNull FirClassLikeSymbol<?> classifierSymbol, @Nullable FirFile containingFile) {
            Intrinsics.checkNotNullParameter(classifierSymbol, "classifierSymbol");
            return new ClassifierRedeclarationImpl(classifierSymbol, containingFile);
        }

        public static /* synthetic */ ClassifierRedeclarationImpl copy$default(ClassifierRedeclarationImpl classifierRedeclarationImpl, FirClassLikeSymbol firClassLikeSymbol, FirFile firFile, int n2, Object object) {
            if ((n2 & 1) != 0) {
                firClassLikeSymbol = classifierRedeclarationImpl.classifierSymbol;
            }
            if ((n2 & 2) != 0) {
                firFile = classifierRedeclarationImpl.containingFile;
            }
            return classifierRedeclarationImpl.copy(firClassLikeSymbol, firFile);
        }

        @NotNull
        public String toString() {
            return "ClassifierRedeclarationImpl(classifierSymbol=" + this.classifierSymbol + ", containingFile=" + this.containingFile + ')';
        }

        public int hashCode() {
            int result2 = this.classifierSymbol.hashCode();
            result2 = result2 * 31 + (this.containingFile == null ? 0 : this.containingFile.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassifierRedeclarationImpl)) {
                return false;
            }
            ClassifierRedeclarationImpl classifierRedeclarationImpl = (ClassifierRedeclarationImpl)other;
            if (!Intrinsics.areEqual(this.classifierSymbol, classifierRedeclarationImpl.classifierSymbol)) {
                return false;
            }
            return Intrinsics.areEqual(this.containingFile, classifierRedeclarationImpl.containingFile);
        }
    }
}

