# Persistent Collections Package

`List` - A persistent list with functional transformations.

`Map` - A persistent map based on the Compressed Hash Array Mapped Prefix-tree
from 'Optimizing Hash-Array Mapped Tries for Fast and Lean Immutable JVM
Collections' by Michael J. Steindorfer and Jurgen J. Vinju.

`Set` - A persistent set implemented as a persistent map of an alias of a type
to itself.

`Vec` - A persistent vector based on the Hash Array Mapped Trie from 'Ideal Hash
Trees' by Phil Bagwell.


## Public Types

* [class Cons](collections-persistent-Cons.md)
* [class HashMap](collections-persistent-HashMap.md)
* [class HashSet](collections-persistent-HashSet.md)
* [type List](collections-persistent-List.md)
* [primitive Lists](collections-persistent-Lists.md)
* [type Map](collections-persistent-Map.md)
* [type MapIs](collections-persistent-MapIs.md)
* [class MapKeys](collections-persistent-MapKeys.md)
* [class MapPairs](collections-persistent-MapPairs.md)
* [class MapValues](collections-persistent-MapValues.md)
* [primitive Nil](collections-persistent-Nil.md)
* [type Set](collections-persistent-Set.md)
* [type SetIs](collections-persistent-SetIs.md)
* [class Vec](collections-persistent-Vec.md)
* [class VecKeys](collections-persistent-VecKeys.md)
* [class VecPairs](collections-persistent-VecPairs.md)
* [class VecValues](collections-persistent-VecValues.md)


## Private Types

* [primitive _Bits](collections-persistent-_Bits.md)
* [type _Map](collections-persistent-_Map.md)
* [class _MapCollisions](collections-persistent-_MapCollisions.md)
* [class _MapEntry](collections-persistent-_MapEntry.md)
* [interface _MapIter](collections-persistent-_MapIter.md)
* [type _MapNode](collections-persistent-_MapNode.md)
* [class _MapSubNodes](collections-persistent-_MapSubNodes.md)
* [class _VecNode](collections-persistent-_VecNode.md)
* [type _VecSubNodes](collections-persistent-_VecSubNodes.md)
