# Constrained\[T: [Any](builtin-Any.md) val, F: [Validator](constrained_types-Validator.md)\[T\]\]
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-42)</span>

Wrapper class for a constrained type.


```pony
class val Constrained[T: Any val, F: Validator[T]]
```

## Constructors

### _create
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-48)</span>


Private constructor that guarantees that `Constrained` can only be created
by the `MakeConstrained` primitive in this package.


```pony
new val _create(
  value: T)
: Constrained[T, F] val^
```
#### Parameters

*   value: T

#### Returns

* [Constrained](constrained_types-Constrained.md)\[T, F\] val^

---

## Public Functions

### apply
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-55)</span>


Unwraps and allows access to the constrained object.


```pony
fun val apply()
: T
```

#### Returns

* T

---

