/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.level;

import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.bus.EventBus;
import org.jetbrains.annotations.ApiStatus;

public class ChunkEvent
extends LevelEvent {
    public static final EventBus<ChunkEvent> BUS = EventBus.create(ChunkEvent.class);
    private final ChunkAccess chunk;

    public ChunkEvent(ChunkAccess chunk) {
        super(chunk.getWorldForge());
        this.chunk = chunk;
    }

    public ChunkEvent(ChunkAccess chunk, LevelAccessor level) {
        super(level);
        this.chunk = chunk;
    }

    public ChunkAccess getChunk() {
        return this.chunk;
    }

    public static final class LightingCalculated
    extends ChunkEvent {
        public static final EventBus<LightingCalculated> BUS = EventBus.create(LightingCalculated.class);

        public LightingCalculated(ChunkAccess chunk) {
            super(chunk);
        }
    }

    public static final class Unload
    extends ChunkEvent {
        public static final EventBus<Unload> BUS = EventBus.create(Unload.class);

        public Unload(ChunkAccess chunk) {
            super(chunk);
        }
    }

    public static final class Load
    extends ChunkEvent {
        public static final EventBus<Load> BUS = EventBus.create(Load.class);
        private final boolean newChunk;

        @ApiStatus.Internal
        public Load(ChunkAccess chunk, boolean newChunk) {
            super(chunk);
            this.newChunk = newChunk;
        }

        public boolean isNewChunk() {
            return this.newChunk;
        }
    }
}

