/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp.log;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jitsi.impl.protocol.xmpp.log.IncludeXmppPackets;

public class XmppPacketsFileHandler
extends FileHandler {
    public XmppPacketsFileHandler() throws IOException, SecurityException {
        this.setFilter(new IncludeXmppPackets());
        this.setFormatter(new Formatter());
        this.setLevel(Level.ALL);
    }

    static class Formatter
    extends java.util.logging.Formatter {
        final SimpleDateFormat stampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        Formatter() {
        }

        @Override
        public String format(LogRecord record) {
            Date when = Date.from(Instant.ofEpochMilli(record.getMillis()));
            String msg = record.getMessage();
            return String.format("%s: %s%n", this.stampFormat.format(when), msg);
        }
    }
}

