/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import java.io.IOException;
import java.io.InputStream;

class EntryInputStream
extends InputStream {
    private Iso9660FileEntry entry;
    private Iso9660FileSystem fileSystem;
    private long pos;
    private long rem;

    EntryInputStream(Iso9660FileEntry entry, Iso9660FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.entry = entry;
        this.pos = 0L;
        this.rem = entry.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        this.ensureOpen();
        if (this.rem <= 0L) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        int toRead = len;
        if ((long)toRead > this.rem) {
            toRead = (int)this.rem;
        }
        Iso9660FileSystem iso9660FileSystem = this.fileSystem;
        synchronized (iso9660FileSystem) {
            if (this.fileSystem.isClosed()) {
                throw new IOException("ISO file closed.");
            }
            read = this.fileSystem.readBytes(this.entry, this.pos, b, off, toRead);
        }
        if (read > 0) {
            this.pos += (long)read;
            this.rem -= (long)read;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == 1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public long skip(long n) {
        this.ensureOpen();
        long len = n > this.rem ? this.rem : n;
        this.pos += len;
        this.rem -= len;
        if (this.rem <= 0L) {
            this.close();
        }
        return len;
    }

    @Override
    public int available() {
        if (this.rem > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.rem < 0L) {
            return 0;
        }
        return (int)this.rem;
    }

    public long size() {
        this.ensureOpen();
        return this.entry.getSize();
    }

    @Override
    public void close() {
        this.rem = 0L;
        this.entry = null;
        this.fileSystem = null;
    }

    private void ensureOpen() {
        if (null == this.entry) {
            throw new IllegalStateException("stream has been closed");
        }
    }
}

