/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.ExtendedFileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileIdentifierDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DescriptorTag;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class UDFFileEntry
implements FileEntry {
    private UDFFileSystem fs;
    private FileEntryDescriptor icb;
    private String parentPath;
    private String entryName;
    private Boolean isRoot;

    public UDFFileEntry(UDFFileSystem fs, FileEntryDescriptor icb, String parentPath, String entryName) {
        this(fs, icb, parentPath, entryName, false);
    }

    public UDFFileEntry(UDFFileSystem fs, FileEntryDescriptor icb, String parentPath, String entryName, Boolean isRoot) {
        this.fs = fs;
        this.parentPath = parentPath;
        this.icb = icb;
        this.entryName = entryName;
        this.isRoot = isRoot;
    }

    public String getName() {
        if (this.isRoot.booleanValue()) {
            return "/";
        }
        return this.entryName;
    }

    public String getPath() {
        if (this.isRoot.booleanValue()) {
            return "/";
        }
        Path path = Paths.get(this.parentPath, new String[0]).resolve(this.entryName);
        return path.toString();
    }

    public long getLastModifiedTime() {
        return 0L;
    }

    public boolean isLink() {
        return this.icb.icbTag.fileType == 12;
    }

    public boolean isSymlink() {
        return false;
    }

    public boolean isDirectory() {
        return this.icb.icbTag.fileType == 4;
    }

    public long getSize() {
        return this.icb.infoLength.longValue();
    }

    public List<ExtentAD> getADs() {
        return this.icb.allocDescriptors;
    }

    public void loadFiles() throws IOException {
        if (this.isDirectory()) {
            this.icb.loadChildren(this.fs);
        }
    }

    public List<UDFFileEntry> getFiles() throws IOException {
        if (!this.isDirectory()) {
            return new ArrayList<UDFFileEntry>();
        }
        String currentPath = this.getPath();
        ArrayList<UDFFileEntry> files = new ArrayList<UDFFileEntry>();
        for (FileIdentifierDescriptor fid : this.icb.fids) {
            FileEntryDescriptor fed;
            Long relativeSectorNum = fid.icb.location.blockNumber;
            Long absSectorNum = relativeSectorNum + this.fs.getFSDloc();
            byte[] buffer = new byte[2048];
            this.fs.readBlock(absSectorNum, buffer);
            try {
                DescriptorTag tag = new DescriptorTag(buffer);
                fed = tag.identifier == 266 ? new ExtendedFileEntryDescriptor(buffer) : new FileEntryDescriptor(buffer);
            }
            catch (InvalidDescriptor ex) {
                throw new IOException("Invalid descriptor found at sector " + absSectorNum.toString());
            }
            String fileName = fid.fileId.toString();
            if (fileName.equals("")) continue;
            UDFFileEntry file = new UDFFileEntry(this.fs, fed, currentPath, fileName);
            files.add(file);
        }
        return files;
    }
}

