/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class ExtendedAttribute {
    public Long attributeType;
    public int attributeSubType;
    public Long attributeLength;
    public byte[] attributeRawData;
    public static final int MINIMUM_LENGTH = 12;

    public ExtendedAttribute(byte[] bytes) throws InvalidDescriptor {
        this.deserialize(bytes);
    }

    private void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 12) {
            throw new InvalidDescriptor("Extended attribute too short");
        }
        this.attributeType = UDFUtil.getUInt32(bytes, 0);
        this.attributeSubType = UDFUtil.getUInt8(bytes, 4);
        this.attributeLength = UDFUtil.getUInt32(bytes, 8);
        if (this.attributeLength > (long)bytes.length) {
            throw new InvalidDescriptor("Extended attributes too long");
        }
        this.attributeRawData = UDFUtil.getBytes(bytes, 12, this.attributeLength.intValue() - 12);
    }

    public String toString() {
        return "ExtendedAttribute [attributeType=" + this.attributeType + ", attributeSubType=" + this.attributeSubType + ", attributeLength=" + this.attributeLength + "]";
    }
}

