/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.index;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AppInfoBDMV {
    byte[] contentProviderData = new byte[32];
    InitialOutputModePreferenceType initialOutputModePreference = InitialOutputModePreferenceType.Mode2D;
    boolean ssContentExistFlag = false;
    VideoFormat videoFormat = VideoFormat.IGNORED;
    FrameRate frameRate = FrameRate.IGNORED;

    public InitialOutputModePreferenceType getInitialOutputModePreference() {
        return this.initialOutputModePreference;
    }

    public void setInitialOutputModePreference(InitialOutputModePreferenceType initialOutputModePreferenceType) {
        this.initialOutputModePreference = initialOutputModePreferenceType;
    }

    public boolean getSSContentExistFlag() {
        return this.ssContentExistFlag;
    }

    public void setSSContentExistFlag(boolean bl) {
        this.ssContentExistFlag = bl;
    }

    public VideoFormat getVideoFormat() {
        return this.videoFormat;
    }

    public void setVideoFormat(VideoFormat videoFormat) {
        this.videoFormat = videoFormat;
    }

    public FrameRate getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(FrameRate frameRate) {
        this.frameRate = frameRate;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(4);
        byte by = dataInputStream.readByte();
        this.initialOutputModePreference = (by & 0x40) != 0 ? InitialOutputModePreferenceType.Mode3D : InitialOutputModePreferenceType.Mode2D;
        this.ssContentExistFlag = (by & 0x20) != 0;
        by = dataInputStream.readByte();
        this.videoFormat = VideoFormat.getFromEncoding(by >> 4);
        this.frameRate = FrameRate.getFromEncoding(by & 0xF);
        dataInputStream.read(this.contentProviderData);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(34);
        int n = 0;
        if (this.initialOutputModePreference == InitialOutputModePreferenceType.Mode3D) {
            n |= 0x40;
        }
        if (this.ssContentExistFlag) {
            n |= 0x20;
        }
        dataOutputStream.writeByte(n);
        n = this.videoFormat.getEncoding() << 4;
        dataOutputStream.writeByte(n |= this.frameRate.getEncoding());
        dataOutputStream.write(this.contentProviderData);
    }

    public static final class FrameRate
    extends Enum<FrameRate> {
        public static final /* enum */ FrameRate IGNORED = new FrameRate();
        public static final /* enum */ FrameRate Hz_24000_1001 = new FrameRate();
        public static final /* enum */ FrameRate Hz_24 = new FrameRate();
        public static final /* enum */ FrameRate Hz_25 = new FrameRate();
        public static final /* enum */ FrameRate Hz_30000_1001 = new FrameRate();
        public static final /* enum */ FrameRate RESERVED_5 = new FrameRate();
        public static final /* enum */ FrameRate Hz_50 = new FrameRate();
        public static final /* enum */ FrameRate Hz_60000_1001 = new FrameRate();
        private static final /* synthetic */ FrameRate[] $VALUES;

        public static FrameRate[] values() {
            return (FrameRate[])$VALUES.clone();
        }

        public static FrameRate valueOf(String string) {
            return Enum.valueOf(FrameRate.class, string);
        }

        public int getEncoding() {
            return this.ordinal();
        }

        public static FrameRate getFromEncoding(int n) {
            FrameRate[] frameRateArray = FrameRate.values();
            for (int i = 0; i < frameRateArray.length; ++i) {
                if (frameRateArray[i].ordinal() != n) continue;
                return frameRateArray[i];
            }
            assert (false);
            return IGNORED;
        }

        static {
            $VALUES = new FrameRate[]{IGNORED, Hz_24000_1001, Hz_24, Hz_25, Hz_30000_1001, RESERVED_5, Hz_50, Hz_60000_1001};
        }
    }

    public static final class VideoFormat
    extends Enum<VideoFormat> {
        public static final /* enum */ VideoFormat IGNORED = new VideoFormat();
        public static final /* enum */ VideoFormat VIDEO_480i = new VideoFormat();
        public static final /* enum */ VideoFormat VIDEO_576i = new VideoFormat();
        public static final /* enum */ VideoFormat VIDEO_480p = new VideoFormat();
        public static final /* enum */ VideoFormat VIDEO_1080i = new VideoFormat();
        public static final /* enum */ VideoFormat VIDEO_720p = new VideoFormat();
        public static final /* enum */ VideoFormat VIDEO_1080p = new VideoFormat();
        public static final /* enum */ VideoFormat VIDEO_576p = new VideoFormat();
        private static final /* synthetic */ VideoFormat[] $VALUES;

        public static VideoFormat[] values() {
            return (VideoFormat[])$VALUES.clone();
        }

        public static VideoFormat valueOf(String string) {
            return Enum.valueOf(VideoFormat.class, string);
        }

        public int getEncoding() {
            return (byte)this.ordinal();
        }

        public static VideoFormat getFromEncoding(int n) {
            VideoFormat[] videoFormatArray = VideoFormat.values();
            for (int i = 0; i < videoFormatArray.length; ++i) {
                if (videoFormatArray[i].ordinal() != n) continue;
                return videoFormatArray[i];
            }
            assert (false);
            return IGNORED;
        }

        static {
            $VALUES = new VideoFormat[]{IGNORED, VIDEO_480i, VIDEO_576i, VIDEO_480p, VIDEO_1080i, VIDEO_720p, VIDEO_1080p, VIDEO_576p};
        }
    }

    public static enum InitialOutputModePreferenceType {
        Mode2D,
        Mode3D;

    }
}

