/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptorTag;
import java.util.ArrayList;
import java.util.List;

public class DescriptorTag {
    public static List<Integer> D_TYPES = new ArrayList<Integer>();
    public Integer identifier;
    public Integer version;
    public Integer checksum;
    public Integer serialNumber;
    public Integer crc;
    public Integer crcLength;
    public Long location;
    public static final int LENGTH = 16;

    public DescriptorTag(byte[] byArray) throws InvalidDescriptorTag {
        this.deserialize(byArray);
    }

    public void deserialize(byte[] byArray) throws InvalidDescriptorTag {
        if (byArray.length < 16) {
            throw new InvalidDescriptorTag("descriptor tag too short");
        }
        this.identifier = UDFUtil.getUInt16(byArray, 0);
        if (!D_TYPES.contains(this.identifier)) {
            throw new InvalidDescriptorTag("Unknown tag identifier: " + this.identifier);
        }
        this.version = UDFUtil.getUInt16(byArray, 2);
        this.checksum = UDFUtil.getUInt8(byArray, 4);
        this.serialNumber = UDFUtil.getUInt16(byArray, 6);
        this.crc = UDFUtil.getUInt16(byArray, 8);
        this.crcLength = UDFUtil.getUInt16(byArray, 10);
        this.location = UDFUtil.getUInt32(byArray, 12);
    }

    public String toString() {
        return "DescriptorTag [identifier=" + this.identifier + ", version=" + this.version + ", checksum=" + this.checksum + ", serialNumber=" + this.serialNumber + ", crc=" + this.crc + ", crcLength=" + this.crcLength + ", location=" + this.location + "]";
    }

    static {
        D_TYPES.add(1);
        D_TYPES.add(2);
        D_TYPES.add(3);
        D_TYPES.add(4);
        D_TYPES.add(5);
        D_TYPES.add(6);
        D_TYPES.add(7);
        D_TYPES.add(8);
        D_TYPES.add(9);
        D_TYPES.add(248);
        D_TYPES.add(249);
        D_TYPES.add(250);
        D_TYPES.add(251);
        D_TYPES.add(252);
        D_TYPES.add(256);
        D_TYPES.add(257);
        D_TYPES.add(258);
        D_TYPES.add(259);
        D_TYPES.add(260);
        D_TYPES.add(261);
        D_TYPES.add(262);
        D_TYPES.add(263);
        D_TYPES.add(264);
        D_TYPES.add(265);
        D_TYPES.add(266);
    }
}

