/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowEpisodeAndSeasonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeAndSeasonParser.class);
    private static final Pattern DATE_1 = Pattern.compile("([0-9]{4})[.-]([0-9]{2})[.-]([0-9]{2})", 2);
    private static final Pattern DATE_2 = Pattern.compile("([0-9]{2})[.-]([0-9]{2})[.-]([0-9]{4})", 2);
    public static final String[] SEASON_TRANSLATIONS = new String[]{"series", "season", "\u0627\u0644\u0645\u0648\u0633\u0645", "sez\u00f3na", "s\u00e6son", "staffel", "\u03c3\u03b5\u03b6\u03cc\u03bd", "temporada", "\u0641\u0635\u0644", "kausi", "saison", "sezona", "\u00e9vad", "\u00fe\u00e1ttar\u00f6\u00f0", "stagione", "\uc2dc\uc98c", "seizoen", "sesong", "sezon", "\u0441\u0435\u0437\u043e\u043d", "\u0441\u0435\u0437\u043e\u043d\u0430", "s\u00e4song", "\u0b9a\u0bc0\u0b9a\u0ba9\u0bcd"};
    public static final Pattern SEASON_LONG;
    public static final Pattern SEASON_ONLY;
    public static final Pattern EPISODE_ONLY;
    private static final Pattern EPISODE_PATTERN;
    private static final Pattern EPISODE_PATTERN_2;
    private static final Pattern EPISODE_PATTERN_NR;
    private static final Pattern ROMAN_PATTERN;
    private static final Pattern SEASON_MULTI_EP;
    private static final Pattern SEASON_MULTI_EP_2;
    private static final Pattern SEASON_EP_RANGE;
    private static final Pattern NUMBERS_2_PATTERN;
    private static final Pattern NUMBERS_3_PATTERN;
    private static final Pattern ANIME_PREPEND1;
    private static final Pattern ANIME_PREPEND2;
    private static final Pattern ANIME_PREPEND3;
    private static final Pattern ANIME_PREPEND4;
    private static final Pattern ANIME_PREPEND4_2;
    private static final Pattern ANIME_APPEND1;
    private static final Pattern ANIME_APPEND2;
    private static final Pattern ANIME_APPEND3;
    private static final Pattern ANIME_APPEND4;

    private TvShowEpisodeAndSeasonParser() {
        throw new IllegalAccessError();
    }

    public static String cleanEpisodeTitle(String titleToClean, String tvShowName) {
        Object basename = ParserUtils.removeStopwordsAndBadwordsFromTvEpisodeName(titleToClean.replaceAll("([\":<>|?*])", ""));
        basename = Utils.cleanFolderStackingMarkers((String)basename);
        Pattern regex = Pattern.compile("(.*[\\/\\\\])");
        Matcher m = regex.matcher((CharSequence)basename);
        if (m.find()) {
            basename = ((String)basename).replaceAll(regex.pattern(), "");
        }
        basename = (String)basename + " ";
        if (tvShowName != null && !tvShowName.isEmpty()) {
            tvShowName = tvShowName.replaceAll("([\":<>|?*])", "");
            basename = ((String)basename).replaceAll("(?i)^[^ES]" + Pattern.quote(tvShowName), "");
            String delimited = tvShowName.replaceAll("[ _.-]", "[ _.-]");
            basename = ((String)basename).replaceAll("(?i)^" + delimited, "");
        }
        basename = StrgUtils.replaceUnicodeCharactersInverse((String)basename);
        basename = ((String)basename).replaceFirst("\\.\\w{1,4}$", "");
        basename = ((String)basename).replaceFirst("[\\(\\[]\\d{4}[\\)\\]]", "");
        basename = ((String)basename).replaceFirst("[\\(\\[][A-Fa-f0-9]{8}[\\)\\]]", "");
        return TvShowEpisodeAndSeasonParser.removeEpisodeVariantsFromTitle((String)basename);
    }

    private static String removeEpisodeVariantsFromTitle(String title) {
        String[] splitted;
        StringBuilder backup = new StringBuilder(title);
        StringBuilder ret = new StringBuilder();
        title = title.replaceAll("[Ss]([0-9]+)[\\]\\[ _.-]*[Ee]([0-9]+)", "");
        title = title.replaceAll("[ _.-]()[Ee][Pp]?_?([0-9]+)", "");
        title = title.replaceAll("([0-9]{4})[.-]([0-9]{2})[.-]([0-9]{2})", "");
        title = title.replaceAll("([0-9]{2})[.-]([0-9]{2})[.-]([0-9]{4})", "");
        title = title.replaceAll("[\\\\/\\._ \\[\\(-]([0-9]+)x([0-9]+)", "");
        title = title.replaceAll("[\\/ _.-]p(?:ar)?t[ _.-]()([ivx]+)", "");
        title = title.replaceAll("[epx_-]+(\\d{1,3})", "");
        title = title.replaceAll("episode[\\. _-]*(\\d{1,3})", "");
        title = title.replaceAll("(part|pt)[\\._\\s]+([MDCLXVI]+)", "");
        title = title.replaceAll(SEASON_LONG.toString(), "");
        title = title.replaceAll("s(\\d{1,4})[ ]?((?:([epx_.-]+\\d{1,3})+))", "");
        title = title.replaceAll("(\\d{1,4})(?=x)((?:([epx]+\\d{1,3})+))", "");
        for (String s : splitted = StringUtils.split((String)title, (String)"[\\[\\]() _,.-]")) {
            if (MediaIdUtil.isValidImdbId(s)) {
                s = "";
            }
            ret.append(" ").append(s);
        }
        if (StringUtils.isEmpty((CharSequence)(ret = new StringBuilder(ret.toString().strip())).toString())) {
            String[] b = StringUtils.split((String)backup.toString(), (String)"[\\[\\]() _,.-]");
            backup = new StringBuilder();
            for (String s : b) {
                backup.append(" ").append(s);
            }
            ret = new StringBuilder(backup.toString().strip());
        }
        return ret.toString();
    }

    public static EpisodeMatchingResult detectEpisodeFromFilename(String name, String showname) {
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        String nameNoExt = name.replaceFirst("\\.\\w{1,4}$", "");
        result = TvShowEpisodeAndSeasonParser.parseAnimeExclusive(result, nameNoExt);
        if (!result.episodes.isEmpty()) {
            if (result.date == null) {
                EpisodeMatchingResult add = new EpisodeMatchingResult();
                TvShowEpisodeAndSeasonParser.parseDatePattern(add, name);
                if (add.date != null) {
                    result.date = add.date;
                }
            }
            return result;
        }
        result = TvShowEpisodeAndSeasonParser.detect(FilenameUtils.getName((String)name), showname);
        if (!result.episodes.isEmpty() && result.season == -1) {
            EpisodeMatchingResult result2 = TvShowEpisodeAndSeasonParser.detect(name, showname);
            if (result2.season != -1 && result2.episodes.size() == result.episodes.size()) {
                result = result2;
            } else {
                result.season = result2.season;
                result = TvShowEpisodeAndSeasonParser.parseAnimeNoHash(result, name);
            }
        } else if (result.episodes.isEmpty() && result.date == null) {
            result = TvShowEpisodeAndSeasonParser.detect(name, showname);
        }
        if (result.date == null) {
            EpisodeMatchingResult add = new EpisodeMatchingResult();
            TvShowEpisodeAndSeasonParser.parseDatePattern(add, name);
            if (add.date != null) {
                result.date = add.date;
            }
        }
        if (!result.episodes.isEmpty() && !result.episodes.contains(-1) && result.season == -1) {
            result.season = 1;
        }
        return result;
    }

    private static EpisodeMatchingResult detect(String name, String showname) {
        int i;
        LOGGER.debug("parsing '{}'", (Object)name);
        EpisodeMatchingResult result = new EpisodeMatchingResult();
        String filename = FilenameUtils.getName((String)name);
        if (filename.toLowerCase(Locale.ROOT).matches("(video_ts|vts_\\d\\d_\\d)\\.(vob|bup|ifo)") || filename.toLowerCase(Locale.ROOT).matches("(index\\.bdmv|movieobject\\.bdmv|\\d{5}\\.m2ts)")) {
            name = FilenameUtils.getPath((String)name);
        }
        Object basename = ParserUtils.removeStopwordsAndBadwordsFromTvEpisodeName(name);
        Object foldername = "";
        Pattern regex = Pattern.compile("(.*[\\/\\\\])");
        Matcher m = regex.matcher((CharSequence)basename);
        if (m.find()) {
            foldername = m.group(1);
            basename = ((String)basename).replaceAll(regex.pattern(), "");
        }
        if (((String)basename).isEmpty() && ((String)foldername).isEmpty()) {
            return result;
        }
        basename = ((String)basename).replaceFirst("\\.\\w{1,4}$", "");
        basename = ((String)basename).replaceFirst("[\\(\\[]\\d{4}[\\)\\]]", "");
        basename = ((String)basename).replaceFirst("[\\(\\[][A-Fa-f0-9]{8}[\\)\\]]", "");
        basename = " " + (String)basename + " ";
        foldername = " " + (String)foldername + " ";
        result.stackingMarkerFound = !Utils.getStackingMarker(filename).isEmpty();
        result.name = ((String)basename).strip();
        result = TvShowEpisodeAndSeasonParser.parseSeasonMultiEPRange(result, (String)basename + (String)foldername);
        result = TvShowEpisodeAndSeasonParser.parseSeasonMultiEP(result, (String)basename + (String)foldername);
        result = TvShowEpisodeAndSeasonParser.parseSeasonMultiEP2(result, (String)basename + (String)foldername);
        result = TvShowEpisodeAndSeasonParser.parseSeasonLong(result, (String)basename + (String)foldername);
        if (result.season != -1) {
            basename = ((String)basename).replaceAll("(?i)" + SEASON_LONG.toString(), "");
            foldername = ((String)foldername).replaceAll("(?i)" + SEASON_LONG.toString(), "");
        }
        result = TvShowEpisodeAndSeasonParser.parseEpisodePattern(result, (String)basename);
        if (result.season == -1 && !StringUtils.isBlank((CharSequence)foldername)) {
            result = TvShowEpisodeAndSeasonParser.parseSeasonOnly(result, (String)foldername);
        }
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        if (showname != null && !showname.isEmpty()) {
            basename = ((String)basename).replaceAll("(?i)[^ES]" + Pattern.quote(showname), "");
            foldername = ((String)foldername).replaceAll("(?i)[^ES]" + Pattern.quote(showname), "");
            try {
                showname = showname.replaceAll("[ _.-]", "[ _.-]");
                foldername = ((String)foldername).replaceAll("(?i)" + showname, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        result = TvShowEpisodeAndSeasonParser.parseRoman(result, (String)basename);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        result = TvShowEpisodeAndSeasonParser.parseDatePattern(result, (String)basename);
        if (result.date != null) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        MediaFile mf = new MediaFile();
        mf.setFilename(filename);
        if (mf.isDiscFile()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        if (result.season == -1) {
            result = TvShowEpisodeAndSeasonParser.parseSeasonOnly(result, (String)basename + (String)foldername);
            if (result.season != -1) {
                foldername = ((String)foldername).replaceAll("(?i)" + SEASON_ONLY.toString(), "");
                basename = ((String)basename).replaceAll("(?i)" + SEASON_ONLY.toString(), "");
            }
        }
        if (result.episodes.isEmpty()) {
            result = TvShowEpisodeAndSeasonParser.parseEpisodeOnly(result, (String)basename);
        }
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        ArrayList<String> numbersOnly = new ArrayList<String>();
        String optionals = "[\\[\\{](.*?)[\\]\\}]";
        String woOptionals = ((String)basename).replaceAll(optionals, "");
        numbersOnly.addAll(Arrays.asList(woOptionals.split("[\\s\\|_.-]")));
        for (i = numbersOnly.size() - 1; i >= 0; --i) {
            if (!((String)numbersOnly.get(i)).isEmpty() && !((String)numbersOnly.get(i)).matches(".*?\\D.*?")) continue;
            numbersOnly.remove(i);
        }
        if (numbersOnly.isEmpty()) {
            regex = Pattern.compile(optionals);
            m = regex.matcher((CharSequence)basename);
            while (m.find()) {
                String delimitedNumbers = " " + m.group(1) + " ";
                numbersOnly.addAll(Arrays.asList(delimitedNumbers.split("[\\s\\|_.-]")));
            }
        }
        for (i = numbersOnly.size() - 1; i >= 0; --i) {
            if (!((String)numbersOnly.get(i)).isEmpty() && !((String)numbersOnly.get(i)).matches(".*?\\D.*?")) continue;
            numbersOnly.remove(i);
        }
        Collections.reverse(numbersOnly);
        result = TvShowEpisodeAndSeasonParser.parseNumbers4(result, numbersOnly);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        result = TvShowEpisodeAndSeasonParser.parseNumbers3(result, numbersOnly);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        result = TvShowEpisodeAndSeasonParser.parseNumbers2(result, numbersOnly);
        if (!result.episodes.isEmpty()) {
            return TvShowEpisodeAndSeasonParser.postClean(result);
        }
        result = TvShowEpisodeAndSeasonParser.parseNumbers1(result, numbersOnly);
        return TvShowEpisodeAndSeasonParser.postClean(result);
    }

    private static EpisodeMatchingResult parseNumbers1(EpisodeMatchingResult result, List<String> numbersOnly) {
        for (String num : numbersOnly) {
            if (num.length() != 1) continue;
            int ep = Integer.parseInt(num);
            if (ep > 0 && !result.episodes.contains(ep)) {
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
            return result;
        }
        return result;
    }

    private static EpisodeMatchingResult parseNumbers2(EpisodeMatchingResult result, List<String> numbersOnly) {
        for (String num : numbersOnly) {
            if (num.length() != 2) continue;
            int ep = Integer.parseInt(num);
            if (ep > 0 && !result.episodes.contains(ep)) {
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
            return result;
        }
        return result;
    }

    private static EpisodeMatchingResult parseNumbers3(EpisodeMatchingResult result, List<String> numbersOnly) {
        for (String num : numbersOnly) {
            if (num.length() != 3) continue;
            int s = Integer.parseInt(num.substring(0, 1));
            int ep = Integer.parseInt(num.substring(1));
            if (result.season != -1 && result.season != s) continue;
            if (ep > 0 && !result.episodes.contains(ep)) {
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
            LOGGER.trace("add found season '{}'", (Object)s);
            result.season = s;
        }
        return result;
    }

    private static EpisodeMatchingResult parseNumbers4(EpisodeMatchingResult result, List<String> numbersOnly) {
        for (String num : numbersOnly) {
            if (num.length() != 4) continue;
            int s = Integer.parseInt(num.substring(0, 2));
            int ep = Integer.parseInt(num.substring(2));
            if (result.season != s || ep <= 0 || result.episodes.contains(ep)) continue;
            result.episodes.add(ep);
            LOGGER.trace("add found EP '{}'", (Object)ep);
        }
        return result;
    }

    private static EpisodeMatchingResult parseDatePattern(EpisodeMatchingResult result, String name) {
        Matcher m = DATE_1.matcher(name);
        if (m.find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(1));
                result.date = new SimpleDateFormat("yyyy-MM-dd").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
            catch (NumberFormatException | ParseException exception) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found year as season '{}', date: '{}'", (Object)s, (Object)result.date);
            return result;
        }
        m = DATE_2.matcher(name);
        if (m.find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(3));
                result.date = new SimpleDateFormat("dd-MM-yyyy").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
            catch (NumberFormatException | ParseException exception) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found year as season '{}', date: '{}'", (Object)s, (Object)result.date);
            return result;
        }
        return result;
    }

    private static EpisodeMatchingResult parseRoman(EpisodeMatchingResult result, String name) {
        if (result.episodes.isEmpty()) {
            Pattern regex = ROMAN_PATTERN;
            Matcher m = regex.matcher(name);
            while (m.find()) {
                int ep = 0;
                ep = TvShowEpisodeAndSeasonParser.decodeRoman(m.group(2));
                if (ep <= 0 || result.episodes.contains(ep)) continue;
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
        }
        return result;
    }

    private static EpisodeMatchingResult parseEpisodePattern(EpisodeMatchingResult result, String name) {
        int ep;
        Matcher m;
        Pattern regex;
        if (result.episodes.isEmpty()) {
            regex = EPISODE_PATTERN_NR;
            m = regex.matcher(name);
            while (m.find()) {
                ep = 0;
                try {
                    ep = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int max = 0;
                try {
                    max = Integer.parseInt(m.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ep <= 0 || result.episodes.contains(ep) || ep > max) continue;
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
        }
        if (result.episodes.isEmpty()) {
            regex = EPISODE_PATTERN_2;
            m = regex.matcher(name);
            while (m.find()) {
                ep = 0;
                try {
                    ep = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ep <= 0 || result.episodes.contains(ep)) continue;
                result.episodes.add(ep);
                LOGGER.trace("add found EP '{}'", (Object)ep);
            }
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonMultiEP2(EpisodeMatchingResult result, String name) {
        Pattern regex = SEASON_MULTI_EP_2;
        Matcher m = regex.matcher(name);
        while (m.find()) {
            int s = -1;
            try {
                s = Integer.parseInt(m.group(1));
                if (m.group(2) != null && result.season < 0) {
                    result.season = s;
                    LOGGER.trace("add found season '{}", (Object)s);
                }
                if (result.season == s) {
                    String eps = m.group(2);
                    Pattern regex2 = EPISODE_PATTERN;
                    Matcher m2 = regex2.matcher(eps);
                    while (m2.find()) {
                        int ep = 0;
                        try {
                            ep = Integer.parseInt(m2.group(1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (ep <= 0 || result.episodes.contains(ep)) continue;
                        result.episodes.add(ep);
                        LOGGER.trace("add found EP '{}'", (Object)ep);
                    }
                    continue;
                }
                LOGGER.trace("also found season {}, but we already have a season {} - ignoring", (Object)s, (Object)result.season);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonMultiEP(EpisodeMatchingResult result, String name) {
        Pattern regex = SEASON_MULTI_EP;
        Matcher m = regex.matcher(name);
        while (m.find()) {
            int s = -1;
            try {
                s = Integer.parseInt(m.group(1));
                if (result.season < 0) {
                    result.season = s;
                    LOGGER.trace("add found season '{}", (Object)s);
                }
                if (result.season == s) {
                    String eps = m.group(2);
                    Pattern regex2 = EPISODE_PATTERN;
                    Matcher m2 = regex2.matcher(eps);
                    while (m2.find()) {
                        int ep = -1;
                        try {
                            ep = Integer.parseInt(m2.group(1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (ep <= -1 || result.episodes.contains(ep)) continue;
                        result.episodes.add(ep);
                        LOGGER.trace("add found EP '{}'", (Object)ep);
                    }
                    continue;
                }
                LOGGER.trace("also found season {}, but we already have a season {} - ignoring", (Object)s, (Object)result.season);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonMultiEPRange(EpisodeMatchingResult result, String name) {
        Matcher m = SEASON_EP_RANGE.matcher(name);
        while (m.find()) {
            try {
                int s = Integer.parseInt(m.group(1));
                int startEp = Integer.parseInt(m.group(2));
                int endEp = Integer.parseInt(m.group(3));
                if (endEp <= startEp) continue;
                if (result.season < 0) {
                    result.season = s;
                    LOGGER.trace("add found season '{}'(range)", (Object)s);
                }
                if (result.season != s) continue;
                for (int ep = startEp; ep <= endEp; ++ep) {
                    if (ep <= -1 || result.episodes.contains(ep)) continue;
                    result.episodes.add(ep);
                    LOGGER.trace("add found EP '{}'(range)", (Object)ep);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return result;
    }

    private static EpisodeMatchingResult parseEpisodeOnly(EpisodeMatchingResult result, String name) {
        Matcher m = EPISODE_ONLY.matcher(name);
        if (m.find()) {
            try {
                int e = Integer.parseInt(m.group(1));
                result.episodes.add(e);
                LOGGER.trace("add found episode '{}'", (Object)e);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonLong(EpisodeMatchingResult result, String name) {
        Matcher m;
        if (result.season == -1 && (m = SEASON_LONG.matcher(name)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found season '{}'", (Object)s);
        }
        return result;
    }

    private static EpisodeMatchingResult parseSeasonOnly(EpisodeMatchingResult result, String name) {
        Matcher m;
        if (result.season == -1 && (m = SEASON_ONLY.matcher(name)).find()) {
            int s = result.season;
            try {
                s = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            result.season = s;
            LOGGER.trace("add found season '{}'", (Object)s);
        }
        return result;
    }

    private static EpisodeMatchingResult parseAnimeExclusive(EpisodeMatchingResult result, String name) {
        int ep2;
        Matcher m = ANIME_PREPEND1.matcher(name);
        if (m.find()) {
            try {
                LOGGER.debug("parsed as Anime PREPEND1 '{}'", (Object)name);
                ep2 = Integer.parseInt(m.group(2));
                result.episodes.add(ep2);
                result.season = 0;
            }
            catch (NumberFormatException ep2) {
                // empty catch block
            }
        }
        if (result.episodes.isEmpty() && (m = ANIME_PREPEND2.matcher(name)).find()) {
            LOGGER.debug("parsed as Anime PREPEND2 '{}'", (Object)name);
            try {
                ep2 = Integer.parseInt(m.group(2));
                result.episodes.add(ep2);
                result.season = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException ep3) {
                // empty catch block
            }
        }
        if (result.episodes.isEmpty() && (m = ANIME_PREPEND3.matcher(name)).find()) {
            LOGGER.debug("parsed as Anime PREPEND3 '{}'", (Object)name);
            try {
                int ep4 = Integer.parseInt(m.group(2));
                result.episodes.add(ep4);
                result.season = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException ep4) {
                // empty catch block
            }
        }
        if (result.episodes.isEmpty() && (m = ANIME_PREPEND4.matcher(name)).find()) {
            LOGGER.debug("parsed as Anime PREPEND4 '{}'", (Object)name);
            try {
                int ep5 = Integer.parseInt(m.group(2));
                result.episodes.add(ep5);
                result.season = 1;
                m = ANIME_PREPEND4_2.matcher(name);
                if (m.find()) {
                    String[] nums;
                    LOGGER.debug("parsed as Anime PREPEND4_2 '{}'", (Object)name);
                    for (String num : nums = m.group(1).split("-")) {
                        ep5 = Integer.parseInt(num);
                        if (result.episodes.contains(ep5)) continue;
                        result.episodes.add(ep5);
                    }
                    Collections.sort(result.episodes);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static EpisodeMatchingResult parseAnimeNoHash(EpisodeMatchingResult result, String name) {
        int ep2;
        Matcher m = ANIME_APPEND1.matcher(name);
        if (m.find()) {
            LOGGER.debug("parsed as Anime APPEND1 '{}'", (Object)name);
            try {
                ep2 = Integer.parseInt(m.group(2));
                if (!result.episodes.contains(ep2)) {
                    result.episodes.add(ep2);
                }
                result.season = 0;
            }
            catch (NumberFormatException ep2) {
                // empty catch block
            }
        }
        if ((result.episodes.isEmpty() || result.season == -1) && (m = ANIME_APPEND2.matcher(name)).find()) {
            LOGGER.debug("parsed as Anime APPEND2 '{}'", (Object)name);
            try {
                ep2 = Integer.parseInt(m.group(2));
                if (!result.episodes.contains(ep2)) {
                    result.episodes.add(ep2);
                }
                result.season = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException ep3) {
                // empty catch block
            }
        }
        if ((result.episodes.isEmpty() || result.season == -1) && (m = ANIME_APPEND3.matcher(name)).find()) {
            LOGGER.debug("parsed as Anime APPEND3 '{}'", (Object)name);
            try {
                int ep4 = Integer.parseInt(m.group(2));
                if (!result.episodes.contains(ep4)) {
                    result.episodes.add(ep4);
                }
                result.season = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException ep4) {
                // empty catch block
            }
        }
        if ((result.episodes.isEmpty() || result.season == -1) && (m = ANIME_APPEND4.matcher(name)).find()) {
            LOGGER.debug("parsed as Anime APPEND4 '{}'", (Object)name);
            try {
                int ep5 = Integer.parseInt(m.group(2));
                if (ep5 > 0 && !result.episodes.contains(ep5)) {
                    result.episodes.add(ep5);
                }
                result.season = 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static EpisodeMatchingResult postClean(EpisodeMatchingResult emr) {
        emr.cleanedName = TvShowEpisodeAndSeasonParser.cleanFilename(emr.name, new Pattern[]{SEASON_LONG, SEASON_MULTI_EP, SEASON_MULTI_EP_2, EPISODE_PATTERN, EPISODE_PATTERN_2, NUMBERS_3_PATTERN, NUMBERS_2_PATTERN, ROMAN_PATTERN, DATE_1, DATE_2, SEASON_ONLY, SEASON_EP_RANGE});
        Collections.sort(emr.episodes);
        LOGGER.trace("returning result '{}'", (Object)emr);
        return emr;
    }

    private static String cleanFilename(String name, Pattern[] patterns) {
        String result = name;
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(result);
            if (!matcher.find()) continue;
            result = matcher.replaceFirst("");
        }
        result = result.replaceAll("^[ \\.\\-_]+", "");
        result = result.replaceAll("[ \\.\\-_]+$", "");
        return result;
    }

    private static int decodeSingleRoman(char letter) {
        switch (letter) {
            case 'M': {
                return 1000;
            }
            case 'D': {
                return 500;
            }
            case 'C': {
                return 100;
            }
            case 'L': {
                return 50;
            }
            case 'X': {
                return 10;
            }
            case 'V': {
                return 5;
            }
            case 'I': {
                return 1;
            }
        }
        return 0;
    }

    public static int decodeRoman(String roman) {
        int result = 0;
        String uRoman = roman.toUpperCase(Locale.ROOT);
        for (int i = 0; i < uRoman.length() - 1; ++i) {
            if (TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i)) < TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i + 1))) {
                result -= TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i));
                continue;
            }
            result += TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(i));
        }
        return result += TvShowEpisodeAndSeasonParser.decodeSingleRoman(uRoman.charAt(uRoman.length() - 1));
    }

    static {
        Object regex = Arrays.stream(SEASON_TRANSLATIONS).collect(Collectors.joining("|"));
        regex = "(" + (String)regex + ")[\\s_.-]?(\\d{1,4})";
        SEASON_LONG = Pattern.compile((String)regex, 2);
        SEASON_ONLY = Pattern.compile("[\\s_.-]s[\\s_.-]?(\\d{1,4})", 2);
        EPISODE_ONLY = Pattern.compile("[\\s_.-]ep?[\\s_.-]?(\\d{1,4})", 2);
        EPISODE_PATTERN = Pattern.compile("[epx_-]+(\\d{1,4})", 2);
        EPISODE_PATTERN_2 = Pattern.compile("(?:episode|ep)[\\. _-]*(\\d{1,4})", 2);
        EPISODE_PATTERN_NR = Pattern.compile("(\\d{1,2})[\u29f8/](\\d{1,2})", 2);
        ROMAN_PATTERN = Pattern.compile("(part|pt)[\\._\\s]+([MDCLXVI]+)", 2);
        SEASON_MULTI_EP = Pattern.compile("s(\\d{1,4})[ _]?((?:([epx.-]+\\d{1,4})+))", 2);
        SEASON_MULTI_EP_2 = Pattern.compile("(\\d{1,4})(?=x)((?:([epx]+\\d{1,4})+))", 2);
        SEASON_EP_RANGE = Pattern.compile("s(\\d{1,4})[ _]?[eE](\\d{1,4})-(\\d{1,4})", 2);
        NUMBERS_2_PATTERN = Pattern.compile("([0-9]{2})", 2);
        NUMBERS_3_PATTERN = Pattern.compile("([0-9])([0-9]{2})", 2);
        ANIME_PREPEND1 = Pattern.compile("(Special|SP|OVA|OAV|Picture Drama)(?:[ _.-]*(?:ep?[ .]?)?(\\d{1,4})(?:[_ ]?v\\d+)?)+(?=\\b|_)[^])}]*?(?:[\\[({][^])}]+[\\])}][ _.-]*)*?(?:[\\[({][\\da-f]{8}[\\])}])", 2);
        ANIME_PREPEND2 = Pattern.compile("(?:S(?:eason)?\\s*(?=\\d))?(Specials|\\d{1,3})[\\/](?:[^\\/]+[\\/])*[^\\/]+(?:\\b|_)(?:[ _.-]*(?:ep?[ .]?)?(\\d{1,4})(?:[_ ]?v\\d+)?)+(?=\\b|_)[^])}]*?(?:[\\[({][^])}]+[\\])}][ _.-]*)*?(?:[\\[({][\\da-f]{8}[\\])}])", 2);
        ANIME_PREPEND3 = Pattern.compile("[-._ ]+S(?:eason ?)?(\\d{1,3})(?:[ _.-]*(?:ep?[ .]?)?(\\d{1,4})(?:[_ ]?v\\d+)?)+(?=\\b|_)[^])}]*?(?:[\\[({][^])}]+[\\])}][ _.-]*)*?(?:[\\[({][\\da-f]{8}[\\])}])", 2);
        ANIME_PREPEND4 = Pattern.compile("((?=\\b|_))(?:[ _.-]*(?:ep?[ .]?)?(\\d{1,4})(?:-(\\d{1,3}))?(?:[_ ]?v\\d+)?)+(?=\\b|_)[^])}]*?(?:[\\[({][^])}]+[\\])}][ _.-]*)*?(?:[\\[({][\\da-f]{8}[\\])}])", 2);
        ANIME_PREPEND4_2 = Pattern.compile("((\\d{1,3})(?:-(\\d{1,3})){1,10})");
        ANIME_APPEND1 = Pattern.compile("(Special|SP|OVA|OAV|Picture Drama)(?:[ _.-]*(?:ep?[ .]?)?(\\d{1,4})(?:[_ ]?v\\d+)?)+(?=\\b|_)[^\\])}]*?(?:[\\[({][^\\])}]+[\\])}][ _.-]*)*?[^\\]\\[)(}{\\\\/]*$", 2);
        ANIME_APPEND2 = Pattern.compile("(?:S(?:eason)?\\s*(?=\\d))?(Specials|\\d{1,3})[\\\\/](?:[^\\\\/]+[\\\\/])*[^\\\\/]+(?:\\b|_)[ _.-]*(?:ep?[ .]?)?(\\d{1,4})(?:[_ ]?v\\d+)?(?:\\b|_)[^\\])}]*?(?:[\\[({][^\\])}]+[\\])}][ _.-]*)*?[^\\]\\[)(}{\\\\/]*$", 2);
        ANIME_APPEND3 = Pattern.compile("[-._ ]+S(?:eason ?)?(\\d{1,3})(?:[ _.-]*(?:ep?[ .]?)?(\\d{1,4})(?:[_ ]?v\\d+)?)+(?=\\b|_)[^\\])}]*?(?:[\\[({][^\\])}]+[\\])}][ _.-]*)*?[^\\]\\[)(}{\\\\/]*$", 2);
        ANIME_APPEND4 = Pattern.compile("((?=\\b|_))(?:[ _.-]*(?:ep?[ .]?)?(\\d{1,4})(?:[_ ]?v\\d+)?)+(?=\\b|_)[^\\])}]*?(?:[\\[({][^\\])}]+[\\])}][ _.-]*)*?[^\\]\\[)(}{\\\\/]*$", 2);
    }

    public static class EpisodeMatchingResult {
        public int season = -1;
        public List<Integer> episodes = new ArrayList<Integer>();
        public String name = "";
        public String cleanedName = "";
        public Date date = null;
        public boolean stackingMarkerFound = false;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

