/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.time;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.time.TimePoint;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public final class Timeout {
    private static final Timeout INFINITE = new Timeout(-1L, null);
    private static final Timeout IMMEDIATE = new Timeout(0L, null);
    private final long durationNanos;
    @Nullable
    private final TimePoint start;

    private Timeout(long durationNanos, @Nullable TimePoint start) {
        this.durationNanos = durationNanos;
        this.start = start;
    }

    public static Timeout started(long duration, TimeUnit unit, TimePoint at) {
        return Timeout.started(unit.toNanos(duration), Assertions.assertNotNull(at));
    }

    public static Timeout started(long durationNanos, TimePoint at) {
        if (durationNanos < 0L || durationNanos == Long.MAX_VALUE) {
            return Timeout.infinite();
        }
        if (durationNanos == 0L) {
            return Timeout.immediate();
        }
        return new Timeout(durationNanos, Assertions.assertNotNull(at));
    }

    public static Timeout startNow(long duration, TimeUnit unit) {
        return Timeout.started(duration, unit, TimePoint.now());
    }

    public static Timeout startNow(long durationNanos) {
        return Timeout.started(durationNanos, TimePoint.now());
    }

    public static Timeout infinite() {
        return INFINITE;
    }

    public static Timeout immediate() {
        return IMMEDIATE;
    }

    long remainingNanos(TimePoint now) {
        return Math.max(0L, this.durationNanos - now.durationSince(Assertions.assertNotNull(this.start)).toNanos());
    }

    public long remaining(TimeUnit unit) {
        Assertions.assertFalse(this.isInfinite());
        return this.isImmediate() ? 0L : Timeout.convertRoundUp(this.remainingNanos(TimePoint.now()), unit);
    }

    public long remainingOrInfinite(TimeUnit unit) {
        return this.isInfinite() ? -1L : this.remaining(unit);
    }

    public boolean expired() {
        return Timeout.expired(this.remainingOrInfinite(TimeUnit.NANOSECONDS));
    }

    public static boolean expired(long remaining) {
        return remaining == 0L;
    }

    public boolean isInfinite() {
        return this.equals(INFINITE);
    }

    public boolean isImmediate() {
        return this.equals(IMMEDIATE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timeout other = (Timeout)o;
        return this.durationNanos == other.durationNanos && Objects.equals(this.start, other.start());
    }

    public int hashCode() {
        return Objects.hash(this.durationNanos, this.start);
    }

    public String toString() {
        return "Timeout{durationNanos=" + this.durationNanos + ", start=" + this.start + '}';
    }

    public String toUserString() {
        if (this.isInfinite()) {
            return "infinite";
        }
        if (this.isImmediate()) {
            return "0 ms (immediate)";
        }
        return Timeout.convertRoundUp(this.durationNanos, TimeUnit.MILLISECONDS) + " ms";
    }

    long durationNanos() {
        return this.durationNanos;
    }

    @Nullable
    TimePoint start() {
        return this.start;
    }

    static long convertRoundUp(long nonNegativeNanos, TimeUnit unit) {
        Assertions.assertTrue(nonNegativeNanos >= 0L);
        if (unit == TimeUnit.NANOSECONDS) {
            return nonNegativeNanos;
        }
        long trimmed = unit.convert(nonNegativeNanos, TimeUnit.NANOSECONDS);
        return TimeUnit.NANOSECONDS.convert(trimmed, unit) < nonNegativeNanos ? trimmed + 1L : trimmed;
    }
}

