/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal;

import com.mongodb.MongoInterruptedException;
import com.mongodb.internal.CheckedSupplier;
import com.mongodb.internal.thread.InterruptionUtil;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class Locks {
    public static void withLock(Lock lock, Runnable action) {
        Locks.withLock(lock, () -> {
            action.run();
            return null;
        });
    }

    public static <V> V withLock(Lock lock, Supplier<V> supplier) {
        return (V)Locks.checkedWithLock(lock, supplier::get);
    }

    public static <V, E extends Exception> V checkedWithLock(Lock lock, CheckedSupplier<V, E> supplier) throws E {
        lock.lock();
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public static void withInterruptibleLock(Lock lock, Runnable action) throws MongoInterruptedException {
        Locks.withInterruptibleLock(lock, () -> {
            action.run();
            return null;
        });
    }

    public static <V> V withInterruptibleLock(Lock lock, Supplier<V> supplier) throws MongoInterruptedException {
        return (V)Locks.checkedWithInterruptibleLock(lock, supplier::get);
    }

    public static <V, E extends Exception> V checkedWithInterruptibleLock(Lock lock, CheckedSupplier<V, E> supplier) throws MongoInterruptedException, E {
        Locks.lockInterruptibly(lock);
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    public static void lockInterruptibly(Lock lock) throws MongoInterruptedException {
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException("Interrupted waiting for lock", e);
        }
    }

    public static void withUnfairLock(ReentrantLock lock, Runnable action) {
        Locks.withUnfairLock(lock, () -> {
            action.run();
            return null;
        });
    }

    public static <V> V withUnfairLock(ReentrantLock lock, Supplier<V> supplier) {
        Locks.lockUnfair(lock);
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private static void lockUnfair(ReentrantLock lock) {
        if (!lock.tryLock()) {
            lock.lock();
        }
    }

    public static void lockInterruptiblyUnfair(ReentrantLock lock) throws MongoInterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException(null, null);
        }
        if (!lock.tryLock()) {
            Locks.lockInterruptibly(lock);
        }
    }

    private Locks() {
    }
}

