/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.lan;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.ace.Q;
import com.ubnt.data.Ipv6RaPriority;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.SettingPreference;
import com.ubnt.model.M.super.new;
import com.ubnt.model.M.super.oOOO;
import com.ubnt.model.api.lan.ImmutableLanConfigurationDto;
import com.ubnt.model.api.network.configuration.NetworkPurpose;
import com.ubnt.return.F;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableLanConfigurationDto.Builder.class)
@Schema(name="LAN Configuration")
@Value.Immutable
@F
public interface LanConfigurationDto {
    @JsonProperty(value="purpose")
    public NetworkPurpose purpose();

    @JsonProperty(value="setting_preference")
    public Optional<SettingPreference> settingPreference();

    @JsonProperty(value="auto_scale_enabled")
    public boolean autoScaleEnabled();

    @JsonProperty(value="dhcpd_enabled")
    public boolean dhcpdEnabled();

    @JsonProperty(value="dhcpdv6_enabled")
    public boolean dhcpdV6Enabled();

    @JsonProperty(value="dhcpguard_enabled")
    public boolean dhcpGuardEnabled();

    @JsonProperty(value="domain_name")
    public Optional<String> domainName();

    @JsonProperty(value="igmp_snooping")
    public boolean igmpSnooping();

    @JsonProperty(value="ipv6_interface_type")
    public oOOO ipv6InterfaceType();

    @JsonProperty(value="ipv6_ra_enabled")
    public boolean ipv6RaEnabled();

    @JsonProperty(value="is_nat")
    public boolean isNat();

    @JsonProperty(value="mdns_enabled")
    public boolean multicastDnsEnabled();

    @JsonProperty(value="dhcpd_boot_enabled")
    public boolean dhcpdBootEnabled();

    @JsonProperty(value="dhcp_relay_enabled")
    public boolean dhcpRelayEnabled();

    @JsonProperty(value="dhcpd_dns_enabled")
    public boolean dhcpdDnsEnabled();

    @JsonProperty(value="dhcpd_gateway_enabled")
    public boolean dhcpdGatewayEnabled();

    @JsonProperty(value="dhcpd_leasetime")
    public int dhcpdLeasetime();

    @JsonProperty(value="dhcpd_ntp_enabled")
    public boolean dhcpNtpEnabled();

    @JsonProperty(value="dhcpd_tftp_server")
    public String dhcpdTftpServer();

    @JsonProperty(value="dhcpd_time_offset_enabled")
    public boolean dhcpdTimeOffsetEnabled();

    @JsonProperty(value="dhcpd_unifi_controller")
    public String dhcpdUnifiController();

    @JsonProperty(value="dhcpd_wins_enabled")
    public boolean dhcpdWinsEnabled();

    @JsonProperty(value="dhcpd_wpad_url")
    public String dhcpdWpadUrl();

    @JsonProperty(value="dhcpd_conflict_checking")
    public boolean dhcpdConflictChecking();

    @JsonProperty(value="dhcpdv6_dns_auto")
    public boolean dhcpdV6DnsAuto();

    @JsonProperty(value="dhcpdv6_leasetime")
    public int dhcpdV6Leasetime();

    @JsonProperty(value="ipv6_pd_interface")
    public String ipv6PdInterface();

    @JsonProperty(value="ipv6_pd_start")
    public String ipv6PdStart();

    @JsonProperty(value="ipv6_pd_stop")
    public String ipv6PdStop();

    @JsonProperty(value="ipv6_ra_preferred_lifetime")
    public String ipv6RaPreferredLifetime();

    @JsonProperty(value="ipv6_ra_priority")
    public Ipv6RaPriority ipv6RaPriority();

    @JsonProperty(value="lte_lan_enabled")
    public boolean lteLanEnabled();

    @JsonProperty(value="networkgroup")
    public String networkGroup();

    @JsonProperty(value="upnp_lan_enabled")
    public boolean upnpLanEnabled();

    @JsonProperty(value="ipv6_setting_preference")
    public Optional<SettingPreference> ipv6SettingPreference();

    @JsonProperty(value="ipv6_client_address_assignment")
    public new ipv6ClientAddressAssignment();

    public static ImmutableLanConfigurationDto.Builder builder() {
        return ImmutableLanConfigurationDto.builder();
    }

    public static LanConfigurationDto ofLegacy(NetworkConf networkConf) {
        return LanConfigurationDto.builder().purpose(Q.\u00d4O0000(NetworkPurpose.class, networkConf.getPurpose()).orElse(NetworkPurpose.CORPORATE)).settingPreference(networkConf.getSettingPreference()).autoScaleEnabled(networkConf.isAutoScaleNetworkEnabled()).dhcpdEnabled(networkConf.isDhcpdEnabled()).dhcpdV6Enabled(networkConf.isDhcpdV6Enabled()).dhcpGuardEnabled(networkConf.isDhcpGuardEnabled()).domainName(networkConf.getDomainName()).igmpSnooping(networkConf.isIgmpSnooping()).ipv6InterfaceType(networkConf.getIpV6InterfaceType()).ipv6RaEnabled(networkConf.isIpv6RaEnabled()).isNat(networkConf.isNat()).multicastDnsEnabled(networkConf.isMulticastDnsEnabled()).dhcpdBootEnabled(networkConf.isDhcpdBootEnabled()).dhcpRelayEnabled(networkConf.isDhcpRelayEnabled()).dhcpdDnsEnabled(networkConf.isDhcpdDnsEnabled()).dhcpdGatewayEnabled(networkConf.isDhcpdGatewayEnabled()).dhcpdLeasetime(networkConf.getDhcpdLeasetime()).dhcpNtpEnabled(networkConf.isDhcpdNtpEnabled()).dhcpdTftpServer(networkConf.getDhcpdTftpServer()).dhcpdTimeOffsetEnabled(networkConf.isDhcpdTimeOffsetEnabled()).dhcpdUnifiController(networkConf.getDhcpdUnifiController()).dhcpdWinsEnabled(networkConf.isDhcpdWinsEnabled()).dhcpdWpadUrl(networkConf.getDhcpdWpadUrl()).dhcpdConflictChecking(networkConf.isDhcpdConflictCheckingEnabled()).dhcpdV6DnsAuto(networkConf.isDhcpdV6DnsAuto()).dhcpdV6Leasetime(networkConf.getDhcpdV6Leasetime()).ipv6PdInterface(networkConf.getIpv6PdInterface()).ipv6PdStart(networkConf.getIpv6PdStart()).ipv6PdStop(networkConf.getIpv6PdStop()).ipv6RaPreferredLifetime(networkConf.getIpv6RaPreferredLifetime()).ipv6RaPriority(networkConf.getIpv6RaPriority()).lteLanEnabled(networkConf.isLteLanEnabled()).networkGroup(networkConf.getNetworkGroup()).upnpLanEnabled(networkConf.isUpnpLanEnabled()).ipv6SettingPreference(networkConf.getIpv6SettingPreference()).ipv6ClientAddressAssignment(networkConf.getClientAddressAssignment()).build();
    }
}

