/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.uid;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.Setting;
import com.ubnt.data.X;
import com.ubnt.service.system.setting.OooO;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.List;

public class UidRadiusConfiguration {
    @JsonProperty(value="radius_profile_id")
    private String radiusProfileId;
    @JsonProperty(value="enabled")
    private boolean enabled;
    @JsonProperty(value="shared_secret")
    @NotEmpty
    @Pattern(regexp="^[^\\\\\"' ]{1,48}$")
    private @NotEmpty @Pattern(regexp="^[^\\\\\"' ]{1,48}$") String sharedSecret;
    @JsonProperty(value="auth_port")
    private int authPort;
    @JsonProperty(value="acct_port")
    private int acctPort;
    @JsonProperty(value="ca_certificate")
    private String caCertificate;
    @JsonProperty(value="server_certificate")
    private String serverCertificate;
    @JsonProperty(value="server_certificate_key")
    private String serverCertificateKey;
    @JsonProperty(value="dh_key")
    private String dhKey;

    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public int getAcctPort() {
        return this.acctPort;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    public String getServerCertificateKey() {
        return this.serverCertificateKey;
    }

    public String getDhKey() {
        return this.dhKey;
    }

    public static UidRadiusConfiguration fromRadiusSettingAndProfile(Setting setting, RadiusProfile radiusProfile) {
        if (radiusProfile == null || setting == null) {
            return null;
        }
        UidRadiusConfiguration uidRadiusConfiguration = new UidRadiusConfiguration();
        uidRadiusConfiguration.radiusProfileId = radiusProfile.getString("_id");
        uidRadiusConfiguration.sharedSecret = setting.getString("x_secret");
        uidRadiusConfiguration.authPort = setting.getInt("auth_port");
        uidRadiusConfiguration.acctPort = setting.getInt("acct_port");
        uidRadiusConfiguration.caCertificate = setting.getString("ca_certificate");
        uidRadiusConfiguration.serverCertificate = setting.getString("server_certificate");
        uidRadiusConfiguration.serverCertificateKey = setting.getString("server_certificate_key");
        uidRadiusConfiguration.dhKey = setting.getString("dh_key");
        uidRadiusConfiguration.enabled = setting.is("enabled", false);
        return uidRadiusConfiguration;
    }

    public RadiusProfile toRadiusProfile(String string, String string2) {
        X x2 = new X().append("port", this.authPort).append("x_secret", this.sharedSecret);
        X x3 = new X().append("port", this.acctPort).append("x_secret", this.sharedSecret);
        return new RadiusProfile().setIdIfPresent(this.radiusProfileId).setSiteId(string).setHiddenId(string2).setAuthenticationServers(List.of(x2)).setAccountingServers(List.of(x3));
    }

    public Setting toRadiusServerSetting(String string) {
        return new Setting(OooO.\u00f5O0000).setSiteId(string).setEnabled(this.enabled).append("x_secret", this.sharedSecret).append("auth_port", this.authPort).append("acct_port", this.acctPort).append("ca_certificate", this.caCertificate).append("server_certificate", this.serverCertificate).append("server_certificate_key", this.serverCertificateKey).append("dh_key", this.dhKey);
    }
}

