/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wan.loadbalancing.sla;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.model.api.wan.loadbalancing.sla.ImmutableWanAlertThresholdDto;
import com.ubnt.return.F;
import com.ubnt.service.config.ubios.wanfailover.sla.E;
import com.ubnt.service.config.ubios.wanfailover.sla.WanAlertThresholdDocumentPart;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableWanAlertThresholdDto.Builder.class)
@Value.Immutable
@F
public interface WanAlertThresholdDto {
    @JsonProperty(value="threshold_policy")
    public E thresholdPolicy();

    @JsonProperty(value="latency_threshold")
    public Optional<@Min(value=5L) @Max(value=10000L) Integer> latencyThreshold();

    @JsonProperty(value="jitter_threshold")
    public Optional<@Min(value=3L) @Max(value=1500L) Integer> jitterThreshold();

    @JsonProperty(value="loss_threshold")
    public Optional<@Min(value=1L) @Max(value=100L) Integer> lossThreshold();

    public static ImmutableWanAlertThresholdDto.Builder builder() {
        return ImmutableWanAlertThresholdDto.builder();
    }

    public static WanAlertThresholdDto fromDocument(WanAlertThresholdDocumentPart wanAlertThresholdDocumentPart) {
        return ImmutableWanAlertThresholdDto.builder().thresholdPolicy(wanAlertThresholdDocumentPart.getThresholdPolicy()).latencyThreshold(wanAlertThresholdDocumentPart.getLatencyThreshold()).jitterThreshold(wanAlertThresholdDocumentPart.getJitterThreshold()).lossThreshold(wanAlertThresholdDocumentPart.getLossThreshold()).build();
    }

    default public WanAlertThresholdDocumentPart toDocument() {
        return WanAlertThresholdDocumentPart.builder().Object(this.thresholdPolicy()).\u00d500000(this.latencyThreshold().orElse(null)).o00000(this.jitterThreshold().orElse(null)).\u00d400000(this.lossThreshold().orElse(null)).\u00d200000();
    }
}

