/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.port;

import com.ubnt.data.Site;
import com.ubnt.model.api.port.DeviceMacTablesDto;
import com.ubnt.model.api.port.DeviceMacTablesParameterDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.port.insight.A;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Ports Insight")
public class PortsInsightController {
    private final A super;

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/ports/mac-tables"})
    @Operation(summary="Retrieve MAC tables of specific devices and ports", description="Since 9.4.4")
    public List<DeviceMacTablesDto> retrieveMacTables(@PathVariable(value="siteName") Site site, @RequestBody @Valid List<DeviceMacTablesParameterDto> list) {
        Map<String, List<Integer>> map = list.stream().collect(Collectors.toMap(DeviceMacTablesParameterDto::getMac, DeviceMacTablesParameterDto::getPortIndexes));
        return this.super.String(site.getId(), map);
    }

    @ConstructorProperties(value={"portsInsightService"})
    @Generated
    public PortsInsightController(A a2) {
        this.super = a2;
    }
}

