/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.profiles;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.ProfileDetails;
import org.verapdf.pdfa.validation.profiles.ProfileDetailsImpl;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.profiles.Variable;

@XmlRootElement(namespace="http://www.verapdf.org/ValidationProfile", name="profile")
final class ValidationProfileImpl
implements ValidationProfile {
    private Map<String, Set<Rule>> objectRuleMap;
    private Map<String, Set<Variable>> objectVariableMap;
    private final Map<RuleId, Rule> ruleLookup = new HashMap<RuleId, Rule>();
    private static final ValidationProfileImpl DEFAULT = new ValidationProfileImpl();
    @XmlAttribute
    private final PDFAFlavour flavour;
    @XmlElement
    private final ProfileDetails details;
    @XmlElement
    private final String hash;
    @XmlElementWrapper
    @XmlElement(name="rule")
    private final Set<Rule> rules;
    @XmlElementWrapper
    @XmlElement(name="variable")
    private final Set<Variable> variables;

    private ValidationProfileImpl() {
        this(PDFAFlavour.NO_FLAVOUR, (ProfileDetails)ProfileDetailsImpl.defaultInstance(), "hash", Collections.emptySet(), Collections.emptySet());
    }

    private ValidationProfileImpl(PDFAFlavour flavour, ProfileDetails details, String hash, Set<Rule> rules, Set<Variable> variables) {
        this.flavour = flavour;
        this.details = details;
        this.hash = hash;
        this.rules = new HashSet<Rule>(rules);
        this.variables = new HashSet<Variable>(variables);
    }

    private ValidationProfileImpl(PDFAFlavour flavour, ProfileDetails details, String hash, SortedSet<Rule> rules, SortedSet<Variable> variables) {
        this.flavour = flavour;
        this.details = details;
        this.hash = hash;
        this.rules = rules;
        this.variables = variables;
    }

    @Override
    public PDFAFlavour getPDFAFlavour() {
        return this.flavour;
    }

    @Override
    public ProfileDetails getDetails() {
        return this.details;
    }

    @Override
    public String getHexSha1Digest() {
        return this.hash;
    }

    @Override
    public Set<Rule> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    @Override
    public Set<Variable> getVariables() {
        return Collections.unmodifiableSet(this.variables);
    }

    @Override
    public Set<Rule> getRulesByObject(String objectName) {
        Set<Rule> objRules;
        if (this.objectRuleMap == null) {
            this.objectRuleMap = this.createObjectRuleMap(this.rules);
        }
        return (objRules = this.objectRuleMap.get(objectName)) == null ? Collections.emptySet() : Collections.unmodifiableSet(objRules);
    }

    @Override
    public Set<Variable> getVariablesByObject(String objectName) {
        Set<Variable> objRules;
        if (this.objectVariableMap == null) {
            this.objectVariableMap = ValidationProfileImpl.createObjectVariableMap(this.variables);
        }
        return (objRules = this.objectVariableMap.get(objectName)) == null ? Collections.emptySet() : Collections.unmodifiableSet(objRules);
    }

    @Override
    public Rule getRuleByRuleId(RuleId id) {
        if (this.ruleLookup.isEmpty()) {
            this.objectRuleMap = this.createObjectRuleMap(this.rules);
        }
        return this.ruleLookup.get(id);
    }

    @Override
    public SortedSet<String> getTags() {
        TreeSet<String> tags = new TreeSet<String>();
        for (Rule rule : this.rules) {
            tags.addAll(rule.getTagsSet());
        }
        return tags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
        result = 31 * result + (this.rules == null ? 0 : this.rules.hashCode());
        result = 31 * result + (this.variables == null ? 0 : this.variables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationProfile)) {
            return false;
        }
        ValidationProfile other = (ValidationProfile)obj;
        if (this.flavour != other.getPDFAFlavour()) {
            return false;
        }
        if (!Objects.equals(this.getHexSha1Digest(), other.getHexSha1Digest())) {
            return false;
        }
        if (!Objects.equals(this.getDetails(), other.getDetails())) {
            return false;
        }
        if (!Objects.equals(this.getRules(), other.getRules())) {
            return false;
        }
        return Objects.equals(this.getVariables(), other.getVariables());
    }

    public String toString() {
        return "ValidationProfile [flavour=" + (Object)((Object)this.flavour) + ", details=" + this.details + ", hash=" + this.hash + ", rules=" + this.rules + ", variables=" + this.variables + "]";
    }

    static ValidationProfile defaultInstance() {
        return DEFAULT;
    }

    static ValidationProfile fromValues(PDFAFlavour flavour, ProfileDetails details, String hash, Set<Rule> rules, Set<Variable> variables) {
        return new ValidationProfileImpl(flavour, details, hash, rules, variables);
    }

    static ValidationProfile fromSortedValues(PDFAFlavour flavour, ProfileDetails details, String hash, SortedSet<Rule> rules, SortedSet<Variable> variables) {
        return new ValidationProfileImpl(flavour, details, hash, rules, variables);
    }

    private Map<String, Set<Rule>> createObjectRuleMap(Set<Rule> rulesToSet) {
        this.ruleLookup.clear();
        HashMap<String, Set<Rule>> rulesByObject = new HashMap<String, Set<Rule>>();
        for (Rule rule : rulesToSet) {
            this.ruleLookup.put(rule.getRuleId(), rule);
            if (!rulesByObject.containsKey(rule.getObject())) {
                rulesByObject.put(rule.getObject(), new HashSet());
            }
            ((Set)rulesByObject.get(rule.getObject())).add(rule);
        }
        return rulesByObject;
    }

    private static Map<String, Set<Variable>> createObjectVariableMap(Set<Variable> variables) {
        HashMap<String, Set<Variable>> variablesByObject = new HashMap<String, Set<Variable>>();
        for (Variable rule : variables) {
            if (!variablesByObject.containsKey(rule.getObject())) {
                variablesByObject.put(rule.getObject(), new HashSet());
            }
            ((Set)variablesByObject.get(rule.getObject())).add(rule);
        }
        return variablesByObject;
    }

    static class Adapter
    extends XmlAdapter<ValidationProfileImpl, ValidationProfile> {
        Adapter() {
        }

        @Override
        public ValidationProfileImpl unmarshal(ValidationProfileImpl profileImpl) {
            return profileImpl;
        }

        @Override
        public ValidationProfileImpl marshal(ValidationProfile profile) {
            return (ValidationProfileImpl)profile;
        }
    }
}

