/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.policy;

import org.verapdf.features.objects.Feature;

public enum SchematronOperation {
    PRESENT(false, "is present"),
    NOT_PRESENT(false, "is not present"),
    IS_EQUAL(true, "equals to"),
    NOT_EQUAL(true, "not equals to"),
    IS_TRUE(false, "is true"),
    IS_FALSE(false, "is false"),
    IS_GREATER(true, "is greater than"),
    IS_GREATER_OR_EQUAL(true, "is greater or equal to"),
    IS_LESS(true, "is less than"),
    IS_LESS_OR_EQUAL(true, "is less or equal to"),
    STARTS_WITH(true, "starts with"),
    CONTAINS(true, "contains substring");

    private final boolean hasArguments;
    private final String description;

    private SchematronOperation(boolean hasArguments, String description) {
        this.hasArguments = hasArguments;
        this.description = description;
    }

    public boolean hasArguments() {
        return this.hasArguments;
    }

    public String getDescription() {
        return this.description;
    }

    public AssertionInformation getAssertionInfo(Feature feature, String argument) {
        String test;
        if (feature == null) {
            throw new IllegalArgumentException("Feature argument can not be null");
        }
        if (this.hasArguments() && argument == null) {
            throw new IllegalArgumentException("Argument variable can not be null for operation " + this.description);
        }
        switch (this) {
            case PRESENT: {
                test = "count(" + feature.getFeatureXPath() + ") > 0";
                break;
            }
            case NOT_PRESENT: {
                test = "not(count(" + feature.getFeatureXPath() + ") > 0)";
                break;
            }
            case IS_EQUAL: {
                if (feature.getFeatureType() == Feature.FeatureType.NUMBER) {
                    test = "number(" + feature.getFeatureXPath() + ") = " + argument;
                    break;
                }
                test = feature.getFeatureXPath() + " = '" + argument + "'";
                break;
            }
            case NOT_EQUAL: {
                if (feature.getFeatureType() == Feature.FeatureType.NUMBER) {
                    test = "not(number(" + feature.getFeatureXPath() + ") = " + argument + ")";
                    break;
                }
                test = "not(" + feature.getFeatureXPath() + " = '" + argument + "')";
                break;
            }
            case IS_TRUE: {
                test = "boolean(" + feature.getFeatureXPath() + ")";
                break;
            }
            case IS_FALSE: {
                test = "not(boolean(" + feature.getFeatureXPath() + "))";
                break;
            }
            case IS_GREATER: {
                test = "number(" + feature.getFeatureXPath() + ") > " + argument;
                break;
            }
            case IS_GREATER_OR_EQUAL: {
                test = "number(" + feature.getFeatureXPath() + ") >= " + argument;
                break;
            }
            case IS_LESS: {
                test = "number(" + feature.getFeatureXPath() + ") < " + argument;
                break;
            }
            case IS_LESS_OR_EQUAL: {
                test = "number(" + feature.getFeatureXPath() + ") <= " + argument;
                break;
            }
            case CONTAINS: {
                test = "contains(" + feature.getFeatureXPath() + ",'" + argument + "')";
                break;
            }
            case STARTS_WITH: {
                test = "starts-with(" + feature.getFeatureXPath() + ",'" + argument + "')";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operation type");
            }
        }
        String desc = "Failed check: " + feature.getFeatureName() + " " + this.getDescription();
        if (this.hasArguments) {
            desc = desc + " " + argument;
        }
        return new AssertionInformation(test, desc);
    }

    public static class AssertionInformation {
        private final String testAssertion;
        private final String assertionDescription;

        private AssertionInformation(String testAssertion, String assertionDescription) {
            this.testAssertion = testAssertion;
            this.assertionDescription = assertionDescription;
        }

        public String getTestAssertion() {
            return this.testAssertion;
        }

        public String getAssertionDescription() {
            return this.assertionDescription;
        }
    }
}

