/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.roimfs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraftforge.roimfs.GlobUtil;
import net.minecraftforge.roimfs.RoimDirectoryStream;
import net.minecraftforge.roimfs.RoimFileStore;
import net.minecraftforge.roimfs.RoimFileSystemProvider;
import net.minecraftforge.roimfs.RoimPath;

final class RoimFileSystem
extends FileSystem {
    private static final byte[] EMPTY = new byte[0];
    final RoimPath rootPath = new RoimPath(this, new char[]{'/'}, true);
    private final String key;
    private final Set<String> directories = new HashSet<String>();
    private final RoimFileSystemProvider provider;
    private final Map<String, byte[]> files;
    private final RoimFileStore fileStore;
    private boolean isOpen = true;
    private static final Set<String> supportedFileAttributeViews = Collections.singleton("basic");

    RoimFileSystem(RoimFileSystemProvider provider, String key, String path, Map<String, ?> env) {
        Object data;
        this.provider = provider;
        this.key = key;
        int total = 0;
        if (!path.isEmpty()) {
            if ((path = RoimFileSystem.normalize(path)).endsWith("/")) {
                this.directories.add(path);
                this.files = Collections.emptyMap();
            } else {
                data = (byte[])env.get("data");
                if (data == null) {
                    throw new IllegalArgumentException("Must specify `data` value when specifying path in constructor");
                }
                this.files = Collections.singletonMap(path, data);
                this.addParents(path);
                total += ((Object)data).length;
            }
        } else {
            data = (Map)env.get("files");
            if (data == null) {
                throw new IllegalArgumentException("Must specify `files` value which is a Map<String, byte[]>");
            }
            this.files = new HashMap<String, byte[]>();
            for (Map.Entry file : data.entrySet()) {
                String name = RoimFileSystem.normalize((String)file.getKey());
                this.addParents(name);
                if (name.endsWith("/")) continue;
                byte[] fdata = file.getValue() == null ? EMPTY : (byte[])file.getValue();
                total += fdata.length;
                this.files.put(name, fdata);
            }
        }
        for (String file : this.files.keySet()) {
            if (!this.directories.contains(file + '/')) continue;
            throw new IllegalArgumentException("Can not create a file, and directory with the same name: " + file);
        }
        this.fileStore = new RoimFileStore(total);
    }

    private static String normalize(String path) {
        return path.length() == 0 ? "/" : (path.charAt(0) == '/' ? path : '/' + path);
    }

    private void addParents(String path) {
        int idx = path.lastIndexOf(47);
        while (idx != -1) {
            this.directories.add(path.substring(0, idx + 1));
            idx = path.lastIndexOf(47, idx - 1);
        }
    }

    String getKey() {
        return this.key;
    }

    void checkExists(String path) throws NoSuchFileException {
        if (!this.files.containsKey(path) && !this.isDirectory(path)) {
            throw new NoSuchFileException("roimfs:" + this.key + path);
        }
    }

    byte[] getFile(String path) throws NoSuchFileException {
        byte[] ret = this.files.get(path);
        if (ret == null) {
            throw new NoSuchFileException("roimfs:" + this.key + path);
        }
        return ret;
    }

    boolean isDirectory(String path) {
        return this.directories.contains(path) || this.directories.contains(path + '/');
    }

    public String toString() {
        return "roimfs:" + this.getKey() + ' ' + this.files.keySet();
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Arrays.asList(this.rootPath);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Arrays.asList(this.fileStore);
    }

    FileStore getFileStore() {
        return this.fileStore;
    }

    DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Path real = dir.toAbsolutePath().normalize();
        String str = real.toString();
        if (str.charAt(str.length() - 1) != '/') {
            str = str + '/';
        }
        if (!this.directories.contains(str)) {
            throw new NotDirectoryException(str);
        }
        int dlen = str.length();
        ArrayList<Path> ret = new ArrayList<Path>();
        for (String file : this.files.keySet()) {
            if (file.length() < dlen || !file.startsWith(str) || file.indexOf(47, dlen + 1) != -1) continue;
            String name = file.substring(dlen);
            ret.add(dir.resolve(name));
        }
        for (String other : this.directories) {
            int idx;
            if (other.length() <= dlen || !other.startsWith(str) || (idx = other.indexOf(47, dlen + 1)) != other.length() - 1) continue;
            String name = other.substring(dlen, idx + 1);
            ret.add(dir.resolve(name));
        }
        Collections.sort(ret);
        return new RoimDirectoryStream(ret, filter);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    @Override
    public void close() throws IOException {
        this.provider.removeFileSystem(this);
    }

    @Override
    public Path getPath(String first, String ... more) {
        if (more.length == 0) {
            return new RoimPath(this, first);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        for (String part : more) {
            if (part.length() == 0) continue;
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(part);
        }
        return new RoimPath(this, sb.toString());
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        String expr;
        int pos = syntaxAndPattern.indexOf(58);
        if (pos <= 0) {
            throw new IllegalArgumentException();
        }
        String syntax = syntaxAndPattern.substring(0, pos);
        String pattern = syntaxAndPattern.substring(pos + 1);
        if (syntax.equalsIgnoreCase("glob")) {
            expr = GlobUtil.convertGlobToRegex(pattern);
        } else if (syntax.equalsIgnoreCase("regex")) {
            expr = pattern;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        Pattern regex = Pattern.compile(expr);
        return path -> regex.matcher(path.toString()).matches();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }
}

