/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.LoadingDotsWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerSelectionList
extends ObjectSelectionList<Entry> {
    static final ResourceLocation INCOMPATIBLE_SPRITE = ResourceLocation.withDefaultNamespace("server_list/incompatible");
    static final ResourceLocation UNREACHABLE_SPRITE = ResourceLocation.withDefaultNamespace("server_list/unreachable");
    static final ResourceLocation PING_1_SPRITE = ResourceLocation.withDefaultNamespace("server_list/ping_1");
    static final ResourceLocation PING_2_SPRITE = ResourceLocation.withDefaultNamespace("server_list/ping_2");
    static final ResourceLocation PING_3_SPRITE = ResourceLocation.withDefaultNamespace("server_list/ping_3");
    static final ResourceLocation PING_4_SPRITE = ResourceLocation.withDefaultNamespace("server_list/ping_4");
    static final ResourceLocation PING_5_SPRITE = ResourceLocation.withDefaultNamespace("server_list/ping_5");
    static final ResourceLocation PINGING_1_SPRITE = ResourceLocation.withDefaultNamespace("server_list/pinging_1");
    static final ResourceLocation PINGING_2_SPRITE = ResourceLocation.withDefaultNamespace("server_list/pinging_2");
    static final ResourceLocation PINGING_3_SPRITE = ResourceLocation.withDefaultNamespace("server_list/pinging_3");
    static final ResourceLocation PINGING_4_SPRITE = ResourceLocation.withDefaultNamespace("server_list/pinging_4");
    static final ResourceLocation PINGING_5_SPRITE = ResourceLocation.withDefaultNamespace("server_list/pinging_5");
    static final ResourceLocation JOIN_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("server_list/join_highlighted");
    static final ResourceLocation JOIN_SPRITE = ResourceLocation.withDefaultNamespace("server_list/join");
    static final ResourceLocation MOVE_UP_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("server_list/move_up_highlighted");
    static final ResourceLocation MOVE_UP_SPRITE = ResourceLocation.withDefaultNamespace("server_list/move_up");
    static final ResourceLocation MOVE_DOWN_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("server_list/move_down_highlighted");
    static final ResourceLocation MOVE_DOWN_SPRITE = ResourceLocation.withDefaultNamespace("server_list/move_down");
    static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    static final Component SCANNING_LABEL = Component.translatable("lanServer.scanning");
    static final Component CANT_RESOLVE_TEXT = Component.translatable("multiplayer.status.cannot_resolve").withColor(-65536);
    static final Component CANT_CONNECT_TEXT = Component.translatable("multiplayer.status.cannot_connect").withColor(-65536);
    static final Component INCOMPATIBLE_STATUS = Component.translatable("multiplayer.status.incompatible");
    static final Component NO_CONNECTION_STATUS = Component.translatable("multiplayer.status.no_connection");
    static final Component PINGING_STATUS = Component.translatable("multiplayer.status.pinging");
    static final Component ONLINE_STATUS = Component.translatable("multiplayer.status.online");
    private final JoinMultiplayerScreen screen;
    private final List<OnlineServerEntry> onlineServers = Lists.newArrayList();
    private final Entry lanHeader = new LANHeader();
    private final List<NetworkServerEntry> networkServers = Lists.newArrayList();

    public ServerSelectionList(JoinMultiplayerScreen p_99771_, Minecraft p_99772_, int p_99773_, int p_99774_, int p_99775_, int p_99776_) {
        super(p_99772_, p_99773_, p_99774_, p_99775_, p_99776_);
        this.screen = p_99771_;
    }

    private void refreshEntries() {
        Entry serverselectionlist$entry = (Entry)this.getSelected();
        ArrayList<OnlineServerEntry> list = new ArrayList<OnlineServerEntry>(this.onlineServers);
        list.add((OnlineServerEntry)this.lanHeader);
        list.addAll(this.networkServers);
        this.replaceEntries(list);
        if (serverselectionlist$entry != null) {
            for (Entry entry : list) {
                if (!entry.matches(serverselectionlist$entry)) continue;
                this.setSelected(entry);
                break;
            }
        }
    }

    public void setSelected(@Nullable Entry p_99790_) {
        super.setSelected((AbstractSelectionList.Entry)p_99790_);
        this.screen.onSelectedChange();
    }

    public void updateOnlineServers(ServerList p_99798_) {
        this.onlineServers.clear();
        for (int i = 0; i < p_99798_.size(); ++i) {
            this.onlineServers.add(new OnlineServerEntry(this.screen, p_99798_.get(i)));
        }
        this.refreshEntries();
    }

    public void updateNetworkServers(List<LanServer> p_99800_) {
        int i = p_99800_.size() - this.networkServers.size();
        this.networkServers.clear();
        for (LanServer lanserver : p_99800_) {
            this.networkServers.add(new NetworkServerEntry(this.screen, lanserver));
        }
        this.refreshEntries();
        for (int i1 = this.networkServers.size() - i; i1 < this.networkServers.size(); ++i1) {
            NetworkServerEntry serverselectionlist$networkserverentry = this.networkServers.get(i1);
            int j = i1 - this.networkServers.size() + this.children().size();
            int k = this.getRowTop(j);
            int l = this.getRowBottom(j);
            if (l < this.getY() || k > this.getBottom()) continue;
            this.minecraft.getNarrator().saySystemQueued((Component)Component.translatable("multiplayer.lan.server_found", serverselectionlist$networkserverentry.getServerNarration()));
        }
    }

    public int getRowWidth() {
        return 305;
    }

    public void removed() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LANHeader
    extends Entry {
        private final Minecraft minecraft = Minecraft.getInstance();
        private final LoadingDotsWidget loadingDotsWidget;

        public LANHeader() {
            this.loadingDotsWidget = new LoadingDotsWidget(this.minecraft.font, SCANNING_LABEL);
        }

        public void renderContent(GuiGraphics p_426245_, int p_422472_, int p_425094_, boolean p_423481_, float p_429004_) {
            this.loadingDotsWidget.setPosition(this.getContentXMiddle() - this.minecraft.font.width(SCANNING_LABEL) / 2, this.getContentY());
            this.loadingDotsWidget.render(p_426245_, p_422472_, p_425094_, p_429004_);
        }

        public Component getNarration() {
            return SCANNING_LABEL;
        }

        @Override
        boolean matches(Entry p_429702_) {
            return p_429702_ instanceof LANHeader;
        }

        @Override
        public void join() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }

        abstract boolean matches(Entry var1);

        public abstract void join();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class OnlineServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int SPACING = 5;
        private static final int STATUS_ICON_WIDTH = 10;
        private static final int STATUS_ICON_HEIGHT = 8;
        private final JoinMultiplayerScreen screen;
        private final Minecraft minecraft;
        private final ServerData serverData;
        private final FaviconTexture icon;
        @Nullable
        private byte[] lastIconBytes;
        @Nullable
        private List<Component> onlinePlayersTooltip;
        @Nullable
        private ResourceLocation statusIcon;
        @Nullable
        private Component statusIconTooltip;

        protected OnlineServerEntry(JoinMultiplayerScreen p_99864_, ServerData p_99865_) {
            this.screen = p_99864_;
            this.serverData = p_99865_;
            this.minecraft = Minecraft.getInstance();
            this.icon = FaviconTexture.forServer((TextureManager)this.minecraft.getTextureManager(), (String)p_99865_.ip);
            this.refreshStatus();
        }

        public void renderContent(GuiGraphics p_425273_, int p_424268_, int p_430737_, boolean p_425246_, float p_422401_) {
            byte[] abyte;
            if (this.serverData.state() == ServerData.State.INITIAL) {
                this.serverData.setState(ServerData.State.PINGING);
                this.serverData.motd = CommonComponents.EMPTY;
                this.serverData.status = CommonComponents.EMPTY;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().pingServer(this.serverData, () -> this.minecraft.execute(this::updateServerList), () -> {
                            this.serverData.setState(this.serverData.protocol == SharedConstants.getCurrentVersion().protocolVersion() ? ServerData.State.SUCCESSFUL : ServerData.State.INCOMPATIBLE);
                            this.minecraft.execute(this::refreshStatus);
                        });
                    }
                    catch (UnknownHostException unknownhostexception) {
                        this.serverData.setState(ServerData.State.UNREACHABLE);
                        this.serverData.motd = CANT_RESOLVE_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                    }
                    catch (Exception exception) {
                        this.serverData.setState(ServerData.State.UNREACHABLE);
                        this.serverData.motd = CANT_CONNECT_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                    }
                });
            }
            p_425273_.drawString(this.minecraft.font, this.serverData.name, this.getContentX() + 32 + 3, this.getContentY() + 1, -1);
            List<FormattedCharSequence> list = this.minecraft.font.split(this.serverData.motd, this.getContentWidth() - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                p_425273_.drawString(this.minecraft.font, list.get(i), this.getContentX() + 32 + 3, this.getContentY() + 12 + 9 * i, -8355712);
            }
            this.drawIcon(p_425273_, this.getContentX(), this.getContentY(), this.icon.textureLocation());
            int k1 = ServerSelectionList.this.children().indexOf(this);
            if (this.serverData.state() == ServerData.State.PINGING) {
                int j = (int)(Util.getMillis() / 100L + (long)(k1 * 2) & 7L);
                if (j > 4) {
                    j = 8 - j;
                }
                this.statusIcon = switch (j) {
                    case 1 -> PINGING_2_SPRITE;
                    case 2 -> PINGING_3_SPRITE;
                    case 3 -> PINGING_4_SPRITE;
                    case 4 -> PINGING_5_SPRITE;
                    default -> PINGING_1_SPRITE;
                };
            }
            int l1 = this.getContentRight() - 10 - 5;
            if (this.statusIcon != null) {
                p_425273_.blitSprite(RenderPipelines.GUI_TEXTURED, this.statusIcon, l1, this.getContentY(), 10, 8);
            }
            if (!Arrays.equals(abyte = this.serverData.getIconBytes(), this.lastIconBytes)) {
                if (this.uploadServerIcon(abyte)) {
                    this.lastIconBytes = abyte;
                } else {
                    this.serverData.setIconBytes(null);
                    this.updateServerList();
                }
            }
            Component component = this.serverData.state() == ServerData.State.INCOMPATIBLE ? this.serverData.version.copy().withStyle(ChatFormatting.RED) : this.serverData.status;
            int k = this.minecraft.font.width(component);
            int l = l1 - k - 5;
            p_425273_.drawString(this.minecraft.font, component, l, this.getContentY() + 1, -8355712);
            if (this.statusIconTooltip != null && p_424268_ >= l1 && p_424268_ <= l1 + 10 && p_430737_ >= this.getContentY() && p_430737_ <= this.getContentY() + 8) {
                p_425273_.setTooltipForNextFrame(this.statusIconTooltip, p_424268_, p_430737_);
            } else if (this.onlinePlayersTooltip != null && p_424268_ >= l && p_424268_ <= l + k && p_430737_ >= this.getContentY() && p_430737_ <= this.getContentY() - 1 + 9) {
                p_425273_.setTooltipForNextFrame(Lists.transform(this.onlinePlayersTooltip, Component::getVisualOrderText), p_424268_, p_430737_);
            }
            ForgeHooksClient.drawForgePingInfo((JoinMultiplayerScreen)this.screen, (ServerData)this.serverData, (GuiGraphics)p_425273_, (int)this.getContentX(), (int)this.getContentY(), (int)this.getContentWidth(), (int)(p_424268_ - this.getContentX()), (int)(p_430737_ - this.getContentY()));
            if (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue() || p_425246_) {
                p_425273_.fill(this.getContentX(), this.getContentY(), this.getContentX() + 32, this.getContentY() + 32, -1601138544);
                int i1 = p_424268_ - this.getContentX();
                int j1 = p_430737_ - this.getContentY();
                if (this.canJoin()) {
                    if (i1 < 32 && i1 > 16) {
                        p_425273_.blitSprite(RenderPipelines.GUI_TEXTURED, JOIN_HIGHLIGHTED_SPRITE, this.getContentX(), this.getContentY(), 32, 32);
                    } else {
                        p_425273_.blitSprite(RenderPipelines.GUI_TEXTURED, JOIN_SPRITE, this.getContentX(), this.getContentY(), 32, 32);
                    }
                }
                if (k1 > 0) {
                    if (i1 < 16 && j1 < 16) {
                        p_425273_.blitSprite(RenderPipelines.GUI_TEXTURED, MOVE_UP_HIGHLIGHTED_SPRITE, this.getContentX(), this.getContentY(), 32, 32);
                    } else {
                        p_425273_.blitSprite(RenderPipelines.GUI_TEXTURED, MOVE_UP_SPRITE, this.getContentX(), this.getContentY(), 32, 32);
                    }
                }
                if (k1 < this.screen.getServers().size() - 1) {
                    if (i1 < 16 && j1 > 16) {
                        p_425273_.blitSprite(RenderPipelines.GUI_TEXTURED, MOVE_DOWN_HIGHLIGHTED_SPRITE, this.getContentX(), this.getContentY(), 32, 32);
                    } else {
                        p_425273_.blitSprite(RenderPipelines.GUI_TEXTURED, MOVE_DOWN_SPRITE, this.getContentX(), this.getContentY(), 32, 32);
                    }
                }
            }
        }

        private void refreshStatus() {
            this.onlinePlayersTooltip = null;
            switch (this.serverData.state()) {
                case INITIAL: 
                case PINGING: {
                    this.statusIcon = PING_1_SPRITE;
                    this.statusIconTooltip = PINGING_STATUS;
                    break;
                }
                case INCOMPATIBLE: {
                    this.statusIcon = INCOMPATIBLE_SPRITE;
                    this.statusIconTooltip = INCOMPATIBLE_STATUS;
                    this.onlinePlayersTooltip = this.serverData.playerList;
                    break;
                }
                case UNREACHABLE: {
                    this.statusIcon = UNREACHABLE_SPRITE;
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                    break;
                }
                case SUCCESSFUL: {
                    this.statusIcon = this.serverData.ping < 150L ? PING_5_SPRITE : (this.serverData.ping < 300L ? PING_4_SPRITE : (this.serverData.ping < 600L ? PING_3_SPRITE : (this.serverData.ping < 1000L ? PING_2_SPRITE : PING_1_SPRITE)));
                    this.statusIconTooltip = Component.translatable("multiplayer.status.ping", this.serverData.ping);
                    this.onlinePlayersTooltip = this.serverData.playerList;
                }
            }
        }

        public void updateServerList() {
            this.screen.getServers().save();
        }

        protected void drawIcon(GuiGraphics p_281338_, int p_283001_, int p_282834_, ResourceLocation p_282534_) {
            p_281338_.blit(RenderPipelines.GUI_TEXTURED, p_282534_, p_283001_, p_282834_, 0.0f, 0.0f, 32, 32, 32, 32);
        }

        private boolean canJoin() {
            return true;
        }

        private boolean uploadServerIcon(@Nullable byte[] p_273176_) {
            if (p_273176_ == null) {
                this.icon.clear();
            } else {
                try {
                    this.icon.upload(NativeImage.read((byte[])p_273176_));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.name, this.serverData.ip, throwable});
                    return false;
                }
            }
            return true;
        }

        public boolean keyPressed(KeyEvent p_426878_) {
            if (p_426878_.isSelection()) {
                this.join();
                return true;
            }
            if (p_426878_.hasShiftDown()) {
                ServerSelectionList serverselectionlist = this.screen.serverSelectionList;
                int i = serverselectionlist.children().indexOf(this);
                if (i == -1) {
                    return true;
                }
                if (p_426878_.isDown() && i < this.screen.getServers().size() - 1 || p_426878_.isUp() && i > 0) {
                    this.swap(i, p_426878_.isDown() ? i + 1 : i - 1);
                    return true;
                }
            }
            return super.keyPressed(p_426878_);
        }

        @Override
        public void join() {
            this.screen.join(this.serverData);
        }

        private void swap(int p_99872_, int p_99873_) {
            this.screen.getServers().swap(p_99872_, p_99873_);
            this.screen.serverSelectionList.swap(p_99872_, p_99873_);
        }

        public boolean mouseClicked(MouseButtonEvent p_427078_, boolean p_424088_) {
            double d0 = p_427078_.x() - (double)this.getX();
            double d1 = p_427078_.y() - (double)this.getY();
            if (d0 <= 32.0) {
                if (d0 < 32.0 && d0 > 16.0 && this.canJoin()) {
                    this.join();
                    return true;
                }
                int i = this.screen.serverSelectionList.children().indexOf(this);
                if (d0 < 16.0 && d1 < 16.0 && i > 0) {
                    this.swap(i, i - 1);
                    return true;
                }
                if (d0 < 16.0 && d1 > 16.0 && i < this.screen.getServers().size() - 1) {
                    this.swap(i, i + 1);
                    return true;
                }
            }
            if (p_424088_) {
                this.join();
            }
            return super.mouseClicked(p_427078_, p_424088_);
        }

        public ServerData getServerData() {
            return this.serverData;
        }

        public Component getNarration() {
            MutableComponent mutablecomponent = Component.empty();
            mutablecomponent.append(Component.translatable("narrator.select", this.serverData.name));
            mutablecomponent.append(CommonComponents.NARRATION_SEPARATOR);
            switch (this.serverData.state()) {
                case PINGING: {
                    mutablecomponent.append(PINGING_STATUS);
                    break;
                }
                case INCOMPATIBLE: {
                    mutablecomponent.append(INCOMPATIBLE_STATUS);
                    mutablecomponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutablecomponent.append(Component.translatable("multiplayer.status.version.narration", this.serverData.version));
                    mutablecomponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutablecomponent.append(Component.translatable("multiplayer.status.motd.narration", this.serverData.motd));
                    break;
                }
                case UNREACHABLE: {
                    mutablecomponent.append(NO_CONNECTION_STATUS);
                    break;
                }
                default: {
                    mutablecomponent.append(ONLINE_STATUS);
                    mutablecomponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutablecomponent.append(Component.translatable("multiplayer.status.ping.narration", this.serverData.ping));
                    mutablecomponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutablecomponent.append(Component.translatable("multiplayer.status.motd.narration", this.serverData.motd));
                    if (this.serverData.players == null) break;
                    mutablecomponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutablecomponent.append(Component.translatable("multiplayer.status.player_count.narration", this.serverData.players.online(), this.serverData.players.max()));
                    mutablecomponent.append(CommonComponents.NARRATION_SEPARATOR);
                    mutablecomponent.append(ComponentUtils.formatList(this.serverData.playerList, Component.literal(", ")));
                }
            }
            return mutablecomponent;
        }

        @Override
        public void close() {
            this.icon.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean matches(Entry p_431278_) {
            if (!(p_431278_ instanceof OnlineServerEntry)) return false;
            OnlineServerEntry serverselectionlist$onlineserverentry = (OnlineServerEntry)p_431278_;
            if (serverselectionlist$onlineserverentry.serverData != this.serverData) return false;
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NetworkServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final Component LAN_SERVER_HEADER = Component.translatable("lanServer.title");
        private static final Component HIDDEN_ADDRESS_TEXT = Component.translatable("selectServer.hiddenAddress");
        private final JoinMultiplayerScreen screen;
        protected final Minecraft minecraft;
        protected final LanServer serverData;

        protected NetworkServerEntry(JoinMultiplayerScreen p_99836_, LanServer p_99837_) {
            this.screen = p_99836_;
            this.serverData = p_99837_;
            this.minecraft = Minecraft.getInstance();
        }

        public void renderContent(GuiGraphics p_282600_, int p_282649_, int p_283641_, boolean p_283673_, float p_282694_) {
            p_282600_.drawString(this.minecraft.font, LAN_SERVER_HEADER, this.getContentX() + 32 + 3, this.getContentY() + 1, -1);
            p_282600_.drawString(this.minecraft.font, this.serverData.getMotd(), this.getContentX() + 32 + 3, this.getContentY() + 12, -8355712);
            if (this.minecraft.options.hideServerAddress) {
                p_282600_.drawString(this.minecraft.font, HIDDEN_ADDRESS_TEXT, this.getContentX() + 32 + 3, this.getContentY() + 12 + 11, -8355712);
            } else {
                p_282600_.drawString(this.minecraft.font, this.serverData.getAddress(), this.getContentX() + 32 + 3, this.getContentY() + 12 + 11, -8355712);
            }
        }

        public boolean mouseClicked(MouseButtonEvent p_424079_, boolean p_424379_) {
            if (p_424379_) {
                this.join();
            }
            return super.mouseClicked(p_424079_, p_424379_);
        }

        public boolean keyPressed(KeyEvent p_425753_) {
            if (p_425753_.isSelection()) {
                this.join();
                return true;
            }
            return super.keyPressed(p_425753_);
        }

        @Override
        public void join() {
            this.screen.join(new ServerData(this.serverData.getMotd(), this.serverData.getAddress(), ServerData.Type.LAN));
        }

        public Component getNarration() {
            return Component.translatable("narrator.select", this.getServerNarration());
        }

        public Component getServerNarration() {
            return Component.empty().append(LAN_SERVER_HEADER).append(CommonComponents.SPACE).append(this.serverData.getMotd());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean matches(Entry p_427565_) {
            if (!(p_427565_ instanceof NetworkServerEntry)) return false;
            NetworkServerEntry serverselectionlist$networkserverentry = (NetworkServerEntry)p_427565_;
            if (serverselectionlist$networkserverentry.serverData != this.serverData) return false;
            return true;
        }
    }
}

