//go:build !ignore_autogenerated

// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by controller-gen. DO NOT EDIT.

package v1

import (
	appsv1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/util/intstr"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *APIServerConfig) DeepCopyInto(out *APIServerConfig) {
	*out = *in
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(Authorization)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new APIServerConfig.
func (in *APIServerConfig) DeepCopy() *APIServerConfig {
	if in == nil {
		return nil
	}
	out := new(APIServerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertingSpec) DeepCopyInto(out *AlertingSpec) {
	*out = *in
	if in.Alertmanagers != nil {
		in, out := &in.Alertmanagers, &out.Alertmanagers
		*out = make([]AlertmanagerEndpoints, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertingSpec.
func (in *AlertingSpec) DeepCopy() *AlertingSpec {
	if in == nil {
		return nil
	}
	out := new(AlertingSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Alertmanager) DeepCopyInto(out *Alertmanager) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Alertmanager.
func (in *Alertmanager) DeepCopy() *Alertmanager {
	if in == nil {
		return nil
	}
	out := new(Alertmanager)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerConfigMatcherStrategy) DeepCopyInto(out *AlertmanagerConfigMatcherStrategy) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerConfigMatcherStrategy.
func (in *AlertmanagerConfigMatcherStrategy) DeepCopy() *AlertmanagerConfigMatcherStrategy {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerConfigMatcherStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerConfiguration) DeepCopyInto(out *AlertmanagerConfiguration) {
	*out = *in
	if in.Global != nil {
		in, out := &in.Global, &out.Global
		*out = new(AlertmanagerGlobalConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Templates != nil {
		in, out := &in.Templates, &out.Templates
		*out = make([]SecretOrConfigMap, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerConfiguration.
func (in *AlertmanagerConfiguration) DeepCopy() *AlertmanagerConfiguration {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerEndpoints) DeepCopyInto(out *AlertmanagerEndpoints) {
	*out = *in
	if in.Namespace != nil {
		in, out := &in.Namespace, &out.Namespace
		*out = new(string)
		**out = **in
	}
	out.Port = in.Port
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.Sigv4 != nil {
		in, out := &in.Sigv4, &out.Sigv4
		*out = new(Sigv4)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.APIVersion != nil {
		in, out := &in.APIVersion, &out.APIVersion
		*out = new(AlertmanagerAPIVersion)
		**out = **in
	}
	if in.Timeout != nil {
		in, out := &in.Timeout, &out.Timeout
		*out = new(Duration)
		**out = **in
	}
	if in.EnableHttp2 != nil {
		in, out := &in.EnableHttp2, &out.EnableHttp2
		*out = new(bool)
		**out = **in
	}
	if in.RelabelConfigs != nil {
		in, out := &in.RelabelConfigs, &out.RelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AlertRelabelConfigs != nil {
		in, out := &in.AlertRelabelConfigs, &out.AlertRelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerEndpoints.
func (in *AlertmanagerEndpoints) DeepCopy() *AlertmanagerEndpoints {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerEndpoints)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerGlobalConfig) DeepCopyInto(out *AlertmanagerGlobalConfig) {
	*out = *in
	if in.SMTPConfig != nil {
		in, out := &in.SMTPConfig, &out.SMTPConfig
		*out = new(GlobalSMTPConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.SlackAPIURL != nil {
		in, out := &in.SlackAPIURL, &out.SlackAPIURL
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.OpsGenieAPIURL != nil {
		in, out := &in.OpsGenieAPIURL, &out.OpsGenieAPIURL
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.OpsGenieAPIKey != nil {
		in, out := &in.OpsGenieAPIKey, &out.OpsGenieAPIKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.PagerdutyURL != nil {
		in, out := &in.PagerdutyURL, &out.PagerdutyURL
		*out = new(URL)
		**out = **in
	}
	if in.TelegramConfig != nil {
		in, out := &in.TelegramConfig, &out.TelegramConfig
		*out = new(GlobalTelegramConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.JiraConfig != nil {
		in, out := &in.JiraConfig, &out.JiraConfig
		*out = new(GlobalJiraConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.VictorOpsConfig != nil {
		in, out := &in.VictorOpsConfig, &out.VictorOpsConfig
		*out = new(GlobalVictorOpsConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.RocketChatConfig != nil {
		in, out := &in.RocketChatConfig, &out.RocketChatConfig
		*out = new(GlobalRocketChatConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.WebexConfig != nil {
		in, out := &in.WebexConfig, &out.WebexConfig
		*out = new(GlobalWebexConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.WeChatConfig != nil {
		in, out := &in.WeChatConfig, &out.WeChatConfig
		*out = new(GlobalWeChatConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerGlobalConfig.
func (in *AlertmanagerGlobalConfig) DeepCopy() *AlertmanagerGlobalConfig {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerGlobalConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerLimitsSpec) DeepCopyInto(out *AlertmanagerLimitsSpec) {
	*out = *in
	if in.MaxSilences != nil {
		in, out := &in.MaxSilences, &out.MaxSilences
		*out = new(int32)
		**out = **in
	}
	if in.MaxPerSilenceBytes != nil {
		in, out := &in.MaxPerSilenceBytes, &out.MaxPerSilenceBytes
		*out = new(ByteSize)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerLimitsSpec.
func (in *AlertmanagerLimitsSpec) DeepCopy() *AlertmanagerLimitsSpec {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerLimitsSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerList) DeepCopyInto(out *AlertmanagerList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Alertmanager, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerList.
func (in *AlertmanagerList) DeepCopy() *AlertmanagerList {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerSpec) DeepCopyInto(out *AlertmanagerSpec) {
	*out = *in
	if in.PodMetadata != nil {
		in, out := &in.PodMetadata, &out.PodMetadata
		*out = new(EmbeddedObjectMetadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(string)
		**out = **in
	}
	if in.ImagePullSecrets != nil {
		in, out := &in.ImagePullSecrets, &out.ImagePullSecrets
		*out = make([]corev1.LocalObjectReference, len(*in))
		copy(*out, *in)
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ConfigMaps != nil {
		in, out := &in.ConfigMaps, &out.ConfigMaps
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
	if in.Storage != nil {
		in, out := &in.Storage, &out.Storage
		*out = new(StorageSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Volumes != nil {
		in, out := &in.Volumes, &out.Volumes
		*out = make([]corev1.Volume, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.VolumeMounts != nil {
		in, out := &in.VolumeMounts, &out.VolumeMounts
		*out = make([]corev1.VolumeMount, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PersistentVolumeClaimRetentionPolicy != nil {
		in, out := &in.PersistentVolumeClaimRetentionPolicy, &out.PersistentVolumeClaimRetentionPolicy
		*out = new(appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy)
		**out = **in
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Resources.DeepCopyInto(&out.Resources)
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SecurityContext != nil {
		in, out := &in.SecurityContext, &out.SecurityContext
		*out = new(corev1.PodSecurityContext)
		(*in).DeepCopyInto(*out)
	}
	if in.DNSPolicy != nil {
		in, out := &in.DNSPolicy, &out.DNSPolicy
		*out = new(DNSPolicy)
		**out = **in
	}
	if in.DNSConfig != nil {
		in, out := &in.DNSConfig, &out.DNSConfig
		*out = new(PodDNSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.EnableServiceLinks != nil {
		in, out := &in.EnableServiceLinks, &out.EnableServiceLinks
		*out = new(bool)
		**out = **in
	}
	if in.ServiceName != nil {
		in, out := &in.ServiceName, &out.ServiceName
		*out = new(string)
		**out = **in
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]corev1.Container, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]corev1.Container, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AdditionalPeers != nil {
		in, out := &in.AdditionalPeers, &out.AdditionalPeers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ClusterLabel != nil {
		in, out := &in.ClusterLabel, &out.ClusterLabel
		*out = new(string)
		**out = **in
	}
	if in.AlertmanagerConfigSelector != nil {
		in, out := &in.AlertmanagerConfigSelector, &out.AlertmanagerConfigSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.AlertmanagerConfigNamespaceSelector != nil {
		in, out := &in.AlertmanagerConfigNamespaceSelector, &out.AlertmanagerConfigNamespaceSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	out.AlertmanagerConfigMatcherStrategy = in.AlertmanagerConfigMatcherStrategy
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.HostAliases != nil {
		in, out := &in.HostAliases, &out.HostAliases
		*out = make([]HostAlias, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Web != nil {
		in, out := &in.Web, &out.Web
		*out = new(AlertmanagerWebSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Limits != nil {
		in, out := &in.Limits, &out.Limits
		*out = new(AlertmanagerLimitsSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.ClusterTLS != nil {
		in, out := &in.ClusterTLS, &out.ClusterTLS
		*out = new(ClusterTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.AlertmanagerConfiguration != nil {
		in, out := &in.AlertmanagerConfiguration, &out.AlertmanagerConfiguration
		*out = new(AlertmanagerConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.AutomountServiceAccountToken != nil {
		in, out := &in.AutomountServiceAccountToken, &out.AutomountServiceAccountToken
		*out = new(bool)
		**out = **in
	}
	if in.EnableFeatures != nil {
		in, out := &in.EnableFeatures, &out.EnableFeatures
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.AdditionalArgs != nil {
		in, out := &in.AdditionalArgs, &out.AdditionalArgs
		*out = make([]Argument, len(*in))
		copy(*out, *in)
	}
	if in.TerminationGracePeriodSeconds != nil {
		in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.HostUsers != nil {
		in, out := &in.HostUsers, &out.HostUsers
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerSpec.
func (in *AlertmanagerSpec) DeepCopy() *AlertmanagerSpec {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerStatus) DeepCopyInto(out *AlertmanagerStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerStatus.
func (in *AlertmanagerStatus) DeepCopy() *AlertmanagerStatus {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerWebSpec) DeepCopyInto(out *AlertmanagerWebSpec) {
	*out = *in
	in.WebConfigFileFields.DeepCopyInto(&out.WebConfigFileFields)
	if in.GetConcurrency != nil {
		in, out := &in.GetConcurrency, &out.GetConcurrency
		*out = new(uint32)
		**out = **in
	}
	if in.Timeout != nil {
		in, out := &in.Timeout, &out.Timeout
		*out = new(uint32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerWebSpec.
func (in *AlertmanagerWebSpec) DeepCopy() *AlertmanagerWebSpec {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerWebSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ArbitraryFSAccessThroughSMsConfig) DeepCopyInto(out *ArbitraryFSAccessThroughSMsConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ArbitraryFSAccessThroughSMsConfig.
func (in *ArbitraryFSAccessThroughSMsConfig) DeepCopy() *ArbitraryFSAccessThroughSMsConfig {
	if in == nil {
		return nil
	}
	out := new(ArbitraryFSAccessThroughSMsConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Argument) DeepCopyInto(out *Argument) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Argument.
func (in *Argument) DeepCopy() *Argument {
	if in == nil {
		return nil
	}
	out := new(Argument)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AttachMetadata) DeepCopyInto(out *AttachMetadata) {
	*out = *in
	if in.Node != nil {
		in, out := &in.Node, &out.Node
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AttachMetadata.
func (in *AttachMetadata) DeepCopy() *AttachMetadata {
	if in == nil {
		return nil
	}
	out := new(AttachMetadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Authorization) DeepCopyInto(out *Authorization) {
	*out = *in
	in.SafeAuthorization.DeepCopyInto(&out.SafeAuthorization)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Authorization.
func (in *Authorization) DeepCopy() *Authorization {
	if in == nil {
		return nil
	}
	out := new(Authorization)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AzureAD) DeepCopyInto(out *AzureAD) {
	*out = *in
	if in.Cloud != nil {
		in, out := &in.Cloud, &out.Cloud
		*out = new(string)
		**out = **in
	}
	if in.ManagedIdentity != nil {
		in, out := &in.ManagedIdentity, &out.ManagedIdentity
		*out = new(ManagedIdentity)
		**out = **in
	}
	if in.OAuth != nil {
		in, out := &in.OAuth, &out.OAuth
		*out = new(AzureOAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.SDK != nil {
		in, out := &in.SDK, &out.SDK
		*out = new(AzureSDK)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AzureAD.
func (in *AzureAD) DeepCopy() *AzureAD {
	if in == nil {
		return nil
	}
	out := new(AzureAD)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AzureOAuth) DeepCopyInto(out *AzureOAuth) {
	*out = *in
	in.ClientSecret.DeepCopyInto(&out.ClientSecret)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AzureOAuth.
func (in *AzureOAuth) DeepCopy() *AzureOAuth {
	if in == nil {
		return nil
	}
	out := new(AzureOAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AzureSDK) DeepCopyInto(out *AzureSDK) {
	*out = *in
	if in.TenantID != nil {
		in, out := &in.TenantID, &out.TenantID
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AzureSDK.
func (in *AzureSDK) DeepCopy() *AzureSDK {
	if in == nil {
		return nil
	}
	out := new(AzureSDK)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BasicAuth) DeepCopyInto(out *BasicAuth) {
	*out = *in
	in.Username.DeepCopyInto(&out.Username)
	in.Password.DeepCopyInto(&out.Password)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BasicAuth.
func (in *BasicAuth) DeepCopy() *BasicAuth {
	if in == nil {
		return nil
	}
	out := new(BasicAuth)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterTLSConfig) DeepCopyInto(out *ClusterTLSConfig) {
	*out = *in
	in.ServerTLS.DeepCopyInto(&out.ServerTLS)
	in.ClientTLS.DeepCopyInto(&out.ClientTLS)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterTLSConfig.
func (in *ClusterTLSConfig) DeepCopy() *ClusterTLSConfig {
	if in == nil {
		return nil
	}
	out := new(ClusterTLSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CommonPrometheusFields) DeepCopyInto(out *CommonPrometheusFields) {
	*out = *in
	if in.PodMetadata != nil {
		in, out := &in.PodMetadata, &out.PodMetadata
		*out = new(EmbeddedObjectMetadata)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceMonitorSelector != nil {
		in, out := &in.ServiceMonitorSelector, &out.ServiceMonitorSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceMonitorNamespaceSelector != nil {
		in, out := &in.ServiceMonitorNamespaceSelector, &out.ServiceMonitorNamespaceSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.PodMonitorSelector != nil {
		in, out := &in.PodMonitorSelector, &out.PodMonitorSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.PodMonitorNamespaceSelector != nil {
		in, out := &in.PodMonitorNamespaceSelector, &out.PodMonitorNamespaceSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ProbeSelector != nil {
		in, out := &in.ProbeSelector, &out.ProbeSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ProbeNamespaceSelector != nil {
		in, out := &in.ProbeNamespaceSelector, &out.ProbeNamespaceSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ScrapeConfigSelector != nil {
		in, out := &in.ScrapeConfigSelector, &out.ScrapeConfigSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ScrapeConfigNamespaceSelector != nil {
		in, out := &in.ScrapeConfigNamespaceSelector, &out.ScrapeConfigNamespaceSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(string)
		**out = **in
	}
	if in.ImagePullSecrets != nil {
		in, out := &in.ImagePullSecrets, &out.ImagePullSecrets
		*out = make([]corev1.LocalObjectReference, len(*in))
		copy(*out, *in)
	}
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
	if in.Shards != nil {
		in, out := &in.Shards, &out.Shards
		*out = new(int32)
		**out = **in
	}
	if in.ReplicaExternalLabelName != nil {
		in, out := &in.ReplicaExternalLabelName, &out.ReplicaExternalLabelName
		*out = new(string)
		**out = **in
	}
	if in.PrometheusExternalLabelName != nil {
		in, out := &in.PrometheusExternalLabelName, &out.PrometheusExternalLabelName
		*out = new(string)
		**out = **in
	}
	if in.ScrapeProtocols != nil {
		in, out := &in.ScrapeProtocols, &out.ScrapeProtocols
		*out = make([]ScrapeProtocol, len(*in))
		copy(*out, *in)
	}
	if in.ExternalLabels != nil {
		in, out := &in.ExternalLabels, &out.ExternalLabels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.EnableOTLPReceiver != nil {
		in, out := &in.EnableOTLPReceiver, &out.EnableOTLPReceiver
		*out = new(bool)
		**out = **in
	}
	if in.RemoteWriteReceiverMessageVersions != nil {
		in, out := &in.RemoteWriteReceiverMessageVersions, &out.RemoteWriteReceiverMessageVersions
		*out = make([]RemoteWriteMessageVersion, len(*in))
		copy(*out, *in)
	}
	if in.EnableFeatures != nil {
		in, out := &in.EnableFeatures, &out.EnableFeatures
		*out = make([]EnableFeature, len(*in))
		copy(*out, *in)
	}
	if in.Storage != nil {
		in, out := &in.Storage, &out.Storage
		*out = new(StorageSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Volumes != nil {
		in, out := &in.Volumes, &out.Volumes
		*out = make([]corev1.Volume, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.VolumeMounts != nil {
		in, out := &in.VolumeMounts, &out.VolumeMounts
		*out = make([]corev1.VolumeMount, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PersistentVolumeClaimRetentionPolicy != nil {
		in, out := &in.PersistentVolumeClaimRetentionPolicy, &out.PersistentVolumeClaimRetentionPolicy
		*out = new(appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy)
		**out = **in
	}
	if in.Web != nil {
		in, out := &in.Web, &out.Web
		*out = new(PrometheusWebSpec)
		(*in).DeepCopyInto(*out)
	}
	in.Resources.DeepCopyInto(&out.Resources)
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.AutomountServiceAccountToken != nil {
		in, out := &in.AutomountServiceAccountToken, &out.AutomountServiceAccountToken
		*out = new(bool)
		**out = **in
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ConfigMaps != nil {
		in, out := &in.ConfigMaps, &out.ConfigMaps
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RemoteWrite != nil {
		in, out := &in.RemoteWrite, &out.RemoteWrite
		*out = make([]RemoteWriteSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.OTLP != nil {
		in, out := &in.OTLP, &out.OTLP
		*out = new(OTLPConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.SecurityContext != nil {
		in, out := &in.SecurityContext, &out.SecurityContext
		*out = new(corev1.PodSecurityContext)
		(*in).DeepCopyInto(*out)
	}
	if in.DNSPolicy != nil {
		in, out := &in.DNSPolicy, &out.DNSPolicy
		*out = new(DNSPolicy)
		**out = **in
	}
	if in.DNSConfig != nil {
		in, out := &in.DNSConfig, &out.DNSConfig
		*out = new(PodDNSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.EnableServiceLinks != nil {
		in, out := &in.EnableServiceLinks, &out.EnableServiceLinks
		*out = new(bool)
		**out = **in
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]corev1.Container, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]corev1.Container, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AdditionalScrapeConfigs != nil {
		in, out := &in.AdditionalScrapeConfigs, &out.AdditionalScrapeConfigs
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.APIServerConfig != nil {
		in, out := &in.APIServerConfig, &out.APIServerConfig
		*out = new(APIServerConfig)
		(*in).DeepCopyInto(*out)
	}
	out.ArbitraryFSAccessThroughSMs = in.ArbitraryFSAccessThroughSMs
	if in.EnforcedSampleLimit != nil {
		in, out := &in.EnforcedSampleLimit, &out.EnforcedSampleLimit
		*out = new(uint64)
		**out = **in
	}
	if in.EnforcedTargetLimit != nil {
		in, out := &in.EnforcedTargetLimit, &out.EnforcedTargetLimit
		*out = new(uint64)
		**out = **in
	}
	if in.EnforcedLabelLimit != nil {
		in, out := &in.EnforcedLabelLimit, &out.EnforcedLabelLimit
		*out = new(uint64)
		**out = **in
	}
	if in.EnforcedLabelNameLengthLimit != nil {
		in, out := &in.EnforcedLabelNameLengthLimit, &out.EnforcedLabelNameLengthLimit
		*out = new(uint64)
		**out = **in
	}
	if in.EnforcedLabelValueLengthLimit != nil {
		in, out := &in.EnforcedLabelValueLengthLimit, &out.EnforcedLabelValueLengthLimit
		*out = new(uint64)
		**out = **in
	}
	if in.EnforcedKeepDroppedTargets != nil {
		in, out := &in.EnforcedKeepDroppedTargets, &out.EnforcedKeepDroppedTargets
		*out = new(uint64)
		**out = **in
	}
	if in.NameValidationScheme != nil {
		in, out := &in.NameValidationScheme, &out.NameValidationScheme
		*out = new(NameValidationSchemeOptions)
		**out = **in
	}
	if in.NameEscapingScheme != nil {
		in, out := &in.NameEscapingScheme, &out.NameEscapingScheme
		*out = new(NameEscapingSchemeOptions)
		**out = **in
	}
	if in.ConvertClassicHistogramsToNHCB != nil {
		in, out := &in.ConvertClassicHistogramsToNHCB, &out.ConvertClassicHistogramsToNHCB
		*out = new(bool)
		**out = **in
	}
	if in.ScrapeClassicHistograms != nil {
		in, out := &in.ScrapeClassicHistograms, &out.ScrapeClassicHistograms
		*out = new(bool)
		**out = **in
	}
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.HostAliases != nil {
		in, out := &in.HostAliases, &out.HostAliases
		*out = make([]HostAlias, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AdditionalArgs != nil {
		in, out := &in.AdditionalArgs, &out.AdditionalArgs
		*out = make([]Argument, len(*in))
		copy(*out, *in)
	}
	if in.WALCompression != nil {
		in, out := &in.WALCompression, &out.WALCompression
		*out = new(bool)
		**out = **in
	}
	if in.ExcludedFromEnforcement != nil {
		in, out := &in.ExcludedFromEnforcement, &out.ExcludedFromEnforcement
		*out = make([]ObjectReference, len(*in))
		copy(*out, *in)
	}
	if in.PodTargetLabels != nil {
		in, out := &in.PodTargetLabels, &out.PodTargetLabels
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.TracingConfig != nil {
		in, out := &in.TracingConfig, &out.TracingConfig
		*out = new(PrometheusTracingConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.BodySizeLimit != nil {
		in, out := &in.BodySizeLimit, &out.BodySizeLimit
		*out = new(ByteSize)
		**out = **in
	}
	if in.SampleLimit != nil {
		in, out := &in.SampleLimit, &out.SampleLimit
		*out = new(uint64)
		**out = **in
	}
	if in.TargetLimit != nil {
		in, out := &in.TargetLimit, &out.TargetLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelLimit != nil {
		in, out := &in.LabelLimit, &out.LabelLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelNameLengthLimit != nil {
		in, out := &in.LabelNameLengthLimit, &out.LabelNameLengthLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelValueLengthLimit != nil {
		in, out := &in.LabelValueLengthLimit, &out.LabelValueLengthLimit
		*out = new(uint64)
		**out = **in
	}
	if in.KeepDroppedTargets != nil {
		in, out := &in.KeepDroppedTargets, &out.KeepDroppedTargets
		*out = new(uint64)
		**out = **in
	}
	if in.ReloadStrategy != nil {
		in, out := &in.ReloadStrategy, &out.ReloadStrategy
		*out = new(ReloadStrategyType)
		**out = **in
	}
	if in.MaximumStartupDurationSeconds != nil {
		in, out := &in.MaximumStartupDurationSeconds, &out.MaximumStartupDurationSeconds
		*out = new(int32)
		**out = **in
	}
	if in.ScrapeClasses != nil {
		in, out := &in.ScrapeClasses, &out.ScrapeClasses
		*out = make([]ScrapeClass, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ServiceDiscoveryRole != nil {
		in, out := &in.ServiceDiscoveryRole, &out.ServiceDiscoveryRole
		*out = new(ServiceDiscoveryRole)
		**out = **in
	}
	if in.TSDB != nil {
		in, out := &in.TSDB, &out.TSDB
		*out = new(TSDBSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.ScrapeFailureLogFile != nil {
		in, out := &in.ScrapeFailureLogFile, &out.ScrapeFailureLogFile
		*out = new(string)
		**out = **in
	}
	if in.ServiceName != nil {
		in, out := &in.ServiceName, &out.ServiceName
		*out = new(string)
		**out = **in
	}
	if in.Runtime != nil {
		in, out := &in.Runtime, &out.Runtime
		*out = new(RuntimeConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.TerminationGracePeriodSeconds != nil {
		in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.HostUsers != nil {
		in, out := &in.HostUsers, &out.HostUsers
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CommonPrometheusFields.
func (in *CommonPrometheusFields) DeepCopy() *CommonPrometheusFields {
	if in == nil {
		return nil
	}
	out := new(CommonPrometheusFields)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Condition) DeepCopyInto(out *Condition) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Condition.
func (in *Condition) DeepCopy() *Condition {
	if in == nil {
		return nil
	}
	out := new(Condition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConfigResourceCondition) DeepCopyInto(out *ConfigResourceCondition) {
	*out = *in
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConfigResourceCondition.
func (in *ConfigResourceCondition) DeepCopy() *ConfigResourceCondition {
	if in == nil {
		return nil
	}
	out := new(ConfigResourceCondition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConfigResourceStatus) DeepCopyInto(out *ConfigResourceStatus) {
	*out = *in
	if in.Bindings != nil {
		in, out := &in.Bindings, &out.Bindings
		*out = make([]WorkloadBinding, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConfigResourceStatus.
func (in *ConfigResourceStatus) DeepCopy() *ConfigResourceStatus {
	if in == nil {
		return nil
	}
	out := new(ConfigResourceStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CoreV1TopologySpreadConstraint) DeepCopyInto(out *CoreV1TopologySpreadConstraint) {
	*out = *in
	if in.LabelSelector != nil {
		in, out := &in.LabelSelector, &out.LabelSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.MinDomains != nil {
		in, out := &in.MinDomains, &out.MinDomains
		*out = new(int32)
		**out = **in
	}
	if in.NodeAffinityPolicy != nil {
		in, out := &in.NodeAffinityPolicy, &out.NodeAffinityPolicy
		*out = new(corev1.NodeInclusionPolicy)
		**out = **in
	}
	if in.NodeTaintsPolicy != nil {
		in, out := &in.NodeTaintsPolicy, &out.NodeTaintsPolicy
		*out = new(corev1.NodeInclusionPolicy)
		**out = **in
	}
	if in.MatchLabelKeys != nil {
		in, out := &in.MatchLabelKeys, &out.MatchLabelKeys
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CoreV1TopologySpreadConstraint.
func (in *CoreV1TopologySpreadConstraint) DeepCopy() *CoreV1TopologySpreadConstraint {
	if in == nil {
		return nil
	}
	out := new(CoreV1TopologySpreadConstraint)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EmbeddedObjectMetadata) DeepCopyInto(out *EmbeddedObjectMetadata) {
	*out = *in
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EmbeddedObjectMetadata.
func (in *EmbeddedObjectMetadata) DeepCopy() *EmbeddedObjectMetadata {
	if in == nil {
		return nil
	}
	out := new(EmbeddedObjectMetadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EmbeddedPersistentVolumeClaim) DeepCopyInto(out *EmbeddedPersistentVolumeClaim) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.EmbeddedObjectMetadata.DeepCopyInto(&out.EmbeddedObjectMetadata)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EmbeddedPersistentVolumeClaim.
func (in *EmbeddedPersistentVolumeClaim) DeepCopy() *EmbeddedPersistentVolumeClaim {
	if in == nil {
		return nil
	}
	out := new(EmbeddedPersistentVolumeClaim)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Endpoint) DeepCopyInto(out *Endpoint) {
	*out = *in
	if in.TargetPort != nil {
		in, out := &in.TargetPort, &out.TargetPort
		*out = new(intstr.IntOrString)
		**out = **in
	}
	if in.Params != nil {
		in, out := &in.Params, &out.Params
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				inVal := (*in)[key]
				in, out := &inVal, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.BearerTokenSecret != nil {
		in, out := &in.BearerTokenSecret, &out.BearerTokenSecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.HonorTimestamps != nil {
		in, out := &in.HonorTimestamps, &out.HonorTimestamps
		*out = new(bool)
		**out = **in
	}
	if in.TrackTimestampsStaleness != nil {
		in, out := &in.TrackTimestampsStaleness, &out.TrackTimestampsStaleness
		*out = new(bool)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.MetricRelabelConfigs != nil {
		in, out := &in.MetricRelabelConfigs, &out.MetricRelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RelabelConfigs != nil {
		in, out := &in.RelabelConfigs, &out.RelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHttp2 != nil {
		in, out := &in.EnableHttp2, &out.EnableHttp2
		*out = new(bool)
		**out = **in
	}
	if in.FilterRunning != nil {
		in, out := &in.FilterRunning, &out.FilterRunning
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Endpoint.
func (in *Endpoint) DeepCopy() *Endpoint {
	if in == nil {
		return nil
	}
	out := new(Endpoint)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Exemplars) DeepCopyInto(out *Exemplars) {
	*out = *in
	if in.MaxSize != nil {
		in, out := &in.MaxSize, &out.MaxSize
		*out = new(int64)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Exemplars.
func (in *Exemplars) DeepCopy() *Exemplars {
	if in == nil {
		return nil
	}
	out := new(Exemplars)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalJiraConfig) DeepCopyInto(out *GlobalJiraConfig) {
	*out = *in
	if in.APIURL != nil {
		in, out := &in.APIURL, &out.APIURL
		*out = new(URL)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalJiraConfig.
func (in *GlobalJiraConfig) DeepCopy() *GlobalJiraConfig {
	if in == nil {
		return nil
	}
	out := new(GlobalJiraConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalRocketChatConfig) DeepCopyInto(out *GlobalRocketChatConfig) {
	*out = *in
	if in.APIURL != nil {
		in, out := &in.APIURL, &out.APIURL
		*out = new(URL)
		**out = **in
	}
	if in.Token != nil {
		in, out := &in.Token, &out.Token
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.TokenID != nil {
		in, out := &in.TokenID, &out.TokenID
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalRocketChatConfig.
func (in *GlobalRocketChatConfig) DeepCopy() *GlobalRocketChatConfig {
	if in == nil {
		return nil
	}
	out := new(GlobalRocketChatConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalSMTPConfig) DeepCopyInto(out *GlobalSMTPConfig) {
	*out = *in
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(string)
		**out = **in
	}
	if in.SmartHost != nil {
		in, out := &in.SmartHost, &out.SmartHost
		*out = new(HostPort)
		**out = **in
	}
	if in.Hello != nil {
		in, out := &in.Hello, &out.Hello
		*out = new(string)
		**out = **in
	}
	if in.AuthUsername != nil {
		in, out := &in.AuthUsername, &out.AuthUsername
		*out = new(string)
		**out = **in
	}
	if in.AuthPassword != nil {
		in, out := &in.AuthPassword, &out.AuthPassword
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.AuthIdentity != nil {
		in, out := &in.AuthIdentity, &out.AuthIdentity
		*out = new(string)
		**out = **in
	}
	if in.AuthSecret != nil {
		in, out := &in.AuthSecret, &out.AuthSecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.RequireTLS != nil {
		in, out := &in.RequireTLS, &out.RequireTLS
		*out = new(bool)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalSMTPConfig.
func (in *GlobalSMTPConfig) DeepCopy() *GlobalSMTPConfig {
	if in == nil {
		return nil
	}
	out := new(GlobalSMTPConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalTelegramConfig) DeepCopyInto(out *GlobalTelegramConfig) {
	*out = *in
	if in.APIURL != nil {
		in, out := &in.APIURL, &out.APIURL
		*out = new(URL)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalTelegramConfig.
func (in *GlobalTelegramConfig) DeepCopy() *GlobalTelegramConfig {
	if in == nil {
		return nil
	}
	out := new(GlobalTelegramConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalVictorOpsConfig) DeepCopyInto(out *GlobalVictorOpsConfig) {
	*out = *in
	if in.APIURL != nil {
		in, out := &in.APIURL, &out.APIURL
		*out = new(URL)
		**out = **in
	}
	if in.APIKey != nil {
		in, out := &in.APIKey, &out.APIKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalVictorOpsConfig.
func (in *GlobalVictorOpsConfig) DeepCopy() *GlobalVictorOpsConfig {
	if in == nil {
		return nil
	}
	out := new(GlobalVictorOpsConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalWeChatConfig) DeepCopyInto(out *GlobalWeChatConfig) {
	*out = *in
	if in.APIURL != nil {
		in, out := &in.APIURL, &out.APIURL
		*out = new(URL)
		**out = **in
	}
	if in.APISecret != nil {
		in, out := &in.APISecret, &out.APISecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.APICorpID != nil {
		in, out := &in.APICorpID, &out.APICorpID
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalWeChatConfig.
func (in *GlobalWeChatConfig) DeepCopy() *GlobalWeChatConfig {
	if in == nil {
		return nil
	}
	out := new(GlobalWeChatConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GlobalWebexConfig) DeepCopyInto(out *GlobalWebexConfig) {
	*out = *in
	if in.APIURL != nil {
		in, out := &in.APIURL, &out.APIURL
		*out = new(URL)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GlobalWebexConfig.
func (in *GlobalWebexConfig) DeepCopy() *GlobalWebexConfig {
	if in == nil {
		return nil
	}
	out := new(GlobalWebexConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPConfig) DeepCopyInto(out *HTTPConfig) {
	*out = *in
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.BearerTokenSecret != nil {
		in, out := &in.BearerTokenSecret, &out.BearerTokenSecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPConfig.
func (in *HTTPConfig) DeepCopy() *HTTPConfig {
	if in == nil {
		return nil
	}
	out := new(HTTPConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostAlias) DeepCopyInto(out *HostAlias) {
	*out = *in
	if in.Hostnames != nil {
		in, out := &in.Hostnames, &out.Hostnames
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostAlias.
func (in *HostAlias) DeepCopy() *HostAlias {
	if in == nil {
		return nil
	}
	out := new(HostAlias)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostPort) DeepCopyInto(out *HostPort) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostPort.
func (in *HostPort) DeepCopy() *HostPort {
	if in == nil {
		return nil
	}
	out := new(HostPort)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagedIdentity) DeepCopyInto(out *ManagedIdentity) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagedIdentity.
func (in *ManagedIdentity) DeepCopy() *ManagedIdentity {
	if in == nil {
		return nil
	}
	out := new(ManagedIdentity)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MetadataConfig) DeepCopyInto(out *MetadataConfig) {
	*out = *in
	if in.MaxSamplesPerSend != nil {
		in, out := &in.MaxSamplesPerSend, &out.MaxSamplesPerSend
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MetadataConfig.
func (in *MetadataConfig) DeepCopy() *MetadataConfig {
	if in == nil {
		return nil
	}
	out := new(MetadataConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NamespaceSelector) DeepCopyInto(out *NamespaceSelector) {
	*out = *in
	if in.MatchNames != nil {
		in, out := &in.MatchNames, &out.MatchNames
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NamespaceSelector.
func (in *NamespaceSelector) DeepCopy() *NamespaceSelector {
	if in == nil {
		return nil
	}
	out := new(NamespaceSelector)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NativeHistogramConfig) DeepCopyInto(out *NativeHistogramConfig) {
	*out = *in
	if in.ScrapeClassicHistograms != nil {
		in, out := &in.ScrapeClassicHistograms, &out.ScrapeClassicHistograms
		*out = new(bool)
		**out = **in
	}
	if in.NativeHistogramBucketLimit != nil {
		in, out := &in.NativeHistogramBucketLimit, &out.NativeHistogramBucketLimit
		*out = new(uint64)
		**out = **in
	}
	if in.NativeHistogramMinBucketFactor != nil {
		in, out := &in.NativeHistogramMinBucketFactor, &out.NativeHistogramMinBucketFactor
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.ConvertClassicHistogramsToNHCB != nil {
		in, out := &in.ConvertClassicHistogramsToNHCB, &out.ConvertClassicHistogramsToNHCB
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NativeHistogramConfig.
func (in *NativeHistogramConfig) DeepCopy() *NativeHistogramConfig {
	if in == nil {
		return nil
	}
	out := new(NativeHistogramConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OAuth2) DeepCopyInto(out *OAuth2) {
	*out = *in
	in.ClientID.DeepCopyInto(&out.ClientID)
	in.ClientSecret.DeepCopyInto(&out.ClientSecret)
	if in.Scopes != nil {
		in, out := &in.Scopes, &out.Scopes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.EndpointParams != nil {
		in, out := &in.EndpointParams, &out.EndpointParams
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OAuth2.
func (in *OAuth2) DeepCopy() *OAuth2 {
	if in == nil {
		return nil
	}
	out := new(OAuth2)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OTLPConfig) DeepCopyInto(out *OTLPConfig) {
	*out = *in
	if in.PromoteAllResourceAttributes != nil {
		in, out := &in.PromoteAllResourceAttributes, &out.PromoteAllResourceAttributes
		*out = new(bool)
		**out = **in
	}
	if in.IgnoreResourceAttributes != nil {
		in, out := &in.IgnoreResourceAttributes, &out.IgnoreResourceAttributes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.PromoteResourceAttributes != nil {
		in, out := &in.PromoteResourceAttributes, &out.PromoteResourceAttributes
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.TranslationStrategy != nil {
		in, out := &in.TranslationStrategy, &out.TranslationStrategy
		*out = new(TranslationStrategyOption)
		**out = **in
	}
	if in.KeepIdentifyingResourceAttributes != nil {
		in, out := &in.KeepIdentifyingResourceAttributes, &out.KeepIdentifyingResourceAttributes
		*out = new(bool)
		**out = **in
	}
	if in.ConvertHistogramsToNHCB != nil {
		in, out := &in.ConvertHistogramsToNHCB, &out.ConvertHistogramsToNHCB
		*out = new(bool)
		**out = **in
	}
	if in.PromoteScopeMetadata != nil {
		in, out := &in.PromoteScopeMetadata, &out.PromoteScopeMetadata
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OTLPConfig.
func (in *OTLPConfig) DeepCopy() *OTLPConfig {
	if in == nil {
		return nil
	}
	out := new(OTLPConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectReference) DeepCopyInto(out *ObjectReference) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectReference.
func (in *ObjectReference) DeepCopy() *ObjectReference {
	if in == nil {
		return nil
	}
	out := new(ObjectReference)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodDNSConfig) DeepCopyInto(out *PodDNSConfig) {
	*out = *in
	if in.Nameservers != nil {
		in, out := &in.Nameservers, &out.Nameservers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Searches != nil {
		in, out := &in.Searches, &out.Searches
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Options != nil {
		in, out := &in.Options, &out.Options
		*out = make([]PodDNSConfigOption, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodDNSConfig.
func (in *PodDNSConfig) DeepCopy() *PodDNSConfig {
	if in == nil {
		return nil
	}
	out := new(PodDNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodDNSConfigOption) DeepCopyInto(out *PodDNSConfigOption) {
	*out = *in
	if in.Value != nil {
		in, out := &in.Value, &out.Value
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodDNSConfigOption.
func (in *PodDNSConfigOption) DeepCopy() *PodDNSConfigOption {
	if in == nil {
		return nil
	}
	out := new(PodDNSConfigOption)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodMetricsEndpoint) DeepCopyInto(out *PodMetricsEndpoint) {
	*out = *in
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(string)
		**out = **in
	}
	if in.PortNumber != nil {
		in, out := &in.PortNumber, &out.PortNumber
		*out = new(int32)
		**out = **in
	}
	if in.TargetPort != nil {
		in, out := &in.TargetPort, &out.TargetPort
		*out = new(intstr.IntOrString)
		**out = **in
	}
	if in.Params != nil {
		in, out := &in.Params, &out.Params
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				inVal := (*in)[key]
				in, out := &inVal, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	if in.HonorTimestamps != nil {
		in, out := &in.HonorTimestamps, &out.HonorTimestamps
		*out = new(bool)
		**out = **in
	}
	if in.TrackTimestampsStaleness != nil {
		in, out := &in.TrackTimestampsStaleness, &out.TrackTimestampsStaleness
		*out = new(bool)
		**out = **in
	}
	if in.MetricRelabelConfigs != nil {
		in, out := &in.MetricRelabelConfigs, &out.MetricRelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RelabelConfigs != nil {
		in, out := &in.RelabelConfigs, &out.RelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.FilterRunning != nil {
		in, out := &in.FilterRunning, &out.FilterRunning
		*out = new(bool)
		**out = **in
	}
	in.HTTPConfig.DeepCopyInto(&out.HTTPConfig)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodMetricsEndpoint.
func (in *PodMetricsEndpoint) DeepCopy() *PodMetricsEndpoint {
	if in == nil {
		return nil
	}
	out := new(PodMetricsEndpoint)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodMonitor) DeepCopyInto(out *PodMonitor) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodMonitor.
func (in *PodMonitor) DeepCopy() *PodMonitor {
	if in == nil {
		return nil
	}
	out := new(PodMonitor)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodMonitorList) DeepCopyInto(out *PodMonitorList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]PodMonitor, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodMonitorList.
func (in *PodMonitorList) DeepCopy() *PodMonitorList {
	if in == nil {
		return nil
	}
	out := new(PodMonitorList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodMonitorSpec) DeepCopyInto(out *PodMonitorSpec) {
	*out = *in
	if in.PodTargetLabels != nil {
		in, out := &in.PodTargetLabels, &out.PodTargetLabels
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.PodMetricsEndpoints != nil {
		in, out := &in.PodMetricsEndpoints, &out.PodMetricsEndpoints
		*out = make([]PodMetricsEndpoint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.Selector.DeepCopyInto(&out.Selector)
	if in.SelectorMechanism != nil {
		in, out := &in.SelectorMechanism, &out.SelectorMechanism
		*out = new(SelectorMechanism)
		**out = **in
	}
	in.NamespaceSelector.DeepCopyInto(&out.NamespaceSelector)
	if in.SampleLimit != nil {
		in, out := &in.SampleLimit, &out.SampleLimit
		*out = new(uint64)
		**out = **in
	}
	if in.TargetLimit != nil {
		in, out := &in.TargetLimit, &out.TargetLimit
		*out = new(uint64)
		**out = **in
	}
	if in.ScrapeProtocols != nil {
		in, out := &in.ScrapeProtocols, &out.ScrapeProtocols
		*out = make([]ScrapeProtocol, len(*in))
		copy(*out, *in)
	}
	if in.FallbackScrapeProtocol != nil {
		in, out := &in.FallbackScrapeProtocol, &out.FallbackScrapeProtocol
		*out = new(ScrapeProtocol)
		**out = **in
	}
	if in.LabelLimit != nil {
		in, out := &in.LabelLimit, &out.LabelLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelNameLengthLimit != nil {
		in, out := &in.LabelNameLengthLimit, &out.LabelNameLengthLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelValueLengthLimit != nil {
		in, out := &in.LabelValueLengthLimit, &out.LabelValueLengthLimit
		*out = new(uint64)
		**out = **in
	}
	in.NativeHistogramConfig.DeepCopyInto(&out.NativeHistogramConfig)
	if in.KeepDroppedTargets != nil {
		in, out := &in.KeepDroppedTargets, &out.KeepDroppedTargets
		*out = new(uint64)
		**out = **in
	}
	if in.AttachMetadata != nil {
		in, out := &in.AttachMetadata, &out.AttachMetadata
		*out = new(AttachMetadata)
		(*in).DeepCopyInto(*out)
	}
	if in.ScrapeClassName != nil {
		in, out := &in.ScrapeClassName, &out.ScrapeClassName
		*out = new(string)
		**out = **in
	}
	if in.BodySizeLimit != nil {
		in, out := &in.BodySizeLimit, &out.BodySizeLimit
		*out = new(ByteSize)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodMonitorSpec.
func (in *PodMonitorSpec) DeepCopy() *PodMonitorSpec {
	if in == nil {
		return nil
	}
	out := new(PodMonitorSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Probe) DeepCopyInto(out *Probe) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Probe.
func (in *Probe) DeepCopy() *Probe {
	if in == nil {
		return nil
	}
	out := new(Probe)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProbeList) DeepCopyInto(out *ProbeList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Probe, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProbeList.
func (in *ProbeList) DeepCopy() *ProbeList {
	if in == nil {
		return nil
	}
	out := new(ProbeList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProbeParam) DeepCopyInto(out *ProbeParam) {
	*out = *in
	if in.Values != nil {
		in, out := &in.Values, &out.Values
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProbeParam.
func (in *ProbeParam) DeepCopy() *ProbeParam {
	if in == nil {
		return nil
	}
	out := new(ProbeParam)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProbeSpec) DeepCopyInto(out *ProbeSpec) {
	*out = *in
	in.ProberSpec.DeepCopyInto(&out.ProberSpec)
	in.Targets.DeepCopyInto(&out.Targets)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	in.BearerTokenSecret.DeepCopyInto(&out.BearerTokenSecret)
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.MetricRelabelConfigs != nil {
		in, out := &in.MetricRelabelConfigs, &out.MetricRelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.SampleLimit != nil {
		in, out := &in.SampleLimit, &out.SampleLimit
		*out = new(uint64)
		**out = **in
	}
	if in.TargetLimit != nil {
		in, out := &in.TargetLimit, &out.TargetLimit
		*out = new(uint64)
		**out = **in
	}
	if in.ScrapeProtocols != nil {
		in, out := &in.ScrapeProtocols, &out.ScrapeProtocols
		*out = make([]ScrapeProtocol, len(*in))
		copy(*out, *in)
	}
	if in.FallbackScrapeProtocol != nil {
		in, out := &in.FallbackScrapeProtocol, &out.FallbackScrapeProtocol
		*out = new(ScrapeProtocol)
		**out = **in
	}
	if in.LabelLimit != nil {
		in, out := &in.LabelLimit, &out.LabelLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelNameLengthLimit != nil {
		in, out := &in.LabelNameLengthLimit, &out.LabelNameLengthLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelValueLengthLimit != nil {
		in, out := &in.LabelValueLengthLimit, &out.LabelValueLengthLimit
		*out = new(uint64)
		**out = **in
	}
	in.NativeHistogramConfig.DeepCopyInto(&out.NativeHistogramConfig)
	if in.KeepDroppedTargets != nil {
		in, out := &in.KeepDroppedTargets, &out.KeepDroppedTargets
		*out = new(uint64)
		**out = **in
	}
	if in.ScrapeClassName != nil {
		in, out := &in.ScrapeClassName, &out.ScrapeClassName
		*out = new(string)
		**out = **in
	}
	if in.Params != nil {
		in, out := &in.Params, &out.Params
		*out = make([]ProbeParam, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProbeSpec.
func (in *ProbeSpec) DeepCopy() *ProbeSpec {
	if in == nil {
		return nil
	}
	out := new(ProbeSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProbeTargetIngress) DeepCopyInto(out *ProbeTargetIngress) {
	*out = *in
	in.Selector.DeepCopyInto(&out.Selector)
	in.NamespaceSelector.DeepCopyInto(&out.NamespaceSelector)
	if in.RelabelConfigs != nil {
		in, out := &in.RelabelConfigs, &out.RelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProbeTargetIngress.
func (in *ProbeTargetIngress) DeepCopy() *ProbeTargetIngress {
	if in == nil {
		return nil
	}
	out := new(ProbeTargetIngress)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProbeTargetStaticConfig) DeepCopyInto(out *ProbeTargetStaticConfig) {
	*out = *in
	if in.Targets != nil {
		in, out := &in.Targets, &out.Targets
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.RelabelConfigs != nil {
		in, out := &in.RelabelConfigs, &out.RelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProbeTargetStaticConfig.
func (in *ProbeTargetStaticConfig) DeepCopy() *ProbeTargetStaticConfig {
	if in == nil {
		return nil
	}
	out := new(ProbeTargetStaticConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProbeTargets) DeepCopyInto(out *ProbeTargets) {
	*out = *in
	if in.StaticConfig != nil {
		in, out := &in.StaticConfig, &out.StaticConfig
		*out = new(ProbeTargetStaticConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = new(ProbeTargetIngress)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProbeTargets.
func (in *ProbeTargets) DeepCopy() *ProbeTargets {
	if in == nil {
		return nil
	}
	out := new(ProbeTargets)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProberSpec) DeepCopyInto(out *ProberSpec) {
	*out = *in
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProberSpec.
func (in *ProberSpec) DeepCopy() *ProberSpec {
	if in == nil {
		return nil
	}
	out := new(ProberSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Prometheus) DeepCopyInto(out *Prometheus) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Prometheus.
func (in *Prometheus) DeepCopy() *Prometheus {
	if in == nil {
		return nil
	}
	out := new(Prometheus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusList) DeepCopyInto(out *PrometheusList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Prometheus, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusList.
func (in *PrometheusList) DeepCopy() *PrometheusList {
	if in == nil {
		return nil
	}
	out := new(PrometheusList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusRule) DeepCopyInto(out *PrometheusRule) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusRule.
func (in *PrometheusRule) DeepCopy() *PrometheusRule {
	if in == nil {
		return nil
	}
	out := new(PrometheusRule)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusRuleExcludeConfig) DeepCopyInto(out *PrometheusRuleExcludeConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusRuleExcludeConfig.
func (in *PrometheusRuleExcludeConfig) DeepCopy() *PrometheusRuleExcludeConfig {
	if in == nil {
		return nil
	}
	out := new(PrometheusRuleExcludeConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusRuleList) DeepCopyInto(out *PrometheusRuleList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]PrometheusRule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusRuleList.
func (in *PrometheusRuleList) DeepCopy() *PrometheusRuleList {
	if in == nil {
		return nil
	}
	out := new(PrometheusRuleList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusRuleSpec) DeepCopyInto(out *PrometheusRuleSpec) {
	*out = *in
	if in.Groups != nil {
		in, out := &in.Groups, &out.Groups
		*out = make([]RuleGroup, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusRuleSpec.
func (in *PrometheusRuleSpec) DeepCopy() *PrometheusRuleSpec {
	if in == nil {
		return nil
	}
	out := new(PrometheusRuleSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusSpec) DeepCopyInto(out *PrometheusSpec) {
	*out = *in
	in.CommonPrometheusFields.DeepCopyInto(&out.CommonPrometheusFields)
	if in.ShardRetentionPolicy != nil {
		in, out := &in.ShardRetentionPolicy, &out.ShardRetentionPolicy
		*out = new(ShardRetentionPolicy)
		(*in).DeepCopyInto(*out)
	}
	out.Rules = in.Rules
	if in.PrometheusRulesExcludedFromEnforce != nil {
		in, out := &in.PrometheusRulesExcludedFromEnforce, &out.PrometheusRulesExcludedFromEnforce
		*out = make([]PrometheusRuleExcludeConfig, len(*in))
		copy(*out, *in)
	}
	if in.RuleSelector != nil {
		in, out := &in.RuleSelector, &out.RuleSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.RuleNamespaceSelector != nil {
		in, out := &in.RuleNamespaceSelector, &out.RuleNamespaceSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Query != nil {
		in, out := &in.Query, &out.Query
		*out = new(QuerySpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Alerting != nil {
		in, out := &in.Alerting, &out.Alerting
		*out = new(AlertingSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.AdditionalAlertRelabelConfigs != nil {
		in, out := &in.AdditionalAlertRelabelConfigs, &out.AdditionalAlertRelabelConfigs
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.AdditionalAlertManagerConfigs != nil {
		in, out := &in.AdditionalAlertManagerConfigs, &out.AdditionalAlertManagerConfigs
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.RemoteRead != nil {
		in, out := &in.RemoteRead, &out.RemoteRead
		*out = make([]RemoteReadSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Thanos != nil {
		in, out := &in.Thanos, &out.Thanos
		*out = new(ThanosSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Exemplars != nil {
		in, out := &in.Exemplars, &out.Exemplars
		*out = new(Exemplars)
		(*in).DeepCopyInto(*out)
	}
	if in.RuleQueryOffset != nil {
		in, out := &in.RuleQueryOffset, &out.RuleQueryOffset
		*out = new(Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusSpec.
func (in *PrometheusSpec) DeepCopy() *PrometheusSpec {
	if in == nil {
		return nil
	}
	out := new(PrometheusSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusStatus) DeepCopyInto(out *PrometheusStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ShardStatuses != nil {
		in, out := &in.ShardStatuses, &out.ShardStatuses
		*out = make([]ShardStatus, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusStatus.
func (in *PrometheusStatus) DeepCopy() *PrometheusStatus {
	if in == nil {
		return nil
	}
	out := new(PrometheusStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusTracingConfig) DeepCopyInto(out *PrometheusTracingConfig) {
	*out = *in
	if in.ClientType != nil {
		in, out := &in.ClientType, &out.ClientType
		*out = new(string)
		**out = **in
	}
	if in.SamplingFraction != nil {
		in, out := &in.SamplingFraction, &out.SamplingFraction
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.Insecure != nil {
		in, out := &in.Insecure, &out.Insecure
		*out = new(bool)
		**out = **in
	}
	if in.Headers != nil {
		in, out := &in.Headers, &out.Headers
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Compression != nil {
		in, out := &in.Compression, &out.Compression
		*out = new(string)
		**out = **in
	}
	if in.Timeout != nil {
		in, out := &in.Timeout, &out.Timeout
		*out = new(Duration)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusTracingConfig.
func (in *PrometheusTracingConfig) DeepCopy() *PrometheusTracingConfig {
	if in == nil {
		return nil
	}
	out := new(PrometheusTracingConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusWebSpec) DeepCopyInto(out *PrometheusWebSpec) {
	*out = *in
	in.WebConfigFileFields.DeepCopyInto(&out.WebConfigFileFields)
	if in.PageTitle != nil {
		in, out := &in.PageTitle, &out.PageTitle
		*out = new(string)
		**out = **in
	}
	if in.MaxConnections != nil {
		in, out := &in.MaxConnections, &out.MaxConnections
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusWebSpec.
func (in *PrometheusWebSpec) DeepCopy() *PrometheusWebSpec {
	if in == nil {
		return nil
	}
	out := new(PrometheusWebSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProxyConfig) DeepCopyInto(out *ProxyConfig) {
	*out = *in
	if in.ProxyURL != nil {
		in, out := &in.ProxyURL, &out.ProxyURL
		*out = new(string)
		**out = **in
	}
	if in.NoProxy != nil {
		in, out := &in.NoProxy, &out.NoProxy
		*out = new(string)
		**out = **in
	}
	if in.ProxyFromEnvironment != nil {
		in, out := &in.ProxyFromEnvironment, &out.ProxyFromEnvironment
		*out = new(bool)
		**out = **in
	}
	if in.ProxyConnectHeader != nil {
		in, out := &in.ProxyConnectHeader, &out.ProxyConnectHeader
		*out = make(map[string][]corev1.SecretKeySelector, len(*in))
		for key, val := range *in {
			var outVal []corev1.SecretKeySelector
			if val == nil {
				(*out)[key] = nil
			} else {
				inVal := (*in)[key]
				in, out := &inVal, &outVal
				*out = make([]corev1.SecretKeySelector, len(*in))
				for i := range *in {
					(*in)[i].DeepCopyInto(&(*out)[i])
				}
			}
			(*out)[key] = outVal
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProxyConfig.
func (in *ProxyConfig) DeepCopy() *ProxyConfig {
	if in == nil {
		return nil
	}
	out := new(ProxyConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *QuerySpec) DeepCopyInto(out *QuerySpec) {
	*out = *in
	if in.LookbackDelta != nil {
		in, out := &in.LookbackDelta, &out.LookbackDelta
		*out = new(string)
		**out = **in
	}
	if in.MaxConcurrency != nil {
		in, out := &in.MaxConcurrency, &out.MaxConcurrency
		*out = new(int32)
		**out = **in
	}
	if in.MaxSamples != nil {
		in, out := &in.MaxSamples, &out.MaxSamples
		*out = new(int32)
		**out = **in
	}
	if in.Timeout != nil {
		in, out := &in.Timeout, &out.Timeout
		*out = new(Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new QuerySpec.
func (in *QuerySpec) DeepCopy() *QuerySpec {
	if in == nil {
		return nil
	}
	out := new(QuerySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *QueueConfig) DeepCopyInto(out *QueueConfig) {
	*out = *in
	if in.BatchSendDeadline != nil {
		in, out := &in.BatchSendDeadline, &out.BatchSendDeadline
		*out = new(Duration)
		**out = **in
	}
	if in.MinBackoff != nil {
		in, out := &in.MinBackoff, &out.MinBackoff
		*out = new(Duration)
		**out = **in
	}
	if in.MaxBackoff != nil {
		in, out := &in.MaxBackoff, &out.MaxBackoff
		*out = new(Duration)
		**out = **in
	}
	if in.SampleAgeLimit != nil {
		in, out := &in.SampleAgeLimit, &out.SampleAgeLimit
		*out = new(Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new QueueConfig.
func (in *QueueConfig) DeepCopy() *QueueConfig {
	if in == nil {
		return nil
	}
	out := new(QueueConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RelabelConfig) DeepCopyInto(out *RelabelConfig) {
	*out = *in
	if in.SourceLabels != nil {
		in, out := &in.SourceLabels, &out.SourceLabels
		*out = make([]LabelName, len(*in))
		copy(*out, *in)
	}
	if in.Separator != nil {
		in, out := &in.Separator, &out.Separator
		*out = new(string)
		**out = **in
	}
	if in.Replacement != nil {
		in, out := &in.Replacement, &out.Replacement
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RelabelConfig.
func (in *RelabelConfig) DeepCopy() *RelabelConfig {
	if in == nil {
		return nil
	}
	out := new(RelabelConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RemoteReadSpec) DeepCopyInto(out *RemoteReadSpec) {
	*out = *in
	if in.RequiredMatchers != nil {
		in, out := &in.RequiredMatchers, &out.RequiredMatchers
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.RemoteTimeout != nil {
		in, out := &in.RemoteTimeout, &out.RemoteTimeout
		*out = new(Duration)
		**out = **in
	}
	if in.Headers != nil {
		in, out := &in.Headers, &out.Headers
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(Authorization)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.FilterExternalLabels != nil {
		in, out := &in.FilterExternalLabels, &out.FilterExternalLabels
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RemoteReadSpec.
func (in *RemoteReadSpec) DeepCopy() *RemoteReadSpec {
	if in == nil {
		return nil
	}
	out := new(RemoteReadSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RemoteWriteSpec) DeepCopyInto(out *RemoteWriteSpec) {
	*out = *in
	if in.Name != nil {
		in, out := &in.Name, &out.Name
		*out = new(string)
		**out = **in
	}
	if in.MessageVersion != nil {
		in, out := &in.MessageVersion, &out.MessageVersion
		*out = new(RemoteWriteMessageVersion)
		**out = **in
	}
	if in.SendExemplars != nil {
		in, out := &in.SendExemplars, &out.SendExemplars
		*out = new(bool)
		**out = **in
	}
	if in.SendNativeHistograms != nil {
		in, out := &in.SendNativeHistograms, &out.SendNativeHistograms
		*out = new(bool)
		**out = **in
	}
	if in.RemoteTimeout != nil {
		in, out := &in.RemoteTimeout, &out.RemoteTimeout
		*out = new(Duration)
		**out = **in
	}
	if in.Headers != nil {
		in, out := &in.Headers, &out.Headers
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.WriteRelabelConfigs != nil {
		in, out := &in.WriteRelabelConfigs, &out.WriteRelabelConfigs
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(Authorization)
		(*in).DeepCopyInto(*out)
	}
	if in.Sigv4 != nil {
		in, out := &in.Sigv4, &out.Sigv4
		*out = new(Sigv4)
		(*in).DeepCopyInto(*out)
	}
	if in.AzureAD != nil {
		in, out := &in.AzureAD, &out.AzureAD
		*out = new(AzureAD)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.QueueConfig != nil {
		in, out := &in.QueueConfig, &out.QueueConfig
		*out = new(QueueConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MetadataConfig != nil {
		in, out := &in.MetadataConfig, &out.MetadataConfig
		*out = new(MetadataConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.EnableHttp2 != nil {
		in, out := &in.EnableHttp2, &out.EnableHttp2
		*out = new(bool)
		**out = **in
	}
	if in.RoundRobinDNS != nil {
		in, out := &in.RoundRobinDNS, &out.RoundRobinDNS
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RemoteWriteSpec.
func (in *RemoteWriteSpec) DeepCopy() *RemoteWriteSpec {
	if in == nil {
		return nil
	}
	out := new(RemoteWriteSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RetainConfig) DeepCopyInto(out *RetainConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RetainConfig.
func (in *RetainConfig) DeepCopy() *RetainConfig {
	if in == nil {
		return nil
	}
	out := new(RetainConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Rule) DeepCopyInto(out *Rule) {
	*out = *in
	out.Expr = in.Expr
	if in.For != nil {
		in, out := &in.For, &out.For
		*out = new(Duration)
		**out = **in
	}
	if in.KeepFiringFor != nil {
		in, out := &in.KeepFiringFor, &out.KeepFiringFor
		*out = new(NonEmptyDuration)
		**out = **in
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Rule.
func (in *Rule) DeepCopy() *Rule {
	if in == nil {
		return nil
	}
	out := new(Rule)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RuleGroup) DeepCopyInto(out *RuleGroup) {
	*out = *in
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Interval != nil {
		in, out := &in.Interval, &out.Interval
		*out = new(Duration)
		**out = **in
	}
	if in.QueryOffset != nil {
		in, out := &in.QueryOffset, &out.QueryOffset
		*out = new(Duration)
		**out = **in
	}
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]Rule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Limit != nil {
		in, out := &in.Limit, &out.Limit
		*out = new(int)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RuleGroup.
func (in *RuleGroup) DeepCopy() *RuleGroup {
	if in == nil {
		return nil
	}
	out := new(RuleGroup)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Rules) DeepCopyInto(out *Rules) {
	*out = *in
	out.Alert = in.Alert
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Rules.
func (in *Rules) DeepCopy() *Rules {
	if in == nil {
		return nil
	}
	out := new(Rules)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RulesAlert) DeepCopyInto(out *RulesAlert) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RulesAlert.
func (in *RulesAlert) DeepCopy() *RulesAlert {
	if in == nil {
		return nil
	}
	out := new(RulesAlert)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RuntimeConfig) DeepCopyInto(out *RuntimeConfig) {
	*out = *in
	if in.GoGC != nil {
		in, out := &in.GoGC, &out.GoGC
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RuntimeConfig.
func (in *RuntimeConfig) DeepCopy() *RuntimeConfig {
	if in == nil {
		return nil
	}
	out := new(RuntimeConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SafeAuthorization) DeepCopyInto(out *SafeAuthorization) {
	*out = *in
	if in.Credentials != nil {
		in, out := &in.Credentials, &out.Credentials
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SafeAuthorization.
func (in *SafeAuthorization) DeepCopy() *SafeAuthorization {
	if in == nil {
		return nil
	}
	out := new(SafeAuthorization)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SafeTLSConfig) DeepCopyInto(out *SafeTLSConfig) {
	*out = *in
	in.CA.DeepCopyInto(&out.CA)
	in.Cert.DeepCopyInto(&out.Cert)
	if in.KeySecret != nil {
		in, out := &in.KeySecret, &out.KeySecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ServerName != nil {
		in, out := &in.ServerName, &out.ServerName
		*out = new(string)
		**out = **in
	}
	if in.InsecureSkipVerify != nil {
		in, out := &in.InsecureSkipVerify, &out.InsecureSkipVerify
		*out = new(bool)
		**out = **in
	}
	if in.MinVersion != nil {
		in, out := &in.MinVersion, &out.MinVersion
		*out = new(TLSVersion)
		**out = **in
	}
	if in.MaxVersion != nil {
		in, out := &in.MaxVersion, &out.MaxVersion
		*out = new(TLSVersion)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SafeTLSConfig.
func (in *SafeTLSConfig) DeepCopy() *SafeTLSConfig {
	if in == nil {
		return nil
	}
	out := new(SafeTLSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ScrapeClass) DeepCopyInto(out *ScrapeClass) {
	*out = *in
	if in.Default != nil {
		in, out := &in.Default, &out.Default
		*out = new(bool)
		**out = **in
	}
	if in.FallbackScrapeProtocol != nil {
		in, out := &in.FallbackScrapeProtocol, &out.FallbackScrapeProtocol
		*out = new(ScrapeProtocol)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(Authorization)
		(*in).DeepCopyInto(*out)
	}
	if in.Relabelings != nil {
		in, out := &in.Relabelings, &out.Relabelings
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MetricRelabelings != nil {
		in, out := &in.MetricRelabelings, &out.MetricRelabelings
		*out = make([]RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AttachMetadata != nil {
		in, out := &in.AttachMetadata, &out.AttachMetadata
		*out = new(AttachMetadata)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ScrapeClass.
func (in *ScrapeClass) DeepCopy() *ScrapeClass {
	if in == nil {
		return nil
	}
	out := new(ScrapeClass)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecretOrConfigMap) DeepCopyInto(out *SecretOrConfigMap) {
	*out = *in
	if in.Secret != nil {
		in, out := &in.Secret, &out.Secret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ConfigMap != nil {
		in, out := &in.ConfigMap, &out.ConfigMap
		*out = new(corev1.ConfigMapKeySelector)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecretOrConfigMap.
func (in *SecretOrConfigMap) DeepCopy() *SecretOrConfigMap {
	if in == nil {
		return nil
	}
	out := new(SecretOrConfigMap)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceMonitor) DeepCopyInto(out *ServiceMonitor) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceMonitor.
func (in *ServiceMonitor) DeepCopy() *ServiceMonitor {
	if in == nil {
		return nil
	}
	out := new(ServiceMonitor)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceMonitorList) DeepCopyInto(out *ServiceMonitorList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ServiceMonitor, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceMonitorList.
func (in *ServiceMonitorList) DeepCopy() *ServiceMonitorList {
	if in == nil {
		return nil
	}
	out := new(ServiceMonitorList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ServiceMonitorSpec) DeepCopyInto(out *ServiceMonitorSpec) {
	*out = *in
	if in.TargetLabels != nil {
		in, out := &in.TargetLabels, &out.TargetLabels
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.PodTargetLabels != nil {
		in, out := &in.PodTargetLabels, &out.PodTargetLabels
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Endpoints != nil {
		in, out := &in.Endpoints, &out.Endpoints
		*out = make([]Endpoint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.Selector.DeepCopyInto(&out.Selector)
	if in.SelectorMechanism != nil {
		in, out := &in.SelectorMechanism, &out.SelectorMechanism
		*out = new(SelectorMechanism)
		**out = **in
	}
	in.NamespaceSelector.DeepCopyInto(&out.NamespaceSelector)
	if in.SampleLimit != nil {
		in, out := &in.SampleLimit, &out.SampleLimit
		*out = new(uint64)
		**out = **in
	}
	if in.ScrapeProtocols != nil {
		in, out := &in.ScrapeProtocols, &out.ScrapeProtocols
		*out = make([]ScrapeProtocol, len(*in))
		copy(*out, *in)
	}
	if in.FallbackScrapeProtocol != nil {
		in, out := &in.FallbackScrapeProtocol, &out.FallbackScrapeProtocol
		*out = new(ScrapeProtocol)
		**out = **in
	}
	if in.TargetLimit != nil {
		in, out := &in.TargetLimit, &out.TargetLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelLimit != nil {
		in, out := &in.LabelLimit, &out.LabelLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelNameLengthLimit != nil {
		in, out := &in.LabelNameLengthLimit, &out.LabelNameLengthLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelValueLengthLimit != nil {
		in, out := &in.LabelValueLengthLimit, &out.LabelValueLengthLimit
		*out = new(uint64)
		**out = **in
	}
	in.NativeHistogramConfig.DeepCopyInto(&out.NativeHistogramConfig)
	if in.KeepDroppedTargets != nil {
		in, out := &in.KeepDroppedTargets, &out.KeepDroppedTargets
		*out = new(uint64)
		**out = **in
	}
	if in.AttachMetadata != nil {
		in, out := &in.AttachMetadata, &out.AttachMetadata
		*out = new(AttachMetadata)
		(*in).DeepCopyInto(*out)
	}
	if in.ScrapeClassName != nil {
		in, out := &in.ScrapeClassName, &out.ScrapeClassName
		*out = new(string)
		**out = **in
	}
	if in.BodySizeLimit != nil {
		in, out := &in.BodySizeLimit, &out.BodySizeLimit
		*out = new(ByteSize)
		**out = **in
	}
	if in.ServiceDiscoveryRole != nil {
		in, out := &in.ServiceDiscoveryRole, &out.ServiceDiscoveryRole
		*out = new(ServiceDiscoveryRole)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ServiceMonitorSpec.
func (in *ServiceMonitorSpec) DeepCopy() *ServiceMonitorSpec {
	if in == nil {
		return nil
	}
	out := new(ServiceMonitorSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ShardRetentionPolicy) DeepCopyInto(out *ShardRetentionPolicy) {
	*out = *in
	if in.WhenScaled != nil {
		in, out := &in.WhenScaled, &out.WhenScaled
		*out = new(WhenScaledRetentionType)
		**out = **in
	}
	if in.Retain != nil {
		in, out := &in.Retain, &out.Retain
		*out = new(RetainConfig)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ShardRetentionPolicy.
func (in *ShardRetentionPolicy) DeepCopy() *ShardRetentionPolicy {
	if in == nil {
		return nil
	}
	out := new(ShardRetentionPolicy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ShardStatus) DeepCopyInto(out *ShardStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ShardStatus.
func (in *ShardStatus) DeepCopy() *ShardStatus {
	if in == nil {
		return nil
	}
	out := new(ShardStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Sigv4) DeepCopyInto(out *Sigv4) {
	*out = *in
	if in.AccessKey != nil {
		in, out := &in.AccessKey, &out.AccessKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.SecretKey != nil {
		in, out := &in.SecretKey, &out.SecretKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.UseFIPSSTSEndpoint != nil {
		in, out := &in.UseFIPSSTSEndpoint, &out.UseFIPSSTSEndpoint
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Sigv4.
func (in *Sigv4) DeepCopy() *Sigv4 {
	if in == nil {
		return nil
	}
	out := new(Sigv4)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StorageSpec) DeepCopyInto(out *StorageSpec) {
	*out = *in
	if in.EmptyDir != nil {
		in, out := &in.EmptyDir, &out.EmptyDir
		*out = new(corev1.EmptyDirVolumeSource)
		(*in).DeepCopyInto(*out)
	}
	if in.Ephemeral != nil {
		in, out := &in.Ephemeral, &out.Ephemeral
		*out = new(corev1.EphemeralVolumeSource)
		(*in).DeepCopyInto(*out)
	}
	in.VolumeClaimTemplate.DeepCopyInto(&out.VolumeClaimTemplate)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StorageSpec.
func (in *StorageSpec) DeepCopy() *StorageSpec {
	if in == nil {
		return nil
	}
	out := new(StorageSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TLSConfig) DeepCopyInto(out *TLSConfig) {
	*out = *in
	in.SafeTLSConfig.DeepCopyInto(&out.SafeTLSConfig)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TLSConfig.
func (in *TLSConfig) DeepCopy() *TLSConfig {
	if in == nil {
		return nil
	}
	out := new(TLSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TSDBSpec) DeepCopyInto(out *TSDBSpec) {
	*out = *in
	if in.OutOfOrderTimeWindow != nil {
		in, out := &in.OutOfOrderTimeWindow, &out.OutOfOrderTimeWindow
		*out = new(Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TSDBSpec.
func (in *TSDBSpec) DeepCopy() *TSDBSpec {
	if in == nil {
		return nil
	}
	out := new(TSDBSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ThanosRuler) DeepCopyInto(out *ThanosRuler) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ThanosRuler.
func (in *ThanosRuler) DeepCopy() *ThanosRuler {
	if in == nil {
		return nil
	}
	out := new(ThanosRuler)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ThanosRulerList) DeepCopyInto(out *ThanosRulerList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ThanosRuler, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ThanosRulerList.
func (in *ThanosRulerList) DeepCopy() *ThanosRulerList {
	if in == nil {
		return nil
	}
	out := new(ThanosRulerList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ThanosRulerSpec) DeepCopyInto(out *ThanosRulerSpec) {
	*out = *in
	if in.Version != nil {
		in, out := &in.Version, &out.Version
		*out = new(string)
		**out = **in
	}
	if in.PodMetadata != nil {
		in, out := &in.PodMetadata, &out.PodMetadata
		*out = new(EmbeddedObjectMetadata)
		(*in).DeepCopyInto(*out)
	}
	if in.ImagePullSecrets != nil {
		in, out := &in.ImagePullSecrets, &out.ImagePullSecrets
		*out = make([]corev1.LocalObjectReference, len(*in))
		copy(*out, *in)
	}
	if in.Replicas != nil {
		in, out := &in.Replicas, &out.Replicas
		*out = new(int32)
		**out = **in
	}
	if in.NodeSelector != nil {
		in, out := &in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Resources.DeepCopyInto(&out.Resources)
	if in.Affinity != nil {
		in, out := &in.Affinity, &out.Affinity
		*out = new(corev1.Affinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SecurityContext != nil {
		in, out := &in.SecurityContext, &out.SecurityContext
		*out = new(corev1.PodSecurityContext)
		(*in).DeepCopyInto(*out)
	}
	if in.DNSPolicy != nil {
		in, out := &in.DNSPolicy, &out.DNSPolicy
		*out = new(DNSPolicy)
		**out = **in
	}
	if in.DNSConfig != nil {
		in, out := &in.DNSConfig, &out.DNSConfig
		*out = new(PodDNSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.EnableServiceLinks != nil {
		in, out := &in.EnableServiceLinks, &out.EnableServiceLinks
		*out = new(bool)
		**out = **in
	}
	if in.ServiceName != nil {
		in, out := &in.ServiceName, &out.ServiceName
		*out = new(string)
		**out = **in
	}
	if in.Storage != nil {
		in, out := &in.Storage, &out.Storage
		*out = new(StorageSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Volumes != nil {
		in, out := &in.Volumes, &out.Volumes
		*out = make([]corev1.Volume, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.VolumeMounts != nil {
		in, out := &in.VolumeMounts, &out.VolumeMounts
		*out = make([]corev1.VolumeMount, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ObjectStorageConfig != nil {
		in, out := &in.ObjectStorageConfig, &out.ObjectStorageConfig
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ObjectStorageConfigFile != nil {
		in, out := &in.ObjectStorageConfigFile, &out.ObjectStorageConfigFile
		*out = new(string)
		**out = **in
	}
	if in.QueryEndpoints != nil {
		in, out := &in.QueryEndpoints, &out.QueryEndpoints
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.QueryConfig != nil {
		in, out := &in.QueryConfig, &out.QueryConfig
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.AlertManagersURL != nil {
		in, out := &in.AlertManagersURL, &out.AlertManagersURL
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.AlertManagersConfig != nil {
		in, out := &in.AlertManagersConfig, &out.AlertManagersConfig
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.RuleSelector != nil {
		in, out := &in.RuleSelector, &out.RuleSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.RuleNamespaceSelector != nil {
		in, out := &in.RuleNamespaceSelector, &out.RuleNamespaceSelector
		*out = new(metav1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ExcludedFromEnforcement != nil {
		in, out := &in.ExcludedFromEnforcement, &out.ExcludedFromEnforcement
		*out = make([]ObjectReference, len(*in))
		copy(*out, *in)
	}
	if in.PrometheusRulesExcludedFromEnforce != nil {
		in, out := &in.PrometheusRulesExcludedFromEnforce, &out.PrometheusRulesExcludedFromEnforce
		*out = make([]PrometheusRuleExcludeConfig, len(*in))
		copy(*out, *in)
	}
	if in.ResendDelay != nil {
		in, out := &in.ResendDelay, &out.ResendDelay
		*out = new(Duration)
		**out = **in
	}
	if in.RuleOutageTolerance != nil {
		in, out := &in.RuleOutageTolerance, &out.RuleOutageTolerance
		*out = new(Duration)
		**out = **in
	}
	if in.RuleQueryOffset != nil {
		in, out := &in.RuleQueryOffset, &out.RuleQueryOffset
		*out = new(Duration)
		**out = **in
	}
	if in.RuleConcurrentEval != nil {
		in, out := &in.RuleConcurrentEval, &out.RuleConcurrentEval
		*out = new(int32)
		**out = **in
	}
	if in.RuleGracePeriod != nil {
		in, out := &in.RuleGracePeriod, &out.RuleGracePeriod
		*out = new(Duration)
		**out = **in
	}
	if in.Containers != nil {
		in, out := &in.Containers, &out.Containers
		*out = make([]corev1.Container, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.InitContainers != nil {
		in, out := &in.InitContainers, &out.InitContainers
		*out = make([]corev1.Container, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TracingConfig != nil {
		in, out := &in.TracingConfig, &out.TracingConfig
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.AlertDropLabels != nil {
		in, out := &in.AlertDropLabels, &out.AlertDropLabels
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.GRPCServerTLSConfig != nil {
		in, out := &in.GRPCServerTLSConfig, &out.GRPCServerTLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.MinReadySeconds != nil {
		in, out := &in.MinReadySeconds, &out.MinReadySeconds
		*out = new(int32)
		**out = **in
	}
	if in.AlertRelabelConfigs != nil {
		in, out := &in.AlertRelabelConfigs, &out.AlertRelabelConfigs
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.AlertRelabelConfigFile != nil {
		in, out := &in.AlertRelabelConfigFile, &out.AlertRelabelConfigFile
		*out = new(string)
		**out = **in
	}
	if in.HostAliases != nil {
		in, out := &in.HostAliases, &out.HostAliases
		*out = make([]HostAlias, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AdditionalArgs != nil {
		in, out := &in.AdditionalArgs, &out.AdditionalArgs
		*out = make([]Argument, len(*in))
		copy(*out, *in)
	}
	if in.Web != nil {
		in, out := &in.Web, &out.Web
		*out = new(ThanosRulerWebSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.RemoteWrite != nil {
		in, out := &in.RemoteWrite, &out.RemoteWrite
		*out = make([]RemoteWriteSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TerminationGracePeriodSeconds != nil {
		in, out := &in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = **in
	}
	if in.EnableFeatures != nil {
		in, out := &in.EnableFeatures, &out.EnableFeatures
		*out = make([]EnableFeature, len(*in))
		copy(*out, *in)
	}
	if in.HostUsers != nil {
		in, out := &in.HostUsers, &out.HostUsers
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ThanosRulerSpec.
func (in *ThanosRulerSpec) DeepCopy() *ThanosRulerSpec {
	if in == nil {
		return nil
	}
	out := new(ThanosRulerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ThanosRulerStatus) DeepCopyInto(out *ThanosRulerStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ThanosRulerStatus.
func (in *ThanosRulerStatus) DeepCopy() *ThanosRulerStatus {
	if in == nil {
		return nil
	}
	out := new(ThanosRulerStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ThanosRulerWebSpec) DeepCopyInto(out *ThanosRulerWebSpec) {
	*out = *in
	in.WebConfigFileFields.DeepCopyInto(&out.WebConfigFileFields)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ThanosRulerWebSpec.
func (in *ThanosRulerWebSpec) DeepCopy() *ThanosRulerWebSpec {
	if in == nil {
		return nil
	}
	out := new(ThanosRulerWebSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ThanosSpec) DeepCopyInto(out *ThanosSpec) {
	*out = *in
	if in.Image != nil {
		in, out := &in.Image, &out.Image
		*out = new(string)
		**out = **in
	}
	if in.Version != nil {
		in, out := &in.Version, &out.Version
		*out = new(string)
		**out = **in
	}
	if in.Tag != nil {
		in, out := &in.Tag, &out.Tag
		*out = new(string)
		**out = **in
	}
	if in.SHA != nil {
		in, out := &in.SHA, &out.SHA
		*out = new(string)
		**out = **in
	}
	if in.BaseImage != nil {
		in, out := &in.BaseImage, &out.BaseImage
		*out = new(string)
		**out = **in
	}
	in.Resources.DeepCopyInto(&out.Resources)
	if in.ObjectStorageConfig != nil {
		in, out := &in.ObjectStorageConfig, &out.ObjectStorageConfig
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ObjectStorageConfigFile != nil {
		in, out := &in.ObjectStorageConfigFile, &out.ObjectStorageConfigFile
		*out = new(string)
		**out = **in
	}
	if in.TracingConfig != nil {
		in, out := &in.TracingConfig, &out.TracingConfig
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.GRPCServerTLSConfig != nil {
		in, out := &in.GRPCServerTLSConfig, &out.GRPCServerTLSConfig
		*out = new(TLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.VolumeMounts != nil {
		in, out := &in.VolumeMounts, &out.VolumeMounts
		*out = make([]corev1.VolumeMount, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AdditionalArgs != nil {
		in, out := &in.AdditionalArgs, &out.AdditionalArgs
		*out = make([]Argument, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ThanosSpec.
func (in *ThanosSpec) DeepCopy() *ThanosSpec {
	if in == nil {
		return nil
	}
	out := new(ThanosSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TopologySpreadConstraint) DeepCopyInto(out *TopologySpreadConstraint) {
	*out = *in
	in.CoreV1TopologySpreadConstraint.DeepCopyInto(&out.CoreV1TopologySpreadConstraint)
	if in.AdditionalLabelSelectors != nil {
		in, out := &in.AdditionalLabelSelectors, &out.AdditionalLabelSelectors
		*out = new(AdditionalLabelSelectors)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TopologySpreadConstraint.
func (in *TopologySpreadConstraint) DeepCopy() *TopologySpreadConstraint {
	if in == nil {
		return nil
	}
	out := new(TopologySpreadConstraint)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebConfigFileFields) DeepCopyInto(out *WebConfigFileFields) {
	*out = *in
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(WebTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(WebHTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebConfigFileFields.
func (in *WebConfigFileFields) DeepCopy() *WebConfigFileFields {
	if in == nil {
		return nil
	}
	out := new(WebConfigFileFields)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebHTTPConfig) DeepCopyInto(out *WebHTTPConfig) {
	*out = *in
	if in.HTTP2 != nil {
		in, out := &in.HTTP2, &out.HTTP2
		*out = new(bool)
		**out = **in
	}
	if in.Headers != nil {
		in, out := &in.Headers, &out.Headers
		*out = new(WebHTTPHeaders)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebHTTPConfig.
func (in *WebHTTPConfig) DeepCopy() *WebHTTPConfig {
	if in == nil {
		return nil
	}
	out := new(WebHTTPConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebHTTPHeaders) DeepCopyInto(out *WebHTTPHeaders) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebHTTPHeaders.
func (in *WebHTTPHeaders) DeepCopy() *WebHTTPHeaders {
	if in == nil {
		return nil
	}
	out := new(WebHTTPHeaders)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebTLSConfig) DeepCopyInto(out *WebTLSConfig) {
	*out = *in
	in.Cert.DeepCopyInto(&out.Cert)
	if in.CertFile != nil {
		in, out := &in.CertFile, &out.CertFile
		*out = new(string)
		**out = **in
	}
	in.KeySecret.DeepCopyInto(&out.KeySecret)
	if in.KeyFile != nil {
		in, out := &in.KeyFile, &out.KeyFile
		*out = new(string)
		**out = **in
	}
	in.ClientCA.DeepCopyInto(&out.ClientCA)
	if in.ClientCAFile != nil {
		in, out := &in.ClientCAFile, &out.ClientCAFile
		*out = new(string)
		**out = **in
	}
	if in.ClientAuthType != nil {
		in, out := &in.ClientAuthType, &out.ClientAuthType
		*out = new(string)
		**out = **in
	}
	if in.MinVersion != nil {
		in, out := &in.MinVersion, &out.MinVersion
		*out = new(string)
		**out = **in
	}
	if in.MaxVersion != nil {
		in, out := &in.MaxVersion, &out.MaxVersion
		*out = new(string)
		**out = **in
	}
	if in.CipherSuites != nil {
		in, out := &in.CipherSuites, &out.CipherSuites
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.PreferServerCipherSuites != nil {
		in, out := &in.PreferServerCipherSuites, &out.PreferServerCipherSuites
		*out = new(bool)
		**out = **in
	}
	if in.CurvePreferences != nil {
		in, out := &in.CurvePreferences, &out.CurvePreferences
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebTLSConfig.
func (in *WebTLSConfig) DeepCopy() *WebTLSConfig {
	if in == nil {
		return nil
	}
	out := new(WebTLSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WorkloadBinding) DeepCopyInto(out *WorkloadBinding) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]ConfigResourceCondition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WorkloadBinding.
func (in *WorkloadBinding) DeepCopy() *WorkloadBinding {
	if in == nil {
		return nil
	}
	out := new(WorkloadBinding)
	in.DeepCopyInto(out)
	return out
}
