/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transport.dtls;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ice4j.util.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.DtlsClient;
import org.jitsi.nlj.dtls.DtlsRole;
import org.jitsi.nlj.dtls.DtlsServer;
import org.jitsi.nlj.dtls.DtlsStack;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.transport.dtls.DtlsTransport;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00049:;<B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u0005J \u0010&\u001a\u00020#2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050)0(J\u000e\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u001dJ \u0010/\u001a\u00020#2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0002J\u001e\u00105\u001a\u00020#2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203J\u0006\u00106\u001a\u00020#J\u0006\u00107\u001a\u000208R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "id", "", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Ljava/lang/String;)V", "logger", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "incomingDataHandler", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$IncomingDataHandler;", "outgoingDataHandler", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$OutgoingDataHandler;", "eventHandler", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$EventHandler;", "dtlsHandshakeComplete", "", "isConnected", "()Z", "stats", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$Stats;", "cryptex", "getCryptex", "setCryptex", "(Z)V", "dtlsQueue", "Lorg/jitsi/utils/queue/PacketQueue;", "Lorg/ice4j/util/Buffer;", "getDtlsQueue", "()Lorg/jitsi/utils/queue/PacketQueue;", "dtlsStack", "Lorg/jitsi/nlj/dtls/DtlsStack;", "startDtlsHandshake", "", "setSetupAttribute", "setupAttr", "setRemoteFingerprints", "remoteFingerprints", "", "", "describe", "iceUdpTransportPe", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "enqueueBuffer", "buffer", "dtlsDataReceived", "data", "", "off", "", "len", "sendDtlsData", "stop", "getDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "Stats", "OutgoingDataHandler", "IncomingDataHandler", "EventHandler", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nDtlsTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtlsTransport.kt\norg/jitsi/videobridge/transport/dtls/DtlsTransport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class DtlsTransport {
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean running;
    @JvmField
    @Nullable
    public IncomingDataHandler incomingDataHandler;
    @JvmField
    @Nullable
    public OutgoingDataHandler outgoingDataHandler;
    @JvmField
    @Nullable
    public EventHandler eventHandler;
    private boolean dtlsHandshakeComplete;
    @NotNull
    private final Stats stats;
    private boolean cryptex;
    @NotNull
    private final PacketQueue<Buffer> dtlsQueue;
    @NotNull
    private final DtlsStack dtlsStack;

    /*
     * WARNING - void declaration
     */
    public DtlsTransport(@NotNull Logger parentLogger, @NotNull String id) {
        void it;
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.running = new AtomicBoolean(true);
        this.stats = new Stats(0, 0, 0, 0, 15, null);
        String string = "dtls-queue-" + id;
        Object object = arg_0 -> DtlsTransport.dtlsQueue$lambda$0(this, arg_0);
        ExecutorService executorService = TaskPools.IO_POOL;
        this.dtlsQueue = (PacketQueue)new PacketQueue<Buffer>(string, (PacketQueue.PacketHandler<Buffer>)object, executorService){

            protected void releasePacket(Buffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                BufferPool.Companion.getReturnBuffer().invoke((Object)buffer.getBuffer());
            }
        };
        string = new DtlsStack(this.logger);
        object = string;
        DtlsTransport dtlsTransport = this;
        boolean bl = false;
        it.setIncomingDataHandler(new DtlsStack.IncomingDataHandler(this){
            final /* synthetic */ DtlsTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataReceived(byte[] data, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Stats stats = DtlsTransport.access$getStats$p(this.this$0);
                int n = stats.getNumPacketsReceived();
                stats.setNumPacketsReceived(n + 1);
                IncomingDataHandler incomingDataHandler = this.this$0.incomingDataHandler;
                if (incomingDataHandler != null) {
                    incomingDataHandler.dtlsAppDataReceived(data, off, len);
                } else {
                    dtlsStack.1.1 var6_6 = this;
                    DtlsTransport dtlsTransport = this.this$0;
                    dtlsStack.1.1 $this$dataReceived_u24lambda_u240 = var6_6;
                    boolean bl = false;
                    Stats stats2 = DtlsTransport.access$getStats$p(dtlsTransport);
                    int n2 = stats2.getNumIncomingPacketsDroppedNoHandler();
                    stats2.setNumIncomingPacketsDroppedNoHandler(n2 + 1);
                }
            }
        });
        it.setOutgoingDataHandler(new DtlsStack.OutgoingDataHandler(this){
            final /* synthetic */ DtlsTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendData(byte[] data, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                OutgoingDataHandler outgoingDataHandler = this.this$0.outgoingDataHandler;
                if (outgoingDataHandler != null) {
                    outgoingDataHandler.sendData(data, off, len);
                    Unit unit = Unit.INSTANCE;
                    DtlsTransport dtlsTransport = this.this$0;
                    Unit it = unit;
                    boolean bl = false;
                    Stats stats = DtlsTransport.access$getStats$p(dtlsTransport);
                    int n = stats.getNumPacketsSent();
                    stats.setNumPacketsSent(n + 1);
                } else {
                    dtlsStack.1.2 var4_5 = this;
                    DtlsTransport dtlsTransport = this.this$0;
                    dtlsStack.1.2 $this$sendData_u24lambda_u241 = var4_5;
                    boolean bl = false;
                    Stats stats = DtlsTransport.access$getStats$p(dtlsTransport);
                    int n = stats.getNumOutgoingPacketsDroppedNoHandler();
                    stats.setNumOutgoingPacketsDroppedNoHandler(n + 1);
                }
            }
        });
        it.setEventHandler(new DtlsStack.EventHandler(this){
            final /* synthetic */ DtlsTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public void handshakeComplete(int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)tlsRole, (String)"tlsRole");
                    Intrinsics.checkNotNullParameter((Object)keyingMaterial, (String)"keyingMaterial");
                    DtlsTransport.access$setDtlsHandshakeComplete$p(this.this$0, true);
                    EventHandler eventHandler = this.this$0.eventHandler;
                    if (eventHandler == null) break block0;
                    eventHandler.handshakeComplete(chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
                }
            }
        });
        dtlsTransport.dtlsStack = string;
    }

    public final boolean isConnected() {
        return this.dtlsHandshakeComplete;
    }

    public final boolean getCryptex() {
        return this.cryptex;
    }

    public final void setCryptex(boolean bl) {
        this.cryptex = bl;
    }

    @NotNull
    public final PacketQueue<Buffer> getDtlsQueue() {
        return this.dtlsQueue;
    }

    public final void startDtlsHandshake() {
        Object object = this.dtlsStack.getRole();
        this.logger.info((Object)("Starting DTLS handshake, role=" + (object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null)));
        if (this.dtlsStack.getRole() == null) {
            this.logger.warn((Object)"Starting the DTLS stack before it knows its role");
        }
        try {
            this.dtlsStack.start();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Error during DTLS negotiation, closing this transport manager", t);
        }
    }

    public final void setSetupAttribute(@Nullable String setupAttr) {
        CharSequence charSequence = setupAttr;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        String string = setupAttr.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        charSequence = string;
        if (Intrinsics.areEqual((Object)charSequence, (Object)"active")) {
            this.logger.info((Object)"The remote side is acting as DTLS client, we'll act as server");
            this.dtlsStack.actAsServer();
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"passive")) {
            this.logger.info((Object)"The remote side is acting as DTLS server, we'll act as client");
            this.dtlsStack.actAsClient();
        } else {
            this.logger.error((Object)("The remote side sent an unrecognized DTLS setup value: " + setupAttr));
        }
    }

    public final void setRemoteFingerprints(@NotNull Map<String, ? extends List<String>> remoteFingerprints) {
        Intrinsics.checkNotNullParameter(remoteFingerprints, (String)"remoteFingerprints");
        if (remoteFingerprints.isEmpty()) {
            return;
        }
        this.dtlsStack.setRemoteFingerprints(remoteFingerprints);
    }

    public final void describe(@NotNull IceUdpTransportPacketExtension iceUdpTransportPe) {
        String string;
        Intrinsics.checkNotNullParameter((Object)iceUdpTransportPe, (String)"iceUdpTransportPe");
        DtlsFingerprintPacketExtension dtlsFingerprintPacketExtension = (DtlsFingerprintPacketExtension)iceUdpTransportPe.getFirstChildOfType(DtlsFingerprintPacketExtension.class);
        if (dtlsFingerprintPacketExtension == null) {
            DtlsFingerprintPacketExtension dtlsFingerprintPacketExtension2;
            DtlsTransport $this$describe_u24lambda_u240 = this;
            boolean bl = false;
            DtlsFingerprintPacketExtension it = dtlsFingerprintPacketExtension2 = new DtlsFingerprintPacketExtension();
            boolean bl2 = false;
            iceUdpTransportPe.addChildExtension((ExtensionElement)it);
            dtlsFingerprintPacketExtension = dtlsFingerprintPacketExtension2;
        }
        DtlsFingerprintPacketExtension fingerprintPE = dtlsFingerprintPacketExtension;
        DtlsRole dtlsRole = this.dtlsStack.getRole();
        if (dtlsRole instanceof DtlsServer) {
            string = "passive";
        } else if (dtlsRole instanceof DtlsClient) {
            string = "active";
        } else if (dtlsRole == null) {
            string = "actpass";
        } else {
            throw new IllegalStateException("Cannot describe role " + this.dtlsStack.getRole());
        }
        fingerprintPE.setSetup(string);
        fingerprintPE.setFingerprint(this.dtlsStack.getLocalFingerprint());
        fingerprintPE.setHash(this.dtlsStack.getLocalFingerprintHashFunction());
        if (this.cryptex) {
            fingerprintPE.setCryptex(Boolean.valueOf(true));
        }
    }

    public final void enqueueBuffer(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.dtlsQueue.add((Object)buffer);
    }

    private final void dtlsDataReceived(byte[] data, int off, int len) {
        this.dtlsStack.processIncomingProtocolData(data, off, len);
    }

    public final void sendDtlsData(@NotNull byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.dtlsStack.sendApplicationData(data, off, len);
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.logger.info((Object)"Stopping");
            this.dtlsStack.close();
        }
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u240 = orderedJsonObject = this.stats.toJson();
        boolean bl = false;
        $this$getDebugState_u24lambda_u240.put((Object)"running", (Object)this.running.get());
        Object object = this.dtlsStack.getRole();
        if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getSimpleName()) == null) {
            object = "null";
        }
        $this$getDebugState_u24lambda_u240.put((Object)"role", object);
        $this$getDebugState_u24lambda_u240.put((Object)"is_connected", (Object)this.isConnected());
        return orderedJsonObject;
    }

    private static final boolean dtlsQueue$lambda$0(DtlsTransport this$0, Buffer buffer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            this$0.dtlsDataReceived(buffer.getBuffer(), buffer.getOffset(), buffer.getLength());
            bl = true;
        }
        catch (Exception e) {
            this$0.logger.warn((Object)"Failed to handle DTLS data", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ Stats access$getStats$p(DtlsTransport $this) {
        return $this.stats;
    }

    public static final /* synthetic */ void access$setDtlsHandshakeComplete$p(DtlsTransport $this, boolean bl) {
        $this.dtlsHandshakeComplete = bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$EventHandler;", "", "handshakeComplete", "", "chosenSrtpProtectionProfile", "", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "keyingMaterial", "", "jitsi-videobridge"})
    public static interface EventHandler {
        public void handshakeComplete(int var1, @NotNull TlsRole var2, @NotNull byte[] var3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$IncomingDataHandler;", "", "dtlsAppDataReceived", "", "buf", "", "off", "", "len", "jitsi-videobridge"})
    public static interface IncomingDataHandler {
        public void dtlsAppDataReceived(@NotNull byte[] var1, int var2, int var3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$OutgoingDataHandler;", "", "sendData", "", "buf", "", "off", "", "len", "jitsi-videobridge"})
    public static interface OutgoingDataHandler {
        public void sendData(@NotNull byte[] var1, int var2, int var3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$Stats;", "", "numPacketsReceived", "", "numIncomingPacketsDroppedNoHandler", "numPacketsSent", "numOutgoingPacketsDroppedNoHandler", "<init>", "(IIII)V", "getNumPacketsReceived", "()I", "setNumPacketsReceived", "(I)V", "getNumIncomingPacketsDroppedNoHandler", "setNumIncomingPacketsDroppedNoHandler", "getNumPacketsSent", "setNumPacketsSent", "getNumOutgoingPacketsDroppedNoHandler", "setNumOutgoingPacketsDroppedNoHandler", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "jitsi-videobridge"})
    private static final class Stats {
        private int numPacketsReceived;
        private int numIncomingPacketsDroppedNoHandler;
        private int numPacketsSent;
        private int numOutgoingPacketsDroppedNoHandler;

        public Stats(int numPacketsReceived, int numIncomingPacketsDroppedNoHandler, int numPacketsSent, int numOutgoingPacketsDroppedNoHandler) {
            this.numPacketsReceived = numPacketsReceived;
            this.numIncomingPacketsDroppedNoHandler = numIncomingPacketsDroppedNoHandler;
            this.numPacketsSent = numPacketsSent;
            this.numOutgoingPacketsDroppedNoHandler = numOutgoingPacketsDroppedNoHandler;
        }

        public /* synthetic */ Stats(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, n4);
        }

        public final int getNumPacketsReceived() {
            return this.numPacketsReceived;
        }

        public final void setNumPacketsReceived(int n) {
            this.numPacketsReceived = n;
        }

        public final int getNumIncomingPacketsDroppedNoHandler() {
            return this.numIncomingPacketsDroppedNoHandler;
        }

        public final void setNumIncomingPacketsDroppedNoHandler(int n) {
            this.numIncomingPacketsDroppedNoHandler = n;
        }

        public final int getNumPacketsSent() {
            return this.numPacketsSent;
        }

        public final void setNumPacketsSent(int n) {
            this.numPacketsSent = n;
        }

        public final int getNumOutgoingPacketsDroppedNoHandler() {
            return this.numOutgoingPacketsDroppedNoHandler;
        }

        public final void setNumOutgoingPacketsDroppedNoHandler(int n) {
            this.numOutgoingPacketsDroppedNoHandler = n;
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u240.put((Object)"num_packets_received", (Object)this.numPacketsReceived);
            $this$toJson_u24lambda_u240.put((Object)"num_incoming_packets_dropped_no_handler", (Object)this.numIncomingPacketsDroppedNoHandler);
            $this$toJson_u24lambda_u240.put((Object)"num_packets_sent", (Object)this.numPacketsSent);
            $this$toJson_u24lambda_u240.put((Object)"num_outgoing_packets_dropped_no_handler", (Object)this.numOutgoingPacketsDroppedNoHandler);
            return orderedJsonObject;
        }

        public final int component1() {
            return this.numPacketsReceived;
        }

        public final int component2() {
            return this.numIncomingPacketsDroppedNoHandler;
        }

        public final int component3() {
            return this.numPacketsSent;
        }

        public final int component4() {
            return this.numOutgoingPacketsDroppedNoHandler;
        }

        @NotNull
        public final Stats copy(int numPacketsReceived, int numIncomingPacketsDroppedNoHandler, int numPacketsSent, int numOutgoingPacketsDroppedNoHandler) {
            return new Stats(numPacketsReceived, numIncomingPacketsDroppedNoHandler, numPacketsSent, numOutgoingPacketsDroppedNoHandler);
        }

        public static /* synthetic */ Stats copy$default(Stats stats, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = stats.numPacketsReceived;
            }
            if ((n5 & 2) != 0) {
                n2 = stats.numIncomingPacketsDroppedNoHandler;
            }
            if ((n5 & 4) != 0) {
                n3 = stats.numPacketsSent;
            }
            if ((n5 & 8) != 0) {
                n4 = stats.numOutgoingPacketsDroppedNoHandler;
            }
            return stats.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Stats(numPacketsReceived=" + this.numPacketsReceived + ", numIncomingPacketsDroppedNoHandler=" + this.numIncomingPacketsDroppedNoHandler + ", numPacketsSent=" + this.numPacketsSent + ", numOutgoingPacketsDroppedNoHandler=" + this.numOutgoingPacketsDroppedNoHandler + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.numPacketsReceived);
            result = result * 31 + Integer.hashCode(this.numIncomingPacketsDroppedNoHandler);
            result = result * 31 + Integer.hashCode(this.numPacketsSent);
            result = result * 31 + Integer.hashCode(this.numOutgoingPacketsDroppedNoHandler);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stats)) {
                return false;
            }
            Stats stats = (Stats)other;
            if (this.numPacketsReceived != stats.numPacketsReceived) {
                return false;
            }
            if (this.numIncomingPacketsDroppedNoHandler != stats.numIncomingPacketsDroppedNoHandler) {
                return false;
            }
            if (this.numPacketsSent != stats.numPacketsSent) {
                return false;
            }
            return this.numOutgoingPacketsDroppedNoHandler == stats.numOutgoingPacketsDroppedNoHandler;
        }

        public Stats() {
            this(0, 0, 0, 0, 15, null);
        }
    }
}

