/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.util;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/videobridge/util/BooleanStateTimeTracker;", "", "initialState", "", "clock", "Ljava/time/Clock;", "<init>", "(ZLjava/time/Clock;)V", "totalTimeOn", "Ljava/time/Duration;", "totalTimeOff", "value", "state", "getState", "()Z", "mostRecentStateChange", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "lock", "setState", "", "on", "off", "jitsi-videobridge"})
public final class BooleanStateTimeTracker {
    @NotNull
    private final Clock clock;
    @NotNull
    private Duration totalTimeOn;
    @NotNull
    private Duration totalTimeOff;
    private boolean state;
    private Instant mostRecentStateChange;
    @NotNull
    private final Object lock;

    public BooleanStateTimeTracker(boolean initialState, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        Duration duration = Duration.ofMillis(0L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        this.totalTimeOn = duration;
        Duration duration2 = Duration.ofMillis(0L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        this.totalTimeOff = duration2;
        this.state = initialState;
        this.mostRecentStateChange = this.clock.instant();
        this.lock = new Object();
    }

    public /* synthetic */ BooleanStateTimeTracker(boolean bl, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(bl, clock);
    }

    public final boolean getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Duration totalTimeOn() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (!this.state) break block4;
                Duration duration = this.totalTimeOn.plus(Duration.between(this.mostRecentStateChange, this.clock.instant()));
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"plus(...)");
                Duration duration2 = duration;
                return duration2;
            }
            Duration duration = this.totalTimeOn;
            return duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Duration totalTimeOff() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (this.state) break block4;
                Duration duration = this.totalTimeOff.plus(Duration.between(this.mostRecentStateChange, this.clock.instant()));
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"plus(...)");
                Duration duration2 = duration;
                return duration2;
            }
            Duration duration = this.totalTimeOff;
            return duration;
        }
    }

    public final void setState(boolean state) {
        if (state) {
            this.on();
        } else {
            this.off();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void on() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.state) {
                this.state = true;
                Duration duration = this.totalTimeOff.plus(Duration.between(this.mostRecentStateChange, this.clock.instant()));
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"plus(...)");
                this.totalTimeOff = duration;
                this.mostRecentStateChange = this.clock.instant();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void off() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.state) {
                this.state = false;
                Duration duration = this.totalTimeOn.plus(Duration.between(this.mostRecentStateChange, this.clock.instant()));
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"plus(...)");
                this.totalTimeOn = duration;
                this.mostRecentStateChange = this.clock.instant();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public BooleanStateTimeTracker() {
        this(false, null, 3, null);
    }
}

